/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component;

import com.sbs.jpm.Common;
import com.sbs.jpm.configuration.Configuration;
import com.sbs.jpm.configuration.ConfigurationSetting;
import com.sbs.jpm.shareit.ShareItKeyHandler;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;

class BrowseLicenseFileAction
implements ActionListener {
    private JButton continueButton;
    private JLabel licenseFileLabel;
    private JLabel statusLabel;
    private JFileChooser fileChooser;

    public BrowseLicenseFileAction(JLabel jLabel, JLabel jLabel2, JButton jButton) {
        this.licenseFileLabel = jLabel;
        this.statusLabel = jLabel2;
        this.continueButton = jButton;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        if (this.fileChooser == null) {
            String string = (String)Configuration.getInstance().getValue(ConfigurationSetting.CURRENT_DIR);
            this.fileChooser = new JFileChooser(new File(string));
        }
        if ((n = this.fileChooser.showOpenDialog(this.continueButton)) == 0) {
            File file = this.fileChooser.getSelectedFile();
            this.handleLicenseFile(file);
        }
    }

    private void displayError(String string) {
        this.statusLabel.setForeground(new Color(210, 30, 30));
        this.statusLabel.setText(string);
        this.continueButton.setEnabled(false);
    }

    private void displayMessage(String string) {
        this.statusLabel.setForeground(new Color(30, 110, 30));
        this.statusLabel.setText(string);
        this.continueButton.setEnabled(true);
    }

    private void handleLicenseFile(File file) {
        try {
            Common.LOGGER.info("Handling license file");
            byte[] byArray = this.readBinary(file);
            Common.LOGGER.info("Serial: " + new String(byArray));
            ShareItKeyHandler shareItKeyHandler = new ShareItKeyHandler();
            boolean bl = shareItKeyHandler.handle(byArray);
            if (bl) {
                Configuration configuration = Configuration.getInstance();
                configuration.setValue(ConfigurationSetting.SERIAL_NUMBER, new String(byArray, "ISO-8859-1"));
                this.displayMessage(Common.I18N_MESSAGES.getString("license.validSerialNumber"));
            } else {
                this.displayError(Common.I18N_MESSAGES.getString("license.invalidSerialNumber"));
            }
            this.licenseFileLabel.setText(file.getAbsolutePath());
        }
        catch (IOException iOException) {
            Common.logException("Error:", iOException);
            this.displayError(Common.I18N_MESSAGES.getString("license.failedToRead"));
        }
    }

    private byte[] readBinary(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[fileInputStream.available()];
        fileInputStream.read(byArray);
        fileInputStream.close();
        return byArray;
    }
}

