/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.action;

import com.sbs.jpm.Common;
import com.sbs.jpm.CompanyDocument;
import com.sbs.jpm.core.baseline.BaselineManager;
import com.sbs.jpm.core.event.CompanyAdapter;
import com.sbs.jpm.core.event.CompanyEvent;
import com.sbs.jpm.document.Document;
import com.sbs.jpm.document.DocumentManager;
import com.sbs.jpm.document.event.DocumentManagerAdapter;
import com.sbs.jpm.document.event.DocumentManagerEvent;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

class ActionToolsHideBaseline
extends AbstractAction {
    private static final long serialVersionUID = 1L;

    public ActionToolsHideBaseline() {
        this.putValue("Name", Common.I18N_ACTIONS.getString("baselines.hide") + "...");
        this.putValue("ShortDescription", Common.I18N_ACTIONS.getString("baselines.hide.tooltip"));
    }

    public void registerAsDocumentManagerListener(DocumentManager documentManager) {
        documentManager.addDocumentManagerListener(new DocumentManagerHandler());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        BaselineManager.getInstance().setShowBaseline(false);
        Common.getApplication().repaint();
    }

    class DocumentManagerHandler
    extends DocumentManagerAdapter {
        DocumentManagerHandler() {
        }

        public void documentSelectionChanged(DocumentManagerEvent documentManagerEvent) {
            Document document = documentManagerEvent.getNewDocument();
            if (document != null) {
                ActionToolsHideBaseline.this.setEnabled(true);
                ((CompanyDocument)document).getData().addCompanyListener(new CompanyAdapter(){

                    public void currentProjectChanged(CompanyEvent companyEvent) {
                        if (companyEvent.getProject().getParent() == null) {
                            ActionToolsHideBaseline.this.setEnabled(false);
                        } else {
                            ActionToolsHideBaseline.this.setEnabled(true);
                        }
                    }
                });
            } else {
                ActionToolsHideBaseline.this.setEnabled(false);
            }
        }
    }
}

