/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.action;

import com.sbs.jpm.Common;
import com.sbs.jpm.CompanyDocument;
import com.sbs.jpm.CompanyDocumentManager;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.event.CompanyAdapter;
import com.sbs.jpm.core.event.CompanyEvent;
import com.sbs.jpm.document.Document;
import com.sbs.jpm.document.DocumentManager;
import com.sbs.jpm.document.event.DocumentManagerAdapter;
import com.sbs.jpm.document.event.DocumentManagerEvent;
import com.sbs.jpm.ui.component.JBaselineDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

class ActionToolsCompareBaseline
extends AbstractAction {
    private static final long serialVersionUID = 1L;

    public ActionToolsCompareBaseline() {
        this.putValue("Name", Common.I18N_ACTIONS.getString("baselines.show") + "...");
        this.putValue("ShortDescription", Common.I18N_ACTIONS.getString("baselines.show.tooltip"));
    }

    public void registerAsDocumentManagerListener(DocumentManager documentManager) {
        documentManager.addDocumentManagerListener(new DocumentManagerHandler());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        CompanyDocumentManager companyDocumentManager = Common.getProjectDocumentManager();
        Task task = ((CompanyDocument)companyDocumentManager.getSelectedDocument()).getData().getCurrentTask();
        if (task.getNonEmptyBaselinesNo() == 0) {
            JOptionPane.showMessageDialog(Common.getApplication(), Common.I18N_MESSAGES.getString("baseline.noSavedBaselineToCompare.message"), Common.I18N_MESSAGES.getString("baseline.noSavedBaselineToCompare.title"), 1);
        } else {
            JBaselineDialog jBaselineDialog = new JBaselineDialog((Frame)Common.getApplication(), Common.I18N_ACTIONS.getString("baselines.show.tooltip"), ((CompanyDocument)companyDocumentManager.getSelectedDocument()).getData().getCurrentTask());
            jBaselineDialog.setVisible(true);
            Common.getApplication().repaint();
        }
    }

    class DocumentManagerHandler
    extends DocumentManagerAdapter {
        DocumentManagerHandler() {
        }

        public void documentSelectionChanged(DocumentManagerEvent documentManagerEvent) {
            Document document = documentManagerEvent.getNewDocument();
            if (document != null) {
                ActionToolsCompareBaseline.this.setEnabled(true);
                ((CompanyDocument)document).getData().addCompanyListener(new CompanyAdapter(){

                    public void currentProjectChanged(CompanyEvent companyEvent) {
                        if (companyEvent.getProject().getParent() == null) {
                            ActionToolsCompareBaseline.this.setEnabled(false);
                        } else {
                            ActionToolsCompareBaseline.this.setEnabled(true);
                        }
                    }
                });
            } else {
                ActionToolsCompareBaseline.this.setEnabled(false);
            }
        }
    }
}

