/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.action;

import com.sbs.jpm.Common;
import com.sbs.jpm.document.DocumentManager;
import com.sbs.jpm.i18n.I18nManager;
import com.sbs.jpm.ui.action.ActionApplicationHide;
import com.sbs.jpm.ui.action.ActionApplicationShow;
import com.sbs.jpm.ui.action.ActionEditRedo;
import com.sbs.jpm.ui.action.ActionEditUndo;
import com.sbs.jpm.ui.action.ActionFileClose;
import com.sbs.jpm.ui.action.ActionFileExit;
import com.sbs.jpm.ui.action.ActionFileExport;
import com.sbs.jpm.ui.action.ActionFileImport;
import com.sbs.jpm.ui.action.ActionFileNew;
import com.sbs.jpm.ui.action.ActionFileOpen;
import com.sbs.jpm.ui.action.ActionFileOpenServer;
import com.sbs.jpm.ui.action.ActionFilePageSetup;
import com.sbs.jpm.ui.action.ActionFilePrint;
import com.sbs.jpm.ui.action.ActionFilePrintPreview;
import com.sbs.jpm.ui.action.ActionFilePrintTo;
import com.sbs.jpm.ui.action.ActionFileSave;
import com.sbs.jpm.ui.action.ActionFileSaveAs;
import com.sbs.jpm.ui.action.ActionFileSaveServer;
import com.sbs.jpm.ui.action.ActionHelpAbout;
import com.sbs.jpm.ui.action.ActionHelpTutorial;
import com.sbs.jpm.ui.action.ActionID;
import com.sbs.jpm.ui.action.ActionProjectArchiveProjects;
import com.sbs.jpm.ui.action.ActionProjectExportProjects;
import com.sbs.jpm.ui.action.ActionProjectImportProjects;
import com.sbs.jpm.ui.action.ActionProjectPublishProjects;
import com.sbs.jpm.ui.action.ActionProjectRestoreProjects;
import com.sbs.jpm.ui.action.ActionSettingsCalendar;
import com.sbs.jpm.ui.action.ActionSettingsOptions;
import com.sbs.jpm.ui.action.ActionToolsClearBaseline;
import com.sbs.jpm.ui.action.ActionToolsCompareBaseline;
import com.sbs.jpm.ui.action.ActionToolsHideBaseline;
import com.sbs.jpm.ui.action.ActionToolsSaveBaseline;
import com.sbs.jpm.ui.action.ActionViewClients;
import com.sbs.jpm.ui.action.ActionViewEPS;
import com.sbs.jpm.ui.action.ActionViewGantt;
import com.sbs.jpm.ui.action.ActionViewGuide;
import com.sbs.jpm.ui.action.ActionViewGuideDetails;
import com.sbs.jpm.ui.action.ActionViewResourceSheet;
import com.sbs.jpm.ui.action.ActionViewResources;
import com.sbs.jpm.ui.action.ActionViewTaskSheet;
import com.sbs.jpm.ui.action.ActionViewWBS;
import com.sbs.jpm.ui.component.event.JAreaViewEvent;
import com.sbs.jpm.ui.component.event.JAreaViewListener;
import com.sbs.jpm.ui.component.view.JProjectViewEPS;
import com.sbs.jpm.ui.core.Data;
import com.sbs.jpm.ui.core.ProjectData;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import javax.swing.Action;

public class ActionManager
implements JAreaViewListener {
    public static final int WBS_DATA = 0;
    public static final int GANTT_DATA = 1;
    public static final int TASKSHEET_DATA = 2;
    public static final int HUMAN_DATA = 3;
    public static final int MATERIAL_DATA = 4;
    public static final int RESOURCESHEET_DATA = 5;
    public static final int CALENDAR_DATA = 6;
    public static final int CLIENTS_DATA = 7;
    private static ActionManager actionManager;
    private Map<ActionID, Action> actions = new Hashtable<ActionID, Action>();
    private Data[] buttonDataList;

    private ActionManager() {
        this.actions.put(ActionID.APPLICATION_SHOW, new ActionApplicationShow());
        this.actions.put(ActionID.APPLICATION_HIDE, new ActionApplicationHide());
        this.actions.put(ActionID.FILE_NEW, new ActionFileNew());
        this.actions.put(ActionID.FILE_OPEN, new ActionFileOpen());
        this.actions.put(ActionID.FILE_OPEN_SERVER, new ActionFileOpenServer());
        this.actions.put(ActionID.FILE_SAVE_SERVER, new ActionFileSaveServer());
        this.actions.put(ActionID.FILE_SAVE, new ActionFileSave());
        this.actions.put(ActionID.FILE_SAVE_AS, new ActionFileSaveAs());
        this.actions.put(ActionID.FILE_IMPORT, new ActionFileImport());
        this.actions.put(ActionID.PROJECT_IMPORT_PROJECTS, new ActionProjectImportProjects());
        this.actions.put(ActionID.PROJECT_EXPORT_PROJECTS, new ActionProjectExportProjects());
        this.actions.put(ActionID.PROJECT_RESTORE_PROJECTS, new ActionProjectRestoreProjects());
        this.actions.put(ActionID.PROJECT_ARCHIVE_PROJECTS, new ActionProjectArchiveProjects());
        this.actions.put(ActionID.PROJECT_PUBLISH_PROJECTS, new ActionProjectPublishProjects());
        this.actions.put(ActionID.FILE_EXPORT, new ActionFileExport());
        this.actions.put(ActionID.FILE_PAGE_SETUP, new ActionFilePageSetup());
        this.actions.put(ActionID.FILE_PRINT_PREVIEW, new ActionFilePrintPreview());
        this.actions.put(ActionID.FILE_PRINT, new ActionFilePrint());
        this.actions.put(ActionID.FILE_PRINT_TO, new ActionFilePrintTo());
        this.actions.put(ActionID.FILE_CLOSE, new ActionFileClose());
        this.actions.put(ActionID.EDIT_UNDO, new ActionEditUndo());
        this.actions.put(ActionID.EDIT_REDO, new ActionEditRedo());
        this.actions.put(ActionID.SETTINGS_OPTIONS, new ActionSettingsOptions());
        this.actions.put(ActionID.SETTINGS_CALENDAR, new ActionSettingsCalendar());
        this.actions.put(ActionID.TOOLS_SAVE_BASELINE, new ActionToolsSaveBaseline());
        this.actions.put(ActionID.TOOLS_CLEAR_BASELINE, new ActionToolsClearBaseline());
        this.actions.put(ActionID.TOOLS_COMPARE_BASELINE, new ActionToolsCompareBaseline());
        this.actions.put(ActionID.TOOLS_HIDE_BASELINE, new ActionToolsHideBaseline());
        this.actions.put(ActionID.VIEW_WBS, new ActionViewWBS());
        this.actions.put(ActionID.VIEW_GANTT, new ActionViewGantt());
        this.actions.put(ActionID.VIEW_TASK_SHEET, new ActionViewTaskSheet());
        this.actions.put(ActionID.VIEW_RESOURCES, new ActionViewResources());
        this.actions.put(ActionID.VIEW_CLIENTS, new ActionViewClients());
        this.actions.put(ActionID.VIEW_RESOURCE_SHEET, new ActionViewResourceSheet());
        this.actions.put(ActionID.VIEW_EPS, new ActionViewEPS());
        this.actions.put(ActionID.VIEW_GUIDE, new ActionViewGuide());
        this.actions.put(ActionID.VIEW_GUIDE_DETAILS, new ActionViewGuideDetails());
        this.actions.put(ActionID.HELP_CONTENTS, new ActionHelpTutorial());
        this.actions.put(ActionID.HELP_ABOUT, new ActionHelpAbout());
        this.actions.put(ActionID.FILE_EXIT, new ActionFileExit());
        this.buttonDataList = new Data[8];
        Locale locale = Locale.getDefault();
        String string = locale.getLanguage();
        String string2 = "";
        String string3 = "";
        if (I18nManager.isLanguageSupported(string)) {
            string2 = "_" + string;
            string3 = string + "/";
        }
        ProjectData projectData = new ProjectData();
        projectData.setShortDescription(string3 + "wbsButtonShort" + string2 + ".html");
        projectData.setName(Common.I18N_ACTIONS.getString("view.wbs") + " View");
        this.buttonDataList[0] = projectData;
        projectData = new ProjectData();
        projectData.setShortDescription(string3 + "ganttButtonShort" + string2 + ".html");
        projectData.setName(Common.I18N_ACTIONS.getString("view.gantt") + " View");
        this.buttonDataList[1] = projectData;
        projectData = new ProjectData();
        projectData.setShortDescription(string3 + "taskSheetButtonShort" + string2 + ".html");
        projectData.setName(Common.I18N_ACTIONS.getString("view.taskSheet") + " View");
        this.buttonDataList[2] = projectData;
        projectData = new ProjectData();
        projectData.setShortDescription(string3 + "humanButtonShort" + string2 + ".html");
        projectData.setName(Common.I18N_ACTIONS.getString("view.resources.human") + " View");
        this.buttonDataList[3] = projectData;
        projectData = new ProjectData();
        projectData.setShortDescription(string3 + "materialButtonShort" + string2 + ".html");
        projectData.setName(Common.I18N_ACTIONS.getString("view.resources.material") + " View");
        this.buttonDataList[4] = projectData;
        projectData = new ProjectData();
        projectData.setShortDescription(string3 + "resourceSheetButtonShort" + string2 + ".html");
        projectData.setName(Common.I18N_ACTIONS.getString("view.resourceSheet") + " View");
        this.buttonDataList[5] = projectData;
        projectData = new ProjectData();
        projectData.setShortDescription(string3 + "calendarShort" + string2 + ".html");
        projectData.setName(Common.I18N_ACTIONS.getString("settings.calendar") + " View");
        this.buttonDataList[6] = projectData;
        projectData = new ProjectData();
        projectData.setShortDescription(string3 + "clientsButtonShort" + string2 + ".html");
        projectData.setName(Common.I18N_ACTIONS.getString("view.clients") + " View");
        this.buttonDataList[7] = projectData;
    }

    public Data getData(int n) {
        return this.buttonDataList[n];
    }

    public static ActionManager getActionManager() {
        if (actionManager == null) {
            actionManager = new ActionManager();
        }
        return actionManager;
    }

    public Action getAction(ActionID actionID) {
        Action action = this.actions.get(actionID);
        return action;
    }

    public void registerAsDocumentManagerListener(DocumentManager documentManager) {
        ((ActionFileSave)this.getAction(ActionID.FILE_SAVE)).registerAsDocumentManagerListener(documentManager);
        ((ActionFileSaveAs)this.getAction(ActionID.FILE_SAVE_AS)).registerAsDocumentManagerListener(documentManager);
        ((ActionFileExport)this.getAction(ActionID.FILE_EXPORT)).registerAsDocumentManagerListener(documentManager);
        ((ActionProjectImportProjects)this.getAction(ActionID.PROJECT_IMPORT_PROJECTS)).registerAsDocumentManagerListener(documentManager);
        ((ActionProjectExportProjects)this.getAction(ActionID.PROJECT_EXPORT_PROJECTS)).registerAsDocumentManagerListener(documentManager);
        ((ActionProjectRestoreProjects)this.getAction(ActionID.PROJECT_RESTORE_PROJECTS)).registerAsDocumentManagerListener(documentManager);
        ((ActionProjectArchiveProjects)this.getAction(ActionID.PROJECT_ARCHIVE_PROJECTS)).registerAsDocumentManagerListener(documentManager);
        ((ActionProjectPublishProjects)this.getAction(ActionID.PROJECT_PUBLISH_PROJECTS)).registerAsDocumentManagerListener(documentManager);
        ((ActionFileClose)this.getAction(ActionID.FILE_CLOSE)).registerAsDocumentManagerListener(documentManager);
        ((ActionEditUndo)this.getAction(ActionID.EDIT_UNDO)).registerAsDocumentManagerListener(documentManager);
        ((ActionEditRedo)this.getAction(ActionID.EDIT_REDO)).registerAsDocumentManagerListener(documentManager);
        ((ActionFilePrint)this.getAction(ActionID.FILE_PRINT)).registerAsDocumentManagerListener(documentManager);
        ((ActionFilePrintTo)this.getAction(ActionID.FILE_PRINT_TO)).registerAsDocumentManagerListener(documentManager);
        ((ActionFilePrintPreview)this.getAction(ActionID.FILE_PRINT_PREVIEW)).registerAsDocumentManagerListener(documentManager);
        ((ActionSettingsOptions)this.getAction(ActionID.SETTINGS_OPTIONS)).registerAsDocumentManagerListener(documentManager);
        ((ActionSettingsCalendar)this.getAction(ActionID.SETTINGS_CALENDAR)).registerAsDocumentManagerListener(documentManager);
        ((ActionToolsClearBaseline)this.getAction(ActionID.TOOLS_CLEAR_BASELINE)).registerAsDocumentManagerListener(documentManager);
        ((ActionToolsCompareBaseline)this.getAction(ActionID.TOOLS_COMPARE_BASELINE)).registerAsDocumentManagerListener(documentManager);
        ((ActionToolsHideBaseline)this.getAction(ActionID.TOOLS_HIDE_BASELINE)).registerAsDocumentManagerListener(documentManager);
        ((ActionToolsSaveBaseline)this.getAction(ActionID.TOOLS_SAVE_BASELINE)).registerAsDocumentManagerListener(documentManager);
        ((ActionViewEPS)this.getAction(ActionID.VIEW_EPS)).registerAsDocumentManagerListener(documentManager);
        ((ActionViewGantt)this.getAction(ActionID.VIEW_GANTT)).registerAsDocumentManagerListener(documentManager);
        ((ActionViewGuide)this.getAction(ActionID.VIEW_GUIDE)).registerAsDocumentManagerListener(documentManager);
        ((ActionViewGuideDetails)this.getAction(ActionID.VIEW_GUIDE_DETAILS)).registerAsDocumentManagerListener(documentManager);
        ((ActionViewResources)this.getAction(ActionID.VIEW_RESOURCES)).registerAsDocumentManagerListener(documentManager);
        ((ActionViewClients)this.getAction(ActionID.VIEW_CLIENTS)).registerAsDocumentManagerListener(documentManager);
        ((ActionViewResourceSheet)this.getAction(ActionID.VIEW_RESOURCE_SHEET)).registerAsDocumentManagerListener(documentManager);
        ((ActionViewTaskSheet)this.getAction(ActionID.VIEW_TASK_SHEET)).registerAsDocumentManagerListener(documentManager);
        ((ActionViewWBS)this.getAction(ActionID.VIEW_WBS)).registerAsDocumentManagerListener(documentManager);
    }

    public void projectViewChanged(JAreaViewEvent jAreaViewEvent) {
        ((ActionFilePrint)this.getAction(ActionID.FILE_PRINT)).projectViewChanged(jAreaViewEvent.getProjectView());
        ((ActionFilePrintTo)this.getAction(ActionID.FILE_PRINT_TO)).projectViewChanged(jAreaViewEvent.getProjectView());
        ((ActionFilePrintPreview)this.getAction(ActionID.FILE_PRINT_PREVIEW)).projectViewChanged(jAreaViewEvent.getProjectView());
    }

    public void EPSShowed() {
        JProjectViewEPS jProjectViewEPS = Common.getApplication().getWorkspace().getJProject().getEpsView();
        ((ActionFilePrint)this.getAction(ActionID.FILE_PRINT)).projectViewChanged(jProjectViewEPS);
        ((ActionFilePrintTo)this.getAction(ActionID.FILE_PRINT_TO)).projectViewChanged(jProjectViewEPS);
        ((ActionFilePrintPreview)this.getAction(ActionID.FILE_PRINT_PREVIEW)).projectViewChanged(jProjectViewEPS);
    }
}

