/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.action;

import com.sbs.jpm.Common;
import com.sbs.jpm.CompanyDocument;
import com.sbs.jpm.CompanyDocumentManager;
import com.sbs.jpm.common.JpmServer;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.SessionManager;
import com.sbs.jpm.core.field.FieldManager;
import com.sbs.jpm.core.remoteClient.RemoteClientFactory;
import com.sbs.jpm.ui.action.ActionEditRedo;
import com.sbs.jpm.ui.action.ActionEditUndo;
import com.sbs.jpm.ui.action.ActionID;
import com.sbs.jpm.ui.action.ActionManager;
import com.sbs.jpm.ui.component.JChangesDialog;
import com.sbs.jpm.undo.ExtendedUndoManager;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.undo.UndoableEdit;

class ActionFileSaveServer
extends AbstractAction {
    private static final long serialVersionUID = 1L;

    public ActionFileSaveServer() {
        this.putValue("Name", Common.I18N_ACTIONS.getString("file.saveToServer"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        RemoteClientFactory remoteClientFactory;
        CompanyDocumentManager companyDocumentManager = Common.getProjectDocumentManager();
        FieldManager.getInstance().setDefaults();
        try {
            remoteClientFactory = (RemoteClientFactory)Class.forName("com.sbs.jpm.remoteClient.spring.http.SpringHttpRemoteServer").newInstance();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Common.logException("Error:", throwable);
            JOptionPane.showMessageDialog(Common.getApplication(), throwable.toString(), Common.I18N_MESSAGES.getString("file.failedToOpen"), 0);
            return;
        }
        JpmServer jpmServer = remoteClientFactory.createJmpServer();
        LinkedList<UndoableEdit> linkedList = new LinkedList<UndoableEdit>();
        Company company = ((CompanyDocument)companyDocumentManager.getSelectedDocument()).getData();
        ExtendedUndoManager extendedUndoManager = (ExtendedUndoManager)company.getUndoManager();
        UndoableEdit undoableEdit = extendedUndoManager.getEditToBeUndone();
        if (undoableEdit != null) {
            Object object2;
            object = extendedUndoManager.getEdits();
            Object object3 = ((Vector)object).iterator();
            while (object3.hasNext()) {
                object2 = object3.next();
                if (object2 instanceof SerializableEdit) {
                    ((SerializableEdit)object2).serialize();
                    linkedList.add((UndoableEdit)object2);
                }
                if (!object2.equals(undoableEdit)) continue;
                break;
            }
            object3 = SessionManager.getInstance();
            object2 = new JChangesDialog();
            ((Window)object2).pack();
            ((Window)object2).setLocationRelativeTo(Common.getApplication());
            ((Dialog)object2).setVisible(true);
            Vector<FailedSerializableEdit> vector = jpmServer.setChanges(linkedList, ((JChangesDialog)object2).getMessage(), ((SessionManager)object3).getUsername(), ((SessionManager)object3).getPassword());
            System.out.println("Failed actions:");
            for (FailedSerializableEdit failedSerializableEdit : vector) {
                System.out.println(failedSerializableEdit.actionName + " ; " + failedSerializableEdit.actionId + "       : " + failedSerializableEdit.errorDetails);
            }
        }
        company.getUndoManager().discardAllEdits();
        object = ActionManager.getActionManager();
        ((ActionEditUndo)((ActionManager)object).getAction(ActionID.EDIT_UNDO)).update();
        ((ActionEditRedo)((ActionManager)object).getAction(ActionID.EDIT_REDO)).update();
        try {
            companyDocumentManager.closeAll();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Common.logException("Error:", exception);
        }
    }
}

