/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.action;

import com.sbs.jpm.Common;
import com.sbs.jpm.CompanyDocumentManager;
import com.sbs.jpm.document.DocumentManager;
import com.sbs.jpm.document.event.DocumentManagerAdapter;
import com.sbs.jpm.document.event.DocumentManagerEvent;
import com.sbs.jpm.ui.JApplication;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

class ActionFileSaveAs
extends AbstractAction {
    private static final long serialVersionUID = 1L;

    public ActionFileSaveAs() {
        this.putValue("Name", Common.I18N_ACTIONS.getString("file.saveAs") + "...");
        this.putValue("ShortDescription", Common.I18N_ACTIONS.getString("file.saveAs.tooltip"));
        this.putValue("MnemonicKey", new Integer(65));
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/SaveAs16.gif")));
    }

    public void registerAsDocumentManagerListener(DocumentManager documentManager) {
        documentManager.addDocumentManagerListener(new DocumentManagerHandler());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Common.LOGGER.info("Preparing to Save As");
        try {
            JApplication jApplication = Common.getApplication();
            CompanyDocumentManager companyDocumentManager = Common.getProjectDocumentManager();
            companyDocumentManager.getSelectedDocument().saveAs();
        }
        catch (Throwable throwable) {
            Common.LOGGER.severe("Unable to Save As in ActionFileSaveAs: " + throwable.getMessage());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            throwable.printStackTrace(printStream);
            printStream.flush();
            Common.LOGGER.severe("Exception: " + byteArrayOutputStream.toString());
            JOptionPane.showMessageDialog(null, throwable.getMessage(), Common.I18N_MESSAGES.getString("file.failedToSave"), 0);
        }
    }

    class DocumentManagerHandler
    extends DocumentManagerAdapter {
        DocumentManagerHandler() {
        }

        public void documentOpened(DocumentManagerEvent documentManagerEvent) {
            ActionFileSaveAs.this.setEnabled(true);
        }

        public void documentCreated(DocumentManagerEvent documentManagerEvent) {
            ActionFileSaveAs.this.setEnabled(true);
        }
    }
}

