/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.action;

import com.sbs.jpm.Common;
import com.sbs.jpm.CompanyDocumentManager;
import com.sbs.jpm.document.Document;
import com.sbs.jpm.document.DocumentManager;
import com.sbs.jpm.document.event.DocumentAdapter;
import com.sbs.jpm.document.event.DocumentEvent;
import com.sbs.jpm.document.event.DocumentListener;
import com.sbs.jpm.document.event.DocumentManagerAdapter;
import com.sbs.jpm.document.event.DocumentManagerEvent;
import com.sbs.util.SystemUtilities;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

class ActionFileSave
extends AbstractAction {
    private static final long serialVersionUID = 1L;

    public ActionFileSave() {
        this.putValue("Name", Common.I18N_ACTIONS.getString("file.save"));
        String string = Common.I18N_ACTIONS.getString("file.save.tooltip");
        string = SystemUtilities.isOSMac() ? string + " (Cmmd-S)" : string + " (Ctrl-S)";
        this.putValue("ShortDescription", string);
        this.putValue("MnemonicKey", new Integer(83));
        if (SystemUtilities.isOSMac()) {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 256));
        } else {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 128));
        }
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Save16.gif")));
    }

    public void registerAsDocumentManagerListener(DocumentManager documentManager) {
        documentManager.addDocumentManagerListener(new DocumentManagerHandler());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Common.LOGGER.info("Preparing to Save");
        try {
            CompanyDocumentManager companyDocumentManager = Common.getProjectDocumentManager();
            companyDocumentManager.getSelectedDocument().save();
        }
        catch (Throwable throwable) {
            Common.logException("Error:", throwable);
            Common.LOGGER.severe("Unable to Save in ActionFileSave: " + throwable.getMessage());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            throwable.printStackTrace(printStream);
            printStream.flush();
            Common.LOGGER.severe("Exception: " + byteArrayOutputStream.toString());
            JOptionPane.showMessageDialog(null, throwable.getLocalizedMessage(), Common.I18N_MESSAGES.getString("file.failedToSave"), 0);
        }
    }

    class DocumentHandler
    extends DocumentAdapter {
        DocumentHandler() {
        }

        public void documentChanged(DocumentEvent documentEvent) {
            Document document = (Document)documentEvent.getSource();
            if (document.isLocked()) {
                ActionFileSave.this.setEnabled(false);
            } else {
                ActionFileSave.this.setEnabled(document.isChanged());
            }
        }

        public void documentLocked(DocumentEvent documentEvent) {
            ActionFileSave.this.setEnabled(false);
        }
    }

    class DocumentManagerHandler
    extends DocumentManagerAdapter {
        private DocumentListener docHandler;

        DocumentManagerHandler() {
            this.docHandler = new DocumentHandler();
        }

        public void documentSelectionChanged(DocumentManagerEvent documentManagerEvent) {
            Document document = documentManagerEvent.getOldDocument();
            Document document2 = documentManagerEvent.getNewDocument();
            if (document != null) {
                document.removeDocumentListener(this.docHandler);
            }
            if (document2 != null) {
                document2.addDocumentListener(this.docHandler);
                ActionFileSave.this.setEnabled(document2.isChanged());
            }
        }

        public void documentClosed(DocumentManagerEvent documentManagerEvent) {
            ActionFileSave.this.setEnabled(false);
        }
    }
}

