/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.action;

import com.sbs.jpm.Common;
import com.sbs.jpm.CompanyDocumentManager;
import com.sbs.jpm.document.DocumentManager;
import com.sbs.jpm.document.event.DocumentManagerAdapter;
import com.sbs.jpm.document.event.DocumentManagerEvent;
import com.sbs.jpm.print.CustomPageable;
import com.sbs.jpm.print.JPrintPreview;
import com.sbs.jpm.print.PrintManager;
import com.sbs.jpm.ui.JApplication;
import com.sbs.jpm.ui.component.JProjectView;
import java.awt.event.ActionEvent;
import java.awt.print.Pageable;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

class ActionFilePrintPreview
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private JProjectView projectView;
    private JPrintPreview previewFrame;

    public ActionFilePrintPreview() {
        this.putValue("Name", Common.I18N_ACTIONS.getString("file.printPreview"));
        this.putValue("ShortDescription", Common.I18N_ACTIONS.getString("file.printPreview.tooltip"));
        this.putValue("MnemonicKey", new Integer(87));
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/PrintPreview16.gif")));
    }

    public void registerAsDocumentManagerListener(DocumentManager documentManager) {
        documentManager.addDocumentManagerListener(new DocumentManagerHandler());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        PrintManager.setStartInterval(this.projectView.getProject().getStartDate());
        PrintManager.setEndInterval(this.projectView.getProject().getEndDate());
        this.previewFrame = new JPrintPreview((CustomPageable)((Object)this.projectView));
        this.previewFrame.setVisible(true);
        this.previewFrame.renderPage();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ActionFilePrintPreview.this.previewFrame.invalidate();
                ActionFilePrintPreview.this.previewFrame.repaint();
            }
        });
    }

    public void projectViewChanged(JProjectView jProjectView) {
        this.projectView = jProjectView;
        JApplication jApplication = Common.getApplication();
        CompanyDocumentManager companyDocumentManager = Common.getProjectDocumentManager();
        this.setEnabled(jProjectView instanceof Pageable && companyDocumentManager.getSelectedDocument() != null);
    }

    public JPrintPreview getPreviewFrame() {
        return this.previewFrame;
    }

    class DocumentManagerHandler
    extends DocumentManagerAdapter {
        DocumentManagerHandler() {
        }

        public void documentSelectionChanged(DocumentManagerEvent documentManagerEvent) {
            ActionFilePrintPreview.this.setEnabled(ActionFilePrintPreview.this.projectView instanceof Pageable && documentManagerEvent.getNewDocument() != null);
        }
    }
}

