/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.action;

import com.sbs.jpm.Common;
import com.sbs.jpm.print.JPrintPreview;
import com.sbs.jpm.ui.JApplication;
import com.sbs.jpm.ui.action.ActionFilePrintPreview;
import com.sbs.jpm.ui.action.ActionID;
import com.sbs.jpm.ui.action.ActionManager;
import java.awt.event.ActionEvent;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.PrintService;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

class ActionFilePageSetup
extends AbstractAction {
    private static final long serialVersionUID = 1L;

    public ActionFilePageSetup() {
        this.putValue("Name", Common.I18N_ACTIONS.getString("file.pageSetup"));
        this.putValue("ShortDescription", Common.I18N_ACTIONS.getString("file.pageSetup.tooltip"));
        this.putValue("MnemonicKey", new Integer(85));
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/PageSetup16.gif")));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JPrintPreview jPrintPreview;
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        JApplication jApplication = Common.getApplication();
        try {
            if (jApplication.getPrintService() != null) {
                printerJob.setPrintService(jApplication.getPrintService());
            }
        }
        catch (PrinterException printerException) {
            Common.logException("Error:", printerException);
            printerException.printStackTrace();
            JOptionPane.showMessageDialog(jApplication, Common.I18N_MESSAGES.getString("pageSetup.printerNotSupported.message"), Common.I18N_MESSAGES.getString("pageSetup.printerNotSupported.title"), 0);
        }
        jApplication.setPageFormat(printerJob.pageDialog(jApplication.getPageFormat()));
        PrintService printService = printerJob.getPrintService();
        if (printService != null) {
            jApplication.setPrintService(printerJob.getPrintService());
        }
        if ((jPrintPreview = ((ActionFilePrintPreview)ActionManager.getActionManager().getAction(ActionID.FILE_PRINT_PREVIEW)).getPreviewFrame()) != null) {
            jPrintPreview.renderPage();
            jPrintPreview.repaint();
        }
    }
}

