/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.action;

import com.sbs.jpm.Common;
import com.sbs.jpm.CompanyDocument;
import com.sbs.jpm.CompanyDocumentManager;
import com.sbs.jpm.common.IDsGenerator.IDGenerator;
import com.sbs.jpm.common.IDsGenerator.IDGeneratorInterface;
import com.sbs.jpm.common.JpmServer;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.SessionManager;
import com.sbs.jpm.core.field.FieldManager;
import com.sbs.jpm.core.io.FileType;
import com.sbs.jpm.core.io.ProjectIOManager;
import com.sbs.jpm.core.remoteClient.ClientIdGenerator;
import com.sbs.jpm.core.remoteClient.RemoteClientFactory;
import com.sbs.jpm.document.DocumentException;
import com.sbs.jpm.ui.action.ActionID;
import com.sbs.jpm.ui.action.ActionManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.jdesktop.swingx.JXLoginPanel;
import org.jdesktop.swingx.auth.LoginService;

class ActionFileOpenServer
extends AbstractAction {
    private static final long serialVersionUID = 1L;

    public ActionFileOpenServer() {
        this.putValue("Name", Common.I18N_ACTIONS.getString("file.openServer"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        RemoteClientFactory remoteClientFactory;
        CompanyDocumentManager companyDocumentManager = Common.getProjectDocumentManager();
        FieldManager.getInstance().setDefaults();
        try {
            remoteClientFactory = (RemoteClientFactory)Class.forName("com.sbs.jpm.remoteClient.spring.http.SpringHttpRemoteServer").newInstance();
        }
        catch (Throwable throwable) {
            Common.logException("Error:", throwable);
            JOptionPane.showMessageDialog(Common.getApplication(), throwable.toString(), Common.I18N_MESSAGES.getString("file.failedToOpen"), 0);
            return;
        }
        final JpmServer jpmServer = remoteClientFactory.createJmpServer();
        JXLoginPanel.Status status = JXLoginPanel.showLoginDialog((Component)Common.getApplication(), (LoginService)new LoginService(){

            public boolean authenticate(String string, char[] cArray, String string2) throws Exception {
                boolean bl = jpmServer.authenticate(string, new String(cArray));
                if (bl) {
                    SessionManager.getInstance().setUsername(string);
                    SessionManager.getInstance().setPassword(new String(cArray));
                }
                return bl;
            }
        });
        if (status == JXLoginPanel.Status.SUCCEEDED) {
            Object object;
            long l = System.currentTimeMillis();
            Company company = null;
            try {
                System.out.println("jpmServer.getCompany() ... " + System.currentTimeMillis());
                byte[] byArray = jpmServer.getCompanyData();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                object = ProjectIOManager.getProjectIOManager().getProjectIO(FileType.PROPRIETARY);
                company = object.load(byteArrayInputStream);
            }
            catch (Throwable throwable) {
                Common.logException("Error:", throwable);
            }
            long l2 = System.currentTimeMillis();
            System.out.println("company retrived in  ... " + (l2 - l));
            object = new ClientIdGenerator();
            ((IDGenerator)object).setCompany(company);
            Common.setIdGenerator(company, (IDGeneratorInterface)object);
            try {
                l = System.currentTimeMillis();
                CompanyDocument companyDocument = new CompanyDocument(company);
                if (companyDocumentManager.closeAll()) {
                    companyDocumentManager.open(companyDocument);
                }
                l2 = System.currentTimeMillis();
                System.out.println("document opened in  ... " + (l2 - l));
            }
            catch (DocumentException documentException) {
                Common.logException("Error:", documentException);
                JOptionPane.showMessageDialog(Common.getApplication(), Common.I18N_MESSAGES.getString("file.failedToSaveOnClose.message"), Common.I18N_MESSAGES.getString("file.failedToSaveOnClose.title"), 0);
            }
            ActionManager.getActionManager().getAction(ActionID.FILE_SAVE_SERVER).setEnabled(true);
        }
    }
}

