/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.action;

import com.sbs.jpm.Common;
import com.sbs.jpm.CompanyDocumentManager;
import com.sbs.jpm.document.DocumentException;
import com.sbs.jpm.ui.action.ActionID;
import com.sbs.jpm.ui.action.ActionManager;
import com.sbs.util.SystemUtilities;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

class ActionFileOpen
extends AbstractAction {
    private static final long serialVersionUID = 1L;

    public ActionFileOpen() {
        this.putValue("Name", Common.I18N_ACTIONS.getString("file.open") + "...");
        String string = Common.I18N_ACTIONS.getString("file.open.tooltip");
        string = SystemUtilities.isOSMac() ? string + " (Cmmd-O)" : string + " (Ctrl-O)";
        this.putValue("ShortDescription", string);
        this.putValue("MnemonicKey", new Integer(79));
        if (SystemUtilities.isOSMac()) {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, 256));
        } else {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, 128));
        }
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Open16.gif")));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            CompanyDocumentManager companyDocumentManager = Common.getProjectDocumentManager();
            companyDocumentManager.open();
        }
        catch (DocumentException documentException) {
            Common.logException("Error:", documentException);
            Common.logException("Error while opening a file", documentException);
            documentException.printStackTrace();
            JOptionPane.showMessageDialog(null, documentException.getLocalizedMessage(), Common.I18N_MESSAGES.getString("file.failedToOpen"), 0);
        }
        ActionManager.getActionManager().getAction(ActionID.FILE_SAVE_SERVER).setEnabled(false);
    }
}

