/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.action;

import com.sbs.jpm.Common;
import com.sbs.jpm.CompanyDocumentManager;
import com.sbs.jpm.document.DocumentException;
import com.sbs.util.SystemUtilities;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

class ActionFileImport
extends AbstractAction {
    private static final long serialVersionUID = 1L;

    public ActionFileImport() {
        super("Import from...");
        String string = SystemUtilities.isOSLinux() ? "Import" : (SystemUtilities.isOSMac() ? "Import (Cmmd-I)" : "Import (Ctrl-I)");
        this.putValue("ShortDescription", string);
        this.putValue("LongDescription", "Import a document in the application");
        this.putValue("MnemonicKey", new Integer(73));
        if (SystemUtilities.isOSMac()) {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(73, 256));
        } else {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(73, 128));
        }
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Import16.gif")));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            CompanyDocumentManager companyDocumentManager = Common.getProjectDocumentManager();
            companyDocumentManager.importDocument();
        }
        catch (DocumentException documentException) {
            Common.logException("Error:", documentException);
            documentException.printStackTrace();
            JOptionPane.showMessageDialog(null, documentException.getMessage(), "Failed to import file", 0);
        }
    }
}

