/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.action;

import com.sbs.jpm.Common;
import com.sbs.jpm.CompanyDocumentManager;
import com.sbs.jpm.document.DocumentException;
import com.sbs.jpm.document.DocumentManager;
import com.sbs.jpm.document.event.DocumentManagerAdapter;
import com.sbs.jpm.document.event.DocumentManagerEvent;
import com.sbs.util.SystemUtilities;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class ActionFileClose
extends AbstractAction {
    private static final long serialVersionUID = 1L;

    public ActionFileClose() {
        this.putValue("Name", Common.I18N_ACTIONS.getString("file.close"));
        this.putValue("ShortDescription", Common.I18N_ACTIONS.getString("file.close.tooltip"));
        this.putValue("MnemonicKey", new Integer(67));
        if (SystemUtilities.isOSMac()) {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(87, 256));
        } else {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(87, 128));
        }
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/empty.png")));
    }

    public void registerAsDocumentManagerListener(DocumentManager documentManager) {
        documentManager.addDocumentManagerListener(new DocumentManagerHandler());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        CompanyDocumentManager companyDocumentManager = Common.getProjectDocumentManager();
        try {
            companyDocumentManager.close(companyDocumentManager.getSelectedDocument());
        }
        catch (DocumentException documentException) {
            Common.logException("Error:", documentException);
            JOptionPane.showMessageDialog(Common.getApplication(), Common.I18N_MESSAGES.getString("file.failedToSaveOnClose.message"), Common.I18N_MESSAGES.getString("file.failedToSaveOnClose.title"), 0);
        }
    }

    class DocumentManagerHandler
    extends DocumentManagerAdapter {
        DocumentManagerHandler() {
        }

        public void documentClosed(DocumentManagerEvent documentManagerEvent) {
            ActionFileClose.this.setEnabled(false);
        }

        public void documentOpened(DocumentManagerEvent documentManagerEvent) {
            ActionFileClose.this.setEnabled(true);
        }

        public void documentCreated(DocumentManagerEvent documentManagerEvent) {
            ActionFileClose.this.setEnabled(true);
        }
    }
}

