/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.action;

import com.sbs.jpm.Common;
import com.sbs.jpm.CompanyDocument;
import com.sbs.jpm.document.DocumentManager;
import com.sbs.jpm.document.event.DocumentManagerAdapter;
import com.sbs.jpm.document.event.DocumentManagerEvent;
import com.sbs.jpm.ui.action.ActionEditRedo;
import com.sbs.jpm.ui.action.ActionID;
import com.sbs.jpm.ui.action.ActionManager;
import com.sbs.util.SystemUtilities;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class ActionEditUndo
extends AbstractAction {
    private static final long serialVersionUID = 1L;

    public ActionEditUndo() {
        this.putValue("Name", Common.I18N_ACTIONS.getString("edit.undo"));
        String string = Common.I18N_ACTIONS.getString("edit.undo.tooltip");
        string = SystemUtilities.isOSMac() ? string + " (Cmmd-Z)" : string + " (Ctrl-Z)";
        this.putValue("ShortDescription", string);
        this.putValue("MnemonicKey", new Integer(85));
        if (SystemUtilities.isOSMac()) {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, 256));
        } else {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, 128));
        }
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Undo16.gif")));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        CompanyDocument companyDocument = (CompanyDocument)Common.getProjectDocumentManager().getSelectedDocument();
        try {
            companyDocument.getData().getUndoManager().undo();
        }
        catch (CannotUndoException cannotUndoException) {
            Common.logException("Error:", cannotUndoException);
            cannotUndoException.printStackTrace();
        }
        this.update();
        ActionManager actionManager = ActionManager.getActionManager();
        ((ActionEditRedo)actionManager.getAction(ActionID.EDIT_REDO)).update();
    }

    public void update() {
        CompanyDocument companyDocument = (CompanyDocument)Common.getProjectDocumentManager().getSelectedDocument();
        if (companyDocument == null) {
            this.setEnabled(false);
            this.putValue("Name", Common.I18N_ACTIONS.getString("edit.undo"));
        } else {
            UndoManager undoManager = companyDocument.getData().getUndoManager();
            if (undoManager.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", undoManager.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", Common.I18N_ACTIONS.getString("edit.undo"));
            }
        }
    }

    public void registerAsDocumentManagerListener(DocumentManager documentManager) {
        documentManager.addDocumentManagerListener(new DocumentManagerHandler());
    }

    class DocumentManagerHandler
    extends DocumentManagerAdapter {
        DocumentManagerHandler() {
        }

        public void documentSelectionChanged(DocumentManagerEvent documentManagerEvent) {
            ActionEditUndo.this.update();
        }
    }
}

