/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.action;

import com.sbs.jpm.Common;
import com.sbs.jpm.CompanyDocument;
import com.sbs.jpm.document.DocumentManager;
import com.sbs.jpm.document.event.DocumentManagerAdapter;
import com.sbs.jpm.document.event.DocumentManagerEvent;
import com.sbs.jpm.ui.action.ActionEditUndo;
import com.sbs.jpm.ui.action.ActionID;
import com.sbs.jpm.ui.action.ActionManager;
import com.sbs.util.SystemUtilities;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.UndoManager;

public class ActionEditRedo
extends AbstractAction {
    private static final long serialVersionUID = 1L;

    public ActionEditRedo() {
        this.putValue("Name", Common.I18N_ACTIONS.getString("edit.redo"));
        String string = Common.I18N_ACTIONS.getString("edit.redo.tooltip");
        string = SystemUtilities.isOSMac() ? string + " (Cmmd-Z)" : string + " (Ctrl-Z)";
        this.putValue("ShortDescription", string);
        this.putValue("MnemonicKey", new Integer(82));
        if (SystemUtilities.isOSMac()) {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(89, 256));
        } else {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(89, 128));
        }
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Redo16.gif")));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        CompanyDocument companyDocument = (CompanyDocument)Common.getProjectDocumentManager().getSelectedDocument();
        try {
            companyDocument.getData().getUndoManager().redo();
        }
        catch (CannotRedoException cannotRedoException) {
            Common.logException("Error:", cannotRedoException);
            cannotRedoException.printStackTrace();
        }
        this.update();
        ActionManager actionManager = ActionManager.getActionManager();
        ((ActionEditUndo)actionManager.getAction(ActionID.EDIT_UNDO)).update();
    }

    public void update() {
        CompanyDocument companyDocument = (CompanyDocument)Common.getProjectDocumentManager().getSelectedDocument();
        if (companyDocument == null) {
            this.setEnabled(false);
            this.putValue("Name", Common.I18N_ACTIONS.getString("edit.redo"));
        } else {
            UndoManager undoManager = companyDocument.getData().getUndoManager();
            if (undoManager.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", undoManager.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", Common.I18N_ACTIONS.getString("edit.redo"));
            }
        }
    }

    public void registerAsDocumentManagerListener(DocumentManager documentManager) {
        documentManager.addDocumentManagerListener(new DocumentManagerHandler());
    }

    class DocumentManagerHandler
    extends DocumentManagerAdapter {
        DocumentManagerHandler() {
        }

        public void documentSelectionChanged(DocumentManagerEvent documentManagerEvent) {
            ActionEditRedo.this.update();
        }
    }
}

