/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui;

import com.sbs.jpm.Common;
import com.sbs.jpm.Main;
import com.sbs.jpm.configuration.Configuration;
import com.sbs.jpm.configuration.ConfigurationSetting;
import com.sbs.jpm.ui.JApplication;
import com.sbs.jpm.ui.JProject;
import com.sbs.jpm.ui.component.JAreaView;
import com.sbs.jpm.ui.component.SmartMenuBar;
import com.sbs.jpm.ui.component.view.JProjectViewGantt;
import com.sbs.jpm.ui.component.view.JProjectViewTaskSheet;
import com.sbs.jpm.ui.component.view.JProjectViewWBS;
import com.sbs.jpm.ui.event.JApplicationEvent;
import com.sbs.jpm.ui.event.JApplicationListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.EventListener;
import javax.swing.event.EventListenerList;

public class UIManager {
    public static final int NEW = 0;
    public static final int OPEN = 1;
    public static final int OPEN_LAST = 2;
    private int startupAction = 0;
    private boolean showMainToolBar = true;
    private boolean showProjectToolBar = true;
    private boolean showMailToolBar = true;
    private boolean showViewToolBar = true;
    private boolean showButtonToolBar = true;
    private boolean showProjectRoot;
    private boolean showProjectCode;
    private boolean showProjectStart = true;
    private boolean showProjectEstimatedStart = true;
    private boolean showProjectFinish = true;
    private boolean showTaskOutline;
    private boolean showCurrentDate;
    private boolean showFocusPoint = true;
    private boolean showSelection = true;
    private boolean showHorizontalGrid;
    private boolean showVerticalGrid;
    private boolean showNonWorking = true;
    private boolean showTaskId;
    private boolean showTaskName;
    private boolean showTaskDuration;
    private boolean showTaskWork;
    private boolean showTaskCompletion;
    private boolean showTaskStart;
    private boolean showTaskEnd;
    private boolean showAssignmentsName = true;
    private boolean showAssignmentsCode;
    private String dateFormat;
    private EventListenerList listeners = new EventListenerList();
    private static UIManager instance;

    private UIManager() {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
        this.dateFormat = ((SimpleDateFormat)dateFormat).toPattern();
    }

    public static UIManager getInstance() {
        if (instance == null) {
            instance = new UIManager();
        }
        return instance;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String string) {
        this.dateFormat = string;
        JApplicationEvent jApplicationEvent = new JApplicationEvent(this);
        this.fireDateFormatChanged(jApplicationEvent);
    }

    public void addJApplicationListener(JApplicationListener jApplicationListener) {
        this.listeners.add(JApplicationListener.class, jApplicationListener);
    }

    public void removeJApplicationListener(JApplicationListener jApplicationListener) {
        this.listeners.remove(JApplicationListener.class, jApplicationListener);
    }

    private void fireDateFormatChanged(JApplicationEvent jApplicationEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(JApplicationListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((JApplicationListener)eventListenerArray[i]).dateFormatChanged(jApplicationEvent);
        }
    }

    public boolean isShowFocusPoint() {
        return this.showFocusPoint;
    }

    public void setShowFocusPoint(boolean bl) {
        this.showFocusPoint = bl;
    }

    public boolean isShowProjectFinish() {
        return this.showProjectFinish;
    }

    public void setShowProjectFinish(boolean bl) {
        this.showProjectFinish = bl;
    }

    public boolean isShowProjectStart() {
        return this.showProjectStart;
    }

    public void setShowProjectStart(boolean bl) {
        this.showProjectStart = bl;
    }

    public boolean isShowHorizontalGrid() {
        return this.showHorizontalGrid;
    }

    public void setShowHorizontalGrid(boolean bl) {
        this.showHorizontalGrid = bl;
    }

    public boolean isShowNonWorking() {
        return this.showNonWorking;
    }

    public void setShowNonWorking(boolean bl) {
        this.showNonWorking = bl;
    }

    public boolean isShowSelection() {
        return this.showSelection;
    }

    public void setShowSelection(boolean bl) {
        this.showSelection = bl;
    }

    public boolean isShowTaskDuration() {
        return this.showTaskDuration;
    }

    public void setShowTaskDuration(boolean bl) {
        this.showTaskDuration = bl;
    }

    public boolean isShowTaskWork() {
        return this.showTaskWork;
    }

    public void setShowTaskWork(boolean bl) {
        this.showTaskWork = bl;
    }

    public boolean isShowTaskId() {
        return this.showTaskId;
    }

    public void setShowTaskId(boolean bl) {
        this.showTaskId = bl;
    }

    public boolean isShowTaskName() {
        return this.showTaskName;
    }

    public void setShowTaskName(boolean bl) {
        this.showTaskName = bl;
    }

    public boolean isShowAssignmentsName() {
        return this.showAssignmentsName;
    }

    public void setShowAssignmentsName(boolean bl) {
        this.showAssignmentsName = bl;
    }

    public boolean isShowVerticalGrid() {
        return this.showVerticalGrid;
    }

    public void setShowVerticalGrid(boolean bl) {
        this.showVerticalGrid = bl;
    }

    public boolean isShowCurrentDate() {
        return this.showCurrentDate;
    }

    public void setShowCurrentDate(boolean bl) {
        this.showCurrentDate = bl;
    }

    public int getStartupAction() {
        return this.startupAction;
    }

    public void setStartupAction(int n) {
        this.startupAction = n;
    }

    public void storeUISettings() {
        Configuration configuration = Configuration.getInstance();
        JApplication jApplication = Common.getApplication();
        configuration.setValue(ConfigurationSetting.MRU_FILES, ((SmartMenuBar)jApplication.getJMenuBar()).getMRUItems());
        configuration.setValue(ConfigurationSetting.FIRST_TIME, "false");
        configuration.setValue(ConfigurationSetting.DATE_FORMAT, this.getDateFormat());
        UIManager uIManager = UIManager.getInstance();
        configuration.setValue(ConfigurationSetting.INSTALL_DATE_TRIAL_VERSION, Main.INSTALL_DATE_TRIAL_VERSION);
        configuration.setValue(ConfigurationSetting.INSTALL_DATE_FULL_VERSION, Main.INSTALL_DATE_FULL_VERSION);
        configuration.setValue(ConfigurationSetting.STARTUP_ACTION, uIManager.getStartupAction());
        configuration.setValue(ConfigurationSetting.PROJECT_ROOT, uIManager.isShowProjectRoot());
        configuration.setValue(ConfigurationSetting.TASK_OUTLINE, uIManager.isShowTaskOutline());
        configuration.setValue(ConfigurationSetting.PROJECT_CODE, uIManager.isShowProjectCode());
        configuration.setValue(ConfigurationSetting.PROJECT_START_LINE, uIManager.isShowProjectStart());
        configuration.setValue(ConfigurationSetting.PROJECT_ESTIMATED_START_LINE, uIManager.isShowProjectEstimatedStart());
        configuration.setValue(ConfigurationSetting.PROJECT_FINISH_LINE, uIManager.isShowProjectFinish());
        configuration.setValue(ConfigurationSetting.CURRENT_LINE, uIManager.isShowCurrentDate());
        configuration.setValue(ConfigurationSetting.FOCUS_POINT, uIManager.isShowFocusPoint());
        configuration.setValue(ConfigurationSetting.GANTT_SELECTION, uIManager.isShowSelection());
        configuration.setValue(ConfigurationSetting.GANTT_HORIZONTAL, uIManager.isShowHorizontalGrid());
        configuration.setValue(ConfigurationSetting.GANTT_VERTICAL, uIManager.isShowVerticalGrid());
        configuration.setValue(ConfigurationSetting.CHART_NONWORKING, uIManager.isShowNonWorking());
        configuration.setValue(ConfigurationSetting.GANTT_TASK_ID, uIManager.isShowTaskId());
        configuration.setValue(ConfigurationSetting.GANTT_TASK_NAME, uIManager.isShowTaskName());
        configuration.setValue(ConfigurationSetting.GANTT_TASK_DURATION, uIManager.isShowTaskDuration());
        configuration.setValue(ConfigurationSetting.GANTT_TASK_WORK, uIManager.isShowTaskWork());
        configuration.setValue(ConfigurationSetting.GANTT_TASK_COMPLETION, uIManager.isShowTaskCompletion());
        configuration.setValue(ConfigurationSetting.GANTT_TASK_START, uIManager.isShowTaskStart());
        configuration.setValue(ConfigurationSetting.GANTT_TASK_END, uIManager.isShowTaskEnd());
        configuration.setValue(ConfigurationSetting.GANTT_TASK_RESOURCES, uIManager.isShowAssignmentsName());
        configuration.setValue(ConfigurationSetting.GANTT_TASK_RESOURCES_CODE, uIManager.isShowAssignmentsCode());
        JProject jProject = jApplication.getWorkspace().getJProject();
        if (jProject != null) {
            configuration.setValue(ConfigurationSetting.GUIDE_SIZE, jProject.getGuidePanel().getSize());
            configuration.setValue(ConfigurationSetting.GUIDE_DETAILS_SIZE, jProject.getAreaView().getGuideDetailPanel().getSize());
            configuration.setValue(ConfigurationSetting.APPLICATION_SIZE, jApplication.getSize());
            configuration.setValue(ConfigurationSetting.APPLICATION_MAXIMIZED, jApplication.getExtendedState() == 6);
        }
        configuration.store();
    }

    public boolean isShowProjectRoot() {
        return this.showProjectRoot;
    }

    public void setShowProjectRoot(boolean bl) {
        this.showProjectRoot = bl;
        JProject jProject = Common.getApplication().getWorkspace().getJProject();
        if (jProject != null) {
            ((JProjectViewGantt)jProject.getAreaView().getViewComponent(JAreaView.ASSIGN_RESOURCES)).getGantt().getTreeTable().setRootVisible(bl);
            ((JProjectViewGantt)jProject.getAreaView().getViewComponent(JAreaView.GANTT)).getGantt().getTreeTable().setRootVisible(bl);
            ((JProjectViewWBS)jProject.getAreaView().getViewComponent(JAreaView.PROJECT_WBS)).getWbs().setRootVisible(bl);
            ((JProjectViewTaskSheet)jProject.getAreaView().getViewComponent(JAreaView.TASK_SHEET)).getTaskSheet().getTreeTable().setRootVisible(bl);
            ((JProjectViewGantt)jProject.getAreaView().getViewComponent(JAreaView.PROJECT_UPDATE)).getGantt().getTreeTable().setRootVisible(bl);
        }
    }

    public boolean isShowProjectCode() {
        return this.showProjectCode;
    }

    public void setShowProjectCode(boolean bl) {
        this.showProjectCode = bl;
    }

    public boolean isShowButtonToolBar() {
        return this.showButtonToolBar;
    }

    public void setShowButtonToolBar(boolean bl) {
        this.showButtonToolBar = bl;
    }

    public boolean isShowMainToolBar() {
        return this.showMainToolBar;
    }

    public void setShowMainToolBar(boolean bl) {
        this.showMainToolBar = bl;
    }

    public boolean isShowProjectToolBar() {
        return this.showProjectToolBar;
    }

    public void setShowProjectToolBar(boolean bl) {
        this.showProjectToolBar = bl;
    }

    public boolean isShowViewToolBar() {
        return this.showViewToolBar;
    }

    public void setShowViewToolBar(boolean bl) {
        this.showViewToolBar = bl;
    }

    public boolean isShowMailToolBar() {
        return this.showMailToolBar;
    }

    public void setShowMailToolBar(boolean bl) {
        this.showMailToolBar = bl;
    }

    public boolean isShowTaskCompletion() {
        return this.showTaskCompletion;
    }

    public void setShowTaskCompletion(boolean bl) {
        this.showTaskCompletion = bl;
    }

    public boolean isShowTaskEnd() {
        return this.showTaskEnd;
    }

    public void setShowTaskEnd(boolean bl) {
        this.showTaskEnd = bl;
    }

    public boolean isShowTaskStart() {
        return this.showTaskStart;
    }

    public void setShowTaskStart(boolean bl) {
        this.showTaskStart = bl;
    }

    public boolean isShowTaskOutline() {
        return this.showTaskOutline;
    }

    public void setShowTaskOutline(boolean bl) {
        this.showTaskOutline = bl;
    }

    public boolean isShowAssignmentsCode() {
        return this.showAssignmentsCode;
    }

    public void setShowAssignmentsCode(boolean bl) {
        this.showAssignmentsCode = bl;
    }

    public boolean isShowProjectEstimatedStart() {
        return this.showProjectEstimatedStart;
    }

    public void setShowProjectEstimatedStart(boolean bl) {
        this.showProjectEstimatedStart = bl;
    }
}

