/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui;

import com.sbs.jpm.Common;
import com.sbs.jpm.Main;
import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.configuration.Configuration;
import com.sbs.jpm.configuration.ConfigurationSetting;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.TaskPlanner;
import com.sbs.jpm.core.constraint.SNET;
import com.sbs.jpm.core.event.CompanyAdapter;
import com.sbs.jpm.core.event.CompanyEvent;
import com.sbs.jpm.core.event.TaskAdapter;
import com.sbs.jpm.core.event.TaskEvent;
import com.sbs.jpm.core.event.TaskListener;
import com.sbs.jpm.core.field.FieldManager;
import com.sbs.jpm.mail.EmailManager;
import com.sbs.jpm.ui.UIManager;
import com.sbs.jpm.ui.action.ActionID;
import com.sbs.jpm.ui.action.ActionManager;
import com.sbs.jpm.ui.component.JAreaView;
import com.sbs.jpm.ui.component.JEmailNotificationDialog;
import com.sbs.jpm.ui.component.JGuide;
import com.sbs.jpm.ui.component.JProjectView;
import com.sbs.jpm.ui.component.event.JAreaViewEvent;
import com.sbs.jpm.ui.component.event.JAreaViewListener;
import com.sbs.jpm.ui.component.util.ComboBoxCompletion;
import com.sbs.jpm.ui.component.view.JProjectViewEPS;
import com.sbs.jpm.undo.CompanyCurrentProjectEdit;
import com.sbs.jpm.undo.ExtendedCompoundEdit;
import com.sbs.jpm.undo.TaskConstraintEdit;
import com.sbs.jpm.undo.TaskInsertEdit;
import com.sbs.jpm.undo.UndoHandler;
import com.sbs.util.SystemUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.net.URL;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;

public class JProject
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JAreaView areaView;
    private JProjectViewEPS epsView;
    private JGuide guidePanel;
    private JPanel showGuidePanel;
    private JPanel headerPanel;
    private JSplitPane splitPane;
    private JToggleButton selectedButton;
    private JToggleButton wbsButton;
    private JToggleButton ganttButton;
    private JToggleButton taskSheetButton;
    private JToggleButton resourceButton;
    private JToggleButton clientButton;
    private JToggleButton resourceSheetButton;
    private JToggleButton epsButton;
    private JSeparator portfolioSeparator;
    private JLabel projectLabel;
    private JComboBox projectsCombo;
    private JButton insertButton;
    private JToolBar viewToolbar;
    private Action insertAction;
    private Action switchEPSAction;
    private JToolBar mainToolbar;
    private JToolBar buttonToolbar;
    private JToolBar projectsToolbar;
    private JToolBar mailToolBar;
    private Company project;
    private ProjectHandler projectsHandler;
    private ComboBoxCompletion automaticCompletion;
    private EventListenerList listeners = new EventListenerList();
    private TaskListener taskHandler = new TaskHandler();
    private UndoHandler undoHandler;
    private int projectNo = 2;

    public JProject() {
        this.createContents();
    }

    public void toggleGuide() {
        boolean bl = this.guidePanel.isVisible();
        this.guidePanel.setVisible(!bl);
        this.showGuidePanel.setVisible(bl);
        Configuration configuration = Configuration.getInstance();
        configuration.setValue(ConfigurationSetting.GUIDE_VISIBLE, !bl);
        if (!bl) {
            Dimension dimension = (Dimension)Configuration.getInstance().getValue(ConfigurationSetting.GUIDE_SIZE);
            if (dimension != null) {
                this.setSize(dimension);
                this.splitPane.setDividerLocation(dimension.width);
            }
        } else {
            configuration.setValue(ConfigurationSetting.GUIDE_SIZE, this.getGuidePanel().getSize());
        }
    }

    public void toggleEPS() {
        boolean bl = this.epsView.isVisible();
        if (!bl) {
            this.showEPS();
        } else {
            this.epsView.setVisible(!bl);
            this.showGuidePanel.setVisible(bl && !this.guidePanel.isVisible());
            this.splitPane.setVisible(bl);
            ActionManager actionManager = ActionManager.getActionManager();
            actionManager.getAction(ActionID.VIEW_GUIDE).setEnabled(true);
            actionManager.getAction(ActionID.VIEW_GUIDE_DETAILS).setEnabled(true);
            JProjectView jProjectView = this.areaView.getActiveViewComponent();
            this.remove(this.epsView);
            this.add((Component)this.showGuidePanel, "West");
            this.add((Component)this.splitPane, "Center");
            this.headerPanel.remove(this.viewToolbar);
            this.viewToolbar = jProjectView.getToolBar();
            this.headerPanel.add((Component)this.viewToolbar, new GridBagConstraints(2, 1, 10, 1, 1.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
            if (this.selectedButton != null) {
                this.selectedButton.doClick();
            }
        }
        this.revalidate();
    }

    public void showEPS() {
        boolean bl = this.epsView.isVisible();
        if (!bl) {
            this.epsView.setVisible(!bl);
            this.showGuidePanel.setVisible(bl && !this.guidePanel.isVisible());
            this.splitPane.setVisible(bl);
            this.deselectViewButtons();
            this.selectedButton = null;
            if (this.wbsButton.isSelected()) {
                this.selectedButton = this.wbsButton;
            } else if (this.ganttButton.isSelected()) {
                this.selectedButton = this.ganttButton;
            } else if (this.taskSheetButton.isSelected()) {
                this.selectedButton = this.taskSheetButton;
            } else if (this.resourceButton.isSelected()) {
                this.selectedButton = this.resourceButton;
            } else if (this.clientButton.isSelected()) {
                this.selectedButton = this.clientButton;
            } else if (this.resourceSheetButton.isSelected()) {
                this.selectedButton = this.resourceSheetButton;
            } else if (this.epsButton.isSelected()) {
                this.selectedButton = this.epsButton;
            }
            ActionManager actionManager = ActionManager.getActionManager();
            actionManager.EPSShowed();
            actionManager.getAction(ActionID.VIEW_GUIDE).setEnabled(false);
            actionManager.getAction(ActionID.VIEW_GUIDE_DETAILS).setEnabled(false);
            this.remove(this.showGuidePanel);
            this.remove(this.splitPane);
            this.add((Component)this.epsView, "Center");
            this.headerPanel.remove(this.viewToolbar);
            this.viewToolbar = this.epsView.getToolBar();
            this.headerPanel.add((Component)this.viewToolbar, new GridBagConstraints(0, 1, 10, 1, 1.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.revalidate();
        }
    }

    public void deselectViewButtons() {
        this.wbsButton.setSelected(false);
        this.ganttButton.setSelected(false);
        this.taskSheetButton.setSelected(false);
        this.resourceButton.setSelected(false);
        this.clientButton.setSelected(false);
        this.resourceSheetButton.setSelected(false);
        this.epsButton.setSelected(false);
    }

    private JToolBar createButtonPanel() {
        Insets insets = new Insets(-4, 0, -3, 2);
        int n = -5;
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setRollover(true);
        jToolBar.setLayout(new GridLayout());
        URL uRL = this.getClass().getClassLoader().getResource("com/sbs/jpm/ui/images/wbs.png");
        ActionManager actionManager = ActionManager.getActionManager();
        this.wbsButton = new JToggleButton(actionManager.getAction(ActionID.VIEW_WBS));
        this.wbsButton.setText(Common.I18N_ACTIONS.getString("view.wbs.button"));
        this.wbsButton.setIcon(new ImageIcon(uRL));
        this.wbsButton.setSelected(false);
        this.wbsButton.setMargin(insets);
        this.wbsButton.setToolTipText(Common.I18N_ACTIONS.getString("view.wbs.tooltip"));
        this.wbsButton.setIconTextGap(n);
        this.wbsButton.setVerticalTextPosition(3);
        this.wbsButton.setHorizontalTextPosition(0);
        this.wbsButton.putClientProperty("Quaqua.Button.style", "toolBarTab");
        uRL = this.getClass().getClassLoader().getResource("com/sbs/jpm/ui/images/gantt.png");
        this.ganttButton = new JToggleButton(actionManager.getAction(ActionID.VIEW_GANTT));
        this.ganttButton.setText(Common.I18N_ACTIONS.getString("view.gantt.button"));
        this.ganttButton.setIcon(new ImageIcon(uRL));
        this.ganttButton.setSelected(false);
        this.ganttButton.setMargin(insets);
        this.ganttButton.setToolTipText(Common.I18N_ACTIONS.getString("view.gantt.tooltip"));
        this.ganttButton.setIconTextGap(n);
        this.ganttButton.setVerticalTextPosition(3);
        this.ganttButton.setHorizontalTextPosition(0);
        this.ganttButton.putClientProperty("Quaqua.Button.style", "toolBarTab");
        uRL = this.getClass().getClassLoader().getResource("com/sbs/jpm/ui/images/task_sheet.png");
        this.taskSheetButton = new JToggleButton(actionManager.getAction(ActionID.VIEW_TASK_SHEET));
        this.taskSheetButton.setText(Common.I18N_ACTIONS.getString("view.taskSheet.button"));
        this.taskSheetButton.setIcon(new ImageIcon(uRL));
        this.taskSheetButton.setSelected(false);
        this.taskSheetButton.setMargin(insets);
        this.taskSheetButton.setToolTipText(Common.I18N_ACTIONS.getString("view.taskSheet.tooltip"));
        this.taskSheetButton.setIconTextGap(n);
        this.taskSheetButton.setVerticalTextPosition(3);
        this.taskSheetButton.setHorizontalTextPosition(0);
        this.taskSheetButton.putClientProperty("Quaqua.Button.style", "toolBarTab");
        uRL = this.getClass().getClassLoader().getResource("com/sbs/jpm/ui/images/human.png");
        this.resourceButton = new JToggleButton(actionManager.getAction(ActionID.VIEW_RESOURCES));
        this.resourceButton.setText(Common.I18N_ACTIONS.getString("view.resources.button"));
        this.resourceButton.setIcon(new ImageIcon(uRL));
        this.resourceButton.setSelected(false);
        this.resourceButton.setMargin(insets);
        this.resourceButton.setToolTipText(Common.I18N_ACTIONS.getString("view.resources.tooltip"));
        this.resourceButton.setIconTextGap(n);
        this.resourceButton.setVerticalTextPosition(3);
        this.resourceButton.setHorizontalTextPosition(0);
        this.resourceButton.putClientProperty("Quaqua.Button.style", "toolBarTab");
        uRL = this.getClass().getClassLoader().getResource("com/sbs/jpm/ui/images/clients.png");
        this.clientButton = new JToggleButton(actionManager.getAction(ActionID.VIEW_CLIENTS));
        this.clientButton.setText(Common.I18N_ACTIONS.getString("view.clients.button"));
        this.clientButton.setIcon(new ImageIcon(uRL));
        this.clientButton.setSelected(false);
        this.clientButton.setMargin(insets);
        this.clientButton.setToolTipText(Common.I18N_ACTIONS.getString("view.resources.tooltip"));
        this.clientButton.setIconTextGap(n);
        this.clientButton.setVerticalTextPosition(3);
        this.clientButton.setHorizontalTextPosition(0);
        this.clientButton.putClientProperty("Quaqua.Button.style", "toolBarTab");
        uRL = this.getClass().getClassLoader().getResource("com/sbs/jpm/ui/images/res_sheet.png");
        this.resourceSheetButton = new JToggleButton(actionManager.getAction(ActionID.VIEW_RESOURCE_SHEET));
        this.resourceSheetButton.setText(Common.I18N_ACTIONS.getString("view.resourceSheet.button"));
        this.resourceSheetButton.setIcon(new ImageIcon(uRL));
        this.resourceSheetButton.setSelected(false);
        this.resourceSheetButton.setMargin(insets);
        this.resourceSheetButton.setToolTipText(Common.I18N_ACTIONS.getString("view.resourceSheet.tooltip"));
        this.resourceSheetButton.setIconTextGap(n);
        this.resourceSheetButton.setVerticalTextPosition(3);
        this.resourceSheetButton.setHorizontalTextPosition(0);
        this.resourceSheetButton.putClientProperty("Quaqua.Button.style", "toolBarTab");
        jToolBar.add(this.wbsButton);
        jToolBar.add(this.ganttButton);
        jToolBar.add(this.resourceButton);
        jToolBar.add(this.taskSheetButton);
        jToolBar.add(this.resourceSheetButton);
        JToolBar jToolBar2 = new JToolBar();
        jToolBar2.setFloatable(false);
        jToolBar2.setRollover(true);
        jToolBar2.setLayout(new GridLayout());
        this.switchEPSAction = new AbstractAction(Common.I18N_ACTIONS.getString("view.projectPortfolio.button")){

            public void actionPerformed(ActionEvent actionEvent) {
                JProject.this.showEPS();
            }
        };
        this.epsButton = new JToggleButton(actionManager.getAction(ActionID.VIEW_EPS));
        uRL = this.getClass().getClassLoader().getResource("com/sbs/jpm/ui/images/projectPortfolio.png");
        this.epsButton.setText(Common.I18N_ACTIONS.getString("view.projectPortfolio.button"));
        this.epsButton.setIcon(new ImageIcon(uRL));
        this.epsButton.setSelected(false);
        this.epsButton.setMargin(insets);
        this.epsButton.setToolTipText(Common.I18N_ACTIONS.getString("view.projectPortfolio.tooltip"));
        this.epsButton.setIconTextGap(n);
        this.epsButton.setVerticalTextPosition(3);
        this.epsButton.setHorizontalTextPosition(0);
        this.epsButton.putClientProperty("Quaqua.Button.style", "toolBarTab");
        this.epsButton.setFocusable(false);
        jToolBar2.add(this.epsButton);
        JToolBar jToolBar3 = new JToolBar();
        jToolBar3.setFloatable(false);
        jToolBar3.setRollover(true);
        this.portfolioSeparator = new JToolBar.Separator();
        jToolBar3.add(jToolBar);
        return jToolBar3;
    }

    private JGuide createGuide() {
        return new JGuide(this);
    }

    private void createContents() {
        Dimension dimension;
        this.setLayout(new BorderLayout());
        this.splitPane = new JSplitPane(1);
        if (SystemUtilities.isOSMac()) {
            this.splitPane.putClientProperty("Quaqua.SplitPane.style", "bar");
        }
        this.splitPane.setDividerSize(1);
        this.guidePanel = this.createGuide();
        Main.getInstance();
        Main.splashScreen.increaseStep(10);
        this.areaView = new JAreaView(this);
        this.epsView = new JProjectViewEPS();
        Main.getInstance();
        Main.splashScreen.increaseStep(5);
        this.epsView.setVisible(false);
        this.splitPane.add(this.guidePanel);
        this.splitPane.add(this.areaView);
        this.headerPanel = this.createHeader();
        Main.getInstance();
        Main.splashScreen.increaseStep(5);
        this.showGuidePanel = this.createShowGuidePanel();
        Main.getInstance();
        Main.splashScreen.increaseStep(5);
        this.showGuidePanel.setVisible(false);
        this.add((Component)this.headerPanel, "North");
        this.add((Component)this.showGuidePanel, "West");
        this.add((Component)this.splitPane, "Center");
        boolean bl = Boolean.valueOf(Configuration.getInstance().getValue(ConfigurationSetting.GUIDE_VISIBLE).toString());
        if (!bl) {
            this.toggleGuide();
        }
        if ((dimension = (Dimension)Configuration.getInstance().getValue(ConfigurationSetting.GUIDE_SIZE)) != null) {
            this.setSize(dimension);
            this.splitPane.setDividerLocation(dimension.width);
        }
    }

    private JToolBar createMainToolBar() {
        JToolBar jToolBar = new JToolBar("Main toolbar");
        jToolBar.setFloatable(false);
        if (SystemUtilities.isOSMac()) {
            jToolBar.setRollover(false);
        } else {
            jToolBar.setRollover(true);
        }
        jToolBar.setFocusable(false);
        ActionManager actionManager = ActionManager.getActionManager();
        jToolBar.add(actionManager.getAction(ActionID.FILE_NEW));
        jToolBar.add(actionManager.getAction(ActionID.FILE_OPEN));
        jToolBar.add(actionManager.getAction(ActionID.FILE_SAVE));
        jToolBar.addSeparator();
        jToolBar.add(actionManager.getAction(ActionID.FILE_PRINT));
        jToolBar.add(actionManager.getAction(ActionID.FILE_PRINT_PREVIEW));
        jToolBar.addSeparator();
        jToolBar.add(actionManager.getAction(ActionID.EDIT_UNDO));
        jToolBar.add(actionManager.getAction(ActionID.EDIT_REDO));
        jToolBar.addSeparator();
        this.projectsHandler = new ProjectHandler();
        this.projectsCombo = new JComboBox();
        this.projectsCombo.setEditable(true);
        this.automaticCompletion = new ComboBoxCompletion(this.projectsCombo);
        this.projectsCombo.setPreferredSize(new Dimension(150, 10));
        this.projectsCombo.setRenderer(new CustomComboboxRendeder(this.projectsCombo));
        this.insertAction = new AbstractAction(Common.I18N_ACTIONS.getString("new")){

            public void actionPerformed(ActionEvent actionEvent) {
                Task task = new Task(Common.getIdGenerator().getNewId(), Common.I18N_RP.getString("project") + " " + JProject.this.projectNo++);
                task.setCalendar(JProject.this.project.getRootTask().getCalendar());
                JProject.this.project.getRootTask().addChild(task, false);
                ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(JProject.this.project.getRootTask());
                TaskInsertEdit taskInsertEdit = new TaskInsertEdit(JProject.this.project.getRootTask(), task, JProject.this.project.getRootTask().getProjectChildNumber(), "02-10-2009 12:44:02");
                extendedCompoundEdit.addEdit(taskInsertEdit);
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(CalendarManager.getDayStartTime(calendar));
                task.getUsedCalendar().getFirstTime(calendar, true, Long.MAX_VALUE);
                SNET sNET = new SNET(calendar.getTime());
                TaskConstraintEdit taskConstraintEdit = new TaskConstraintEdit(task, task.getConstraint(), sNET, "09/11/09 12:37:02");
                task.setConstraint(sNET);
                extendedCompoundEdit.addEdit(taskConstraintEdit);
                extendedCompoundEdit.end();
                UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                JProject.this.fireUndoableEditHappened(undoableEditEvent);
                TaskPlanner.rescheduleTree(JProject.this.project.getRootTask());
                JProject.this.setCurrentProject(task);
                JProject.this.guidePanel.getTree().setSelectionRow(1);
                if (JProject.this.epsView.isVisible()) {
                    JProject.this.toggleEPS();
                }
            }
        };
        return jToolBar;
    }

    private JToolBar createSecondaryToolBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setRollover(true);
        return jToolBar;
    }

    private JPanel createShowGuidePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(0, 0, 0, 0);
        JButton jButton = new JButton(new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/show_guide.png")));
        jButton.setMargin(new Insets(-1, -1, -2, -2));
        jButton.setContentAreaFilled(false);
        jButton.setToolTipText(Common.I18N_ACTIONS.getString("view.guide.tooltip"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JProject.this.toggleGuide();
            }
        });
        JButton jButton2 = new JButton(new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/info_guide.png")));
        jButton2.setMargin(new Insets(-1, -1, -2, -2));
        jButton2.setContentAreaFilled(false);
        jButton2.setToolTipText(Common.I18N_RP.getString("guide.info"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JProject.this.guidePanel.getTree().setSelectionRow(1);
            }
        });
        JButton jButton3 = new JButton(new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/notes_guide.png")));
        jButton3.setMargin(new Insets(-1, -1, -2, -2));
        jButton3.setContentAreaFilled(false);
        jButton3.setToolTipText(Common.I18N_RP.getString("guide.notesAndLinks"));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JProject.this.guidePanel.getTree().setSelectionRow(2);
            }
        });
        JButton jButton4 = new JButton(new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/calendar_guide.png")));
        jButton4.setMargin(new Insets(-1, -1, -2, -2));
        jButton4.setContentAreaFilled(false);
        jButton4.setToolTipText(Common.I18N_RP.getString("guide.calendar"));
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JProject.this.guidePanel.getTree().setSelectionRow(3);
            }
        });
        JButton jButton5 = new JButton(new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/assumptions_guide.png")));
        jButton5.setMargin(new Insets(-1, -1, -2, -2));
        jButton5.setContentAreaFilled(false);
        jButton5.setToolTipText(Common.I18N_RP.getString("guide.assumptionsAndConstraints"));
        jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JProject.this.guidePanel.getTree().setSelectionRow(4);
            }
        });
        JButton jButton6 = new JButton(new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/risks_guide.png")));
        jButton6.setMargin(new Insets(-1, -1, -2, -2));
        jButton6.setContentAreaFilled(false);
        jButton6.setToolTipText(Common.I18N_RP.getString("guide.risks"));
        jButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JProject.this.guidePanel.getTree().setSelectionRow(5);
            }
        });
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setFloatable(false);
        jToolBar.setRollover(true);
        jToolBar.add(jButton2);
        jToolBar.add(jButton3);
        jToolBar.add(jButton4);
        jToolBar.add(jButton5);
        jToolBar.add(jButton6);
        jPanel.add((Component)jButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add(Box.createVerticalStrut(8), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)jToolBar, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)new JPanel(), new GridBagConstraints(0, 3, 1, 1, 0.0, 1.0, 21, 0, insets, 0, 0));
        return jPanel;
    }

    private JToolBar createProjectsPanel() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setRollover(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Insets insets = new Insets(0, 0, 0, 0);
        this.projectLabel = new JLabel(" " + Common.I18N_RP.getString("currentProject") + ": ");
        this.insertButton = new JButton(this.insertAction);
        this.insertButton.setFocusable(false);
        this.insertButton.setToolTipText(Common.I18N_ACTIONS.getString("new.tooltip"));
        jPanel.add((Component)this.projectLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 3, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.projectsCombo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 3, insets, 0, 0));
        jPanel.add((Component)this.insertButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 21, 3, insets, 0, 0));
        jToolBar.add(jPanel);
        return jToolBar;
    }

    private void setViewToolbar(JPanel jPanel, JToolBar jToolBar) {
        if (jToolBar.getComponentCount() > 0) {
            jPanel.add((Component)jToolBar, new GridBagConstraints(0, 1, 10, 1, 0.0, 0.0, 25, 0, new Insets(0, 0, 0, 0), 0, 0));
            jToolBar.setVisible(UIManager.getInstance().isShowViewToolBar());
        }
    }

    private JPanel createHeader() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Insets insets = new Insets(0, 0, 0, 0);
        this.mainToolbar = this.createMainToolBar();
        this.viewToolbar = this.createSecondaryToolBar();
        this.buttonToolbar = this.createButtonPanel();
        this.projectsToolbar = this.createProjectsPanel();
        UIManager uIManager = UIManager.getInstance();
        jPanel.add((Component)this.mainToolbar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        this.mainToolbar.setVisible(uIManager.isShowMainToolBar());
        JButton jButton = new JButton(new ImageIcon(this.getClass().getClassLoader().getResource("com/sbs/jpm/ui/images/emailAssignments.png")));
        jButton.setToolTipText(Common.I18N_ACTIONS.getString("emailAssignments.tooltip"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EmailManager emailManager = EmailManager.getInstance();
                emailManager.loadSettings();
                if (emailManager.getMailUsername().equals("rplantest@gmail.com")) {
                    JOptionPane.showMessageDialog(JProject.this, Common.I18N_MESSAGES.getString("email.serverPropertiesNotSet.message"), Common.I18N_MESSAGES.getString("email.serverPropertiesNotSet.title"), 2);
                }
                JEmailNotificationDialog jEmailNotificationDialog = new JEmailNotificationDialog(JProject.this.project.getCurrentTask());
                jEmailNotificationDialog.pack();
                jEmailNotificationDialog.setLocationRelativeTo(Common.getApplication());
                jEmailNotificationDialog.setVisible(true);
            }
        });
        this.mailToolBar = new JToolBar();
        this.mailToolBar.setFloatable(false);
        this.mailToolBar.addSeparator();
        this.mailToolBar.add(jButton);
        this.mailToolBar.setVisible(uIManager.isShowMailToolBar());
        jPanel.add((Component)this.mailToolBar, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        this.mailToolBar.setVisible(uIManager.isShowMailToolBar());
        this.setViewToolbar(jPanel, this.viewToolbar);
        jPanel.add((Component)new JPanel(), new GridBagConstraints(4, 0, 1, 2, 1.0, 1.0, 24, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.buttonToolbar, new GridBagConstraints(5, 0, 1, 2, 0.0, 0.0, 24, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonToolbar.setVisible(uIManager.isShowButtonToolBar());
        return jPanel;
    }

    private void addTasksListeners(Task task) {
        task.addTaskListener(this.taskHandler);
        for (int i = 0; i < task.getProjectChildNumber(); ++i) {
            this.addTasksListeners(task.getProjectChildAt(i));
        }
    }

    private void removeTasksListeners(Task task) {
        task.removeTaskListener(this.taskHandler);
        for (int i = 0; i < task.getProjectChildNumber(); ++i) {
            this.removeTasksListeners(task.getProjectChildAt(i));
        }
    }

    public void setCurrentProject(Task task) {
        if (task != null) {
            CompanyCurrentProjectEdit companyCurrentProjectEdit = new CompanyCurrentProjectEdit(this.project, this.project.getCurrentTask(), task, 1);
            task.getCompany().setCurrentTask(task);
            if (task.getName().equals(Common.I18N_RP.getString("allProjects"))) {
                this.projectsCombo.setFont(this.projectsCombo.getFont().deriveFont(1));
            } else {
                this.projectsCombo.setFont(this.projectsCombo.getFont().deriveFont(0));
            }
            UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, companyCurrentProjectEdit);
            this.fireUndoableEditHappened(undoableEditEvent);
        }
    }

    public void setProject(Company company) {
        boolean bl;
        Serializable serializable;
        this.project = company;
        if (company.getMultiProject() == 1) {
            this.projectLabel.setVisible(false);
            this.projectsCombo.setVisible(false);
            this.insertButton.setVisible(false);
            this.epsButton.setVisible(false);
            this.portfolioSeparator.setVisible(false);
        } else if (company.getMultiProject() == 0 && !((Task)(serializable = company.getRootTask())).getName().equals(Common.I18N_RP.getString("allProjects"))) {
            this.projectLabel.setVisible(false);
            this.projectsCombo.setVisible(false);
            this.insertButton.setVisible(false);
            this.epsButton.setVisible(false);
            this.portfolioSeparator.setVisible(false);
        }
        this.projectNo = company.getRootTask().getProjectTaskList().size();
        company.addCompanyListener(new CompanyAdapter(){

            public void currentProjectChanged(CompanyEvent companyEvent) {
                JProject.this.updateProjectsCombo(companyEvent.getProject());
            }
        });
        this.addTasksListeners(company.getRootTask());
        serializable = this.getTopLevelAncestor();
        boolean bl2 = bl = !((Component)serializable).isVisible();
        if (bl) {
            ((Component)serializable).addComponentListener(new ComponentAdapter((Container)serializable){
                final /* synthetic */ Container val$ancestor;
                {
                    this.val$ancestor = container;
                }

                public void componentShown(ComponentEvent componentEvent) {
                    JProject.this.areaView.addJAreaViewListener(new JAreaViewHandler());
                    this.val$ancestor.removeComponentListener(this);
                }
            });
            bl = false;
        }
        if (company != null) {
            this.removeUndoableEditListener(this.undoHandler);
            this.undoHandler = new UndoHandler(company.getUndoManager());
            this.addUndoableEditListener(this.undoHandler);
            this.areaView.setProject(company);
            this.epsView.setProject(company.getRootTask());
            this.updateProjectsCombo(company.getCurrentTask());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Configuration.getInstance().loadUISettings();
                    JProject jProject = Common.getApplication().getWorkspace().getJProject();
                    if (jProject.getAreaView().getCurrentViewName() == null) {
                        jProject.getGuidePanel().getTree().setSelectionRow(1);
                    }
                    JProject.this.project.setLoaded(false);
                    FieldManager.getInstance().setCustomNames();
                    JProject.this.project.setLoaded(true);
                }
            });
        }
    }

    private void updateProjectsCombo(Task task) {
        this.projectsCombo.getEditor().getEditorComponent().removeKeyListener(this.projectsHandler);
        this.projectsCombo.getEditor().getEditorComponent().removeFocusListener(this.projectsHandler);
        this.projectsCombo.removeActionListener(this.projectsHandler);
        List<Task> list = task.getCompany().getRootTask().getProjectTaskList();
        Collections.sort(list, new Comparator<Task>(){

            @Override
            public int compare(Task task, Task task2) {
                if (task == null) {
                    if (task2 == null) {
                        return 0;
                    }
                    return -1;
                }
                if (task2 == null) {
                    return 1;
                }
                return task.getName().compareToIgnoreCase(task2.getName());
            }
        });
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(list.toArray());
        this.automaticCompletion.setModel(defaultComboBoxModel);
        this.projectsCombo.setSelectedItem(task);
        JTextField jTextField = (JTextField)this.projectsCombo.getEditor().getEditorComponent();
        jTextField.setCaretPosition(0);
        this.projectsCombo.getEditor().getEditorComponent().addKeyListener(this.projectsHandler);
        this.projectsCombo.getEditor().getEditorComponent().addFocusListener(this.projectsHandler);
        this.projectsCombo.addActionListener(this.projectsHandler);
    }

    public JAreaView getAreaView() {
        return this.areaView;
    }

    public void updateToolbar(JProjectView jProjectView) {
        this.headerPanel.remove(this.viewToolbar);
        this.viewToolbar = jProjectView.getToolBar();
        this.setViewToolbar(this.headerPanel, this.viewToolbar);
        this.validate();
        this.repaint();
    }

    public JGuide getGuidePanel() {
        return this.guidePanel;
    }

    public JToggleButton getGanttButton() {
        return this.ganttButton;
    }

    public JToggleButton getResourceButton() {
        return this.resourceButton;
    }

    public JToggleButton getClientButton() {
        return this.clientButton;
    }

    public JToggleButton getResourceSheetButton() {
        return this.resourceSheetButton;
    }

    public JToggleButton getTaskSheetButton() {
        return this.taskSheetButton;
    }

    public JToggleButton getWbsButton() {
        return this.wbsButton;
    }

    public JToggleButton getEPSButton() {
        return this.epsButton;
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.add(UndoableEditListener.class, undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.remove(UndoableEditListener.class, undoableEditListener);
    }

    private void fireUndoableEditHappened(UndoableEditEvent undoableEditEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(UndoableEditListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((UndoableEditListener)eventListenerArray[i]).undoableEditHappened(undoableEditEvent);
        }
    }

    public JProjectViewEPS getEpsView() {
        return this.epsView;
    }

    public int getProjectNo() {
        return this.projectNo;
    }

    public void setProjectNo(int n) {
        this.projectNo = n;
    }

    public Company getProject() {
        return this.project;
    }

    public JToolBar getViewToolbar() {
        return this.viewToolbar;
    }

    public JToolBar getButtonToolbar() {
        return this.buttonToolbar;
    }

    public JToolBar getProjectsToolbar() {
        return this.projectsToolbar;
    }

    public JToolBar getMainToolbar() {
        return this.mainToolbar;
    }

    public JToolBar getMailToolBar() {
        return this.mailToolBar;
    }

    private class ProjectHandler
    extends KeyAdapter
    implements ActionListener,
    FocusListener {
        private ProjectHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getModifiers() == 16) {
                JProject.this.setCurrentProject((Task)((JComboBox)actionEvent.getSource()).getSelectedItem());
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 10) {
                JProject.this.setCurrentProject((Task)JProject.this.projectsCombo.getSelectedItem());
            } else if (n == 27) {
                this.cancel();
            }
        }

        private void cancel() {
            JProject.this.projectsCombo.setSelectedItem(JProject.this.project.getCurrentTask());
            JTextComponent jTextComponent = (JTextComponent)JProject.this.projectsCombo.getEditor().getEditorComponent();
            jTextComponent.setSelectionStart(jTextComponent.getText().length());
            jTextComponent.setSelectionEnd(jTextComponent.getText().length());
            jTextComponent.setCaretPosition(0);
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            this.cancel();
        }
    }

    class TaskHandler
    extends TaskAdapter {
        TaskHandler() {
        }

        public void changingNameChanged(TaskEvent taskEvent) {
            Task task = (Task)taskEvent.getSource();
            if (JProject.this.projectsCombo.getSelectedItem().equals(task)) {
                JTextField jTextField = (JTextField)JProject.this.projectsCombo.getEditor().getEditorComponent();
                jTextField.setText(task.getName());
                jTextField.setCaretPosition(0);
                JProject.this.projectsCombo.repaint();
            }
        }

        public void nameChanged(TaskEvent taskEvent) {
            Task task = (Task)taskEvent.getSource();
            if (JProject.this.projectsCombo.getSelectedItem().equals(task)) {
                JTextField jTextField = (JTextField)JProject.this.projectsCombo.getEditor().getEditorComponent();
                jTextField.setText(task.getName());
                jTextField.setCaretPosition(0);
                JProject.this.projectsCombo.repaint();
            }
        }

        public void childAdded(TaskEvent taskEvent) {
            Task task = taskEvent.getTask();
            if (task.isProject()) {
                JProject.this.addTasksListeners(task);
                JProject.this.updateProjectsCombo(JProject.this.project.getCurrentTask());
            }
        }

        public void childWillRemove(TaskEvent taskEvent) {
            Task task = taskEvent.getTask();
            if (task.isProject()) {
                JProject.this.removeTasksListeners(task);
            }
        }

        public void childRemoved(TaskEvent taskEvent) {
            Task task = taskEvent.getTask();
            if (task.isProject()) {
                if (JProject.this.projectsCombo.getSelectedItem().equals(task)) {
                    JProject.this.projectsCombo.setSelectedItem(JProject.this.project.getRootTask());
                    JProject.this.updateProjectsCombo(JProject.this.project.getRootTask());
                } else {
                    JProject.this.updateProjectsCombo(JProject.this.project.getCurrentTask());
                }
            }
        }
    }

    class CustomComboboxRendeder
    extends DefaultListCellRenderer {
        private Font initialFont;

        public CustomComboboxRendeder(JComboBox jComboBox) {
            this.initialFont = jComboBox.getFont();
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component;
            Serializable serializable;
            if (UIManager.getInstance().isShowTaskOutline()) {
                serializable = (Task)object;
                component = super.getListCellRendererComponent((JList<?>)jList, serializable.getOutlineNumber() + " " + serializable.getName(), n, bl, bl2);
            } else {
                component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            }
            if (n == 0) {
                serializable = this.initialFont.deriveFont(1);
                component.setFont((Font)serializable);
            } else {
                component.setFont(this.initialFont);
            }
            return component;
        }
    }

    class JAreaViewHandler
    implements JAreaViewListener {
        JAreaViewHandler() {
        }

        public void projectViewChanged(JAreaViewEvent jAreaViewEvent) {
            JProjectView jProjectView = jAreaViewEvent.getProjectView();
            JProject.this.updateToolbar(jProjectView);
        }
    }
}

