/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui;

import com.sbs.jpm.Common;
import com.sbs.jpm.CompanyDocument;
import com.sbs.jpm.CompanyDocumentManager;
import com.sbs.jpm.Main;
import com.sbs.jpm.document.AbstractDocument;
import com.sbs.jpm.document.Document;
import com.sbs.jpm.document.event.DocumentAdapter;
import com.sbs.jpm.document.event.DocumentEvent;
import com.sbs.jpm.document.event.DocumentListener;
import com.sbs.jpm.document.event.DocumentManagerAdapter;
import com.sbs.jpm.document.event.DocumentManagerEvent;
import com.sbs.jpm.ui.JWorkspace;
import com.sbs.jpm.ui.action.ActionID;
import com.sbs.jpm.ui.action.ActionManager;
import com.sbs.jpm.ui.component.SmartMenuBar;
import com.sbs.jpm.ui.component.StatusBar;
import com.sbs.util.SystemUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.text.MessageFormat;
import javax.print.PrintService;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;

public class JApplication
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JWorkspace workspace;
    private JMenuBar menuBar;
    private JPanel statusBar;
    private PageFormat pageFormat;
    private PrintService printSevice;
    private Dimension size = new Dimension(820, 700);
    private static final String APPLICATION_NAME = "RationalPlan";
    private static final String APPLICATION_SITE = "http://www.rationalplan.com";
    private static final String APPLICATION_SHORT_NAME = "RationalPlan";
    private static final String APPLICATION_VERSION = "3.15.7";
    private static final String APPLICATION_UI_SETTINGS = "com/sbs/jpm/ui/projectUI.xml";

    public JApplication() {
        super(JApplication.getApplicationName());
        this.setIconImage(new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/logo-16.png")).getImage());
        this.pageFormat = PrinterJob.getPrinterJob().defaultPage();
        this.pageFormat.setOrientation(0);
        this.setName(JApplication.getApplicationName());
        this.setJMenuBar(this.createMenuBar());
        Common.setProjectDocumentManager(new CompanyDocumentManager());
        ActionManager actionManager = ActionManager.getActionManager();
        actionManager.registerAsDocumentManagerListener(Common.getProjectDocumentManager());
        Main.getInstance();
        Main.splashScreen.increaseStep(5);
        this.workspace = new JWorkspace();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.workspace, "Center");
        this.getContentPane().add((Component)this.createStatusBar(), "South");
        Common.getProjectDocumentManager().addDocumentManagerListener(new ProjectDocumentManagerHandler());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Action action = ActionManager.getActionManager().getAction(ActionID.APPLICATION_HIDE);
                action.actionPerformed(null);
            }
        });
        Main.getInstance();
        Main.splashScreen.increaseStep(5);
    }

    public JMenuBar getJMenuBar() {
        return this.menuBar;
    }

    public static final String getApplicationName() {
        return "RationalPlan Single Project";
    }

    public static final String getApplicationShortName() {
        return "RationalPlan";
    }

    public static final String getApplicationVersion() {
        return APPLICATION_VERSION;
    }

    public static String getApplicationSite() {
        return APPLICATION_SITE;
    }

    public static final String getApplicationUISettings() {
        return APPLICATION_UI_SETTINGS;
    }

    public Dimension getPreferredSize() {
        return this.size;
    }

    private JMenuBar createMenuBar() {
        this.menuBar = new SmartMenuBar();
        return this.menuBar;
    }

    private JPanel createStatusBar() {
        this.statusBar = new JPanel();
        Object[] objectArray = new Object[]{JApplication.getApplicationName()};
        this.statusBar = new StatusBar(MessageFormat.format(Common.I18N_RP.getString("buyToday"), objectArray));
        return this.statusBar;
    }

    public JWorkspace getWorkspace() {
        return this.workspace;
    }

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.pageFormat = pageFormat;
    }

    public PrintService getPrintService() {
        return this.printSevice;
    }

    public void setPrintService(PrintService printService) {
        this.printSevice = printService;
    }

    class ProjectDocumentHandler
    extends DocumentAdapter {
        ProjectDocumentHandler() {
        }

        public void documentChanged(DocumentEvent documentEvent) {
            Document document = (Document)documentEvent.getSource();
            if (document.isChanged()) {
                if (SystemUtilities.isOSMac()) {
                    JApplication.this.getRootPane().putClientProperty("Window.documentModified", Boolean.TRUE);
                } else {
                    JApplication.this.setTitle("*" + JApplication.this.getTitle());
                }
            } else {
                if (SystemUtilities.isOSMac()) {
                    JApplication.this.getRootPane().putClientProperty("Window.documentModified", Boolean.FALSE);
                }
                JApplication.this.setTitle(document.getFile().getName() + " - " + JApplication.getApplicationName());
            }
        }

        public void documentFileChanged(DocumentEvent documentEvent) {
            Document document = (Document)documentEvent.getSource();
            if (((AbstractDocument)document).isProprietary()) {
                JApplication.this.setTitle(document.getFile().getName() + " - " + JApplication.getApplicationName());
            } else {
                JApplication.this.setTitle(Common.I18N_RP.getString("untitled") + " - " + JApplication.getApplicationName());
            }
            ((SmartMenuBar)JApplication.this.getJMenuBar()).addMRUItem(document.getFile().getAbsolutePath());
        }
    }

    class ProjectDocumentManagerHandler
    extends DocumentManagerAdapter {
        private DocumentListener docHandler;

        ProjectDocumentManagerHandler() {
            this.docHandler = new ProjectDocumentHandler();
        }

        public void documentClosed(DocumentManagerEvent documentManagerEvent) {
            Document document = documentManagerEvent.getNewDocument();
            if (document instanceof CompanyDocument) {
                JApplication.this.workspace.removeProject((CompanyDocument)document);
            }
        }

        public void documentOpened(DocumentManagerEvent documentManagerEvent) {
            Document document = documentManagerEvent.getNewDocument();
            if (document instanceof CompanyDocument) {
                CompanyDocument companyDocument = (CompanyDocument)document;
                JApplication.this.workspace.addProject(companyDocument);
                if (companyDocument.getFile() != null) {
                    ((SmartMenuBar)JApplication.this.getJMenuBar()).addMRUItem(companyDocument.getFile().getAbsolutePath());
                }
            }
        }

        public void documentSelectionChanged(DocumentManagerEvent documentManagerEvent) {
            Document document = documentManagerEvent.getNewDocument();
            Document document2 = documentManagerEvent.getOldDocument();
            if (document2 != null) {
                document2.removeDocumentListener(this.docHandler);
            }
            if (document != null) {
                if (!((AbstractDocument)document).isProprietary() || document.getFile() == null) {
                    JApplication.this.setTitle(Common.I18N_RP.getString("untitled") + " - " + JApplication.getApplicationName());
                    if (SystemUtilities.isOSMac()) {
                        JApplication.this.getRootPane().putClientProperty("Window.documentModified", Boolean.TRUE);
                    }
                } else {
                    JApplication.this.setTitle(document.getFile().getName() + " - " + JApplication.getApplicationName());
                    if (SystemUtilities.isOSMac()) {
                        JApplication.this.getRootPane().putClientProperty("Window.documentFile", document.getFile());
                        JApplication.this.getRootPane().putClientProperty("Window.documentModified", Boolean.FALSE);
                    }
                }
                document.addDocumentListener(this.docHandler);
            } else {
                if (SystemUtilities.isOSMac()) {
                    JApplication.this.getRootPane().putClientProperty("Window.documentModified", Boolean.FALSE);
                }
                JApplication.this.setTitle(JApplication.this.getName());
            }
        }

        public void documentCreated(DocumentManagerEvent documentManagerEvent) {
            Document document = documentManagerEvent.getNewDocument();
            if (document instanceof CompanyDocument) {
                JApplication.this.workspace.addProject((CompanyDocument)document);
            }
        }
    }
}

