/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.shareit;

import com.sbs.jpm.Common;
import com.sbs.jpm.configuration.Configuration;
import com.sbs.jpm.configuration.ConfigurationSetting;
import com.sbs.jpm.key.KeyHandler;
import com.sbs.jpm.key.SNManager;
import com.sbs.jpm.shareit.ShareItKeyDecoder;
import com.sbs.jpm.ui.JApplication;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class ShareItKeyHandler
implements KeyHandler {
    public boolean handle(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Common.LOGGER.severe("Unsupported Encoding Exception for the serial");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            unsupportedEncodingException.printStackTrace(printStream);
            printStream.flush();
            Common.LOGGER.severe("Exception: " + byteArrayOutputStream.toString());
            return false;
        }
        return this.handle(byArray);
    }

    public boolean handle(byte[] byArray) {
        try {
            SNManager sNManager = SNManager.getInstance();
            SecretKey secretKey = ShareItKeyHandler.generateKey();
            ShareItKeyDecoder shareItKeyDecoder = new ShareItKeyDecoder(secretKey);
            byte[] byArray2 = shareItKeyDecoder.decodeKey(byArray);
            if (byArray2.length > 0) {
                byte by = byArray2[0];
                Common.LOGGER.info("Major version: " + by);
                byte by2 = byArray2[1];
                Common.LOGGER.info("Secrete code length: " + by2);
                byte by3 = (byte)Character.digit(JApplication.getApplicationVersion().charAt(0), 10);
                if (by == by3) {
                    byte[] byArray3 = new byte[by2];
                    byte[] byArray4 = new byte[byArray2.length - by2 - 2];
                    System.arraycopy(byArray2, 2, byArray3, 0, by2);
                    System.arraycopy(byArray2, 2 + by2, byArray4, 0, byArray2.length - by2 - 2);
                    Common.LOGGER.info("Secrete code: " + new String(byArray3));
                    if (Arrays.equals(byArray3, sNManager.getCode())) {
                        Configuration.getInstance().setValue(ConfigurationSetting.KEY_USER, new String(byArray4, "UTF-8"));
                        return true;
                    }
                }
            } else {
                Common.LOGGER.warning("The serial is empty");
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    public static SecretKey generateKey() {
        try {
            byte[] byArray = "StandBySoft".getBytes("UTF-8");
            SecretKeySpec secretKeySpec = new SecretKeySpec(ShareItKeyHandler.addParity(byArray), "DES");
            return secretKeySpec;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Common.LOGGER.severe("Unable to generate secrete key");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            unsupportedEncodingException.printStackTrace(printStream);
            printStream.flush();
            Common.LOGGER.severe("Exception: " + byteArrayOutputStream.toString());
            return null;
        }
    }

    private static byte[] addParity(byte[] byArray) {
        byte[] byArray2 = new byte[8];
        int n = 1;
        int n2 = 0;
        for (int i = 0; i < 56; ++i) {
            boolean bl;
            boolean bl2 = bl = (byArray[6 - i / 8] & 1 << i % 8) > 0;
            if (bl) {
                int n3 = 7 - n / 8;
                byArray2[n3] = (byte)(byArray2[n3] | 1 << n % 8 & 0xFF);
                ++n2;
            }
            if ((i + 1) % 7 == 0) {
                if (n2 % 2 == 0) {
                    int n4 = 7 - n / 8;
                    byArray2[n4] = (byte)(byArray2[n4] | 1);
                }
                ++n;
                n2 = 0;
            }
            ++n;
        }
        return byArray2;
    }
}

