/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.shareit;

import com.sbs.jpm.Common;
import com.sbs.jpm.key.KeyDecoder;
import com.sbs.jpm.key.KeyException;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

public class ShareItKeyDecoder
implements KeyDecoder {
    private Cipher dcipher;

    public ShareItKeyDecoder(SecretKey secretKey) throws KeyException {
        try {
            this.dcipher = Cipher.getInstance("DES");
            this.dcipher.init(2, secretKey);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            noSuchPaddingException.printStackTrace(printStream);
            printStream.flush();
            Common.LOGGER.severe("Exception: " + byteArrayOutputStream.toString());
            throw new KeyException(noSuchPaddingException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            noSuchAlgorithmException.printStackTrace(printStream);
            printStream.flush();
            Common.LOGGER.severe("Exception: " + byteArrayOutputStream.toString());
            throw new KeyException(noSuchAlgorithmException.getMessage());
        }
        catch (InvalidKeyException invalidKeyException) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            invalidKeyException.printStackTrace(printStream);
            printStream.flush();
            Common.LOGGER.severe("Exception: " + byteArrayOutputStream.toString());
            throw new KeyException(invalidKeyException.getMessage());
        }
    }

    public byte[] decodeKey(byte[] byArray) throws KeyException {
        try {
            byte[] byArray2 = this.dcipher.doFinal(byArray);
            return byArray2;
        }
        catch (BadPaddingException badPaddingException) {
            Common.LOGGER.severe("Unable to decode key: " + badPaddingException.getMessage());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            badPaddingException.printStackTrace(printStream);
            printStream.flush();
            Common.LOGGER.severe("Exception: " + byteArrayOutputStream.toString());
            throw new KeyException(badPaddingException.getMessage());
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            Common.LOGGER.severe("Unable to decode key: " + illegalBlockSizeException.getMessage());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            illegalBlockSizeException.printStackTrace(printStream);
            printStream.flush();
            Common.LOGGER.severe("Exception: " + byteArrayOutputStream.toString());
            throw new KeyException(illegalBlockSizeException.getMessage());
        }
    }
}

