/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.print;

import com.sbs.util.SystemUtilities;
import java.awt.Component;
import java.awt.Graphics2D;
import java.util.Date;
import javax.swing.RepaintManager;

public class PrintManager {
    public static final int TOP = 2;
    public static final int BOTTOM = 20;
    public static final int LEFT = 2;
    public static final int RIGHT = 2;
    private static boolean showHeader = true;
    public static final double SCALE = 1.3;
    public static double ZOOM = 1.0;
    private static Date startInterval;
    private static Date endInterval;
    public static Integer[] zoomLevels;

    private static void disableDoubleBuffering(Component component) {
        RepaintManager repaintManager = RepaintManager.currentManager(component);
        repaintManager.setDoubleBufferingEnabled(false);
    }

    private static void enableDoubleBuffering(Component component) {
        RepaintManager repaintManager = RepaintManager.currentManager(component);
        repaintManager.setDoubleBufferingEnabled(true);
    }

    public static void bufferAndPaint(Graphics2D graphics2D, Component component) {
        boolean bl = SystemUtilities.isOSMac();
        if (!bl) {
            PrintManager.disableDoubleBuffering(component);
        }
        component.paint(graphics2D);
        if (!bl) {
            PrintManager.enableDoubleBuffering(component);
        }
    }

    public static boolean isShowHeader() {
        return showHeader;
    }

    public static void setShowHeader(boolean bl) {
        showHeader = bl;
    }

    public static Date getStartInterval() {
        return startInterval;
    }

    public static void setStartInterval(Date date) {
        startInterval = date;
    }

    public static Date getEndInterval() {
        return endInterval;
    }

    public static void setEndInterval(Date date) {
        endInterval = date;
    }

    static {
        zoomLevels = new Integer[]{25, 50, 75, 100, 125, 150, 175, 200};
    }
}

