/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.print;

import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import com.sbs.jpm.Common;
import com.sbs.jpm.PDFFileFilter;
import com.sbs.jpm.configuration.Configuration;
import com.sbs.jpm.configuration.ConfigurationSetting;
import com.sbs.jpm.print.CustomPageable;
import com.sbs.jpm.print.PrintManager;
import com.sbs.jpm.ui.JApplication;
import com.sbs.jpm.ui.action.ActionID;
import com.sbs.jpm.ui.action.ActionManager;
import com.sbs.jpm.ui.component.view.JProjectViewGantt;
import com.sbs.jpm.ui.component.view.JProjectViewResourceSheet;
import com.sbs.jpm.ui.component.view.JProjectViewTaskSheet;
import com.sbs.util.SystemUtilities;
import com.standbysoft.component.date.DefaultDateSelectionModel;
import com.standbysoft.component.date.event.DateSelectionAdapter;
import com.standbysoft.component.date.event.DateSelectionEvent;
import com.standbysoft.component.date.event.DateSelectionListener;
import com.standbysoft.component.date.swing.JDatePicker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.InternationalFormatter;

public class JPrintPreview
extends JFrame {
    private JPrintPreviewMultiPage pagePanel;
    private JPrintPreviewToolBar toolbar;
    private CustomPageable pageable;
    private boolean singlePage;
    private boolean fitToPage;
    private WindowHandler windowHandler;
    private int pageIndex = 0;

    public JPrintPreview(CustomPageable customPageable) {
        super(Common.I18N_ACTIONS.getString("file.printPreview"));
        this.setIconImage(new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/logo-16.png")).getImage());
        this.pageable = customPageable;
        this.windowHandler = new WindowHandler();
        this.init();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this.windowHandler);
        this.addComponentListener(this.windowHandler);
    }

    private void init() {
        this.setBounds(Common.getApplication().getBounds());
        this.pagePanel = new JPrintPreviewMultiPage(this, this.pageable);
        this.toolbar = new JPrintPreviewToolBar(this);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(true);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.toolbar, "North");
        jPanel.add((Component)this.pagePanel, "Center");
        this.setContentPane(jPanel);
        this.renderPage();
    }

    public void nextPage() {
        ++this.pageIndex;
        this.renderPage();
    }

    public void previousPage() {
        --this.pageIndex;
        this.renderPage();
    }

    public void upPage() {
        this.pageIndex -= this.pageable.getHorizontalNumberOfPages();
        this.renderPage();
    }

    public void downPage() {
        this.pageIndex += this.pageable.getHorizontalNumberOfPages();
        this.renderPage();
    }

    public void toPage(int n) {
        this.singlePage = true;
        this.pageIndex = n;
        if (this.pageIndex < 0) {
            this.pageIndex = 0;
        } else {
            int n2 = this.pageable.getNumberOfPages();
            if (this.pageIndex >= n2) {
                this.pageIndex = n2 - 1;
            }
        }
        this.renderPage();
    }

    public void firstPage() {
        this.pageIndex = 0;
        this.renderPage();
    }

    public void lastPage() {
        this.pageIndex = this.pageable.getNumberOfPages() - 1;
        this.renderPage();
    }

    public void singlePage() {
        this.singlePage = true;
        this.renderPage();
    }

    public void multiPage() {
        this.singlePage = false;
        this.renderPage();
    }

    public void fitToPage() {
        double d;
        double d2;
        double d3;
        PageFormat pageFormat = Common.getApplication().getPageFormat();
        Dimension dimension = this.pageable.getPrintSize();
        double d4 = dimension.getHeight();
        double d5 = dimension.getWidth();
        if (pageFormat.getOrientation() == 1) {
            d3 = pageFormat.getPaper().getImageableWidth() * 1.3 - 2.0 - 2.0;
            d2 = pageFormat.getPaper().getImageableHeight() * 1.3 - 2.0 - 20.0;
        } else {
            d3 = pageFormat.getPaper().getImageableHeight() * 1.3 - 2.0 - 2.0;
            d2 = pageFormat.getPaper().getImageableWidth() * 1.3 - 2.0 - 20.0;
        }
        double d6 = d3 / d5;
        double d7 = d2 / d4;
        double d8 = d6 < d7 ? d6 : d7;
        long l = (long)(d8 * 10000.0);
        PrintManager.ZOOM = d = (double)l / 10000.0;
        this.toolbar.zoomCombo.removeItemListener(this.toolbar.zoomHandler);
        this.toolbar.zoomCombo.setSelectedItem(d * 100.0);
        this.toolbar.zoomCombo.addItemListener(this.toolbar.zoomHandler);
        this.pagePanel.computePages();
        this.pageIndex = 0;
    }

    public void renderPage() {
        if (this.fitToPage) {
            this.fitToPage();
        }
        if (this.singlePage) {
            this.pagePanel.renderPage(this.pageIndex);
            this.toolbar.renderPage(this.pageIndex);
        } else {
            this.pagePanel.renderPage();
            this.toolbar.renderPage();
        }
    }

    private class WindowHandler
    extends WindowAdapter
    implements ActionListener,
    ComponentListener {
        private WindowHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            this.windowClosing();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.windowClosing();
        }

        private void windowClosing() {
            Action action = ActionManager.getActionManager().getAction(ActionID.FILE_PAGE_SETUP);
            action.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/PageSetup16.gif")));
            Action action2 = ActionManager.getActionManager().getAction(ActionID.FILE_PRINT_TO);
            action2.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/empty.png")));
            JApplication jApplication = Common.getApplication();
            jApplication.setBounds(JPrintPreview.this.getBounds());
            jApplication.setVisible(true);
            JPrintPreview.this.dispose();
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentResized(ComponentEvent componentEvent) {
            JPrintPreview.this.pagePanel.computeValues();
            JPrintPreview.this.pagePanel.revalidate();
        }

        public void componentShown(ComponentEvent componentEvent) {
        }
    }

    private class JPrintPreviewToolBar
    extends JToolBar
    implements ActionListener {
        private JButton firstPage;
        private JButton lastPage;
        private JToggleButton singlePage;
        private JToggleButton multiPage;
        private JCheckBox fitToPageCheck;
        private JToggleButton showHeader;
        private JButton upPage;
        private JButton downPage;
        private JButton nextPage;
        private JButton previousPage;
        private JComboBox zoomCombo;
        private JButton close;
        private JLabel pagesNo;
        private JFormattedTextField pageNumberTextField;
        private JDatePicker from;
        private JDatePicker to;
        private JPrintPreview preview;
        private ZoomHandler zoomHandler;

        public JPrintPreviewToolBar(JPrintPreview jPrintPreview2) {
            this.preview = jPrintPreview2;
            this.init();
        }

        private void init() {
            this.zoomHandler = new ZoomHandler();
            this.setFloatable(false);
            this.firstPage = new JButton();
            this.lastPage = new JButton();
            this.singlePage = new JToggleButton();
            this.singlePage.setSelected(true);
            this.multiPage = new JToggleButton();
            this.fitToPageCheck = new JCheckBox(Common.I18N_ACTIONS.getString("printPreview.fitToPage"));
            this.showHeader = new JToggleButton();
            this.showHeader.setSelected(PrintManager.isShowHeader());
            this.showHeader.setToolTipText(Common.I18N_ACTIONS.getString("printPreview.showHeaderTooltip"));
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.singlePage);
            buttonGroup.add(this.multiPage);
            this.upPage = new JButton();
            this.downPage = new JButton();
            this.nextPage = new JButton();
            this.previousPage = new JButton();
            this.zoomCombo = new JComboBox<Integer>(PrintManager.zoomLevels);
            this.zoomCombo.setMaximumSize(new Dimension(70, 50));
            this.zoomCombo.setPreferredSize(new Dimension(70, 10));
            this.zoomCombo.setSelectedItem((int)(PrintManager.ZOOM * 100.0));
            this.zoomCombo.setEditable(true);
            this.close = new JButton(Common.I18N_ACTIONS.getString("file.close"));
            this.pageNumberTextField = new JFormattedTextField();
            this.pageNumberTextField.setPreferredSize(new Dimension(30, 10));
            this.pageNumberTextField.setMaximumSize(new Dimension(30, 100));
            this.pagesNo = new JLabel("/" + JPrintPreview.this.pageable.getNumberOfPages());
            this.firstPage.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/media/StepBack16.gif")));
            this.firstPage.setActionCommand("firstPage");
            this.firstPage.addActionListener(this);
            this.singlePage.setIcon(new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/onePage.png")));
            this.singlePage.setActionCommand("singlePage");
            this.singlePage.addActionListener(this);
            this.showHeader.setIcon(new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/showHeader.png")));
            this.showHeader.setActionCommand("showHeader");
            this.showHeader.addActionListener(this);
            this.multiPage.setIcon(new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/multiplePage.png")));
            this.multiPage.setActionCommand("multiPage");
            this.multiPage.addActionListener(this);
            this.fitToPageCheck.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    JPrintPreview.this.fitToPage = itemEvent.getStateChange() == 1;
                    JPrintPreviewToolBar.this.preview.renderPage();
                }
            });
            this.previousPage.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Back16.gif")));
            this.previousPage.setActionCommand("previousPage");
            this.previousPage.addActionListener(this);
            this.nextPage.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Forward16.gif")));
            this.nextPage.setActionCommand("nextPage");
            this.nextPage.addActionListener(this);
            this.upPage.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Up16.gif")));
            this.upPage.setActionCommand("upPage");
            this.upPage.addActionListener(this);
            this.downPage.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Down16.gif")));
            this.downPage.setActionCommand("downPage");
            this.downPage.addActionListener(this);
            this.lastPage.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/media/StepForward16.gif")));
            this.lastPage.setActionCommand("lastPage");
            this.lastPage.addActionListener(this);
            this.zoomCombo.addItemListener(this.zoomHandler);
            this.close.addActionListener(JPrintPreview.this.windowHandler);
            this.close.setMnemonic(67);
            PageNumberFormat pageNumberFormat = new PageNumberFormat();
            this.pageNumberTextField.setFormatterFactory(new DefaultFormatterFactory(new InternationalFormatter(pageNumberFormat)));
            this.pageNumberTextField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JPrintPreviewToolBar.this.preview.toPage((Integer)JPrintPreviewToolBar.this.pageNumberTextField.getValue() - 1);
                }
            });
            this.add(this.firstPage);
            this.add(this.previousPage);
            this.add(this.nextPage);
            this.add(this.upPage);
            this.add(this.downPage);
            this.add(this.lastPage);
            this.add(this.pageNumberTextField);
            this.add(this.pagesNo);
            this.addSeparator();
            this.add(this.singlePage);
            this.add(this.multiPage);
            this.add(this.fitToPageCheck);
            this.addSeparator();
            this.add(new JLabel(Common.I18N_ACTIONS.getString("printPreview.scaleTo") + ": "));
            this.add(this.zoomCombo);
            this.add(new JLabel(" % "));
            this.add(this.showHeader);
            this.addSeparator();
            this.from = new JDatePicker(false);
            try {
                this.from.setEmptySelectionAllowed(false);
            }
            catch (Exception exception) {
                Common.logException("Error:", exception);
            }
            this.from.setEmptySelectionText("");
            this.from.setSelectedDate(PrintManager.getStartInterval());
            ((DefaultDateSelectionModel)this.from.getDateSelectionModel()).setMaximumAllowed(PrintManager.getEndInterval());
            this.from.addDateSelectionListener((DateSelectionListener)new DateSelectionAdapter(){

                public void dateSelectionChanged(DateSelectionEvent dateSelectionEvent) {
                    if (dateSelectionEvent.getFirstDate().before(JPrintPreviewToolBar.this.to.getSelectedDate())) {
                        PrintManager.setStartInterval(dateSelectionEvent.getFirstDate());
                        ((DefaultDateSelectionModel)JPrintPreviewToolBar.this.to.getDateSelectionModel()).setMinimumAllowed(dateSelectionEvent.getFirstDate());
                        JPrintPreviewToolBar.this.preview.pagePanel.computePages();
                        JPrintPreviewToolBar.this.preview.pageIndex = 0;
                        JPrintPreviewToolBar.this.preview.renderPage();
                    }
                }
            });
            this.to = new JDatePicker(false);
            try {
                this.to.setEmptySelectionAllowed(false);
            }
            catch (Exception exception) {
                Common.logException("Error:", exception);
            }
            this.to.setEmptySelectionText("");
            this.to.setSelectedDate(PrintManager.getEndInterval());
            ((DefaultDateSelectionModel)this.to.getDateSelectionModel()).setMinimumAllowed(PrintManager.getStartInterval());
            this.to.addDateSelectionListener((DateSelectionListener)new DateSelectionAdapter(){

                public void dateSelectionChanged(DateSelectionEvent dateSelectionEvent) {
                    if (dateSelectionEvent.getFirstDate().after(JPrintPreviewToolBar.this.from.getSelectedDate())) {
                        PrintManager.setEndInterval(dateSelectionEvent.getFirstDate());
                        ((DefaultDateSelectionModel)JPrintPreviewToolBar.this.from.getDateSelectionModel()).setMaximumAllowed(dateSelectionEvent.getFirstDate());
                        JPrintPreviewToolBar.this.preview.pagePanel.computePages();
                        JPrintPreviewToolBar.this.preview.pageIndex = 0;
                        JPrintPreviewToolBar.this.preview.renderPage();
                    }
                }
            });
            if (JPrintPreview.this.pageable instanceof JProjectViewGantt || JPrintPreview.this.pageable instanceof JProjectViewTaskSheet || JPrintPreview.this.pageable instanceof JProjectViewResourceSheet) {
                this.add(new JLabel(Common.I18N_RP.getString("from") + ":"));
                this.add((Component)this.from);
                this.add(new JLabel(Common.I18N_RP.getString("to") + ":"));
                this.add((Component)this.to);
                this.addSeparator();
            }
            Action action = ActionManager.getActionManager().getAction(ActionID.FILE_PAGE_SETUP);
            action.putValue("SmallIcon", null);
            this.add(action);
            this.add(new PrintAction());
            this.add(new PrintToAction());
            this.addSeparator();
            this.add(this.close);
            this.add(Box.createHorizontalGlue());
            Common.getApplication().setVisible(false);
        }

        public void renderPage(int n) {
            int n2 = JPrintPreview.this.pageable.getNumberOfPages();
            this.pagesNo.setText("/" + n2);
            int n3 = JPrintPreview.this.pageable.getHorizontalNumberOfPages();
            this.firstPage.setEnabled(n > 0);
            this.previousPage.setEnabled(n > 0);
            this.nextPage.setEnabled(n < n2 - 1);
            this.lastPage.setEnabled(n < n2 - 1);
            this.upPage.setEnabled(n > n3 - 1);
            this.downPage.setEnabled(n < n2 - n3);
            this.pageNumberTextField.setValue(n + 1);
            this.singlePage.setSelected(true);
        }

        public void renderPage() {
            this.pagesNo.setText("/" + JPrintPreview.this.pageable.getNumberOfPages());
            this.firstPage.setEnabled(false);
            this.previousPage.setEnabled(false);
            this.nextPage.setEnabled(false);
            this.lastPage.setEnabled(false);
            this.upPage.setEnabled(false);
            this.downPage.setEnabled(false);
            this.pageNumberTextField.setValue(JPrintPreview.this.pageIndex + 1);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("nextPage")) {
                this.preview.nextPage();
            } else if (string.equals("previousPage")) {
                this.preview.previousPage();
            } else if (string.equals("firstPage")) {
                this.preview.firstPage();
            } else if (string.equals("lastPage")) {
                this.preview.lastPage();
            } else if (string.equals("upPage")) {
                this.preview.upPage();
            } else if (string.equals("downPage")) {
                this.preview.downPage();
            } else if (string.equals("singlePage")) {
                this.preview.singlePage();
            } else if (string.equals("multiPage")) {
                this.preview.multiPage();
            } else if (string.equals("showHeader")) {
                PrintManager.setShowHeader(this.showHeader.isSelected());
                this.preview.renderPage();
            }
        }

        private class ZoomHandler
        implements ItemListener {
            private ZoomHandler() {
            }

            public void itemStateChanged(ItemEvent itemEvent) {
                Object object;
                double d;
                if (itemEvent.getStateChange() == 1 && (d = ((Number)(object = itemEvent.getItem())).doubleValue()) != PrintManager.ZOOM * 100.0) {
                    if (d < 1.0 || d > 200.0) {
                        JOptionPane.showMessageDialog(JPrintPreview.this, Common.I18N_MESSAGES.getString("printPreview.scaleLimitation.message"), Common.I18N_MESSAGES.getString("printPreview.scaleLimitation.title"), 0);
                        JPrintPreviewToolBar.this.zoomCombo.setSelectedItem(PrintManager.ZOOM * 100.0);
                        return;
                    }
                    PrintManager.ZOOM = d / 100.0;
                    JPrintPreviewToolBar.this.preview.pagePanel.computePages();
                    JPrintPreviewToolBar.this.preview.pageIndex = 0;
                    JPrintPreviewToolBar.this.fitToPageCheck.setSelected(false);
                    JPrintPreviewToolBar.this.preview.renderPage();
                }
            }
        }

        private class PrintToAction
        extends AbstractAction {
            public PrintToAction() {
                this.putValue("Name", Common.I18N_ACTIONS.getString("file.printTo"));
                this.putValue("ShortDescription", Common.I18N_ACTIONS.getString("file.printTo.tooltip"));
                this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/pdf.png")));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                PrintManager.setStartInterval(JPrintPreviewToolBar.this.from.getSelectedDate());
                PrintManager.setEndInterval(JPrintPreviewToolBar.this.to.getSelectedDate());
                if (JPrintPreview.this.pageable.getNumberOfPages() == 0) {
                    JOptionPane.showMessageDialog(null, Common.I18N_MESSAGES.getString("print.noInfoToPrint"), Common.I18N_MESSAGES.getString("print.failedToPrint"), 1);
                    return;
                }
                this.exportToPDF();
            }

            private void exportToPDF() {
                PageFormat pageFormat = Common.getApplication().getPageFormat();
                Rectangle rectangle = new Rectangle((float)pageFormat.getWidth(), (float)pageFormat.getHeight());
                File file = this.getSelectedFile();
                if (file != null) {
                    Document document = new Document(rectangle);
                    try {
                        PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(file));
                        document.open();
                        PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
                        int n = 0;
                        for (int i = 0; i < JPrintPreview.this.pageable.getVerticalNumberOfPages(); ++i) {
                            for (int j = 0; j < JPrintPreview.this.pageable.getHorizontalNumberOfPages(); ++j) {
                                PdfTemplate pdfTemplate = pdfContentByte.createTemplate(rectangle.getWidth(), rectangle.getHeight());
                                Graphics2D graphics2D = pdfTemplate.createGraphicsShapes(rectangle.getWidth(), rectangle.getHeight());
                                JPrintPreview.this.pageable.getPrintable(n).print(graphics2D, pageFormat, n);
                                pdfContentByte.addTemplate(pdfTemplate, 0.0f, 0.0f);
                                document.newPage();
                                ++n;
                                graphics2D.dispose();
                            }
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        Common.logException("Error:", exception);
                    }
                    document.close();
                }
            }

            private File getSelectedFile() {
                Configuration configuration = Configuration.getInstance();
                String string = configuration.getValue(ConfigurationSetting.CURRENT_DIR).toString();
                JFileChooser jFileChooser = new JFileChooser(string);
                jFileChooser.setDialogTitle(Common.I18N_ACTIONS.getString("file.printTo.tooltip"));
                jFileChooser.setFileFilter(new PDFFileFilter());
                JApplication jApplication = Common.getApplication();
                int n = jFileChooser.showSaveDialog(jApplication);
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    int n2 = file.getName().lastIndexOf(".");
                    if (n2 != -1) {
                        if (!file.getName().substring(n2).equals(".pdf")) {
                            return null;
                        }
                    } else {
                        file = new File(file.getAbsolutePath() + ".pdf");
                    }
                    configuration.setValue(ConfigurationSetting.CURRENT_DIR, file.getParent());
                    return file;
                }
                return null;
            }
        }

        private class PrintAction
        extends AbstractAction {
            public PrintAction() {
                this.putValue("Name", Common.I18N_ACTIONS.getString("file.print"));
                this.putValue("ShortDescription", Common.I18N_ACTIONS.getString("file.print.tooltip"));
                this.putValue("MnemonicKey", new Integer(80));
                if (SystemUtilities.isOSMac()) {
                    this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, 256));
                } else {
                    this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, 128));
                }
                this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Print16.gif")));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                PrintManager.setStartInterval(JPrintPreviewToolBar.this.from.getSelectedDate());
                PrintManager.setEndInterval(JPrintPreviewToolBar.this.to.getSelectedDate());
                JApplication jApplication = Common.getApplication();
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                printerJob.setPageable(JPrintPreview.this.pageable);
                if (printerJob.printDialog()) {
                    try {
                        printerJob.print();
                    }
                    catch (PrinterException printerException) {
                        Common.logException("Error:", printerException);
                        JOptionPane.showMessageDialog(jApplication, Common.I18N_MESSAGES.getString("print.failedToPrint.message") + " (" + printerException.getLocalizedMessage() + ")", Common.I18N_MESSAGES.getString("print.failedToPrint.title"), 0);
                    }
                }
            }
        }

        private class PageNumberFormat
        extends Format {
            private PageNumberFormat() {
            }

            public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
                if (object != null && object instanceof Integer) {
                    Integer n = (Integer)object;
                    if (n < 1) {
                        throw new IllegalArgumentException("Invalid page number");
                    }
                    stringBuffer.append(String.valueOf(n));
                }
                return stringBuffer;
            }

            public Object parseObject(String string, ParsePosition parsePosition) {
                try {
                    int n = Integer.parseInt(string);
                    if (n < 1) {
                        parsePosition.setErrorIndex(0);
                        return null;
                    }
                    parsePosition.setIndex(string.length());
                    return n;
                }
                catch (NumberFormatException numberFormatException) {
                    parsePosition.setErrorIndex(0);
                    return null;
                }
            }
        }
    }

    private class JPrintPreviewPage
    extends JPanel {
        private int pageIndex;
        private Pageable pageable;

        private JPrintPreviewPage() {
        }

        public void renderPage(Pageable pageable, int n) {
            this.pageable = pageable;
            this.pageIndex = n;
            this.repaint();
        }

        public void paint(Graphics graphics) {
            double d;
            double d2;
            super.paint(graphics);
            PageFormat pageFormat = this.pageable.getPageFormat(this.pageIndex);
            Printable printable = this.pageable.getPrintable(this.pageIndex);
            int n = this.getHeight();
            int n2 = this.getWidth();
            if (pageFormat.getOrientation() == 1) {
                d2 = pageFormat.getPaper().getWidth() * 1.3 / PrintManager.ZOOM;
                d = pageFormat.getPaper().getHeight() * 1.3 / PrintManager.ZOOM;
            } else {
                d2 = pageFormat.getPaper().getHeight() * 1.3 / PrintManager.ZOOM;
                d = pageFormat.getPaper().getWidth() * 1.3 / PrintManager.ZOOM;
            }
            double d3 = d2 / (double)n2;
            double d4 = d / (double)n;
            double d5 = d3 > d4 ? d3 : d4;
            Graphics2D graphics2D = (Graphics2D)graphics;
            Color color = graphics.getColor();
            graphics.setColor(Color.GRAY);
            graphics.fillRect(0, 0, n2, n);
            graphics.setColor(color);
            graphics2D.translate((n2 - (int)(1.0 / d5 * d2)) / 2, (n - (int)(1.0 / d5 * d)) / 2);
            graphics2D.scale(1.0 / d5, 1.0 / d5);
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(1, 1, (int)d2 - 2, (int)d - 2);
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawRect(0, 0, (int)d2, (int)d);
            graphics2D.scale(1.3 / PrintManager.ZOOM, 1.3 / PrintManager.ZOOM);
            try {
                printable.print(graphics2D, pageFormat, this.pageIndex);
            }
            catch (PrinterException printerException) {
                Common.logException("Error:", printerException);
                printerException.printStackTrace();
            }
        }
    }

    private class JPrintPreviewMultiPage
    extends JPanel {
        private List pages;
        private MouseListener mouseHandler;
        private CustomPageable pageable;
        private JPrintPreview preview;
        private Dimension preferredPageSize;

        public JPrintPreviewMultiPage(JPrintPreview jPrintPreview2, CustomPageable customPageable) {
            this.preview = jPrintPreview2;
            this.pageable = customPageable;
            JPrintPreview.this.singlePage = true;
            this.mouseHandler = new MouseHandler();
            this.init();
        }

        private void init() {
            this.setBackground(Color.GRAY);
            this.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
            this.computePages();
            this.setLayout(new GridBagLayout());
            this.renderPage(0);
        }

        private void computePages() {
            this.pages = new LinkedList();
            for (int i = 0; i < this.pageable.getHorizontalNumberOfPages(); ++i) {
                for (int j = 0; j < this.pageable.getVerticalNumberOfPages(); ++j) {
                    JPrintPreviewPage jPrintPreviewPage = new JPrintPreviewPage();
                    jPrintPreviewPage.addMouseListener(this.mouseHandler);
                    this.pages.add(jPrintPreviewPage);
                }
            }
        }

        public void renderPage(int n) {
            if (this.pages.size() != 0) {
                JPrintPreviewPage jPrintPreviewPage = (JPrintPreviewPage)this.pages.get(n);
                jPrintPreviewPage.pageIndex = n;
                jPrintPreviewPage.pageable = this.pageable;
                Insets insets = new Insets(5, 5, 5, 5);
                this.removeAll();
                this.add((Component)jPrintPreviewPage, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 21, 1, insets, 0, 0));
            }
            this.revalidate();
            this.repaint();
        }

        private void computeValues() {
            double d;
            double d2;
            PageFormat pageFormat = Common.getApplication().getPageFormat();
            if (pageFormat.getOrientation() == 1) {
                d2 = pageFormat.getPaper().getWidth();
                d = pageFormat.getPaper().getHeight();
            } else {
                d2 = pageFormat.getPaper().getHeight();
                d = pageFormat.getPaper().getWidth();
            }
            int n = this.pageable.getHorizontalNumberOfPages();
            int n2 = this.pageable.getVerticalNumberOfPages();
            double d3 = this.getHeight() - n2 * 10 - 10;
            double d4 = this.getWidth() - n * 10 - 10;
            double d5 = d3 / (double)n2;
            double d6 = d4 / (double)n;
            double d7 = d2 / d;
            double d8 = d6 / d5;
            if (d7 < d8) {
                d6 = d5 * d7;
            } else {
                d5 = d6 / d7;
            }
            this.preferredPageSize = new Dimension((int)d6, (int)d5);
            int n3 = 0;
            for (int i = 0; i < this.pageable.getVerticalNumberOfPages(); ++i) {
                for (int j = 0; j < this.pageable.getHorizontalNumberOfPages(); ++j) {
                    JPrintPreviewPage jPrintPreviewPage = (JPrintPreviewPage)this.pages.get(n3);
                    jPrintPreviewPage.setPreferredSize(this.preferredPageSize);
                    ++n3;
                }
            }
        }

        public void renderPage() {
            Insets insets = new Insets(5, 5, 5, 5);
            this.computePages();
            this.computeValues();
            this.removeAll();
            int n = 0;
            for (int i = 0; i < this.pageable.getVerticalNumberOfPages(); ++i) {
                for (int j = 0; j < this.pageable.getHorizontalNumberOfPages(); ++j) {
                    JPrintPreviewPage jPrintPreviewPage = (JPrintPreviewPage)this.pages.get(n);
                    jPrintPreviewPage.pageIndex = n;
                    jPrintPreviewPage.pageable = this.pageable;
                    this.add((Component)jPrintPreviewPage, new GridBagConstraints(j, i, 1, 1, 0.0, 0.0, 21, 1, insets, 0, 0));
                    ++n;
                }
            }
            this.revalidate();
            this.repaint();
        }

        private class MouseHandler
        implements MouseListener {
            private MouseHandler() {
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = JPrintPreviewMultiPage.this.pages.indexOf(mouseEvent.getSource());
                JPrintPreviewMultiPage.this.preview.toPage(n);
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        }
    }
}

