/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.mail;

import com.sbs.jpm.Common;
import com.sbs.jpm.configuration.Configuration;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.ui.UIManager;
import com.sbs.jpm.ui.component.JEmailNotificationDialog;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Security;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.swing.JOptionPane;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Method;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmailManager {
    private static final String SSL_FACTORY = "javax.net.ssl.SSLSocketFactory";
    private static final String ATTACHMENT_FILENAME = "assignments.ics";
    public static final String ASSIGNMENTS_TABLE = Common.I18N_RP.getString("email.assignmentsTable");
    public static final String START_DATE = Common.I18N_RP.getString("email.startDate");
    public static final String END_DATE = Common.I18N_RP.getString("email.endDate");
    public static final String RESOURCE = Common.I18N_RP.getString("email.resource");
    public static String EMAIL_TEMPLATE = Common.I18N_RP.getString("email.template");
    private String mailText;
    private String mailServer;
    private String mailFrom;
    private String mailPort;
    private String mailUsername;
    private String mailPassword;
    private boolean mailAuthentication;
    private boolean needsICalendarAttached;
    private boolean mailSSL;
    private boolean icalendarToDo;
    private static EmailManager instance;
    private Properties properties = new Properties();
    private List<String> unsentMails = new LinkedList<String>();

    private EmailManager() {
        Security.addProvider((java.security.Provider)new Provider());
    }

    public static final EmailManager getInstance() {
        if (instance == null) {
            instance = new EmailManager();
        }
        return instance;
    }

    public String getMailPassword() {
        return this.mailPassword;
    }

    public void setMailPassword(String string) {
        this.mailPassword = string;
    }

    public String getMailPort() {
        return this.mailPort;
    }

    public void setMailPort(String string) {
        this.mailPort = string;
    }

    public String getMailServer() {
        return this.mailServer;
    }

    public void setMailServer(String string) {
        this.mailServer = string;
    }

    public void setDefaultText(String string) {
        this.mailText = string;
    }

    public String getDefaultText() {
        return this.mailText;
    }

    public void sendEmails(List<JEmailNotificationDialog.NotificationResource> list, String string, Task task, java.util.Date date, java.util.Date date2) {
        this.loadSettings();
        this.unsentMails.clear();
        int n = 0;
        for (JEmailNotificationDialog.NotificationResource object : list) {
            if (!object.isSelected()) continue;
            ++n;
            this.sendEmail(object, string, task, date, date2);
        }
        StringBuffer stringBuffer = new StringBuffer("<html>");
        stringBuffer.append(Common.I18N_MESSAGES.getString("email.sentEmails") + " " + (n - this.unsentMails.size()) + "<br>");
        stringBuffer.append(Common.I18N_MESSAGES.getString("email.unsentEmails") + " " + this.unsentMails.size() + "<br>");
        if (!this.unsentMails.isEmpty()) {
            stringBuffer.append(Common.I18N_MESSAGES.getString("email.report.message") + "<br>");
            for (String string2 : this.unsentMails) {
                stringBuffer.append(string2);
                stringBuffer.append("<br>");
            }
        }
        stringBuffer.append("</html>");
        JOptionPane.showMessageDialog(Common.getApplication(), stringBuffer.toString(), Common.I18N_MESSAGES.getString("email.report.title"), 1);
    }

    public void sendEmail(JEmailNotificationDialog.NotificationResource notificationResource, String string, Task task, java.util.Date date, java.util.Date date2) {
        StringBuffer stringBuffer;
        String string2 = Common.I18N_RP.getString("email.subject");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(UIManager.getInstance().getDateFormat());
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(Common.I18N_RP.getString("email.tableHeader"));
        ComponentList componentList = new ComponentList();
        for (Task serializable2 : notificationResource.getTasks()) {
            stringBuffer = new StringBuffer();
            List<Task> throwable = serializable2.getPath(serializable2.getProjectTask());
            throwable.remove(serializable2.getProjectTask());
            stringBuffer.append(serializable2.getProjectTask().getName());
            for (Task exception : throwable) {
                stringBuffer.append("/");
                stringBuffer.append(exception.getName());
            }
            stringBuffer2.append("<tr><td>" + serializable2.getName() + "</td><td>" + simpleDateFormat.format(serializable2.getStartDate()) + "</td><td>" + simpleDateFormat.format(serializable2.getEndDate()) + "</td><td>" + serializable2.getCompletion() + "</td><td>" + (serializable2.getDeadlineDate() != null ? "<b><FONT COLOR=\"#FF0000\">" + simpleDateFormat.format(serializable2.getDeadlineDate()) + "</FONT></b>" : "<P ALIGN=\"center\"> - </P>") + "</td><td>" + serializable2.getAssignmentAt(serializable2.getAssignmentIndex(notificationResource.getResource())).getUnits() + "</td><td>" + stringBuffer.toString() + "</td></tr>");
            if (!this.needsICalendarAttached) continue;
            Object object = this.icalendarToDo ? new VToDo((Date)new DateTime(serializable2.getStartDate()), (Date)new DateTime(serializable2.getEndDate()), serializable2.getName()) : new VEvent((Date)new DateTime(serializable2.getStartDate()), (Date)new DateTime(serializable2.getEndDate()), serializable2.getName());
            try {
                Task exception;
                exception = new Uid();
                exception.setValue(serializable2.getId() + "");
                object.getProperties().add((Property)exception);
            }
            catch (Exception exception) {
                Common.logException("Error:", exception);
                exception.printStackTrace();
            }
            componentList.add((Component)object);
        }
        stringBuffer2.append("</table></strong>");
        Object object = string;
        object = ((String)object).replace("\n", "<br>");
        object = ((String)object).replace(ASSIGNMENTS_TABLE, stringBuffer2.toString());
        object = ((String)object).replace(RESOURCE, notificationResource.getResource().getName());
        object = ((String)object).replace(START_DATE, simpleDateFormat.format(date));
        object = ((String)object).replace(END_DATE, simpleDateFormat.format(date2));
        StringBuffer stringBuffer3 = new StringBuffer();
        stringBuffer3.append("<html><head></head><body>");
        stringBuffer3.append((String)object);
        stringBuffer3.append("</body></html>");
        stringBuffer = null;
        if (this.needsICalendarAttached) {
            stringBuffer = new Calendar(componentList);
            stringBuffer.getProperties().add((Property)new ProdId("-//Ben Fortuna//iCal4j 1.0//EN"));
            stringBuffer.getProperties().add((Property)Version.VERSION_2_0);
            stringBuffer.getProperties().add((Property)Method.PUBLISH);
            stringBuffer.getProperties().add((Property)CalScale.GREGORIAN);
        }
        try {
            this.sendEmail(this.mailFrom, notificationResource.getResource().getEmail(), string2, stringBuffer3.toString(), (Calendar)stringBuffer);
        }
        catch (Throwable throwable) {
            Common.logException("Error:", throwable);
            this.unsentMails.add(notificationResource.getResource().getName() + " (" + Common.I18N_MESSAGES.getString("email.email") + ": " + notificationResource.getResource().getEmail() + "; " + throwable.getMessage() + ")");
            Common.logException("error while sending email: ", throwable);
        }
    }

    private void sendEmail(String string, String string2, String string3, String string4, Calendar calendar) throws Throwable {
        Session session;
        SMTPAuthenticator sMTPAuthenticator;
        this.properties.put("mail.smtp.starttls.enable", "true");
        if (this.mailAuthentication) {
            sMTPAuthenticator = new SMTPAuthenticator();
            session = Session.getInstance((Properties)this.properties, (Authenticator)sMTPAuthenticator);
        } else {
            session = Session.getInstance((Properties)this.properties, null);
        }
        sMTPAuthenticator = new MimeMessage(session);
        sMTPAuthenticator.setFrom((Address)new InternetAddress(string));
        int n = 0;
        boolean bl = false;
        do {
            String string5;
            int n2;
            if ((n2 = string2.indexOf(";", n)) > 0) {
                string5 = string2.substring(n, n2);
                n = n2 + 1;
            } else {
                n2 = string2.indexOf(",", n);
                if (n2 > 0) {
                    string5 = string2.substring(n, n2);
                    n = n2 + 1;
                } else {
                    string5 = string2.substring(n);
                    bl = true;
                }
            }
            string5 = string5.trim();
            sMTPAuthenticator.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(string5));
        } while (!bl);
        sMTPAuthenticator.setSubject(string3);
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setContent((Object)string4, "text/html");
        MimeMultipart mimeMultipart = new MimeMultipart();
        mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
        File file = null;
        if (calendar != null) {
            FileOutputStream fileOutputStream;
            MimeBodyPart mimeBodyPart2 = new MimeBodyPart();
            String string6 = Configuration.getSettingsDirectory() + ATTACHMENT_FILENAME;
            file = new File(string6);
            try {
                fileOutputStream = new FileOutputStream(file);
                CalendarOutputter calendarOutputter = new CalendarOutputter();
                calendarOutputter.output(calendar, (OutputStream)fileOutputStream);
            }
            catch (Exception exception) {
                Common.logException("Error:", exception);
                exception.printStackTrace();
            }
            fileOutputStream = new FileDataSource(string6);
            mimeBodyPart2.setDataHandler(new DataHandler((DataSource)fileOutputStream));
            mimeBodyPart2.setFileName(ATTACHMENT_FILENAME);
            mimeMultipart.addBodyPart((BodyPart)mimeBodyPart2);
            Common.log("attachment file created, can read: " + file.canRead());
        }
        sMTPAuthenticator.setContent((Multipart)mimeMultipart);
        Transport.send((Message)sMTPAuthenticator);
        if (file != null) {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSettings() {
        File file = Configuration.getInstance().getEmailPropertiesFile();
        FileInputStream fileInputStream = null;
        this.mailServer = "smtp.gmail.com";
        this.mailFrom = "rplantest@gmail.com";
        this.mailPort = "465";
        this.mailUsername = "rplantest@gmail.com";
        this.mailText = EMAIL_TEMPLATE;
        this.mailPassword = "rationalplan";
        this.mailAuthentication = true;
        this.mailSSL = true;
        this.needsICalendarAttached = true;
        try {
            fileInputStream = new FileInputStream(file);
            this.properties.clear();
            this.properties.load(fileInputStream);
            this.mailServer = this.properties.get("mail.smtp.host").toString();
            this.mailFrom = this.properties.get("mail.from").toString();
            this.mailPort = this.properties.get("mail.smtp.port").toString();
            this.mailUsername = this.properties.get("mail.user").toString();
            this.mailText = this.properties.get("mail.text").toString();
            this.mailAuthentication = Boolean.parseBoolean(this.properties.get("mail.smtp.auth").toString());
            Object object = this.properties.get("mail.smtp.ssl.enable");
            this.mailSSL = object == null ? false : Boolean.parseBoolean(object.toString());
            Object object2 = this.properties.get("mail.icalendar.attached");
            this.needsICalendarAttached = object2 == null ? false : Boolean.parseBoolean(object2.toString());
            Object object3 = this.properties.get("mail.icalendar.todo");
            if (object3 != null) {
                this.icalendarToDo = Boolean.parseBoolean(object3.toString());
            }
            this.mailPassword = this.properties.get("mail.password").toString();
        }
        catch (Exception exception) {
            Common.logException("Error:", exception);
            exception.printStackTrace();
            this.storeSettings();
        }
        finally {
            try {
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
            }
            catch (IOException iOException) {
                Common.logException("Error:", iOException);
                iOException.printStackTrace();
            }
        }
    }

    public void storeSettings() {
        Properties properties = new Properties();
        properties.put("mail.smtp.host", this.mailServer);
        properties.put("mail.smtp.port", this.mailPort);
        properties.put("mail.smtp.auth", this.mailAuthentication + "");
        properties.put("mail.icalendar.attached", this.needsICalendarAttached + "");
        properties.put("mail.icalendar.todo", this.icalendarToDo + "");
        properties.put("mail.from", this.mailFrom);
        properties.put("mail.user", this.mailUsername);
        properties.put("mail.text", this.mailText);
        properties.put("mail.password", this.mailPassword);
        if (this.mailSSL) {
            properties.put("mail.smtp.ssl.enable", this.mailSSL + "");
            properties.put("mail.smtp.socketFactory.port", this.mailPort);
            properties.put("mail.smtp.socketFactory.class", SSL_FACTORY);
            properties.put("mail.smtp.socketFactory.fallback", "false");
        }
        Configuration.getInstance().storeEmailProperties(properties);
    }

    public String getMailUsername() {
        return this.mailUsername;
    }

    public void setMailUsername(String string) {
        this.mailUsername = string;
    }

    public String getMailFrom() {
        return this.mailFrom;
    }

    public void setMailFrom(String string) {
        this.mailFrom = string;
    }

    public boolean isMailAuthentication() {
        return this.mailAuthentication;
    }

    public void setMailAuthentication(boolean bl) {
        this.mailAuthentication = bl;
    }

    public boolean needsICalendarAttached() {
        return this.needsICalendarAttached;
    }

    public void setNeedsICalendarAttached(boolean bl) {
        this.needsICalendarAttached = bl;
    }

    public boolean isIcalendarToDo() {
        return this.icalendarToDo;
    }

    public void setIcalendarToDo(boolean bl) {
        this.icalendarToDo = bl;
    }

    public boolean isMailSSL() {
        return this.mailSSL;
    }

    public void setMailSSL(boolean bl) {
        this.mailSSL = bl;
    }

    private class SMTPAuthenticator
    extends Authenticator {
        private SMTPAuthenticator() {
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(EmailManager.this.mailUsername, EmailManager.this.mailPassword);
        }
    }
}

