/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.i18n;

import com.sbs.jpm.Common;
import com.sbs.util.LazyCreationManager;
import java.util.Locale;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class I18nManager {
    private static final Locale[] SUPPORTED_LANGUAGES = new Locale[]{new Locale("en"), new Locale("it"), new Locale("ro")};
    public static Locale[] availableLocales;

    public static boolean isLanguageSupported(String string) {
        boolean bl = false;
        for (int i = 0; i < SUPPORTED_LANGUAGES.length; ++i) {
            if (!string.equals(SUPPORTED_LANGUAGES[i].getLanguage())) continue;
            bl = true;
        }
        return bl;
    }

    public static Locale[] getSupportedLanguages() {
        return SUPPORTED_LANGUAGES;
    }

    public static boolean isLocaleSupported(Locale locale) {
        boolean bl = false;
        Locale[] localeArray = Locale.getAvailableLocales();
        for (int i = 0; i < localeArray.length; ++i) {
            if (!locale.equals(localeArray[i])) continue;
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector<Locale> getAvailableLocales() {
        Vector<Locale> vector = new Vector<Locale>();
        vector.add(null);
        try {
            Object object = LazyCreationManager.localesLock;
            synchronized (object) {
                if (availableLocales == null) {
                    LazyCreationManager.localesLock.wait();
                }
            }
        }
        catch (Throwable throwable) {
            Common.logException("Exception while waiting for LazyCreationManager to create available locales.", throwable);
        }
        for (int i = 0; i < availableLocales.length; ++i) {
            vector.add(availableLocales[i]);
        }
        return vector;
    }
}

