/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.document;

import com.sbs.jpm.core.io.FileType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CustomTypeFile {
    private File file;
    private FileType fileType;

    public CustomTypeFile(File file, FileType fileType) {
        this.file = file;
        this.fileType = fileType;
    }

    public CustomTypeFile(File file) {
        this.file = file;
        int n = file.getName().lastIndexOf(".");
        if (n != -1) {
            if (file.getName().toLowerCase().substring(n).equals(".xrp")) {
                this.fileType = FileType.PROPRIETARY;
            } else if (file.getName().substring(n).toLowerCase().equals(".xml")) {
                this.fileType = FileType.MSPROJECT_XML;
            } else if (file.getName().substring(n).toLowerCase().equals(".mpp")) {
                this.fileType = FileType.MSPROJECT_MPP;
            } else if (file.getName().substring(n).toLowerCase().equals(".mpt")) {
                this.fileType = FileType.MSPROJECT_MPT;
            } else if (file.getName().substring(n).toLowerCase().equals(".mpx")) {
                this.fileType = FileType.MSPROJECT_MPX;
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public void setFileType(FileType fileType) {
        this.fileType = fileType;
    }

    public void backup() throws IOException {
        int n;
        String string = this.file.getAbsolutePath();
        string = string.substring(0, string.length() - 4) + ".backup" + string.substring(string.length() - 4);
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(this.file);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        byte[] byArray = new byte[1024];
        while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
        }
        ((InputStream)fileInputStream).close();
        ((OutputStream)fileOutputStream).close();
    }
}

