/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.document;

import com.sbs.jpm.Common;
import com.sbs.jpm.configuration.Configuration;
import com.sbs.jpm.configuration.ConfigurationSetting;
import com.sbs.jpm.core.io.FileType;
import com.sbs.jpm.document.CustomTypeFile;
import com.sbs.jpm.document.Document;
import com.sbs.jpm.document.DocumentException;
import com.sbs.jpm.document.event.DocumentEvent;
import com.sbs.jpm.document.event.DocumentListener;
import com.sbs.jpm.ui.component.JLockingDialog;
import com.sbs.util.CustomNameFile;
import com.sbs.util.LockException;
import com.sbs.util.LockedFile;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.EventListener;
import javax.swing.JOptionPane;
import javax.swing.event.EventListenerList;

public abstract class AbstractDocument
implements Document {
    protected File file;
    protected boolean changed;
    protected boolean proprietary;
    protected boolean locked;
    protected boolean newlyCreated = true;
    private EventListenerList listeners = new EventListenerList();

    public void addDocumentListener(DocumentListener documentListener) {
        this.listeners.add(DocumentListener.class, documentListener);
    }

    public void removeDocumentListener(DocumentListener documentListener) {
        this.listeners.remove(DocumentListener.class, documentListener);
    }

    public boolean isNewlyCreated() {
        return this.newlyCreated;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean bl) {
        this.newlyCreated = false;
        if (this.changed != bl) {
            this.changed = bl;
            this.fireDocumentChanged();
        }
    }

    public File getFile() {
        return this.file;
    }

    protected abstract void save(File var1, FileType var2) throws DocumentException;

    public boolean save() throws DocumentException {
        try {
            if (this.isChanged()) {
                Common.LOGGER.info("changed... ");
                if (!this.isProprietary() || this.getFile() == null) {
                    return this.saveAs();
                }
                this.save(this.getFile(), FileType.PROPRIETARY);
                this.setChanged(false);
            }
            return true;
        }
        catch (Throwable throwable) {
            Common.LOGGER.severe("Unable to Save: " + throwable.getMessage());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            throwable.printStackTrace(printStream);
            printStream.flush();
            Common.LOGGER.severe("Exception: " + byteArrayOutputStream.toString());
            if (throwable instanceof DocumentException) {
                throw (DocumentException)throwable;
            }
            return false;
        }
    }

    protected abstract CustomTypeFile getSelectedFile();

    protected abstract CustomTypeFile getExportedFile();

    public boolean saveAs() throws DocumentException {
        try {
            CustomTypeFile customTypeFile = this.getSelectedFile();
            if (customTypeFile != null) {
                if (!customTypeFile.getFile().equals(this.file)) {
                    this.saveAs(customTypeFile);
                } else {
                    this.save();
                }
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            Common.LOGGER.severe("Unable to Save As: " + throwable.getMessage());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            throwable.printStackTrace(printStream);
            printStream.flush();
            Common.LOGGER.severe("Exception: " + byteArrayOutputStream.toString());
            if (throwable instanceof DocumentException) {
                throw (DocumentException)throwable;
            }
            return false;
        }
    }

    protected void saveAs(CustomTypeFile customTypeFile) throws DocumentException {
        if (customTypeFile.getFileType().equals(FileType.PROPRIETARY)) {
            block32: {
                LockedFile lockedFile = null;
                try {
                    lockedFile = LockedFile.createOpenedLockedFile(customTypeFile.getFile());
                }
                catch (LockException lockException) {
                    Object object;
                    Common.LOGGER.severe("Unable to create locked file in Save(File, FileType): " + lockException.getMessage());
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    PrintStream printStream = new PrintStream(byteArrayOutputStream);
                    lockException.printStackTrace(printStream);
                    printStream.flush();
                    Common.LOGGER.severe("Exception: " + byteArrayOutputStream.toString());
                    JOptionPane.showMessageDialog(Common.getApplication(), Common.I18N_MESSAGES.getString("document.fileInUseOnSave.message"), Common.I18N_MESSAGES.getString("document.fileInUse.title"), 0);
                    if (this.getFile() instanceof LockedFile) {
                        object = (LockedFile)this.getFile();
                        try {
                            if (object != null) {
                                ((LockedFile)object).unlock();
                            }
                        }
                        catch (IOException iOException) {
                            Common.logException("Error:", iOException);
                        }
                    }
                    object = customTypeFile.getFile().getAbsolutePath();
                    object = ((String)object).substring(0, ((String)object).length() - 4) + ".backup" + ((String)object).substring(((String)object).length() - 4);
                    try {
                        this.file = new CustomNameFile((String)object);
                    }
                    catch (Exception exception) {
                        Common.logException("Error saving:", exception);
                        throw new DocumentException(exception.getLocalizedMessage());
                    }
                    this.setLocked(true);
                    break block32;
                }
                catch (IOException iOException) {
                    Serializable serializable;
                    Common.logException("Error:", iOException);
                    if (Boolean.parseBoolean(Configuration.getInstance().getValue(ConfigurationSetting.NETWORK_LOCKING).toString())) {
                        serializable = new JLockingDialog((Frame)Common.getApplication(), iOException.getLocalizedMessage());
                        ((Dialog)serializable).setVisible(true);
                    }
                    serializable = null;
                    if (this.getFile() instanceof LockedFile) {
                        serializable = (LockedFile)this.getFile();
                    }
                    try {
                        this.save(customTypeFile.getFile(), FileType.PROPRIETARY);
                    }
                    catch (Throwable throwable) {
                        Common.LOGGER.severe("Unable to Save(CustomFile) without locking: " + throwable.getMessage());
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        PrintStream printStream = new PrintStream(byteArrayOutputStream);
                        throwable.printStackTrace(printStream);
                        printStream.flush();
                        Common.LOGGER.severe("Exception: " + byteArrayOutputStream.toString());
                        throw new DocumentException(throwable.getLocalizedMessage());
                    }
                    try {
                        customTypeFile.backup();
                    }
                    catch (IOException iOException2) {
                        Common.logException("Error:", iOException2);
                        iOException2.printStackTrace();
                    }
                    if (this.getFile() instanceof LockedFile) {
                        try {
                            if (serializable != null) {
                                ((LockedFile)serializable).unlock();
                            }
                        }
                        catch (IOException iOException3) {
                            Common.logException("Error:", iOException3);
                        }
                    }
                    this.file = customTypeFile.getFile();
                    break block32;
                }
                LockedFile lockedFile2 = null;
                if (this.getFile() instanceof LockedFile) {
                    lockedFile2 = (LockedFile)this.getFile();
                }
                try {
                    this.save(lockedFile, FileType.PROPRIETARY);
                }
                catch (Throwable throwable) {
                    Common.LOGGER.severe("Unable to Save(CustomFile): " + throwable.getMessage());
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    PrintStream printStream = new PrintStream(byteArrayOutputStream);
                    throwable.printStackTrace(printStream);
                    printStream.flush();
                    Common.LOGGER.severe("Exception: " + byteArrayOutputStream.toString());
                    throw new DocumentException(throwable.getLocalizedMessage());
                }
                try {
                    lockedFile.backup();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    Common.logException("Error:", iOException);
                }
                if (this.getFile() instanceof LockedFile) {
                    try {
                        if (lockedFile2 != null) {
                            lockedFile2.unlock();
                        }
                    }
                    catch (IOException iOException) {
                        Common.logException("Error:", iOException);
                    }
                }
                this.file = lockedFile;
            }
            this.setProprietary(true);
            this.fireDocumentFileChanged();
            this.setChanged(false);
        } else {
            try {
                this.save(customTypeFile.getFile(), customTypeFile.getFileType());
            }
            catch (Exception exception) {
                Common.LOGGER.severe("Unable to Save(CustomFile) for not proprietary formats: " + exception.getMessage());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                PrintStream printStream = new PrintStream(byteArrayOutputStream);
                exception.printStackTrace(printStream);
                printStream.flush();
                Common.LOGGER.severe("Exception: " + byteArrayOutputStream.toString());
                throw new DocumentException(exception.getLocalizedMessage());
            }
        }
    }

    protected void export(File file, FileType fileType) throws DocumentException {
        block5: {
            try {
                if (file instanceof LockedFile) {
                    LockedFile lockedFile = null;
                    try {
                        lockedFile = LockedFile.createOpenedLockedFile(file);
                    }
                    catch (Exception exception) {
                        Common.logException("Error:", exception);
                        JOptionPane.showMessageDialog(Common.getApplication(), Common.I18N_MESSAGES.getString("document.fileInUseOnExport.message"), Common.I18N_MESSAGES.getString("document.fileInUse.title"), 0);
                        return;
                    }
                    this.save(lockedFile, fileType);
                    lockedFile.unlock();
                    break block5;
                }
                this.save(file, fileType);
            }
            catch (Exception exception) {
                Common.logException("Error exporting file:", exception);
                throw new DocumentException(exception.getLocalizedMessage());
            }
        }
    }

    public boolean export() throws DocumentException {
        CustomTypeFile customTypeFile = this.getExportedFile();
        if (customTypeFile != null && customTypeFile.getFile() != null) {
            this.export(customTypeFile.getFile(), customTypeFile.getFileType());
            return true;
        }
        return false;
    }

    protected void fireDocumentChanged() {
        DocumentEvent documentEvent = new DocumentEvent(this);
        EventListener[] eventListenerArray = this.listeners.getListeners(DocumentListener.class);
        int n = this.listeners.getListenerCount();
        for (int i = 0; i < n; ++i) {
            ((DocumentListener)eventListenerArray[i]).documentChanged(documentEvent);
        }
    }

    protected void fireDocumentLocked() {
        DocumentEvent documentEvent = new DocumentEvent(this);
        EventListener[] eventListenerArray = this.listeners.getListeners(DocumentListener.class);
        int n = this.listeners.getListenerCount();
        for (int i = 0; i < n; ++i) {
            ((DocumentListener)eventListenerArray[i]).documentLocked(documentEvent);
        }
    }

    protected void fireDocumentFileChanged() {
        DocumentEvent documentEvent = new DocumentEvent(this);
        EventListener[] eventListenerArray = this.listeners.getListeners(DocumentListener.class);
        int n = this.listeners.getListenerCount();
        for (int i = 0; i < n; ++i) {
            ((DocumentListener)eventListenerArray[i]).documentFileChanged(documentEvent);
        }
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean bl) {
        this.locked = bl;
        this.fireDocumentLocked();
    }

    public boolean isProprietary() {
        return this.proprietary;
    }

    public void setProprietary(boolean bl) {
        this.proprietary = bl;
    }
}

