/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.dB.xml;

import com.sbs.jpm.Common;
import com.sbs.jpm.Main;
import com.sbs.jpm.ui.JApplication;
import com.sbs.util.Product;
import com.sbs.util.SystemUtilities;
import com.sbs.util.Version;
import com.sbs.xml.XmlUtil;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VersionLoader {
    private static final String PRODUCT = "product";
    private static final String PRODUCT_NAME = "name";
    private static final String PRODUCT_VERSION = "version";
    private static final String FULL_LINK_WINDOWS = "full-link-windows";
    private static final String FULL_LINK_MAC = "full-link-mac";
    private static final String FULL_LINK_CROSS = "full-link-cross";
    private static final String TRIAL_LINK_WINDOWS = "trial-link-windows";
    private static final String TRIAL_LINK_CROSS = "trial-link-cross";
    private static final String TRIAL_LINK_MAC = "trial-link-mac";
    private static final String VIEWER_LINK_WINDOWS = "viewer-link-windows";
    private static final String VIEWER_LINK_MAC = "viewer-link-mac";
    private static final String VIEWER_LINK_CROSS = "viewer-link-cross";

    public static List loadProducts(URL uRL) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            String string = "";
            string = string + "T";
            string = string + "RationalPlan";
            string = string + "Single";
            string = string + "-" + JApplication.getApplicationVersion();
            if (SystemUtilities.isOSLinux()) {
                string = string + "-Linux";
            } else if (SystemUtilities.isOSMac()) {
                string = string + "-Mac";
            } else if (SystemUtilities.isOSWindows()) {
                string = string + "-Windows";
            }
            if (SystemUtilities.isOSWindowsVista()) {
                string = string + "Vista";
            } else if (SystemUtilities.isOSWindows2000()) {
                string = string + "2000";
            } else if (SystemUtilities.isOSWindowsXP()) {
                string = string + "XP";
            }
            string = string + ";" + Main.INSTALL_DATE_TRIAL_VERSION + "*" + Main.INSTALL_DATE_FULL_VERSION;
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setRequestProperty("Referer", string);
            Document document = documentBuilder.parse(uRLConnection.getInputStream());
            return VersionLoader.parseProducts(document.getFirstChild());
        }
        catch (Throwable throwable) {
            Common.logException("Error:", throwable);
            return null;
        }
    }

    private static List parseProducts(Node node) {
        LinkedList<Product> linkedList = new LinkedList<Product>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(PRODUCT) != 0) continue;
            linkedList.add(VersionLoader.parseProduct(node2));
        }
        return linkedList;
    }

    private static Product parseProduct(Node node) {
        Product product = new Product();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            if (node2.getNodeName().compareTo(PRODUCT_NAME) == 0) {
                product.setName(XmlUtil.getTextFromNode(node2));
                continue;
            }
            if (node2.getNodeName().compareTo(PRODUCT_VERSION) == 0) {
                product.setVersion(new Version(XmlUtil.getTextFromNode(node2)));
                continue;
            }
            if (node2.getNodeName().compareTo(FULL_LINK_WINDOWS) == 0) {
                product.setFullLinkWindows(XmlUtil.getTextFromNode(node2));
                continue;
            }
            if (node2.getNodeName().compareTo(FULL_LINK_MAC) == 0) {
                product.setFullLinkMac(XmlUtil.getTextFromNode(node2));
                continue;
            }
            if (node2.getNodeName().compareTo(FULL_LINK_CROSS) == 0) {
                product.setFullLinkCross(XmlUtil.getTextFromNode(node2));
                continue;
            }
            if (node2.getNodeName().compareTo(TRIAL_LINK_WINDOWS) == 0) {
                product.setTrialLinkWindows(XmlUtil.getTextFromNode(node2));
                continue;
            }
            if (node2.getNodeName().compareTo(TRIAL_LINK_MAC) == 0) {
                product.setTrialLinkMac(XmlUtil.getTextFromNode(node2));
                continue;
            }
            if (node2.getNodeName().compareTo(TRIAL_LINK_CROSS) == 0) {
                product.setTrialLinkCross(XmlUtil.getTextFromNode(node2));
                continue;
            }
            if (node2.getNodeName().compareTo(VIEWER_LINK_WINDOWS) == 0) {
                product.setViewerLinkWindows(XmlUtil.getTextFromNode(node2));
                continue;
            }
            if (node2.getNodeName().compareTo(VIEWER_LINK_MAC) == 0) {
                product.setViewerLinkMac(XmlUtil.getTextFromNode(node2));
                continue;
            }
            if (node2.getNodeName().compareTo(VIEWER_LINK_CROSS) != 0) continue;
            product.setViewerLinkCross(XmlUtil.getTextFromNode(node2));
        }
        return product;
    }
}

