/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.dB.xml;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Risk;
import com.sbs.jpm.core.Task;
import com.sbs.xml.XmlUtil;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RiskLoader {
    private static final String LOW = "1-low";
    private static final String MEDIUM = "2-medium";
    private static final String HIGH = "3-high";
    private static final String OPENED = "opened";
    private static final String CLOSED = "closed";
    private static final String RISK = "risk";
    private static final String RISK_STATUS = "risk-status";
    private static final String RISK_DESCRIPTION = "risk-description";
    private static final String RISK_RESPONSE_PLAN = "risk-response-plan";
    private static final String RISK_IMPACT = "risk-impact";
    private static final String RISK_PROBABILITY = "risk-probability";
    private static final String RISK_UNIQUE_ID = "risk-unique-id";
    public static final String RISK_LIST = "risk-list";

    public static List loadRiskList(Task task, Node node) {
        LinkedList<Risk> linkedList = new LinkedList<Risk>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(RISK) != 0) continue;
            linkedList.add(RiskLoader.loadRisk(task, node2));
        }
        return linkedList;
    }

    private static Risk loadRisk(Task task, Node node) {
        Common.getIdGenerator();
        Risk risk = new Risk(Long.MIN_VALUE);
        risk.setOwner(task.getCompany());
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            if (node2.getNodeName().compareTo(RISK_STATUS) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                if (string.equals(OPENED)) {
                    risk.setStatus(Risk.OPENED);
                    continue;
                }
                risk.setStatus(Risk.CLOSED);
                continue;
            }
            if (node2.getNodeName().compareTo(RISK_DESCRIPTION) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                if (string == null) continue;
                risk.setDescription(string);
                continue;
            }
            if (node2.getNodeName().compareTo(RISK_UNIQUE_ID) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                if (string == null) continue;
                risk.setUniqueId(Long.parseLong(string));
                continue;
            }
            if (node2.getNodeName().compareTo(RISK_RESPONSE_PLAN) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                if (string == null) continue;
                risk.setResponsePlan(string);
                continue;
            }
            if (node2.getNodeName().compareTo(RISK_IMPACT) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                if (string.equals(HIGH)) {
                    risk.setImpact(Risk.HIGH);
                    continue;
                }
                if (string.equals(LOW)) {
                    risk.setImpact(Risk.LOW);
                    continue;
                }
                risk.setImpact(Risk.MEDIUM);
                continue;
            }
            if (node2.getNodeName().compareTo(RISK_PROBABILITY) != 0) continue;
            string = XmlUtil.getTextFromNode(node2);
            if (string.equals(HIGH)) {
                risk.setProbability(Risk.HIGH);
                continue;
            }
            if (string.equals(LOW)) {
                risk.setProbability(Risk.LOW);
                continue;
            }
            risk.setProbability(Risk.MEDIUM);
        }
        return risk;
    }

    public static Element storeRiskList(Document document, List list) {
        Element element = document.createElement(RISK_LIST);
        for (Risk risk : list) {
            element.appendChild(RiskLoader.storeRisk(document, risk));
        }
        return element;
    }

    private static Element storeRisk(Document document, Risk risk) {
        Element element = document.createElement(RISK);
        String string = OPENED;
        if (risk.getStatus().equals(Risk.CLOSED)) {
            string = CLOSED;
        } else if (risk.getStatus().equals(Risk.OPENED)) {
            string = OPENED;
        }
        Element element2 = XmlUtil.createTextElement(document, RISK_STATUS, string);
        Element element3 = XmlUtil.createTextElement(document, RISK_DESCRIPTION, risk.getDescription());
        Element element4 = XmlUtil.createTextElement(document, RISK_UNIQUE_ID, Long.toString(risk.getUniqueId()));
        Element element5 = XmlUtil.createTextElement(document, RISK_RESPONSE_PLAN, risk.getResponsePlan());
        String string2 = MEDIUM;
        if (risk.getImpact().equals(Risk.LOW)) {
            string2 = LOW;
        } else if (risk.getImpact().equals(Risk.MEDIUM)) {
            string2 = MEDIUM;
        } else if (risk.getImpact().equals(Risk.HIGH)) {
            string2 = HIGH;
        }
        Element element6 = XmlUtil.createTextElement(document, RISK_IMPACT, string2);
        string2 = MEDIUM;
        if (risk.getProbability().equals(Risk.LOW)) {
            string2 = LOW;
        } else if (risk.getProbability().equals(Risk.MEDIUM)) {
            string2 = MEDIUM;
        } else if (risk.getProbability().equals(Risk.HIGH)) {
            string2 = HIGH;
        }
        Element element7 = XmlUtil.createTextElement(document, RISK_PROBABILITY, string2);
        element.appendChild(element4);
        element.appendChild(element2);
        element.appendChild(element3);
        element.appendChild(element5);
        element.appendChild(element6);
        element.appendChild(element7);
        return element;
    }
}

