/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.dB.xml;

import com.sbs.jpm.Common;
import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.calendar.DayWorkingPattern;
import com.sbs.jpm.calendar.PeriodInDay;
import com.sbs.jpm.calendar.ResourceCalendarManager;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.HumanResource;
import com.sbs.jpm.core.InvalidOperationException;
import com.sbs.jpm.core.MaterialResource;
import com.sbs.jpm.core.Resource;
import com.sbs.jpm.dB.CalendarCollection;
import com.sbs.jpm.dB.xml.AdditionalFieldLoader;
import com.sbs.jpm.ui.PrivacyManager;
import com.sbs.xml.XmlUtil;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceLoader {
    private static final String RESOURCE = "resource";
    private static final String EMPTY_RESOURCE = "empty-resource";
    private static final String RESOURCE_NAME = "resource-name";
    private static final String RESOURCE_PHONE = "resource-phone";
    private static final String RESOURCE_EMAIL = "resource-email";
    private static final String RESOURCE_CODE = "resource-code";
    private static final String RESOURCE_NOTES = "resource-notes";
    private static final String RESOURCE_STANDARD_RATE = "resource-standard-rate";
    private static final String RESOURCE_OVERTIME_RATE = "resource-overtime-rate";
    private static final String RESOURCE_COST_PER_USE = "resource-cost-per-use";
    private static final String RESOURCE_MAX_UNIT = "resource-max-unit";
    private static final String RESOURCE_ID = "resource-id";
    private static final String RESOURCE_UNIQUE_ID = "resource-unique-id";
    private static final String RESOURCE_CALENDAR_ID = "resource-calendar-id";
    private static final String RESOURCE_MEASUREMENT_UNIT = "resource-measurement-unit";
    public static final String RESOURCE_LIST = "resource-list";
    public static final String HUMAN_RESOURCE_LIST = "human-resource-list";
    public static final String MATERIAL_RESOURCE_LIST = "material-resource-list";
    private static final String SPECIAL_PATTERN_LIST = "special-pattern-list";
    private static final String PATTERN = "pattern";
    private static final String PATTERN_DATE = "date";
    private static final String PERIOD_IN_DAY = "period-in-day";
    private static final String PERIOD_TYPE = "period-type";
    private static final String PERIOD_START = "period-start-date";
    private static final String PERIOD_END = "period-end-date";
    private static final DateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy, HH:mm:ss");

    public static List loadHumanResourceList(Company company, Node node, CalendarCollection calendarCollection) {
        LinkedList<Resource> linkedList = new LinkedList<Resource>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(RESOURCE) != 0 && node2.getNodeName().compareTo(EMPTY_RESOURCE) != 0) continue;
            linkedList.add(ResourceLoader.loadHumanResource(company, node2, calendarCollection));
        }
        return linkedList;
    }

    public static List loadMaterialResourceList(Company company, Node node) {
        LinkedList<Resource> linkedList = new LinkedList<Resource>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(RESOURCE) != 0 && node2.getNodeName().compareTo(EMPTY_RESOURCE) != 0) continue;
            linkedList.add(ResourceLoader.loadMaterialResource(company, node2));
        }
        return linkedList;
    }

    private static void loadSpecialPatternList(ResourceCalendarManager resourceCalendarManager, Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(PATTERN) != 0) continue;
            NamedNodeMap namedNodeMap = node2.getAttributes();
            Node node3 = namedNodeMap.getNamedItem(PATTERN_DATE);
            String string = node3.getNodeValue();
            Date date = null;
            try {
                date = dateFormat.parse(string);
            }
            catch (ParseException parseException) {
                Common.logException("Error:", parseException);
                parseException.printStackTrace();
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            resourceCalendarManager.setResourceDayPattern(calendar, ResourceLoader.loadDayPattern(resourceCalendarManager, node2));
        }
    }

    private static DayWorkingPattern loadDayPattern(CalendarManager calendarManager, Node node) {
        DayWorkingPattern dayWorkingPattern = new DayWorkingPattern();
        dayWorkingPattern.setOwner(calendarManager);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(PERIOD_IN_DAY) != 0) continue;
            dayWorkingPattern.addAlternance(ResourceLoader.loadPeriodInDay(node2));
        }
        dayWorkingPattern.fillWithNonWorking();
        return dayWorkingPattern;
    }

    private static PeriodInDay loadPeriodInDay(Node node) {
        boolean bl = false;
        long l = 0L;
        long l2 = 0L;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            if (node2.getNodeName().compareTo(PERIOD_TYPE) == 0) {
                bl = Boolean.parseBoolean(XmlUtil.getTextFromNode(node2));
                continue;
            }
            if (node2.getNodeName().compareTo(PERIOD_START) == 0) {
                l = Long.parseLong(XmlUtil.getTextFromNode(node2));
                continue;
            }
            if (node2.getNodeName().compareTo(PERIOD_END) != 0) continue;
            l2 = Long.parseLong(XmlUtil.getTextFromNode(node2));
        }
        PeriodInDay periodInDay = null;
        try {
            periodInDay = new PeriodInDay(bl, l, l2);
        }
        catch (InvalidOperationException invalidOperationException) {
            Common.logException("Error:", invalidOperationException);
            JOptionPane.showMessageDialog(Common.getApplication(), invalidOperationException.getLocalizedMessage(), Common.I18N_MESSAGES.getString("file.failedToOpen"), 0);
        }
        return periodInDay;
    }

    private static Resource loadHumanResource(Company company, Node node, CalendarCollection calendarCollection) {
        HumanResource humanResource = new HumanResource(Long.MIN_VALUE);
        if (node.getNodeName().compareTo(RESOURCE) != 0) {
            humanResource.setEmpty(true);
        }
        humanResource.setOwner(company);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            if (node2.getNodeName().compareTo(RESOURCE_UNIQUE_ID) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                humanResource.setUniqueId(Long.parseLong(string));
                continue;
            }
            if (node2.getNodeName().compareTo(RESOURCE_ID) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                humanResource.setId(Long.parseLong(string));
                continue;
            }
            if (node2.getNodeName().compareTo(RESOURCE_NAME) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                if (string == null) continue;
                humanResource.setName(string);
                continue;
            }
            if (node2.getNodeName().compareTo(RESOURCE_CODE) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                if (string == null) continue;
                humanResource.setCode(string);
                continue;
            }
            if (node2.getNodeName().compareTo(RESOURCE_PHONE) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                if (string == null) continue;
                humanResource.setPhoneNo(string);
                continue;
            }
            if (node2.getNodeName().compareTo(RESOURCE_EMAIL) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                if (string == null) continue;
                humanResource.setEmail(string);
                continue;
            }
            if (node2.getNodeName().compareTo(RESOURCE_NOTES) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                if (string == null) continue;
                humanResource.setNotes(string);
                continue;
            }
            if (node2.getNodeName().compareTo(RESOURCE_STANDARD_RATE) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                humanResource.setStandardRate(Double.parseDouble(string));
                continue;
            }
            if (node2.getNodeName().compareTo(RESOURCE_OVERTIME_RATE) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                humanResource.setOvertimeRate(Double.parseDouble(string));
                continue;
            }
            if (node2.getNodeName().compareTo(RESOURCE_MAX_UNIT) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                humanResource.setMaxUnits(Double.parseDouble(string));
                continue;
            }
            if (node2.getNodeName().compareTo(RESOURCE_CALENDAR_ID) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                humanResource.setCalendar(calendarCollection.getCalendarForId(Long.parseLong(string)));
                continue;
            }
            if (node2.getNodeName().compareTo("field-list") == 0) {
                AdditionalFieldLoader.loadResourceFieldList(humanResource, node2);
                continue;
            }
            if (node2.getNodeName().compareTo(SPECIAL_PATTERN_LIST) != 0) continue;
            ResourceLoader.loadSpecialPatternList(humanResource.getResourceCalendar(), node2);
        }
        return humanResource;
    }

    private static Resource loadMaterialResource(Company company, Node node) {
        MaterialResource materialResource = new MaterialResource(Long.MIN_VALUE);
        if (node.getNodeName().compareTo(RESOURCE) != 0) {
            materialResource.setEmpty(true);
        }
        materialResource.setOwner(company);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            if (node2.getNodeName().compareTo(RESOURCE_UNIQUE_ID) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                materialResource.setUniqueId(Long.parseLong(string));
                continue;
            }
            if (node2.getNodeName().compareTo(RESOURCE_ID) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                materialResource.setId(Long.parseLong(string));
                continue;
            }
            if (node2.getNodeName().compareTo(RESOURCE_NAME) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                if (string == null) continue;
                materialResource.setName(string);
                continue;
            }
            if (node2.getNodeName().compareTo(RESOURCE_CODE) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                if (string == null) continue;
                materialResource.setCode(string);
                continue;
            }
            if (node2.getNodeName().compareTo(RESOURCE_NOTES) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                if (string == null) continue;
                materialResource.setNotes(string);
                continue;
            }
            if (node2.getNodeName().compareTo(RESOURCE_STANDARD_RATE) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                materialResource.setStandardRate(Double.parseDouble(string));
                continue;
            }
            if (node2.getNodeName().compareTo(RESOURCE_MEASUREMENT_UNIT) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                if (string == null) continue;
                materialResource.setMeasurementUnit(string);
                continue;
            }
            if (node2.getNodeName().compareTo("field-list") != 0) continue;
            AdditionalFieldLoader.loadResourceFieldList(materialResource, node2);
        }
        return materialResource;
    }

    public static Element storeHumanResourceList(Document document, List list, boolean bl) {
        Element element = document.createElement(HUMAN_RESOURCE_LIST);
        if (!PrivacyManager.getInstance().isHideResources()) {
            for (Resource resource : list) {
                element.appendChild(ResourceLoader.storeHumanResource(document, resource, bl));
            }
        }
        return element;
    }

    public static Element storeMaterialResourceList(Document document, List list, boolean bl) {
        Element element = document.createElement(MATERIAL_RESOURCE_LIST);
        if (!PrivacyManager.getInstance().isHideResources()) {
            for (Resource resource : list) {
                element.appendChild(ResourceLoader.storeMaterialResource(document, resource, bl));
            }
        }
        return element;
    }

    private static Element storeDayPattern(Document document, Calendar calendar, DayWorkingPattern dayWorkingPattern) {
        Element element = document.createElement(PATTERN);
        element.setAttribute(PATTERN_DATE, dateFormat.format(calendar.getTime()));
        PeriodInDay[] periodInDayArray = dayWorkingPattern.getPeriodsInDay();
        for (int i = 0; i < periodInDayArray.length; ++i) {
            PeriodInDay periodInDay = periodInDayArray[i];
            element.appendChild(ResourceLoader.storePeriodInDay(document, periodInDay));
        }
        return element;
    }

    private static Element storePeriodInDay(Document document, PeriodInDay periodInDay) {
        Element element = document.createElement(PERIOD_IN_DAY);
        Element element2 = XmlUtil.createTextElement(document, PERIOD_TYPE, String.valueOf(periodInDay.isWorking()));
        Element element3 = XmlUtil.createTextElement(document, PERIOD_START, String.valueOf(periodInDay.getStartPeriod()));
        Element element4 = XmlUtil.createTextElement(document, PERIOD_END, String.valueOf(periodInDay.getEndPeriod()));
        element.appendChild(element2);
        element.appendChild(element3);
        element.appendChild(element4);
        return element;
    }

    private static Element storeSpecialPatternList(Document document, List list) {
        Element element = document.createElement(SPECIAL_PATTERN_LIST);
        for (CalendarManager.SpecialDay specialDay : list) {
            Element element2 = ResourceLoader.storeDayPattern(document, specialDay.getDate(), specialDay.getDayPattern());
            element.appendChild(element2);
        }
        return element;
    }

    private static Element storeHumanResource(Document document, Resource resource, boolean bl) {
        Element element;
        if (resource.isEmpty()) {
            element = document.createElement(EMPTY_RESOURCE);
            if (Common.SAVE_IDs) {
                Element element2 = XmlUtil.createTextElement(document, RESOURCE_UNIQUE_ID, "" + resource.getUniqueId());
                element.appendChild(element2);
            }
        } else {
            HumanResource humanResource = (HumanResource)resource;
            element = document.createElement(RESOURCE);
            PrivacyManager privacyManager = PrivacyManager.getInstance();
            Element element3 = XmlUtil.createTextElement(document, RESOURCE_NAME, resource.getName());
            Element element4 = XmlUtil.createTextElement(document, RESOURCE_CODE, resource.getCode());
            Element element5 = XmlUtil.createTextElement(document, RESOURCE_PHONE, humanResource.getPhoneNo());
            Element element6 = XmlUtil.createTextElement(document, RESOURCE_EMAIL, humanResource.getEmail());
            Element element7 = XmlUtil.createTextElement(document, RESOURCE_NOTES, bl && privacyManager.isHideResourceNotes() ? "" : resource.getNotes());
            Element element8 = XmlUtil.createTextElement(document, RESOURCE_STANDARD_RATE, bl && privacyManager.isHideResourceCosts() ? "0" : "" + resource.getStandardRate());
            Element element9 = XmlUtil.createTextElement(document, RESOURCE_OVERTIME_RATE, bl && privacyManager.isHideResourceCosts() ? "0" : "" + humanResource.getOvertimeRate());
            Element element10 = XmlUtil.createTextElement(document, RESOURCE_MAX_UNIT, String.valueOf(humanResource.getMaxUnits()));
            Element element11 = XmlUtil.createTextElement(document, RESOURCE_ID, resource.getId() + "");
            Element element12 = XmlUtil.createTextElement(document, RESOURCE_UNIQUE_ID, "" + resource.getUniqueId());
            Element element13 = ResourceLoader.storeSpecialPatternList(document, humanResource.getResourceCalendar().getResourcePatternList());
            Element element14 = AdditionalFieldLoader.storeFieldList(document, resource);
            if (Common.SAVE_IDs) {
                element.appendChild(element12);
            }
            element.appendChild(element11);
            element.appendChild(element3);
            element.appendChild(element5);
            element.appendChild(element6);
            element.appendChild(element7);
            element.appendChild(element8);
            element.appendChild(element9);
            element.appendChild(element10);
            element.appendChild(element4);
            element.appendChild(element14);
            if (humanResource.getCalendar() != null) {
                Element element15 = XmlUtil.createTextElement(document, RESOURCE_CALENDAR_ID, humanResource.getCalendar().getId().toString());
                element.appendChild(element15);
            }
            element.appendChild(element13);
        }
        return element;
    }

    private static Element storeMaterialResource(Document document, Resource resource, boolean bl) {
        Element element;
        if (resource.isEmpty()) {
            element = document.createElement(EMPTY_RESOURCE);
            if (Common.SAVE_IDs) {
                Element element2 = XmlUtil.createTextElement(document, RESOURCE_UNIQUE_ID, "" + resource.getUniqueId());
                element.appendChild(element2);
            }
        } else {
            MaterialResource materialResource = (MaterialResource)resource;
            element = document.createElement(RESOURCE);
            PrivacyManager privacyManager = PrivacyManager.getInstance();
            Element element3 = XmlUtil.createTextElement(document, RESOURCE_ID, resource.getId() + "");
            Element element4 = XmlUtil.createTextElement(document, RESOURCE_UNIQUE_ID, "" + resource.getUniqueId());
            Element element5 = XmlUtil.createTextElement(document, RESOURCE_NAME, resource.getName());
            Element element6 = XmlUtil.createTextElement(document, RESOURCE_CODE, resource.getCode());
            Element element7 = XmlUtil.createTextElement(document, RESOURCE_NOTES, bl && privacyManager.isHideResourceNotes() ? "" : resource.getNotes());
            Element element8 = XmlUtil.createTextElement(document, RESOURCE_STANDARD_RATE, bl && privacyManager.isHideResourceCosts() ? "0" : "" + resource.getStandardRate());
            Element element9 = XmlUtil.createTextElement(document, RESOURCE_MEASUREMENT_UNIT, materialResource.getMeasurementUnit());
            Element element10 = AdditionalFieldLoader.storeFieldList(document, resource);
            if (Common.SAVE_IDs) {
                element.appendChild(element4);
            }
            element.appendChild(element3);
            element.appendChild(element5);
            element.appendChild(element7);
            element.appendChild(element8);
            element.appendChild(element9);
            element.appendChild(element6);
            element.appendChild(element10);
        }
        return element;
    }
}

