/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.dB.xml;

import com.sbs.jpm.Common;
import com.sbs.jpm.ui.core.Data;
import com.sbs.jpm.ui.core.Node;
import com.sbs.jpm.ui.core.ProjectData;
import com.sbs.jpm.ui.core.ProjectNode;
import com.sbs.jpm.ui.core.ProjectTree;
import com.sbs.jpm.ui.core.Tree;
import com.sbs.xml.XmlUtil;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class ProjectUILoader {
    private static final String NODE_LIST = "node-list";
    private static final String NODE = "node";
    private static final String DATA_NAME = "data-name";
    private static final String DATA_SHORT_DESCRIPTION = "data-short-description";
    private static final String DATA_LONG_DESCRIPTION = "data-long-description";
    private static final String DATA = "data";
    private static final String TREE = "tree";

    public static Tree loadProjectUI(URL uRL) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(uRL.openStream());
            return ProjectUILoader.parseTree(document.getFirstChild());
        }
        catch (Throwable throwable) {
            Common.logException("Error:", throwable);
            throwable.printStackTrace();
            return null;
        }
    }

    private static Tree parseTree(org.w3c.dom.Node node) {
        ProjectTree projectTree = new ProjectTree();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            org.w3c.dom.Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(NODE) != 0) continue;
            projectTree.setRoot(ProjectUILoader.parseNode(node2));
        }
        return projectTree;
    }

    private static List parseNodeList(org.w3c.dom.Node node) throws RuntimeException {
        if (node.getNodeType() != 1 || node.getNodeName().compareTo(NODE_LIST) != 0) {
            throw new RuntimeException("Invalid node: not 'node-list'");
        }
        Vector<Node> vector = new Vector<Node>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            org.w3c.dom.Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(NODE) != 0) continue;
            vector.add(ProjectUILoader.parseNode(node2));
        }
        return vector;
    }

    private static Node parseNode(org.w3c.dom.Node node) {
        ProjectNode projectNode = new ProjectNode();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            org.w3c.dom.Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            if (node2.getNodeName().compareTo(DATA) == 0) {
                projectNode.setData(ProjectUILoader.parseData(node2));
                continue;
            }
            if (node2.getNodeName().compareTo(NODE_LIST) != 0) continue;
            List list = ProjectUILoader.parseNodeList(node2);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                projectNode.addChild((Node)iterator.next());
            }
        }
        return projectNode;
    }

    private static Data parseData(org.w3c.dom.Node node) {
        ProjectData projectData = new ProjectData();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            org.w3c.dom.Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            if (node2.getNodeName().compareTo(DATA_NAME) == 0) {
                projectData.setName(XmlUtil.getTextFromNode(node2));
                continue;
            }
            if (node2.getNodeName().compareTo(DATA_SHORT_DESCRIPTION) == 0) {
                projectData.setShortDescription(XmlUtil.getTextFromNode(node2));
                continue;
            }
            if (node2.getNodeName().compareTo(DATA_LONG_DESCRIPTION) != 0) continue;
            projectData.setLongDescription(XmlUtil.getTextFromNode(node2));
        }
        return projectData;
    }
}

