/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.dB.xml;

import com.sbs.jpm.core.Link;
import com.sbs.jpm.core.Task;
import com.sbs.xml.XmlUtil;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LinkLoader {
    private static final String LINK = "link";
    private static final String LINK_NAME = "link-name";
    private static final String LINK_DESCRIPTION = "link-description";
    private static final String LINK_UNIQUE_ID = "link-unique-id";
    public static final String LINK_LIST = "link-list";

    public static List loadLinkList(Task task, Node node) {
        LinkedList<Link> linkedList = new LinkedList<Link>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(LINK) != 0) continue;
            linkedList.add(LinkLoader.loadLink(task, node2));
        }
        return linkedList;
    }

    private static Link loadLink(Task task, Node node) {
        Link link = new Link(Long.MIN_VALUE);
        link.setOwner(task.getCompany());
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            if (node2.getNodeName().compareTo(LINK_NAME) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                if (string == null) continue;
                link.setName(string);
                continue;
            }
            if (node2.getNodeName().compareTo(LINK_DESCRIPTION) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                if (string == null) continue;
                link.setDescription(string);
                continue;
            }
            if (node2.getNodeName().compareTo(LINK_UNIQUE_ID) != 0 || (string = XmlUtil.getTextFromNode(node2)) == null) continue;
            link.setUniqueId(Long.parseLong(string));
        }
        return link;
    }

    public static Element storeLinkList(Document document, List list) {
        Element element = document.createElement(LINK_LIST);
        for (Link link : list) {
            element.appendChild(LinkLoader.storeLink(document, link));
        }
        return element;
    }

    private static Element storeLink(Document document, Link link) {
        Element element = document.createElement(LINK);
        Element element2 = XmlUtil.createTextElement(document, LINK_NAME, link.getName());
        Element element3 = XmlUtil.createTextElement(document, LINK_DESCRIPTION, link.getDescription());
        Element element4 = XmlUtil.createTextElement(document, LINK_UNIQUE_ID, Long.toString(link.getUniqueId()));
        element.appendChild(element4);
        element.appendChild(element2);
        element.appendChild(element3);
        return element;
    }
}

