/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.dB.xml;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.constraint.ALAP;
import com.sbs.jpm.core.constraint.ASAP;
import com.sbs.jpm.core.constraint.Constraint;
import com.sbs.jpm.core.constraint.FNET;
import com.sbs.jpm.core.constraint.FNLT;
import com.sbs.jpm.core.constraint.MFO;
import com.sbs.jpm.core.constraint.MSO;
import com.sbs.jpm.core.constraint.SNET;
import com.sbs.jpm.core.constraint.SNLT;
import com.sbs.xml.XmlUtil;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConstraintLoader {
    private static final String SNET = "snet";
    private static final String SNLT = "snlt";
    private static final String FNET = "fnet";
    private static final String FNLT = "fnlt";
    private static final String ASAP = "asap";
    private static final String ALAP = "alap";
    private static final String MSO = "mso";
    private static final String MFO = "mfo";
    private static final DateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy, HH:mm:ss");

    public static Constraint loadConstraint(Node node) {
        Constraint constraint = null;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Date date;
            String string;
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            if (node2.getNodeName().compareTo(ASAP) == 0) {
                constraint = new ASAP();
                continue;
            }
            if (node2.getNodeName().compareTo(ALAP) == 0) {
                constraint = new ALAP();
                continue;
            }
            if (node2.getNodeName().compareTo(MSO) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                date = null;
                try {
                    date = dateFormat.parse(string);
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace();
                    Common.logException("Error:", parseException);
                }
                constraint = new MSO(date);
                continue;
            }
            if (node2.getNodeName().compareTo(MFO) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                date = null;
                try {
                    date = dateFormat.parse(string);
                }
                catch (ParseException parseException) {
                    Common.logException("Error:", parseException);
                    parseException.printStackTrace();
                }
                constraint = new MFO(date);
                continue;
            }
            if (node2.getNodeName().compareTo(SNET) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                date = null;
                try {
                    date = dateFormat.parse(string);
                }
                catch (ParseException parseException) {
                    Common.logException("Error:", parseException);
                    parseException.printStackTrace();
                }
                constraint = new SNET(date);
                continue;
            }
            if (node2.getNodeName().compareTo(SNLT) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                date = null;
                try {
                    date = dateFormat.parse(string);
                }
                catch (ParseException parseException) {
                    Common.logException("Error:", parseException);
                    parseException.printStackTrace();
                }
                constraint = new SNLT(date);
                continue;
            }
            if (node2.getNodeName().compareTo(FNET) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                date = null;
                try {
                    date = dateFormat.parse(string);
                }
                catch (ParseException parseException) {
                    Common.logException("Error:", parseException);
                    parseException.printStackTrace();
                }
                constraint = new FNET(date);
                continue;
            }
            if (node2.getNodeName().compareTo(FNLT) != 0) continue;
            string = XmlUtil.getTextFromNode(node2);
            date = null;
            try {
                date = dateFormat.parse(string);
            }
            catch (ParseException parseException) {
                Common.logException("Error:", parseException);
                parseException.printStackTrace();
            }
            constraint = new FNLT(date);
        }
        return constraint;
    }

    public static Element storeConstraint(Document document, Constraint constraint) {
        Element element = null;
        if (constraint instanceof SNET) {
            Date date = ((SNET)constraint).getDate();
            element = XmlUtil.createTextElement(document, SNET, dateFormat.format(date));
        } else if (constraint instanceof SNLT) {
            Date date = ((SNLT)constraint).getDate();
            element = XmlUtil.createTextElement(document, SNLT, dateFormat.format(date));
        } else if (constraint instanceof FNLT) {
            Date date = ((FNLT)constraint).getDate();
            element = XmlUtil.createTextElement(document, FNLT, dateFormat.format(date));
        } else if (constraint instanceof FNET) {
            Date date = ((FNET)constraint).getDate();
            element = XmlUtil.createTextElement(document, FNET, dateFormat.format(date));
        } else if (constraint instanceof ASAP) {
            element = XmlUtil.createTextElement(document, ASAP, "");
        } else if (constraint instanceof ALAP) {
            element = XmlUtil.createTextElement(document, ALAP, "");
        } else if (constraint instanceof MSO) {
            Date date = ((MSO)constraint).getDate();
            element = XmlUtil.createTextElement(document, MSO, dateFormat.format(date));
        } else if (constraint instanceof MFO) {
            Date date = ((MFO)constraint).getDate();
            element = XmlUtil.createTextElement(document, MFO, dateFormat.format(date));
        }
        return element;
    }
}

