/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.dB.xml;

import com.sbs.jpm.Common;
import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.core.Client;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Dependency;
import com.sbs.jpm.core.HumanResource;
import com.sbs.jpm.core.MaterialResource;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.conflict.Conflict;
import com.sbs.jpm.dB.CalendarCollection;
import com.sbs.jpm.dB.ClientCollection;
import com.sbs.jpm.dB.ResourceCollection;
import com.sbs.jpm.dB.TaskCollection;
import com.sbs.jpm.dB.xml.AdditionalFieldLoader;
import com.sbs.jpm.dB.xml.AssignmentLoader;
import com.sbs.jpm.dB.xml.CalendarLoader;
import com.sbs.jpm.dB.xml.ClientLoader;
import com.sbs.jpm.dB.xml.ConflictLoader;
import com.sbs.jpm.dB.xml.DependencyLoader;
import com.sbs.jpm.dB.xml.ResourceLoader;
import com.sbs.jpm.dB.xml.TaskLoader;
import com.sbs.jpm.dB.xml.ViewerLoader;
import com.sbs.jpm.ui.JApplication;
import com.sbs.jpm.ui.component.JAreaView;
import com.sbs.jpm.ui.component.JProjectView;
import com.sbs.jpm.ui.component.view.JProjectViewGantt;
import com.sbs.jpm.ui.treetablechart.JGanttChart;
import com.sbs.util.Version;
import com.sbs.xml.XmlUtil;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CompanyLoader {
    public static final String VERSION = "version";
    public static final String MULTI_PROJECT = "type";
    public static final String COMPANY = "company";
    private static final String COMPANY_CALENDAR_ID = "company-calendar-id";

    private static Node getChildNode(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(string) != 0) continue;
            return node2;
        }
        return null;
    }

    public static String getVersion(Node node) {
        Node node2 = CompanyLoader.getChildNode(node, VERSION);
        if (node2 != null) {
            String string = XmlUtil.getTextFromNode(node2);
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Company loadCompany(Node node) throws Exception {
        Object object;
        Iterator iterator;
        Object object2;
        Object object3;
        Node node2;
        Object object4;
        Node node3;
        Node node4;
        Node node5;
        Node node6;
        Object object5;
        Object object6;
        Object object7;
        Long l = System.currentTimeMillis();
        Task task = new Task(Long.MIN_VALUE);
        CalendarManager calendarManager = CalendarManager.createStandardCalendarInstance();
        List list = new LinkedList();
        List<HumanResource> list2 = new LinkedList<HumanResource>();
        List<MaterialResource> list3 = new LinkedList<MaterialResource>();
        LinkedList<Client> linkedList = new LinkedList();
        LinkedList<CalendarManager> linkedList2 = new LinkedList();
        TaskCollection taskCollection = null;
        ResourceCollection resourceCollection = null;
        ClientCollection clientCollection = null;
        CalendarCollection calendarCollection = null;
        Company company = new Company();
        company.LOADING = true;
        Node node7 = CompanyLoader.getChildNode(node, VERSION);
        if (node7 != null) {
            object7 = XmlUtil.getTextFromNode(node7);
            object6 = new Version((String)object7);
            object5 = new Version(JApplication.getApplicationVersion());
            if (((Version)object5).compareVersionTo(object6) < 0) {
                Object[] objectArray = new Object[]{object7};
                throw new Exception(MessageFormat.format(Common.I18N_MESSAGES.getString("company.versionNotSupported"), objectArray));
            }
        } else {
            throw new Exception(Common.I18N_MESSAGES.getString("company.versionMissing"));
        }
        object7 = CompanyLoader.getChildNode(node, MULTI_PROJECT);
        if (object7 != null) {
            int n = Integer.parseInt(XmlUtil.getTextFromNode((Node)object7));
            company.setMultiProject(n);
        }
        if ((object6 = CompanyLoader.getChildNode(node, "viewer")) != null) {
            ViewerLoader.loadCompanyTaskFieldList((Node)object6);
        }
        if ((object5 = CompanyLoader.getChildNode(node, "task-field-list")) != null) {
            AdditionalFieldLoader.loadCompanyTaskFieldList((Node)object5);
        }
        if ((node6 = CompanyLoader.getChildNode(node, "resource-field-list")) != null) {
            AdditionalFieldLoader.loadCompanyResourceFieldList(node6);
        }
        if ((node5 = CompanyLoader.getChildNode(node, "client-field-list")) != null) {
            AdditionalFieldLoader.loadCompanyClientFieldList(node5);
        }
        if ((node4 = CompanyLoader.getChildNode(node, "calendar-list")) == null) {
            throw new Exception("No calendar list specified");
        }
        linkedList2 = CalendarLoader.loadCalendarList(node4);
        calendarCollection = new CalendarCollection(linkedList2);
        company.setCalendarList(linkedList2);
        Node node8 = CompanyLoader.getChildNode(node, COMPANY_CALENDAR_ID);
        if (node8 != null) {
            calendarManager = calendarCollection.getCalendarForId(Long.parseLong(XmlUtil.getTextFromNode(node8)));
            if (calendarManager == null) {
                throw new Exception("Project calendar ID is not in the list of calendars");
            }
            company.setCalendarManager(calendarManager);
        }
        if ((node3 = CompanyLoader.getChildNode(node, "resource-list")) != null) {
            object4 = node3.getChildNodes();
            for (int i = 0; i < object4.getLength(); ++i) {
                node2 = object4.item(i);
                if (node2.getNodeType() != 1) continue;
                if (node2.getNodeName().compareTo("human-resource-list") == 0) {
                    list2 = ResourceLoader.loadHumanResourceList(company, node2, calendarCollection);
                    continue;
                }
                if (node2.getNodeName().compareTo("material-resource-list") != 0) continue;
                list3 = ResourceLoader.loadMaterialResourceList(company, node2);
            }
            object3 = new LinkedList(list2);
            object3.addAll(list3);
            resourceCollection = new ResourceCollection((List)object3);
            company.setHumanResources(list2);
            company.setMaterialResources(list3);
        }
        if ((object4 = CompanyLoader.getChildNode(node, "client-list")) != null) {
            linkedList = ClientLoader.loadClientList(company, (Node)object4);
            clientCollection = new ClientCollection(linkedList);
            company.setClients(linkedList);
        }
        if ((object3 = CompanyLoader.getChildNode(node, "task")) != null) {
            task = TaskLoader.loadTask(null, company, (Node)object3, calendarCollection, clientCollection);
            taskCollection = new TaskCollection(task);
            company.setRootTask(task);
        }
        if ((node2 = CompanyLoader.getChildNode(node, "task-dependency-list")) != null) {
            object2 = new DependencyLoader(taskCollection);
            list = ((DependencyLoader)object2).loadTaskDependencyList(node2);
            iterator = list.iterator();
            while (iterator.hasNext()) {
                object = (Dependency)iterator.next();
                if (((Dependency)object).getSuccessor() == null) continue;
                try {
                    ((Dependency)object).getSuccessor().setForce(true);
                    ((Dependency)object).getPredecessor();
                    Task.addDependency((Dependency)object, false);
                }
                finally {
                    ((Dependency)object).getSuccessor().setForce(false);
                }
            }
        }
        if ((object2 = CompanyLoader.getChildNode(node, "conflict-list")) != null) {
            iterator = new ConflictLoader(taskCollection);
            object = ((ConflictLoader)((Object)iterator)).loadConflictList((Node)object2);
            company.getConflictManager().setConflicts((List<Conflict>)object);
        }
        if ((iterator = CompanyLoader.getChildNode(node, "assignment-list")) != null) {
            object = new AssignmentLoader(taskCollection, resourceCollection);
            ((AssignmentLoader)object).loadAssignmentList((Node)((Object)iterator));
        }
        if (object3 != null) {
            TaskLoader.loadTaskWorkDuration(task, (Node)object3);
        }
        if (object3 != null) {
            TaskLoader.loadTaskCompletion(task, (Node)object3);
        }
        company.setChanged(false);
        object = System.currentTimeMillis();
        company.LOADING = false;
        return company;
    }

    private static void storeExpandedState() {
        JProjectView jProjectView = Common.getApplication().getWorkspace().getJProject().getAreaView().getViewComponent(JAreaView.GANTT);
        JGanttChart jGanttChart = ((JProjectViewGantt)jProjectView).getGantt();
        for (int i = 0; i < jGanttChart.getTreeTable().getRowCount(); ++i) {
            TreePath treePath = jGanttChart.getTreeTable().getPathForRow(i);
            Task task = (Task)treePath.getLastPathComponent();
            if (task.isEmpty()) continue;
            task.setExpanded(jGanttChart.getTreeTable().isExpanded(i));
        }
    }

    public static void storeCompany(Document document, Company company, boolean bl) {
        Node node = document.getFirstChild();
        Element element = XmlUtil.createTextElement(document, VERSION, JApplication.getApplicationVersion());
        Element element2 = XmlUtil.createTextElement(document, MULTI_PROJECT, company.getMultiProject() + "");
        Element element3 = ViewerLoader.storeViewer(document);
        Element element4 = XmlUtil.createTextElement(document, COMPANY_CALENDAR_ID, company.getCalendarManager().getId().toString());
        Element element5 = AdditionalFieldLoader.storeTaskFieldList(document);
        Element element6 = AdditionalFieldLoader.storeResourceFieldList(document);
        Element element7 = AdditionalFieldLoader.storeClientFieldList(document);
        Element element8 = CalendarLoader.storeCalendarList(document, company.getCalendarList());
        Element element9 = document.createElement("resource-list");
        Element element10 = ResourceLoader.storeHumanResourceList(document, company.getHumanResources(), bl);
        Element element11 = ResourceLoader.storeMaterialResourceList(document, company.getMaterialResources(), bl);
        element9.appendChild(element10);
        element9.appendChild(element11);
        Element element12 = ClientLoader.storeClientList(document, company.getClients());
        if (!Common.isServerBuild()) {
            CompanyLoader.storeExpandedState();
        }
        Element element13 = TaskLoader.storeTask(document, company.getRootTask(), bl);
        TaskCollection taskCollection = new TaskCollection(company.getRootTask());
        DependencyLoader dependencyLoader = new DependencyLoader(taskCollection);
        Element element14 = dependencyLoader.storeTaskDependencyList(document, company.getRootTask());
        ConflictLoader conflictLoader = new ConflictLoader(taskCollection);
        Element element15 = conflictLoader.storeConflictList(document, company);
        ResourceCollection resourceCollection = new ResourceCollection(company.getResources());
        AssignmentLoader assignmentLoader = new AssignmentLoader(taskCollection, resourceCollection);
        Element element16 = assignmentLoader.storeAssignmentList(document, company.getRootTask());
        node.appendChild(element);
        node.appendChild(element2);
        node.appendChild(element3);
        node.appendChild(element4);
        node.appendChild(element5);
        node.appendChild(element6);
        node.appendChild(element7);
        node.appendChild(element8);
        node.appendChild(element9);
        node.appendChild(element12);
        node.appendChild(element13);
        node.appendChild(element14);
        node.appendChild(element15);
        node.appendChild(element16);
    }
}

