/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.dB.xml;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Client;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Contact;
import com.sbs.jpm.dB.ContactCollection;
import com.sbs.jpm.dB.xml.AdditionalFieldLoader;
import com.sbs.xml.XmlUtil;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientLoader {
    private static final String CLIENT = "client";
    private static final String EMPTY_CLIENT = "empty-client";
    private static final String CLIENT_MAIN_CONTACT = "client-main-contact";
    private static final String CLIENT_NAME = "client-name";
    private static final String CLIENT_ADDRESS = "client-address";
    private static final String CLIENT_SITE = "client-site";
    private static final String CLIENT_NOTES = "client-notes";
    private static final String CLIENT_ID = "client-id";
    private static final String CLIENT_UNIQUE_ID = "client-unique-id";
    public static final String CLIENT_LIST = "client-list";
    private static final String CONTACT = "contact";
    private static final String CONTACT_ID = "contact-id";
    private static final String CONTACT_UNIQUE_ID = "contact-unique-id";
    private static final String CONTACT_NAME = "contact-name";
    private static final String CONTACT_PHONE = "contact-phone";
    private static final String CONTACT_EMAIL = "contact-email";
    private static final String CONTACT_NOTES = "contact-notes";
    public static final String CONTACT_LIST = "contact-list";

    private static Node getChildNode(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(string) != 0) continue;
            return node2;
        }
        return null;
    }

    public static List<Client> loadClientList(Company company, Node node) {
        LinkedList<Client> linkedList = new LinkedList<Client>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(CLIENT) != 0 && node2.getNodeName().compareTo(EMPTY_CLIENT) != 0) continue;
            linkedList.add(ClientLoader.loadClient(company, node2));
        }
        return linkedList;
    }

    public static List<Contact> loadContactList(Node node) {
        LinkedList<Contact> linkedList = new LinkedList<Contact>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(CONTACT) != 0) continue;
            linkedList.add(ClientLoader.loadContact(node2));
        }
        return linkedList;
    }

    private static Client loadClient(Company company, Node node) {
        Object object;
        Node node2;
        Object object2;
        Client client = new Client(Long.MIN_VALUE);
        if (node.getNodeName().compareTo(CLIENT) != 0) {
            client.setEmpty(true);
        }
        client.setOwner(company);
        Node node3 = ClientLoader.getChildNode(node, CONTACT_LIST);
        if (node3 != null) {
            object2 = ClientLoader.loadContactList(node3);
            client.setContacts((List<Contact>)object2);
            ContactCollection contactCollection = new ContactCollection((List<Contact>)object2);
            node2 = ClientLoader.getChildNode(node, CLIENT_MAIN_CONTACT);
            if (node2 != null) {
                object = contactCollection.getContactForId(Long.parseLong(XmlUtil.getTextFromNode(node2)));
                client.setMainContact((Contact)object);
            }
        }
        object2 = node.getChildNodes();
        for (int i = 0; i < object2.getLength(); ++i) {
            node2 = object2.item(i);
            if (node2.getNodeType() != 1) continue;
            if (node2.getNodeName().compareTo(CLIENT_UNIQUE_ID) == 0) {
                object = XmlUtil.getTextFromNode(node2);
                client.setUniqueId(Long.parseLong((String)object));
                continue;
            }
            if (node2.getNodeName().compareTo(CLIENT_ID) == 0) {
                object = XmlUtil.getTextFromNode(node2);
                client.setId(Long.parseLong((String)object));
                continue;
            }
            if (node2.getNodeName().compareTo(CLIENT_NAME) == 0) {
                object = XmlUtil.getTextFromNode(node2);
                if (object == null) continue;
                client.setName((String)object);
                continue;
            }
            if (node2.getNodeName().compareTo(CLIENT_ADDRESS) == 0) {
                object = XmlUtil.getTextFromNode(node2);
                if (object == null) continue;
                client.setAddress((String)object);
                continue;
            }
            if (node2.getNodeName().compareTo(CLIENT_SITE) == 0) {
                object = XmlUtil.getTextFromNode(node2);
                if (object == null) continue;
                client.setSite((String)object);
                continue;
            }
            if (node2.getNodeName().compareTo(CLIENT_NOTES) == 0) {
                object = XmlUtil.getTextFromNode(node2);
                if (object == null) continue;
                client.setNotes((String)object);
                continue;
            }
            if (node2.getNodeName().compareTo("field-list") != 0) continue;
            AdditionalFieldLoader.loadClientFieldList(client, node2);
        }
        return client;
    }

    private static Contact loadContact(Node node) {
        Contact contact = new Contact(Long.MIN_VALUE);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            if (node2.getNodeName().compareTo(CONTACT_UNIQUE_ID) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                if (string == null) continue;
                contact.setUniqueId(Long.parseLong(string));
                continue;
            }
            if (node2.getNodeName().compareTo(CONTACT_ID) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                if (string == null) continue;
                contact.setId(Long.parseLong(string));
                continue;
            }
            if (node2.getNodeName().compareTo(CONTACT_NAME) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                if (string == null) continue;
                contact.setName(string);
                continue;
            }
            if (node2.getNodeName().compareTo(CONTACT_PHONE) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                if (string == null) continue;
                contact.setPhone(string);
                continue;
            }
            if (node2.getNodeName().compareTo(CONTACT_EMAIL) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                if (string == null) continue;
                contact.setEmail(string);
                continue;
            }
            if (node2.getNodeName().compareTo(CONTACT_NOTES) != 0 || (string = XmlUtil.getTextFromNode(node2)) == null) continue;
            contact.setNotes(string);
        }
        return contact;
    }

    public static Element storeClientList(Document document, List<Client> list) {
        Element element = document.createElement(CLIENT_LIST);
        for (Client client : list) {
            element.appendChild(ClientLoader.storeClient(document, client));
        }
        return element;
    }

    public static Element storeContactList(Document document, List<Contact> list) {
        Element element = document.createElement(CONTACT_LIST);
        for (Contact contact : list) {
            element.appendChild(ClientLoader.storeContact(document, contact));
        }
        return element;
    }

    private static Element storeClient(Document document, Client client) {
        Element element;
        if (client.isEmpty()) {
            element = document.createElement(EMPTY_CLIENT);
            if (Common.SAVE_IDs) {
                Element element2 = XmlUtil.createTextElement(document, CLIENT_UNIQUE_ID, client.getUniqueId() + "");
                element.appendChild(element2);
            }
        } else {
            element = document.createElement(CLIENT);
            Element element3 = XmlUtil.createTextElement(document, CLIENT_NAME, client.getName());
            Element element4 = XmlUtil.createTextElement(document, CLIENT_ADDRESS, client.getAddress());
            Element element5 = XmlUtil.createTextElement(document, CLIENT_SITE, client.getSite());
            Element element6 = XmlUtil.createTextElement(document, CLIENT_NOTES, client.getNotes());
            Element element7 = XmlUtil.createTextElement(document, CLIENT_ID, client.getId().toString());
            Element element8 = XmlUtil.createTextElement(document, CLIENT_UNIQUE_ID, client.getUniqueId() + "");
            Element element9 = AdditionalFieldLoader.storeFieldList(document, client);
            Element element10 = ClientLoader.storeContactList(document, client.getContacts());
            if (Common.SAVE_IDs) {
                element.appendChild(element8);
            }
            element.appendChild(element7);
            element.appendChild(element3);
            element.appendChild(element4);
            element.appendChild(element5);
            element.appendChild(element6);
            element.appendChild(element9);
            if (client.getMainContact() != null) {
                Element element11 = XmlUtil.createTextElement(document, CLIENT_MAIN_CONTACT, client.getMainContact().getId() + "");
                element.appendChild(element11);
            }
            element.appendChild(element10);
        }
        return element;
    }

    private static Element storeContact(Document document, Contact contact) {
        Element element = document.createElement(CONTACT);
        Element element2 = XmlUtil.createTextElement(document, CONTACT_UNIQUE_ID, contact.getUniqueId() + "");
        Element element3 = XmlUtil.createTextElement(document, CONTACT_ID, contact.getId() + "");
        Element element4 = XmlUtil.createTextElement(document, CONTACT_NAME, contact.getName());
        Element element5 = XmlUtil.createTextElement(document, CONTACT_PHONE, contact.getPhone());
        Element element6 = XmlUtil.createTextElement(document, CONTACT_EMAIL, contact.getEmail());
        Element element7 = XmlUtil.createTextElement(document, CONTACT_NOTES, contact.getNotes());
        if (Common.SAVE_IDs) {
            element.appendChild(element2);
        }
        element.appendChild(element3);
        element.appendChild(element4);
        element.appendChild(element5);
        element.appendChild(element6);
        element.appendChild(element7);
        return element;
    }
}

