/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.dB.xml;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.baseline.Baseline;
import com.sbs.jpm.core.baseline.ProjectBaseline;
import com.sbs.xml.XmlUtil;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BaselineLoader {
    public static final String PROJECT_BASELINE_LIST = "project-baseline-list";
    public static final String BASELINE_LIST = "baseline-list";
    private static final String BASELINE = "baseline";
    private static final String BASELINE_NO = "baseline-no";
    private static final String BASELINE_START = "baseline-start";
    private static final String BASELINE_END = "baseline-end";
    private static final String BASELINE_COMPLETION_DATE = "baseline-completion-date";
    private static final String BASELINE_COMPLETION = "baseline-completion";
    private static final String PROJECT_BASELINE = "project-baseline";
    private static final String DESCRIPTION = "description";
    private static final String DATE = "date";
    private static final String NO = "no";
    private static final DateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy, HH:mm:ss");

    public static void loadProjectBaselineList(Task task, Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(PROJECT_BASELINE) != 0) continue;
            BaselineLoader.loadProjectBaseline(task, node2);
        }
    }

    public static void loadBaselineList(Task task, Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(BASELINE) != 0) continue;
            BaselineLoader.loadBaseline(task, node2);
        }
    }

    private static Node getChildNode(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(string) != 0) continue;
            return node2;
        }
        return null;
    }

    private static void loadProjectBaseline(Task task, Node node) {
        Node node2 = BaselineLoader.getChildNode(node, NO);
        if (node2 != null) {
            Object object;
            Object object2;
            int n = Integer.parseInt(XmlUtil.getTextFromNode(node2));
            ProjectBaseline projectBaseline = new ProjectBaseline();
            Node node3 = BaselineLoader.getChildNode(node, DATE);
            if (node3 != null) {
                object2 = XmlUtil.getTextFromNode(node3);
                object = null;
                try {
                    object = dateFormat.parse((String)object2);
                }
                catch (ParseException parseException) {
                    Common.logException("Error:", parseException);
                }
                projectBaseline.setDate((Date)object);
            }
            if ((object2 = BaselineLoader.getChildNode(node, DESCRIPTION)) != null && (object = XmlUtil.getTextFromNode((Node)object2)) != null) {
                projectBaseline.setDescription((String)object);
            }
            task.setProjectBaselineAt(n, projectBaseline);
        }
    }

    private static void loadBaseline(Task task, Node node) {
        Node node2 = BaselineLoader.getChildNode(node, BASELINE_NO);
        if (node2 != null) {
            Baseline baseline = new Baseline();
            int n = Integer.parseInt(XmlUtil.getTextFromNode(node2));
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Date date;
                String string;
                Node node3 = nodeList.item(i);
                if (node3.getNodeType() != 1) continue;
                if (node3.getNodeName().compareTo(BASELINE_START) == 0) {
                    string = XmlUtil.getTextFromNode(node3);
                    date = null;
                    try {
                        date = dateFormat.parse(string);
                    }
                    catch (ParseException parseException) {
                        Common.logException("Error:", parseException);
                    }
                    baseline.setStartDate(date);
                    continue;
                }
                if (node3.getNodeName().compareTo(BASELINE_END) == 0) {
                    string = XmlUtil.getTextFromNode(node3);
                    date = null;
                    try {
                        date = dateFormat.parse(string);
                    }
                    catch (ParseException parseException) {
                        Common.logException("Error:", parseException);
                    }
                    baseline.setEndDate(date);
                    continue;
                }
                if (node3.getNodeName().compareTo(BASELINE_COMPLETION_DATE) == 0) {
                    string = XmlUtil.getTextFromNode(node3);
                    date = null;
                    try {
                        date = dateFormat.parse(string);
                    }
                    catch (ParseException parseException) {
                        Common.logException("Error:", parseException);
                    }
                    baseline.setCompletionDate(date);
                    continue;
                }
                if (node3.getNodeName().compareTo(BASELINE_COMPLETION) != 0) continue;
                string = XmlUtil.getTextFromNode(node3);
                baseline.setCompletion(Double.parseDouble(string));
            }
            task.setBaselineAt(n, baseline);
        }
    }

    public static Element storeProjectBaselineList(Document document, Task task) {
        Element element = document.createElement(PROJECT_BASELINE_LIST);
        for (int i = 0; i < 10; ++i) {
            ProjectBaseline projectBaseline = task.getProjectBaselineAt(i);
            if (projectBaseline == null) continue;
            element.appendChild(BaselineLoader.storeProjectBaseline(document, projectBaseline, i));
        }
        return element;
    }

    public static Element storeBaselineList(Document document, Task task) {
        Element element = document.createElement(BASELINE_LIST);
        for (int i = 0; i < 10; ++i) {
            Baseline baseline = task.getBaselineAt(i);
            if (baseline == null) continue;
            element.appendChild(BaselineLoader.storeBaseline(document, baseline, i));
        }
        return element;
    }

    private static Element storeProjectBaseline(Document document, ProjectBaseline projectBaseline, int n) {
        Element element = document.createElement(PROJECT_BASELINE);
        element.appendChild(XmlUtil.createTextElement(document, NO, "" + n));
        if (projectBaseline.getDate() != null) {
            element.appendChild(XmlUtil.createTextElement(document, DATE, dateFormat.format(projectBaseline.getDate())));
        }
        if (projectBaseline.getDescription() != null) {
            element.appendChild(XmlUtil.createTextElement(document, DESCRIPTION, projectBaseline.getDescription()));
        }
        return element;
    }

    private static Element storeBaseline(Document document, Baseline baseline, int n) {
        Element element = document.createElement(BASELINE);
        Element element2 = XmlUtil.createTextElement(document, BASELINE_NO, "" + n);
        Element element3 = XmlUtil.createTextElement(document, BASELINE_START, dateFormat.format(baseline.getStartDate()));
        Element element4 = XmlUtil.createTextElement(document, BASELINE_END, dateFormat.format(baseline.getEndDate()));
        Element element5 = XmlUtil.createTextElement(document, BASELINE_COMPLETION_DATE, dateFormat.format(baseline.getCompletionDate()));
        Element element6 = XmlUtil.createTextElement(document, BASELINE_COMPLETION, "" + baseline.getCompletion());
        element.appendChild(element2);
        element.appendChild(element3);
        element.appendChild(element4);
        element.appendChild(element5);
        element.appendChild(element6);
        return element;
    }
}

