/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.dB.xml;

import com.sbs.jpm.Common;
import com.sbs.jpm.ui.JProject;
import com.sbs.jpm.ui.UIManager;
import com.sbs.jpm.ui.component.JAreaView;
import com.sbs.jpm.ui.component.JClientsTable;
import com.sbs.jpm.ui.component.JHumanResourcesTable;
import com.sbs.jpm.ui.component.JMaterialResourcesTable;
import com.sbs.jpm.ui.component.JProjectRisksTable;
import com.sbs.jpm.ui.component.view.JProjectViewClients;
import com.sbs.jpm.ui.component.view.JProjectViewEPS;
import com.sbs.jpm.ui.component.view.JProjectViewGantt;
import com.sbs.jpm.ui.component.view.JProjectViewResourceSheet;
import com.sbs.jpm.ui.component.view.JProjectViewResources;
import com.sbs.jpm.ui.component.view.JProjectViewRisks;
import com.sbs.jpm.ui.component.view.JProjectViewTaskSheet;
import com.sbs.jpm.ui.component.view.JProjectViewWBS;
import com.sbs.jpm.ui.core.Data;
import com.sbs.jpm.ui.core.ProjectData;
import com.sbs.jpm.ui.treetablechart.JEPSTable;
import com.sbs.jpm.ui.treetablechart.JTreeTable;
import com.sbs.jpm.ui.treetablechart.JWBSTreeTable;
import com.sbs.jpm.ui.treetablechart.chart.ChartUIConfiguration;
import com.sbs.jpm.ui.treetablechart.time.TimeScaleManager;
import com.sbs.xml.XmlUtil;
import java.awt.Color;
import javax.swing.JSplitPane;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ApplicationLoader {
    private static final String CLIENTS = "Clients";
    private static final String PROJECT = "Project";
    private static final String PROJECT_INFO = "Info";
    private static final String PROJECT_NOTES = "Notes & Links";
    private static final String CALENDAR = "Calendar";
    private static final String PROJECT_ASSUMPTIONS = "Assumptions & Constraints";
    private static final String PROJECT_RISKS = "Risks";
    private static final String PLANNING = "Planning";
    private static final String PROJECT_WBS = "Create WBS";
    private static final String GANTT = "Schedule tasks";
    private static final String DEFINE_RESOURCES = "Define resources";
    private static final String HUMAN_RESOURCES = "Human & Equipment";
    private static final String MATERIAL_RESOURCES = "Materials";
    private static final String ASSIGN_RESOURCES = "Assign resources";
    private static final String LEVEL_RESOURCES = "Level resources";
    private static final String TASK_SHEET = "Define additional costs for tasks";
    private static final String CONTROLLING = "Controlling";
    private static final String PROJECT_UPDATE = "Update tasks completion";
    private static final String RESOURCE_SHEET = "Work & Cost tracking";
    private static final String PROJECT_PORTFOLIO = "Project portfolio";
    private static final String LEFT = "left";
    private static final String CENTER = "center";
    private static final String RIGHT = "right";
    public static final String SETTINGS = "settings";
    private static final String CURRENT_VIEW = "current-view";
    private static final String VIEW = "view";
    private static final String VIEW_NAME = "view-name";
    private static final String COLUMN = "column";
    private static final String COLUMN_NAME = "column-name";
    private static final String COLUMN_VISIBLE = "column-visible";
    private static final String COLUMN_ORDER = "column-order";
    private static final String COLUMN_WIDTH = "column-width";
    private static final String VERTICAL_SPLIT = "vertical-split";
    private static final String HORIZONTAL_SPLIT = "horizontal-split";
    private static final String LEVELING_SPLIT = "leveling-split";
    private static final String SPLIT_ORIENTATION = "split-orientation";
    private static final String SPLIT_POSITION = "split-position";
    private static final String APPLICATION = "application";
    private static final String APPLICATION_MAXIMIZED = "application-maximized";
    private static final String APPLICATION_SIZE = "application-size";
    private static final String APPLICATION_POSITION = "application-position";
    private static final String GUIDE = "guide";
    private static final String GUIDE_VISIBLE = "guide-visible";
    private static final String GUIDE_SIZE = "guide-size";
    private static final String GUIDE_DETAILS = "guide-details";
    private static final String GUIDE_DETAILS_VISIBLE = "guide-details-visible";
    private static final String GUIDE_DETAILS_SIZE = "guide-details-size";
    private static final String COLOR_BARS = "bar-colors";
    private static final String COLOR_TASK = "task-color";
    private static final String COLOR_PHASE = "phase-color";
    private static final String COLOR_PROJECT = "project-color";
    private static final String COLOR_MILESTONE = "milestone-color";
    private static final String COLOR_TASK_CRITICAL = "task-critical-color";
    private static final String COLOR_BASELINE = "baseline-color";
    private static final String COLOR_TASK_COMPLETION = "completion-color";
    private static final String TOOLBARS = "toolbars";
    private static final String MAIN_TOOLBAR = "main-toolbar";
    private static final String PROJECT_TOOLBAR = "project-toolbar";
    private static final String MAIL_TOOLBAR = "mail-toolbar";
    private static final String VIEW_TOOLBAR = "view-toolbar";
    private static final String BUTTON_TOOLBAR = "button-toolbar";
    private static final String SCALE_CURSOR = "scale-cursor";

    public static Element storeSettings(Document document) {
        Element element = document.createElement(SETTINGS);
        Element element2 = document.createElement(APPLICATION);
        Element element3 = document.createElement(GUIDE);
        Element element4 = document.createElement(GUIDE_DETAILS);
        Element element5 = XmlUtil.createTextElement(document, CURRENT_VIEW, Common.getApplication().getWorkspace().getJProject().getAreaView().getCurrentViewName());
        element.appendChild(element2);
        element.appendChild(element3);
        element.appendChild(element4);
        element.appendChild(element5);
        element.appendChild(ApplicationLoader.storeToolBar(document));
        element.appendChild(ApplicationLoader.storeEPS(document));
        element.appendChild(ApplicationLoader.storeRisks(document));
        element.appendChild(ApplicationLoader.storeCreateWBS(document));
        element.appendChild(ApplicationLoader.storeScheduleTasks(document));
        element.appendChild(ApplicationLoader.storeHumanEquipment(document));
        element.appendChild(ApplicationLoader.storeMaterial(document));
        element.appendChild(ApplicationLoader.storeClients(document));
        element.appendChild(ApplicationLoader.storeAssignResources(document));
        element.appendChild(ApplicationLoader.storeLevelResources(document));
        element.appendChild(ApplicationLoader.storeAdditionalCosts(document));
        element.appendChild(ApplicationLoader.storeUpdateTasks(document));
        element.appendChild(ApplicationLoader.storeResourceSheet(document));
        return element;
    }

    private static Element storeToolBar(Document document) {
        UIManager uIManager = UIManager.getInstance();
        Element element = document.createElement(TOOLBARS);
        element.appendChild(XmlUtil.createTextElement(document, MAIN_TOOLBAR, "" + uIManager.isShowMainToolBar()));
        element.appendChild(XmlUtil.createTextElement(document, PROJECT_TOOLBAR, "" + uIManager.isShowProjectToolBar()));
        element.appendChild(XmlUtil.createTextElement(document, MAIL_TOOLBAR, "" + uIManager.isShowMailToolBar()));
        element.appendChild(XmlUtil.createTextElement(document, VIEW_TOOLBAR, "" + uIManager.isShowViewToolBar()));
        element.appendChild(XmlUtil.createTextElement(document, BUTTON_TOOLBAR, "" + uIManager.isShowButtonToolBar()));
        return element;
    }

    private static void storeTreeTable(Document document, JTreeTable jTreeTable, TableModel tableModel, Element element) {
        for (int i = tableModel.getColumnCount() - 1; i >= 0; --i) {
            int n = jTreeTable.convertColumnIndexToView(i);
            Element element2 = document.createElement(COLUMN);
            if (n == -1) {
                element2.appendChild(XmlUtil.createTextElement(document, COLUMN_NAME, jTreeTable.getModel().getColumnName(i)));
                element2.appendChild(XmlUtil.createTextElement(document, COLUMN_VISIBLE, "false"));
            } else {
                Object object = jTreeTable.getColumn(n).getIdentifier();
                element2.appendChild(XmlUtil.createTextElement(document, COLUMN_NAME, object.toString()));
                element2.appendChild(XmlUtil.createTextElement(document, COLUMN_VISIBLE, "true"));
                element2.appendChild(XmlUtil.createTextElement(document, COLUMN_ORDER, "" + n));
                element2.appendChild(XmlUtil.createTextElement(document, COLUMN_WIDTH, "" + jTreeTable.getColumn(n).getWidth()));
            }
            element.appendChild(element2);
        }
    }

    private static void storeSplitPane(Document document, JSplitPane jSplitPane, Element element) {
        if (!jSplitPane.getLeftComponent().isVisible()) {
            element.appendChild(XmlUtil.createTextElement(document, SPLIT_ORIENTATION, RIGHT));
        } else if (!jSplitPane.getRightComponent().isVisible()) {
            element.appendChild(XmlUtil.createTextElement(document, SPLIT_ORIENTATION, LEFT));
        } else {
            element.appendChild(XmlUtil.createTextElement(document, SPLIT_ORIENTATION, CENTER));
            element.appendChild(XmlUtil.createTextElement(document, SPLIT_POSITION, "" + jSplitPane.getDividerLocation()));
        }
    }

    private static void storeBarColors(Document document, ChartUIConfiguration chartUIConfiguration, Element element) {
        element.appendChild(XmlUtil.createTextElement(document, COLOR_TASK, "" + chartUIConfiguration.getTaskColor().getRGB()));
        element.appendChild(XmlUtil.createTextElement(document, COLOR_PHASE, "" + chartUIConfiguration.getPhaseTaskColor().getRGB()));
        element.appendChild(XmlUtil.createTextElement(document, COLOR_MILESTONE, "" + chartUIConfiguration.getMilestoneColor().getRGB()));
        element.appendChild(XmlUtil.createTextElement(document, COLOR_PROJECT, "" + chartUIConfiguration.getProjectTaskColor().getRGB()));
        element.appendChild(XmlUtil.createTextElement(document, COLOR_BASELINE, "" + chartUIConfiguration.getBaselineColor().getRGB()));
        element.appendChild(XmlUtil.createTextElement(document, COLOR_TASK_CRITICAL, "" + chartUIConfiguration.getTaskCriticalColor().getRGB()));
        element.appendChild(XmlUtil.createTextElement(document, COLOR_TASK_COMPLETION, "" + chartUIConfiguration.getTaskCompletionColor().getRGB()));
    }

    private static void storeTable(Document document, JXTable jXTable, TableModel tableModel, Element element) {
        for (int i = tableModel.getColumnCount() - 1; i >= 0; --i) {
            int n = jXTable.convertColumnIndexToView(i);
            Element element2 = document.createElement(COLUMN);
            if (n == -1) {
                element2.appendChild(XmlUtil.createTextElement(document, COLUMN_NAME, jXTable.getModel().getColumnName(i)));
                element2.appendChild(XmlUtil.createTextElement(document, COLUMN_VISIBLE, "false"));
            } else {
                Object object = jXTable.getColumn(n).getIdentifier();
                element2.appendChild(XmlUtil.createTextElement(document, COLUMN_NAME, object.toString()));
                element2.appendChild(XmlUtil.createTextElement(document, COLUMN_VISIBLE, "true"));
                element2.appendChild(XmlUtil.createTextElement(document, COLUMN_ORDER, "" + n));
                element2.appendChild(XmlUtil.createTextElement(document, COLUMN_WIDTH, "" + jXTable.getColumn(n).getWidth()));
            }
            element.appendChild(element2);
        }
    }

    private static Element storeScaleCursor(Document document, TimeScaleManager timeScaleManager) {
        return XmlUtil.createTextElement(document, SCALE_CURSOR, timeScaleManager.getCurrentScaleCursor() + "");
    }

    private static Element storeEPS(Document document) {
        JProjectViewEPS jProjectViewEPS = Common.getApplication().getWorkspace().getJProject().getEpsView();
        Element element = document.createElement(VIEW);
        element.appendChild(XmlUtil.createTextElement(document, VIEW_NAME, PROJECT_PORTFOLIO));
        JEPSTable jEPSTable = jProjectViewEPS.getEps();
        ApplicationLoader.storeTable(document, jEPSTable, jEPSTable.getModel(), element);
        Element element2 = document.createElement(VERTICAL_SPLIT);
        JSplitPane jSplitPane = jProjectViewEPS.getSplitPane();
        ApplicationLoader.storeSplitPane(document, jSplitPane, element2);
        element.appendChild(element2);
        return element;
    }

    private static Element storeCreateWBS(Document document) {
        JAreaView jAreaView = Common.getApplication().getWorkspace().getJProject().getAreaView();
        JProjectViewWBS jProjectViewWBS = (JProjectViewWBS)jAreaView.getViewComponent(JAreaView.PROJECT_WBS);
        Element element = document.createElement(VIEW);
        element.appendChild(XmlUtil.createTextElement(document, VIEW_NAME, PROJECT_WBS));
        JWBSTreeTable jWBSTreeTable = jProjectViewWBS.getWbs();
        ApplicationLoader.storeTreeTable(document, jWBSTreeTable, jWBSTreeTable.getModel(), element);
        Element element2 = document.createElement(VERTICAL_SPLIT);
        JSplitPane jSplitPane = jProjectViewWBS.getSplitPane();
        ApplicationLoader.storeSplitPane(document, jSplitPane, element2);
        element.appendChild(element2);
        return element;
    }

    private static Element storeRisks(Document document) {
        JAreaView jAreaView = Common.getApplication().getWorkspace().getJProject().getAreaView();
        JProjectViewRisks jProjectViewRisks = (JProjectViewRisks)jAreaView.getViewComponent(JAreaView.PROJECT_RISKS);
        Element element = document.createElement(VIEW);
        element.appendChild(XmlUtil.createTextElement(document, VIEW_NAME, PROJECT_RISKS));
        JProjectRisksTable jProjectRisksTable = jProjectViewRisks.getProjectRisksTable();
        ApplicationLoader.storeTable(document, jProjectRisksTable, jProjectRisksTable.getModel(), element);
        Element element2 = document.createElement(VERTICAL_SPLIT);
        JSplitPane jSplitPane = jProjectViewRisks.getSplitPane();
        ApplicationLoader.storeSplitPane(document, jSplitPane, element2);
        element.appendChild(element2);
        return element;
    }

    private static Element storeScheduleTasks(Document document) {
        JAreaView jAreaView = Common.getApplication().getWorkspace().getJProject().getAreaView();
        JProjectViewGantt jProjectViewGantt = (JProjectViewGantt)jAreaView.getViewComponent(JAreaView.GANTT);
        Element element = document.createElement(VIEW);
        element.appendChild(XmlUtil.createTextElement(document, VIEW_NAME, GANTT));
        JTreeTable jTreeTable = jProjectViewGantt.getGantt().getTreeTable();
        ApplicationLoader.storeTreeTable(document, jTreeTable, jTreeTable.getModel(), element);
        element.appendChild(ApplicationLoader.storeScaleCursor(document, jProjectViewGantt.getGantt().getArea().getTimeScaleManager()));
        Element element2 = document.createElement(COLOR_BARS);
        ChartUIConfiguration chartUIConfiguration = jProjectViewGantt.getGantt().getArea().getChartUIConfiguration();
        ApplicationLoader.storeBarColors(document, chartUIConfiguration, element2);
        element.appendChild(element2);
        Element element3 = document.createElement(VERTICAL_SPLIT);
        JSplitPane jSplitPane = jProjectViewGantt.getSplitPane();
        ApplicationLoader.storeSplitPane(document, jSplitPane, element3);
        element.appendChild(element3);
        Element element4 = document.createElement(LEVELING_SPLIT);
        JSplitPane jSplitPane2 = jProjectViewGantt.getLevelingSplitPane();
        ApplicationLoader.storeSplitPane(document, jSplitPane2, element4);
        element.appendChild(element4);
        Element element5 = document.createElement(HORIZONTAL_SPLIT);
        JSplitPane jSplitPane3 = jProjectViewGantt.getGantt().getSplitPane();
        ApplicationLoader.storeSplitPane(document, jSplitPane3, element5);
        element.appendChild(element5);
        return element;
    }

    private static Element storeHumanEquipment(Document document) {
        JAreaView jAreaView = Common.getApplication().getWorkspace().getJProject().getAreaView();
        JProjectViewResources jProjectViewResources = (JProjectViewResources)jAreaView.getViewComponent(JAreaView.DEFINE_RESOURCES);
        Element element = document.createElement(VIEW);
        element.appendChild(XmlUtil.createTextElement(document, VIEW_NAME, HUMAN_RESOURCES));
        JHumanResourcesTable jHumanResourcesTable = jProjectViewResources.getHumanResourceView().getResourceTable();
        ApplicationLoader.storeTable(document, jHumanResourcesTable, jHumanResourcesTable.getModel(), element);
        Element element2 = document.createElement(VERTICAL_SPLIT);
        JSplitPane jSplitPane = jProjectViewResources.getHumanResourceView().getSplitPane();
        ApplicationLoader.storeSplitPane(document, jSplitPane, element2);
        element.appendChild(element2);
        return element;
    }

    private static Element storeMaterial(Document document) {
        JAreaView jAreaView = Common.getApplication().getWorkspace().getJProject().getAreaView();
        JProjectViewResources jProjectViewResources = (JProjectViewResources)jAreaView.getViewComponent(JAreaView.DEFINE_RESOURCES);
        Element element = document.createElement(VIEW);
        element.appendChild(XmlUtil.createTextElement(document, VIEW_NAME, MATERIAL_RESOURCES));
        JMaterialResourcesTable jMaterialResourcesTable = jProjectViewResources.getMaterialResourceView().getResourceTable();
        ApplicationLoader.storeTable(document, jMaterialResourcesTable, jMaterialResourcesTable.getModel(), element);
        Element element2 = document.createElement(VERTICAL_SPLIT);
        JSplitPane jSplitPane = jProjectViewResources.getMaterialResourceView().getSplitPane();
        ApplicationLoader.storeSplitPane(document, jSplitPane, element2);
        element.appendChild(element2);
        return element;
    }

    private static Element storeClients(Document document) {
        JAreaView jAreaView = Common.getApplication().getWorkspace().getJProject().getAreaView();
        JProjectViewClients jProjectViewClients = (JProjectViewClients)jAreaView.getViewComponent(JAreaView.CLIENTS);
        Element element = document.createElement(VIEW);
        element.appendChild(XmlUtil.createTextElement(document, VIEW_NAME, CLIENTS));
        JClientsTable jClientsTable = jProjectViewClients.getClientTable();
        ApplicationLoader.storeTable(document, jClientsTable, jClientsTable.getModel(), element);
        Element element2 = document.createElement(VERTICAL_SPLIT);
        JSplitPane jSplitPane = jProjectViewClients.getSplitPane();
        ApplicationLoader.storeSplitPane(document, jSplitPane, element2);
        element.appendChild(element2);
        return element;
    }

    private static Element storeAssignResources(Document document) {
        JAreaView jAreaView = Common.getApplication().getWorkspace().getJProject().getAreaView();
        JProjectViewGantt jProjectViewGantt = (JProjectViewGantt)jAreaView.getViewComponent(JAreaView.ASSIGN_RESOURCES);
        Element element = document.createElement(VIEW);
        element.appendChild(XmlUtil.createTextElement(document, VIEW_NAME, ASSIGN_RESOURCES));
        JTreeTable jTreeTable = jProjectViewGantt.getGantt().getTreeTable();
        ApplicationLoader.storeTreeTable(document, jTreeTable, jTreeTable.getModel(), element);
        element.appendChild(ApplicationLoader.storeScaleCursor(document, jProjectViewGantt.getGantt().getArea().getTimeScaleManager()));
        Element element2 = document.createElement(VERTICAL_SPLIT);
        JSplitPane jSplitPane = jProjectViewGantt.getSplitPane();
        ApplicationLoader.storeSplitPane(document, jSplitPane, element2);
        element.appendChild(element2);
        Element element3 = document.createElement(LEVELING_SPLIT);
        JSplitPane jSplitPane2 = jProjectViewGantt.getLevelingSplitPane();
        ApplicationLoader.storeSplitPane(document, jSplitPane2, element3);
        element.appendChild(element3);
        Element element4 = document.createElement(HORIZONTAL_SPLIT);
        JSplitPane jSplitPane3 = jProjectViewGantt.getGantt().getSplitPane();
        ApplicationLoader.storeSplitPane(document, jSplitPane3, element4);
        element.appendChild(element4);
        return element;
    }

    private static Element storeLevelResources(Document document) {
        JAreaView jAreaView = Common.getApplication().getWorkspace().getJProject().getAreaView();
        JProjectViewGantt jProjectViewGantt = (JProjectViewGantt)jAreaView.getViewComponent(JAreaView.LEVEL_RESOURCES);
        Element element = document.createElement(VIEW);
        element.appendChild(XmlUtil.createTextElement(document, VIEW_NAME, LEVEL_RESOURCES));
        JTreeTable jTreeTable = jProjectViewGantt.getGantt().getTreeTable();
        ApplicationLoader.storeTreeTable(document, jTreeTable, jTreeTable.getModel(), element);
        element.appendChild(ApplicationLoader.storeScaleCursor(document, jProjectViewGantt.getGantt().getArea().getTimeScaleManager()));
        Element element2 = document.createElement(COLOR_BARS);
        ChartUIConfiguration chartUIConfiguration = jProjectViewGantt.getGantt().getArea().getChartUIConfiguration();
        ApplicationLoader.storeBarColors(document, chartUIConfiguration, element2);
        element.appendChild(element2);
        Element element3 = document.createElement(VERTICAL_SPLIT);
        JSplitPane jSplitPane = jProjectViewGantt.getSplitPane();
        ApplicationLoader.storeSplitPane(document, jSplitPane, element3);
        element.appendChild(element3);
        Element element4 = document.createElement(LEVELING_SPLIT);
        JSplitPane jSplitPane2 = jProjectViewGantt.getLevelingSplitPane();
        ApplicationLoader.storeSplitPane(document, jSplitPane2, element4);
        element.appendChild(element4);
        Element element5 = document.createElement(HORIZONTAL_SPLIT);
        JSplitPane jSplitPane3 = jProjectViewGantt.getGantt().getSplitPane();
        ApplicationLoader.storeSplitPane(document, jSplitPane3, element5);
        element.appendChild(element5);
        return element;
    }

    private static Element storeResourceSheet(Document document) {
        JAreaView jAreaView = Common.getApplication().getWorkspace().getJProject().getAreaView();
        JProjectViewResourceSheet jProjectViewResourceSheet = (JProjectViewResourceSheet)jAreaView.getViewComponent(JAreaView.RESOURCE_SHEET);
        Element element = document.createElement(VIEW);
        element.appendChild(XmlUtil.createTextElement(document, VIEW_NAME, RESOURCE_SHEET));
        JTreeTable jTreeTable = jProjectViewResourceSheet.getResourceSheet().getTreeTable();
        ApplicationLoader.storeTreeTable(document, jTreeTable, jTreeTable.getModel(), element);
        element.appendChild(ApplicationLoader.storeScaleCursor(document, jProjectViewResourceSheet.getResourceSheet().getArea().getTimeScaleManager()));
        Element element2 = document.createElement(VERTICAL_SPLIT);
        JSplitPane jSplitPane = jProjectViewResourceSheet.getSplitPane();
        ApplicationLoader.storeSplitPane(document, jSplitPane, element2);
        element.appendChild(element2);
        Element element3 = document.createElement(HORIZONTAL_SPLIT);
        JSplitPane jSplitPane2 = jProjectViewResourceSheet.getResourceSheet().getSplitPane();
        ApplicationLoader.storeSplitPane(document, jSplitPane2, element3);
        element.appendChild(element3);
        return element;
    }

    private static Element storeAdditionalCosts(Document document) {
        JAreaView jAreaView = Common.getApplication().getWorkspace().getJProject().getAreaView();
        JProjectViewTaskSheet jProjectViewTaskSheet = (JProjectViewTaskSheet)jAreaView.getViewComponent(JAreaView.TASK_SHEET);
        Element element = document.createElement(VIEW);
        element.appendChild(XmlUtil.createTextElement(document, VIEW_NAME, TASK_SHEET));
        JTreeTable jTreeTable = jProjectViewTaskSheet.getTaskSheet().getTreeTable();
        ApplicationLoader.storeTreeTable(document, jTreeTable, jTreeTable.getModel(), element);
        element.appendChild(ApplicationLoader.storeScaleCursor(document, jProjectViewTaskSheet.getTaskSheet().getArea().getTimeScaleManager()));
        Element element2 = document.createElement(VERTICAL_SPLIT);
        JSplitPane jSplitPane = jProjectViewTaskSheet.getSplitPane();
        ApplicationLoader.storeSplitPane(document, jSplitPane, element2);
        element.appendChild(element2);
        Element element3 = document.createElement(HORIZONTAL_SPLIT);
        JSplitPane jSplitPane2 = jProjectViewTaskSheet.getTaskSheet().getSplitPane();
        ApplicationLoader.storeSplitPane(document, jSplitPane2, element3);
        element.appendChild(element3);
        return element;
    }

    private static Element storeUpdateTasks(Document document) {
        JAreaView jAreaView = Common.getApplication().getWorkspace().getJProject().getAreaView();
        JProjectViewGantt jProjectViewGantt = (JProjectViewGantt)jAreaView.getViewComponent(JAreaView.PROJECT_UPDATE);
        Element element = document.createElement(VIEW);
        element.appendChild(XmlUtil.createTextElement(document, VIEW_NAME, PROJECT_UPDATE));
        JTreeTable jTreeTable = jProjectViewGantt.getGantt().getTreeTable();
        ApplicationLoader.storeTreeTable(document, jTreeTable, jTreeTable.getModel(), element);
        element.appendChild(ApplicationLoader.storeScaleCursor(document, jProjectViewGantt.getGantt().getArea().getTimeScaleManager()));
        Element element2 = document.createElement(VERTICAL_SPLIT);
        JSplitPane jSplitPane = jProjectViewGantt.getSplitPane();
        ApplicationLoader.storeSplitPane(document, jSplitPane, element2);
        element.appendChild(element2);
        Element element3 = document.createElement(LEVELING_SPLIT);
        JSplitPane jSplitPane2 = jProjectViewGantt.getLevelingSplitPane();
        ApplicationLoader.storeSplitPane(document, jSplitPane2, element3);
        element.appendChild(element3);
        Element element4 = document.createElement(HORIZONTAL_SPLIT);
        JSplitPane jSplitPane3 = jProjectViewGantt.getGantt().getSplitPane();
        ApplicationLoader.storeSplitPane(document, jSplitPane3, element4);
        element.appendChild(element4);
        return element;
    }

    private static void loadBarColors(ChartUIConfiguration chartUIConfiguration, Node node) {
        Node node2 = ApplicationLoader.getChildNode(node, COLOR_TASK);
        int n = Integer.valueOf(XmlUtil.getTextFromNode(node2));
        chartUIConfiguration.setTaskColor(new Color(n));
        node2 = ApplicationLoader.getChildNode(node, COLOR_MILESTONE);
        n = Integer.valueOf(XmlUtil.getTextFromNode(node2));
        chartUIConfiguration.setMilestoneColor(new Color(n));
        node2 = ApplicationLoader.getChildNode(node, COLOR_BASELINE);
        if (node2 != null) {
            n = Integer.valueOf(XmlUtil.getTextFromNode(node2));
            chartUIConfiguration.setBaselineColor(new Color(n));
        }
        node2 = ApplicationLoader.getChildNode(node, COLOR_PHASE);
        n = Integer.valueOf(XmlUtil.getTextFromNode(node2));
        chartUIConfiguration.setPhaseTaskColor(new Color(n));
        node2 = ApplicationLoader.getChildNode(node, COLOR_PROJECT);
        n = Integer.valueOf(XmlUtil.getTextFromNode(node2));
        chartUIConfiguration.setProjectTaskColor(new Color(n));
        node2 = ApplicationLoader.getChildNode(node, COLOR_TASK_CRITICAL);
        n = Integer.valueOf(XmlUtil.getTextFromNode(node2));
        chartUIConfiguration.setTaskCriticalColor(new Color(n));
        node2 = ApplicationLoader.getChildNode(node, COLOR_TASK_COMPLETION);
        n = Integer.valueOf(XmlUtil.getTextFromNode(node2));
        chartUIConfiguration.setTaskCompletionColor(new Color(n));
    }

    private static void loadSplitPane(JSplitPane jSplitPane, Node node, boolean bl) {
        Node node2 = ApplicationLoader.getChildNode(node, SPLIT_ORIENTATION);
        String string = XmlUtil.getTextFromNode(node2);
        if (string.equals(RIGHT)) {
            jSplitPane.getLeftComponent().setVisible(false);
            jSplitPane.getRightComponent().setVisible(true);
        } else if (string.equals(LEFT)) {
            jSplitPane.getLeftComponent().setVisible(true);
            jSplitPane.getRightComponent().setVisible(false);
        } else {
            jSplitPane.getLeftComponent().setVisible(true);
            jSplitPane.getRightComponent().setVisible(true);
            Node node3 = ApplicationLoader.getChildNode(node, SPLIT_POSITION);
            String string2 = XmlUtil.getTextFromNode(node3);
            jSplitPane.setDividerLocation(Integer.valueOf(string2));
        }
        if (bl) {
            if (!jSplitPane.getLeftComponent().isVisible()) {
                jSplitPane.setDividerSize(0);
            } else if (!jSplitPane.getRightComponent().isVisible()) {
                jSplitPane.setDividerSize(0);
            } else {
                jSplitPane.setDividerSize(5);
            }
        }
    }

    private static void loadTreeTable(Node node, JTreeTable jTreeTable) {
        Object object;
        Node node2;
        Node node3;
        Node node4;
        int n;
        NodeList nodeList = node.getChildNodes();
        for (n = 0; n < nodeList.getLength(); ++n) {
            node4 = nodeList.item(n);
            if (node4.getNodeType() != 1 || node4.getNodeName().compareTo(COLUMN) != 0) continue;
            node3 = ApplicationLoader.getChildNode(node4, COLUMN_NAME);
            String string = XmlUtil.getTextFromNode(node3);
            if (string == null) {
                string = "";
            }
            node2 = ApplicationLoader.getChildNode(node4, COLUMN_VISIBLE);
            boolean bl = Boolean.parseBoolean(XmlUtil.getTextFromNode(node2));
            object = jTreeTable.getColumnExt(string);
            if (object == null) continue;
            object.setVisible(bl);
        }
        for (n = 0; n < nodeList.getLength(); ++n) {
            boolean bl;
            node4 = nodeList.item(n);
            if (node4.getNodeType() != 1 || node4.getNodeName().compareTo(COLUMN) != 0 || !(bl = Boolean.parseBoolean(XmlUtil.getTextFromNode(node3 = ApplicationLoader.getChildNode(node4, COLUMN_VISIBLE))))) continue;
            node2 = ApplicationLoader.getChildNode(node4, COLUMN_NAME);
            String string = XmlUtil.getTextFromNode(node2);
            if (string == null) {
                string = "";
            }
            object = ApplicationLoader.getChildNode(node4, COLUMN_ORDER);
            int n2 = Integer.valueOf(XmlUtil.getTextFromNode((Node)object));
            try {
                TableColumn tableColumn = jTreeTable.getColumn(string);
                int n3 = tableColumn.getModelIndex();
                jTreeTable.moveColumn(jTreeTable.convertColumnIndexToView(n3), n2);
                Node node5 = ApplicationLoader.getChildNode(node4, COLUMN_WIDTH);
                int n4 = Integer.valueOf(XmlUtil.getTextFromNode(node5));
                tableColumn.setPreferredWidth(n4);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Common.logException("Error:", illegalArgumentException);
            }
        }
    }

    private static void loadTable(Node node, JXTable jXTable) {
        Object object;
        Node node2;
        Node node3;
        Node node4;
        int n;
        NodeList nodeList = node.getChildNodes();
        for (n = 0; n < nodeList.getLength(); ++n) {
            node4 = nodeList.item(n);
            if (node4.getNodeType() != 1 || node4.getNodeName().compareTo(COLUMN) != 0) continue;
            node3 = ApplicationLoader.getChildNode(node4, COLUMN_NAME);
            String string = XmlUtil.getTextFromNode(node3);
            node2 = ApplicationLoader.getChildNode(node4, COLUMN_VISIBLE);
            boolean bl = Boolean.parseBoolean(XmlUtil.getTextFromNode(node2));
            object = jXTable.getColumnExt((Object)string);
            if (object == null) continue;
            object.setVisible(bl);
        }
        for (n = 0; n < nodeList.getLength(); ++n) {
            boolean bl;
            node4 = nodeList.item(n);
            if (node4.getNodeType() != 1 || node4.getNodeName().compareTo(COLUMN) != 0 || !(bl = Boolean.parseBoolean(XmlUtil.getTextFromNode(node3 = ApplicationLoader.getChildNode(node4, COLUMN_VISIBLE))))) continue;
            node2 = ApplicationLoader.getChildNode(node4, COLUMN_NAME);
            String string = XmlUtil.getTextFromNode(node2);
            if (string == null) {
                string = "";
            }
            object = ApplicationLoader.getChildNode(node4, COLUMN_ORDER);
            int n2 = Integer.valueOf(XmlUtil.getTextFromNode((Node)object));
            try {
                TableColumn tableColumn = jXTable.getColumn((Object)string);
                int n3 = tableColumn.getModelIndex();
                jXTable.moveColumn(jXTable.convertColumnIndexToView(n3), n2);
                Node node5 = ApplicationLoader.getChildNode(node4, COLUMN_WIDTH);
                int n4 = Integer.valueOf(XmlUtil.getTextFromNode(node5));
                tableColumn.setPreferredWidth(n4);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Common.logException("Error:", illegalArgumentException);
            }
        }
    }

    private static void loadColumnsEPS(Node node) {
        JProjectViewEPS jProjectViewEPS = Common.getApplication().getWorkspace().getJProject().getEpsView();
        JEPSTable jEPSTable = jProjectViewEPS.getEps();
        ApplicationLoader.loadTable(node, jEPSTable);
    }

    private static void loadColumnsCreateWBS(Node node) {
        JAreaView jAreaView = Common.getApplication().getWorkspace().getJProject().getAreaView();
        JProjectViewWBS jProjectViewWBS = (JProjectViewWBS)jAreaView.getViewComponent(JAreaView.PROJECT_WBS);
        JWBSTreeTable jWBSTreeTable = jProjectViewWBS.getWbs();
        ApplicationLoader.loadTreeTable(node, jWBSTreeTable);
    }

    private static void loadColumnsScheduleTasks(Node node) {
        JAreaView jAreaView = Common.getApplication().getWorkspace().getJProject().getAreaView();
        JProjectViewGantt jProjectViewGantt = (JProjectViewGantt)jAreaView.getViewComponent(JAreaView.GANTT);
        JTreeTable jTreeTable = jProjectViewGantt.getGantt().getTreeTable();
        ApplicationLoader.loadTreeTable(node, jTreeTable);
    }

    private static void loadColumnsHumanEquipment(Node node) {
        JAreaView jAreaView = Common.getApplication().getWorkspace().getJProject().getAreaView();
        JProjectViewResources jProjectViewResources = (JProjectViewResources)jAreaView.getViewComponent(JAreaView.DEFINE_RESOURCES);
        JHumanResourcesTable jHumanResourcesTable = jProjectViewResources.getHumanResourceView().getResourceTable();
        ApplicationLoader.loadTable(node, jHumanResourcesTable);
    }

    private static void loadColumnsMaterial(Node node) {
        JAreaView jAreaView = Common.getApplication().getWorkspace().getJProject().getAreaView();
        JProjectViewResources jProjectViewResources = (JProjectViewResources)jAreaView.getViewComponent(JAreaView.DEFINE_RESOURCES);
        JMaterialResourcesTable jMaterialResourcesTable = jProjectViewResources.getMaterialResourceView().getResourceTable();
        ApplicationLoader.loadTable(node, jMaterialResourcesTable);
    }

    private static void loadColumnsClients(Node node) {
        JAreaView jAreaView = Common.getApplication().getWorkspace().getJProject().getAreaView();
        JProjectViewClients jProjectViewClients = (JProjectViewClients)jAreaView.getViewComponent(JAreaView.CLIENTS);
        JClientsTable jClientsTable = jProjectViewClients.getClientTable();
        ApplicationLoader.loadTable(node, jClientsTable);
    }

    private static void loadColumnsAssignResources(Node node) {
        JAreaView jAreaView = Common.getApplication().getWorkspace().getJProject().getAreaView();
        JProjectViewGantt jProjectViewGantt = (JProjectViewGantt)jAreaView.getViewComponent(JAreaView.ASSIGN_RESOURCES);
        JTreeTable jTreeTable = jProjectViewGantt.getGantt().getTreeTable();
        ApplicationLoader.loadTreeTable(node, jTreeTable);
    }

    private static void loadColumnsLevelResources(Node node) {
        JAreaView jAreaView = Common.getApplication().getWorkspace().getJProject().getAreaView();
        JProjectViewGantt jProjectViewGantt = (JProjectViewGantt)jAreaView.getViewComponent(JAreaView.LEVEL_RESOURCES);
        JTreeTable jTreeTable = jProjectViewGantt.getGantt().getTreeTable();
        ApplicationLoader.loadTreeTable(node, jTreeTable);
    }

    private static void loadColumnsResourceSheet(Node node) {
        JAreaView jAreaView = Common.getApplication().getWorkspace().getJProject().getAreaView();
        JProjectViewResourceSheet jProjectViewResourceSheet = (JProjectViewResourceSheet)jAreaView.getViewComponent(JAreaView.RESOURCE_SHEET);
        JTreeTable jTreeTable = jProjectViewResourceSheet.getResourceSheet().getTreeTable();
        ApplicationLoader.loadTreeTable(node, jTreeTable);
    }

    private static void loadColumnsAdditionalCosts(Node node) {
        JAreaView jAreaView = Common.getApplication().getWorkspace().getJProject().getAreaView();
        JProjectViewTaskSheet jProjectViewTaskSheet = (JProjectViewTaskSheet)jAreaView.getViewComponent(JAreaView.TASK_SHEET);
        JTreeTable jTreeTable = jProjectViewTaskSheet.getTaskSheet().getTreeTable();
        ApplicationLoader.loadTreeTable(node, jTreeTable);
    }

    private static void loadColumnsUpdateTasks(Node node) {
        JAreaView jAreaView = Common.getApplication().getWorkspace().getJProject().getAreaView();
        JProjectViewGantt jProjectViewGantt = (JProjectViewGantt)jAreaView.getViewComponent(JAreaView.PROJECT_UPDATE);
        JTreeTable jTreeTable = jProjectViewGantt.getGantt().getTreeTable();
        ApplicationLoader.loadTreeTable(node, jTreeTable);
    }

    private static void loadScaleCursor(Node node, TimeScaleManager timeScaleManager) {
        timeScaleManager.setCurrentScaleCursor(Integer.parseInt(XmlUtil.getTextFromNode(node)));
    }

    private static void loadEPS(Node node) {
        JProjectViewEPS jProjectViewEPS = Common.getApplication().getWorkspace().getJProject().getEpsView();
        JEPSTable jEPSTable = jProjectViewEPS.getEps();
        ApplicationLoader.loadTable(node, jEPSTable);
        Node node2 = ApplicationLoader.getChildNode(node, VERTICAL_SPLIT);
        if (node2 != null) {
            JSplitPane jSplitPane = jProjectViewEPS.getSplitPane();
            ApplicationLoader.loadSplitPane(jSplitPane, node2, true);
        }
        jProjectViewEPS.updateInfoButtons();
    }

    private static void loadCreateWBS(Node node) {
        JAreaView jAreaView = Common.getApplication().getWorkspace().getJProject().getAreaView();
        JProjectViewWBS jProjectViewWBS = (JProjectViewWBS)jAreaView.getViewComponent(JAreaView.PROJECT_WBS);
        JWBSTreeTable jWBSTreeTable = jProjectViewWBS.getWbs();
        ApplicationLoader.loadTreeTable(node, jWBSTreeTable);
        Node node2 = ApplicationLoader.getChildNode(node, VERTICAL_SPLIT);
        if (node2 != null) {
            JSplitPane jSplitPane = jProjectViewWBS.getSplitPane();
            ApplicationLoader.loadSplitPane(jSplitPane, node2, true);
        }
        jProjectViewWBS.updateInfoButtons();
    }

    private static void loadRisks(Node node) {
        JAreaView jAreaView = Common.getApplication().getWorkspace().getJProject().getAreaView();
        JProjectViewRisks jProjectViewRisks = (JProjectViewRisks)jAreaView.getViewComponent(JAreaView.PROJECT_RISKS);
        JProjectRisksTable jProjectRisksTable = jProjectViewRisks.getProjectRisksTable();
        ApplicationLoader.loadTable(node, jProjectRisksTable);
        Node node2 = ApplicationLoader.getChildNode(node, VERTICAL_SPLIT);
        if (node2 != null) {
            JSplitPane jSplitPane = jProjectViewRisks.getSplitPane();
            ApplicationLoader.loadSplitPane(jSplitPane, node2, true);
        }
        jProjectViewRisks.updateInfoButtons();
    }

    private static void loadScheduleTasks(Node node) {
        Object object;
        Object object2;
        Object object3;
        Node node2;
        JAreaView jAreaView = Common.getApplication().getWorkspace().getJProject().getAreaView();
        JProjectViewGantt jProjectViewGantt = (JProjectViewGantt)jAreaView.getViewComponent(JAreaView.GANTT);
        JTreeTable jTreeTable = jProjectViewGantt.getGantt().getTreeTable();
        ApplicationLoader.loadTreeTable(node, jTreeTable);
        Node node3 = ApplicationLoader.getChildNode(node, SCALE_CURSOR);
        if (node3 != null) {
            ApplicationLoader.loadScaleCursor(node3, jProjectViewGantt.getGantt().getArea().getTimeScaleManager());
        }
        if ((node2 = ApplicationLoader.getChildNode(node, COLOR_BARS)) != null) {
            object3 = jProjectViewGantt.getGantt().getArea().getChartUIConfiguration();
            ApplicationLoader.loadBarColors((ChartUIConfiguration)object3, node2);
        }
        if ((object3 = ApplicationLoader.getChildNode(node, VERTICAL_SPLIT)) != null) {
            object2 = jProjectViewGantt.getSplitPane();
            ApplicationLoader.loadSplitPane((JSplitPane)object2, (Node)object3, true);
            if (!((JSplitPane)object2).getLeftComponent().isVisible()) {
                ((JSplitPane)object2).setDividerSize(0);
            } else if (!((JSplitPane)object2).getRightComponent().isVisible()) {
                ((JSplitPane)object2).setDividerSize(0);
            } else {
                ((JSplitPane)object2).setDividerSize(5);
            }
        }
        if ((object2 = ApplicationLoader.getChildNode(node, LEVELING_SPLIT)) != null) {
            object = jProjectViewGantt.getLevelingSplitPane();
            ApplicationLoader.loadSplitPane((JSplitPane)object, (Node)object2, true);
            if (!((JSplitPane)object).getLeftComponent().isVisible()) {
                ((JSplitPane)object).setDividerSize(0);
            } else if (!((JSplitPane)object).getRightComponent().isVisible()) {
                ((JSplitPane)object).setDividerSize(0);
            } else {
                ((JSplitPane)object).setDividerSize(5);
            }
        }
        jProjectViewGantt.updateInfoButtons();
        object = ApplicationLoader.getChildNode(node, HORIZONTAL_SPLIT);
        if (object != null) {
            JSplitPane jSplitPane = jProjectViewGantt.getGantt().getSplitPane();
            ApplicationLoader.loadSplitPane(jSplitPane, (Node)object, false);
        }
    }

    private static void loadHumanEquipment(Node node) {
        JAreaView jAreaView = Common.getApplication().getWorkspace().getJProject().getAreaView();
        JProjectViewResources jProjectViewResources = (JProjectViewResources)jAreaView.getViewComponent(JAreaView.DEFINE_RESOURCES);
        JHumanResourcesTable jHumanResourcesTable = jProjectViewResources.getHumanResourceView().getResourceTable();
        ApplicationLoader.loadTable(node, jHumanResourcesTable);
        Node node2 = ApplicationLoader.getChildNode(node, VERTICAL_SPLIT);
        if (node2 != null) {
            JSplitPane jSplitPane = jProjectViewResources.getHumanResourceView().getSplitPane();
            ApplicationLoader.loadSplitPane(jSplitPane, node2, true);
        }
        jProjectViewResources.getHumanResourceView().updateInfoButtons();
    }

    private static void loadMaterial(Node node) {
        JAreaView jAreaView = Common.getApplication().getWorkspace().getJProject().getAreaView();
        JProjectViewResources jProjectViewResources = (JProjectViewResources)jAreaView.getViewComponent(JAreaView.DEFINE_RESOURCES);
        JMaterialResourcesTable jMaterialResourcesTable = jProjectViewResources.getMaterialResourceView().getResourceTable();
        ApplicationLoader.loadTable(node, jMaterialResourcesTable);
        Node node2 = ApplicationLoader.getChildNode(node, VERTICAL_SPLIT);
        if (node2 != null) {
            JSplitPane jSplitPane = jProjectViewResources.getMaterialResourceView().getSplitPane();
            ApplicationLoader.loadSplitPane(jSplitPane, node2, true);
        }
        jProjectViewResources.getMaterialResourceView().updateInfoButtons();
    }

    private static void loadClients(Node node) {
        JAreaView jAreaView = Common.getApplication().getWorkspace().getJProject().getAreaView();
        JProjectViewClients jProjectViewClients = (JProjectViewClients)jAreaView.getViewComponent(JAreaView.CLIENTS);
        JClientsTable jClientsTable = jProjectViewClients.getClientTable();
        ApplicationLoader.loadTable(node, jClientsTable);
        Node node2 = ApplicationLoader.getChildNode(node, VERTICAL_SPLIT);
        if (node2 != null) {
            JSplitPane jSplitPane = jProjectViewClients.getSplitPane();
            ApplicationLoader.loadSplitPane(jSplitPane, node2, true);
        }
        jProjectViewClients.updateInfoButtons();
    }

    private static void loadAssignResources(Node node) {
        Object object;
        Object object2;
        Node node2;
        JAreaView jAreaView = Common.getApplication().getWorkspace().getJProject().getAreaView();
        JProjectViewGantt jProjectViewGantt = (JProjectViewGantt)jAreaView.getViewComponent(JAreaView.ASSIGN_RESOURCES);
        JTreeTable jTreeTable = jProjectViewGantt.getGantt().getTreeTable();
        ApplicationLoader.loadTreeTable(node, jTreeTable);
        Node node3 = ApplicationLoader.getChildNode(node, SCALE_CURSOR);
        if (node3 != null) {
            ApplicationLoader.loadScaleCursor(node3, jProjectViewGantt.getGantt().getArea().getTimeScaleManager());
        }
        if ((node2 = ApplicationLoader.getChildNode(node, VERTICAL_SPLIT)) != null) {
            object2 = jProjectViewGantt.getSplitPane();
            ApplicationLoader.loadSplitPane((JSplitPane)object2, node2, true);
        }
        if ((object2 = ApplicationLoader.getChildNode(node, LEVELING_SPLIT)) != null) {
            object = jProjectViewGantt.getLevelingSplitPane();
            ApplicationLoader.loadSplitPane((JSplitPane)object, (Node)object2, true);
        }
        jProjectViewGantt.updateInfoButtons();
        object = ApplicationLoader.getChildNode(node, HORIZONTAL_SPLIT);
        if (object != null) {
            JSplitPane jSplitPane = jProjectViewGantt.getGantt().getSplitPane();
            ApplicationLoader.loadSplitPane(jSplitPane, (Node)object, false);
        }
    }

    private static void loadLevelResources(Node node) {
        Object object;
        Object object2;
        Object object3;
        Node node2;
        JAreaView jAreaView = Common.getApplication().getWorkspace().getJProject().getAreaView();
        JProjectViewGantt jProjectViewGantt = (JProjectViewGantt)jAreaView.getViewComponent(JAreaView.LEVEL_RESOURCES);
        JTreeTable jTreeTable = jProjectViewGantt.getGantt().getTreeTable();
        ApplicationLoader.loadTreeTable(node, jTreeTable);
        Node node3 = ApplicationLoader.getChildNode(node, SCALE_CURSOR);
        if (node3 != null) {
            ApplicationLoader.loadScaleCursor(node3, jProjectViewGantt.getGantt().getArea().getTimeScaleManager());
        }
        if ((node2 = ApplicationLoader.getChildNode(node, COLOR_BARS)) != null) {
            object3 = jProjectViewGantt.getGantt().getArea().getChartUIConfiguration();
            ApplicationLoader.loadBarColors((ChartUIConfiguration)object3, node2);
        }
        if ((object3 = ApplicationLoader.getChildNode(node, VERTICAL_SPLIT)) != null) {
            object2 = jProjectViewGantt.getSplitPane();
            ApplicationLoader.loadSplitPane((JSplitPane)object2, (Node)object3, true);
            if (!((JSplitPane)object2).getLeftComponent().isVisible()) {
                ((JSplitPane)object2).setDividerSize(0);
            } else if (!((JSplitPane)object2).getRightComponent().isVisible()) {
                ((JSplitPane)object2).setDividerSize(0);
            } else {
                ((JSplitPane)object2).setDividerSize(5);
            }
        }
        if ((object2 = ApplicationLoader.getChildNode(node, LEVELING_SPLIT)) != null) {
            object = jProjectViewGantt.getLevelingSplitPane();
            ApplicationLoader.loadSplitPane((JSplitPane)object, (Node)object2, true);
            if (!((JSplitPane)object).getLeftComponent().isVisible()) {
                ((JSplitPane)object).setDividerSize(0);
            } else if (!((JSplitPane)object).getRightComponent().isVisible()) {
                ((JSplitPane)object).setDividerSize(0);
            } else {
                ((JSplitPane)object).setDividerSize(5);
            }
        }
        jProjectViewGantt.updateInfoButtons();
        object = ApplicationLoader.getChildNode(node, HORIZONTAL_SPLIT);
        if (object != null) {
            JSplitPane jSplitPane = jProjectViewGantt.getGantt().getSplitPane();
            ApplicationLoader.loadSplitPane(jSplitPane, (Node)object, false);
        }
    }

    private static void loadResourceSheet(Node node) {
        Object object;
        Node node2;
        JAreaView jAreaView = Common.getApplication().getWorkspace().getJProject().getAreaView();
        JProjectViewResourceSheet jProjectViewResourceSheet = (JProjectViewResourceSheet)jAreaView.getViewComponent(JAreaView.RESOURCE_SHEET);
        JTreeTable jTreeTable = jProjectViewResourceSheet.getResourceSheet().getTreeTable();
        ApplicationLoader.loadTreeTable(node, jTreeTable);
        Node node3 = ApplicationLoader.getChildNode(node, SCALE_CURSOR);
        if (node3 != null) {
            ApplicationLoader.loadScaleCursor(node3, jProjectViewResourceSheet.getResourceSheet().getArea().getTimeScaleManager());
        }
        if ((node2 = ApplicationLoader.getChildNode(node, VERTICAL_SPLIT)) != null) {
            object = jProjectViewResourceSheet.getSplitPane();
            ApplicationLoader.loadSplitPane((JSplitPane)object, node2, true);
            if (!((JSplitPane)object).getLeftComponent().isVisible()) {
                ((JSplitPane)object).setDividerSize(0);
            } else if (!((JSplitPane)object).getRightComponent().isVisible()) {
                ((JSplitPane)object).setDividerSize(0);
            } else {
                ((JSplitPane)object).setDividerSize(5);
            }
        }
        jProjectViewResourceSheet.updateInfoButtons();
        object = ApplicationLoader.getChildNode(node, HORIZONTAL_SPLIT);
        if (object != null) {
            JSplitPane jSplitPane = jProjectViewResourceSheet.getResourceSheet().getSplitPane();
            ApplicationLoader.loadSplitPane(jSplitPane, (Node)object, false);
        }
    }

    private static void loadAdditionalCosts(Node node) {
        Object object;
        Node node2;
        JAreaView jAreaView = Common.getApplication().getWorkspace().getJProject().getAreaView();
        JProjectViewTaskSheet jProjectViewTaskSheet = (JProjectViewTaskSheet)jAreaView.getViewComponent(JAreaView.TASK_SHEET);
        JTreeTable jTreeTable = jProjectViewTaskSheet.getTaskSheet().getTreeTable();
        ApplicationLoader.loadTreeTable(node, jTreeTable);
        Node node3 = ApplicationLoader.getChildNode(node, SCALE_CURSOR);
        if (node3 != null) {
            ApplicationLoader.loadScaleCursor(node3, jProjectViewTaskSheet.getTaskSheet().getArea().getTimeScaleManager());
        }
        if ((node2 = ApplicationLoader.getChildNode(node, VERTICAL_SPLIT)) != null) {
            object = jProjectViewTaskSheet.getSplitPane();
            ApplicationLoader.loadSplitPane((JSplitPane)object, node2, true);
        }
        jProjectViewTaskSheet.updateInfoButtons();
        object = ApplicationLoader.getChildNode(node, HORIZONTAL_SPLIT);
        if (object != null) {
            JSplitPane jSplitPane = jProjectViewTaskSheet.getTaskSheet().getSplitPane();
            ApplicationLoader.loadSplitPane(jSplitPane, (Node)object, false);
        }
    }

    private static void loadUpdateTasks(Node node) {
        Object object;
        Object object2;
        Node node2;
        JAreaView jAreaView = Common.getApplication().getWorkspace().getJProject().getAreaView();
        JProjectViewGantt jProjectViewGantt = (JProjectViewGantt)jAreaView.getViewComponent(JAreaView.PROJECT_UPDATE);
        JTreeTable jTreeTable = jProjectViewGantt.getGantt().getTreeTable();
        ApplicationLoader.loadTreeTable(node, jTreeTable);
        Node node3 = ApplicationLoader.getChildNode(node, SCALE_CURSOR);
        if (node3 != null) {
            ApplicationLoader.loadScaleCursor(node3, jProjectViewGantt.getGantt().getArea().getTimeScaleManager());
        }
        if ((node2 = ApplicationLoader.getChildNode(node, VERTICAL_SPLIT)) != null) {
            object2 = jProjectViewGantt.getSplitPane();
            ApplicationLoader.loadSplitPane((JSplitPane)object2, node2, true);
        }
        if ((object2 = ApplicationLoader.getChildNode(node, LEVELING_SPLIT)) != null) {
            object = jProjectViewGantt.getLevelingSplitPane();
            ApplicationLoader.loadSplitPane((JSplitPane)object, (Node)object2, true);
        }
        jProjectViewGantt.updateInfoButtons();
        object = ApplicationLoader.getChildNode(node, HORIZONTAL_SPLIT);
        if (object != null) {
            JSplitPane jSplitPane = jProjectViewGantt.getGantt().getSplitPane();
            ApplicationLoader.loadSplitPane(jSplitPane, (Node)object, false);
        }
    }

    public static void loadSettings(Node node) throws Exception {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            Object object2;
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(APPLICATION) == 0 || node2.getNodeName().compareTo(GUIDE) == 0 || node2.getNodeName().compareTo(GUIDE_DETAILS) == 0) continue;
            if (node2.getNodeName().compareTo(TOOLBARS) == 0) {
                ApplicationLoader.loadToolBar(node2);
                continue;
            }
            if (node2.getNodeName().compareTo(CURRENT_VIEW) == 0) {
                object2 = Common.getApplication().getWorkspace().getJProject();
                ((JProject)object2).getAreaView().setActiveView(XmlUtil.getTextFromNode(node2));
                ((JProject)object2).deselectViewButtons();
                ((JProject)object2).getGuidePanel().disableNavigation();
                object = new ProjectData();
                object.setShortDescription("empty.html");
                ((JProject)object2).getGuidePanel().setData((Data)object);
                ((JProject)object2).getGuidePanel().getDetailsTitleLabel().setText(object.getName());
                ((JProject)object2).getAreaView().grabFocus();
                ((JProject)object2).updateToolbar(((JProject)object2).getAreaView().getActiveViewComponent());
                continue;
            }
            if (node2.getNodeName().compareTo(VIEW) != 0) continue;
            object2 = ApplicationLoader.getChildNode(node2, VIEW_NAME);
            object = XmlUtil.getTextFromNode((Node)object2);
            if (((String)object).equals(PROJECT_PORTFOLIO)) {
                ApplicationLoader.loadEPS(node2);
                continue;
            }
            if (((String)object).equals(PROJECT_RISKS)) {
                ApplicationLoader.loadRisks(node2);
                continue;
            }
            if (((String)object).equals(PROJECT_WBS)) {
                ApplicationLoader.loadCreateWBS(node2);
                continue;
            }
            if (((String)object).equals(GANTT)) {
                ApplicationLoader.loadScheduleTasks(node2);
                continue;
            }
            if (((String)object).equals(HUMAN_RESOURCES)) {
                ApplicationLoader.loadHumanEquipment(node2);
                continue;
            }
            if (((String)object).equals(MATERIAL_RESOURCES)) {
                ApplicationLoader.loadMaterial(node2);
                continue;
            }
            if (((String)object).equals(CLIENTS)) {
                ApplicationLoader.loadClients(node2);
                continue;
            }
            if (((String)object).equals(ASSIGN_RESOURCES)) {
                ApplicationLoader.loadAssignResources(node2);
                continue;
            }
            if (((String)object).equals(LEVEL_RESOURCES)) {
                ApplicationLoader.loadLevelResources(node2);
                continue;
            }
            if (((String)object).equals(TASK_SHEET)) {
                ApplicationLoader.loadAdditionalCosts(node2);
                continue;
            }
            if (((String)object).equals(PROJECT_UPDATE)) {
                ApplicationLoader.loadUpdateTasks(node2);
                continue;
            }
            if (!((String)object).equals(RESOURCE_SHEET)) continue;
            ApplicationLoader.loadResourceSheet(node2);
        }
    }

    private static void loadToolBar(Node node) {
        Node node2;
        Node node3;
        Node node4;
        Node node5;
        UIManager uIManager = UIManager.getInstance();
        Node node6 = ApplicationLoader.getChildNode(node, MAIN_TOOLBAR);
        if (node6 != null) {
            uIManager.setShowMainToolBar(Boolean.parseBoolean(XmlUtil.getTextFromNode(node6)));
        }
        if ((node5 = ApplicationLoader.getChildNode(node, PROJECT_TOOLBAR)) != null) {
            uIManager.setShowProjectToolBar(Boolean.parseBoolean(XmlUtil.getTextFromNode(node5)));
        }
        if ((node4 = ApplicationLoader.getChildNode(node, MAIL_TOOLBAR)) != null) {
            uIManager.setShowMailToolBar(Boolean.parseBoolean(XmlUtil.getTextFromNode(node4)));
        }
        if ((node3 = ApplicationLoader.getChildNode(node, VIEW_TOOLBAR)) != null) {
            uIManager.setShowViewToolBar(Boolean.parseBoolean(XmlUtil.getTextFromNode(node3)));
        }
        if ((node2 = ApplicationLoader.getChildNode(node, BUTTON_TOOLBAR)) != null) {
            uIManager.setShowButtonToolBar(Boolean.parseBoolean(XmlUtil.getTextFromNode(node2)));
        }
    }

    public static void loadColumnsSettings(Node node) throws Exception {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(VIEW) != 0) continue;
            Node node3 = ApplicationLoader.getChildNode(node2, VIEW_NAME);
            String string = XmlUtil.getTextFromNode(node3);
            if (string.equals(Common.I18N_RP.getString("projectPortfolio"))) {
                ApplicationLoader.loadColumnsEPS(node2);
                continue;
            }
            if (string.equals(JAreaView.PROJECT_WBS)) {
                ApplicationLoader.loadColumnsCreateWBS(node2);
                continue;
            }
            if (string.equals(JAreaView.GANTT)) {
                ApplicationLoader.loadColumnsScheduleTasks(node2);
                continue;
            }
            if (string.equals(JAreaView.HUMAN_RESOURCES)) {
                ApplicationLoader.loadColumnsHumanEquipment(node2);
                continue;
            }
            if (string.equals(JAreaView.MATERIAL_RESOURCES)) {
                ApplicationLoader.loadColumnsMaterial(node2);
                continue;
            }
            if (string.equals(JAreaView.CLIENTS)) {
                ApplicationLoader.loadColumnsClients(node2);
                continue;
            }
            if (string.equals(JAreaView.ASSIGN_RESOURCES)) {
                ApplicationLoader.loadColumnsAssignResources(node2);
                continue;
            }
            if (string.equals(JAreaView.LEVEL_RESOURCES)) {
                ApplicationLoader.loadColumnsLevelResources(node2);
                continue;
            }
            if (string.equals(JAreaView.TASK_SHEET)) {
                ApplicationLoader.loadColumnsAdditionalCosts(node2);
                continue;
            }
            if (string.equals(JAreaView.PROJECT_UPDATE)) {
                ApplicationLoader.loadColumnsUpdateTasks(node2);
                continue;
            }
            if (!string.equals(JAreaView.RESOURCE_SHEET)) continue;
            ApplicationLoader.loadColumnsResourceSheet(node2);
        }
    }

    private static Node getChildNode(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(string) != 0) continue;
            return node2;
        }
        return null;
    }
}

