/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.dB.msproject.xml;

import com.sbs.jpm.calendar.ResourceCalendarManager;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.HumanResource;
import com.sbs.jpm.core.MaterialResource;
import com.sbs.jpm.core.Resource;
import com.sbs.jpm.dB.CalendarCollection;
import com.sbs.jpm.dB.msproject.xml.CalendarLoader;
import com.sbs.jpm.dB.msproject.xml.MSCalendar;
import com.sbs.xml.XmlUtil;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceLoader {
    public static final String RESOURCE_LIST = "Resources";
    private static final String RESOURCE = "Resource";
    private static final String RESOURCE_ID = "UID";
    private static final String RESOURCE_NAME = "Name";
    private static final String RESOURCE_TYPE = "Type";
    private static final String RESOURCE_EMPTY = "IsNull";
    private static final String RESOURCE_MATERIAL_LABEL = "MaterialLabel";
    private static final String RESOURCE_MAX_UNIT = "MaxUnits";
    private static final String RESOURCE_EMAIL = "EmailAddress";
    private static final String RESOURCE_NOTES = "Notes";
    public static final String RESOURCE_CODE = "Code";
    private static final String RESOURCE_STANDARD_RATE = "StandardRate";
    private static final String RESOURCE_STANDARD_RATE_FORMAT = "StandardRateFormat";
    private static final String RESOURCE_OVERTIME_RATE = "OvertimeRate";
    private static final String RESOURCE_OVERTIME_RATE_FORMAT = "OvertimeRateFormat";
    private static final String RESOURCE_CALENDAR_ID = "CalendarUID";

    private static Node getChildNode(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(string) != 0) continue;
            return node2;
        }
        return null;
    }

    public static List loadHumanResourceList(Company company, Node node, CalendarCollection calendarCollection) {
        LinkedList<Resource> linkedList = new LinkedList<Resource>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2;
            int n;
            Node node3 = nodeList.item(i);
            if (node3.getNodeType() != 1 || node3.getNodeName().compareTo(RESOURCE) != 0 || (n = (node2 = ResourceLoader.getChildNode(node3, RESOURCE_TYPE)) != null ? Integer.parseInt(XmlUtil.getTextFromNode(node2)) : 1) != 1) continue;
            Node node4 = ResourceLoader.getChildNode(node3, RESOURCE_ID);
            if (node4 == null) {
                linkedList.add(ResourceLoader.loadHumanResource(company, node3, calendarCollection));
                continue;
            }
            if (XmlUtil.getTextFromNode(node4).equals("0")) continue;
            linkedList.add(ResourceLoader.loadHumanResource(company, node3, calendarCollection));
        }
        return linkedList;
    }

    public static List loadMaterialResourceList(Company company, Node node) {
        LinkedList<Resource> linkedList = new LinkedList<Resource>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            int n;
            Node node2;
            Node node3 = nodeList.item(i);
            if (node3.getNodeType() != 1 || node3.getNodeName().compareTo(RESOURCE) != 0 || (node2 = ResourceLoader.getChildNode(node3, RESOURCE_TYPE)) == null || (n = Integer.parseInt(XmlUtil.getTextFromNode(node2))) != 0) continue;
            linkedList.add(ResourceLoader.loadMaterialResource(company, node3));
        }
        return linkedList;
    }

    private static Resource loadHumanResource(Company company, Node node, CalendarCollection calendarCollection) {
        HumanResource humanResource = new HumanResource(Long.MIN_VALUE);
        humanResource.setOwner(company);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            int n;
            Node node2;
            Node node3 = nodeList.item(i);
            if (node3.getNodeType() != 1) continue;
            if (node3.getNodeName().compareTo(RESOURCE_ID) == 0) {
                humanResource.setId(Long.parseLong(XmlUtil.getTextFromNode(node3)));
                continue;
            }
            if (node3.getNodeName().compareTo(RESOURCE_NAME) == 0) {
                String string2 = XmlUtil.getTextFromNode(node3);
                if (string2 == null) continue;
                humanResource.setName(string2);
                continue;
            }
            if (node3.getNodeName().compareTo(RESOURCE_EMAIL) == 0) {
                String string3 = XmlUtil.getTextFromNode(node3);
                if (string3 == null) continue;
                humanResource.setEmail(string3);
                continue;
            }
            if (node3.getNodeName().compareTo(RESOURCE_CODE) == 0) {
                String string4 = XmlUtil.getTextFromNode(node3);
                if (string4 == null) continue;
                humanResource.setCode(string4);
                continue;
            }
            if (node3.getNodeName().compareTo(RESOURCE_MAX_UNIT) == 0) {
                humanResource.setMaxUnits(Double.parseDouble(XmlUtil.getTextFromNode(node3)));
                continue;
            }
            if (node3.getNodeName().compareTo(RESOURCE_STANDARD_RATE) == 0) {
                double d = Double.parseDouble(XmlUtil.getTextFromNode(node3));
                node2 = ResourceLoader.getChildNode(node3, RESOURCE_STANDARD_RATE_FORMAT);
                if (node2 != null) {
                    n = Integer.parseInt(XmlUtil.getTextFromNode(node3));
                    switch (n) {
                        case 1: {
                            humanResource.setStandardRate(d * 60.0);
                            break;
                        }
                        case 2: {
                            humanResource.setStandardRate(d);
                            break;
                        }
                        case 3: {
                            humanResource.setStandardRate(d / 24.0);
                            break;
                        }
                        case 4: {
                            humanResource.setStandardRate(d / 168.0);
                            break;
                        }
                        case 5: {
                            humanResource.setStandardRate(d / 720.0);
                            break;
                        }
                        case 6: {
                            humanResource.setStandardRate(d / 8760.0);
                            break;
                        }
                        default: {
                            humanResource.setStandardRate(d);
                            break;
                        }
                    }
                    continue;
                }
                humanResource.setStandardRate(d);
                continue;
            }
            if (node3.getNodeName().compareTo(RESOURCE_OVERTIME_RATE) == 0) {
                double d = Double.parseDouble(XmlUtil.getTextFromNode(node3));
                node2 = ResourceLoader.getChildNode(node3, RESOURCE_OVERTIME_RATE_FORMAT);
                if (node2 != null) {
                    n = Integer.parseInt(XmlUtil.getTextFromNode(node3));
                    switch (n) {
                        case 1: {
                            humanResource.setOvertimeRate(d * 60.0);
                            break;
                        }
                        case 2: {
                            humanResource.setOvertimeRate(d);
                            break;
                        }
                        case 3: {
                            humanResource.setOvertimeRate(d / 24.0);
                            break;
                        }
                        case 4: {
                            humanResource.setOvertimeRate(d / 168.0);
                            break;
                        }
                        case 5: {
                            humanResource.setOvertimeRate(d / 720.0);
                            break;
                        }
                        case 6: {
                            humanResource.setOvertimeRate(d / 8760.0);
                            break;
                        }
                        default: {
                            humanResource.setOvertimeRate(d);
                            break;
                        }
                    }
                    continue;
                }
                humanResource.setOvertimeRate(d);
                continue;
            }
            if (node3.getNodeName().compareTo(RESOURCE_CALENDAR_ID) == 0) {
                MSCalendar mSCalendar = (MSCalendar)CalendarLoader.idToMSCalendarMap.get(Long.parseLong(XmlUtil.getTextFromNode(node3)));
                ResourceCalendarManager resourceCalendarManager = new ResourceCalendarManager(humanResource);
                if (mSCalendar.getSpecialPatternList() != null) {
                    resourceCalendarManager.setResourcePatternList(mSCalendar.getSpecialPatternList());
                }
                humanResource.setCalendar(mSCalendar.getCalendar());
                humanResource.setResourceCalendar(resourceCalendarManager);
                continue;
            }
            if (node3.getNodeName().compareTo(RESOURCE_NOTES) != 0 || (string = XmlUtil.getTextFromNode(node3)) == null) continue;
            humanResource.setNotes(string);
        }
        return humanResource;
    }

    private static Resource loadMaterialResource(Company company, Node node) {
        MaterialResource materialResource = new MaterialResource(Long.MIN_VALUE);
        materialResource.setOwner(company);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            if (node2.getNodeName().compareTo(RESOURCE_ID) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                materialResource.setId(Long.parseLong(string));
                continue;
            }
            if (node2.getNodeName().compareTo(RESOURCE_NAME) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                if (string == null) continue;
                materialResource.setName(string);
                continue;
            }
            if (node2.getNodeName().compareTo(RESOURCE_CODE) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                if (string == null) continue;
                materialResource.setCode(string);
                continue;
            }
            if (node2.getNodeName().compareTo(RESOURCE_MATERIAL_LABEL) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                if (string == null) continue;
                materialResource.setMeasurementUnit(string);
                continue;
            }
            if (node2.getNodeName().compareTo(RESOURCE_STANDARD_RATE) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                materialResource.setStandardRate(Double.parseDouble(string));
                continue;
            }
            if (node2.getNodeName().compareTo(RESOURCE_NOTES) != 0 || (string = XmlUtil.getTextFromNode(node2)) == null) continue;
            materialResource.setNotes(string);
        }
        return materialResource;
    }

    public static Element storeHumanResourceList(Document document, Element element, List list) {
        for (Resource resource : list) {
            element.appendChild(ResourceLoader.storeHumanResource(document, resource));
        }
        return element;
    }

    public static Element storeMaterialResourceList(Document document, Element element, List list) {
        for (Resource resource : list) {
            element.appendChild(ResourceLoader.storeMaterialResource(document, resource));
        }
        return element;
    }

    private static Element storeHumanResource(Document document, Resource resource) {
        Element element = document.createElement(RESOURCE);
        Element element2 = XmlUtil.createTextElement(document, RESOURCE_TYPE, "1");
        element.appendChild(element2);
        if (resource.isEmpty()) {
            Element element3 = XmlUtil.createTextElement(document, RESOURCE_EMPTY, "1");
            element.appendChild(element3);
        } else {
            HumanResource humanResource = (HumanResource)resource;
            Element element4 = XmlUtil.createTextElement(document, RESOURCE_EMPTY, "0");
            Element element5 = XmlUtil.createTextElement(document, RESOURCE_ID, "" + resource.getId());
            Element element6 = XmlUtil.createTextElement(document, RESOURCE_NAME, resource.getName());
            Element element7 = XmlUtil.createTextElement(document, RESOURCE_CODE, resource.getCode());
            Element element8 = XmlUtil.createTextElement(document, RESOURCE_MAX_UNIT, String.valueOf(humanResource.getMaxUnits()));
            Element element9 = XmlUtil.createTextElement(document, RESOURCE_STANDARD_RATE, "" + resource.getStandardRate());
            Element element10 = XmlUtil.createTextElement(document, RESOURCE_STANDARD_RATE_FORMAT, "2");
            Element element11 = XmlUtil.createTextElement(document, RESOURCE_OVERTIME_RATE, "" + humanResource.getOvertimeRate());
            Element element12 = XmlUtil.createTextElement(document, RESOURCE_OVERTIME_RATE_FORMAT, "2");
            Element element13 = XmlUtil.createTextElement(document, RESOURCE_EMAIL, humanResource.getEmail());
            Element element14 = XmlUtil.createTextElement(document, RESOURCE_NOTES, resource.getNotes());
            element.appendChild(element4);
            element.appendChild(element5);
            element.appendChild(element6);
            element.appendChild(element7);
            element.appendChild(element8);
            element.appendChild(element9);
            element.appendChild(element10);
            element.appendChild(element11);
            element.appendChild(element12);
            element.appendChild(element13);
            element.appendChild(element14);
            if (humanResource.getCalendar() != null) {
                Element element15 = XmlUtil.createTextElement(document, RESOURCE_CALENDAR_ID, "" + CalendarLoader.resourceCalendarToIdMap.get(humanResource.getResourceCalendar()));
                element.appendChild(element15);
            }
        }
        return element;
    }

    private static Element storeMaterialResource(Document document, Resource resource) {
        Element element = document.createElement(RESOURCE);
        Element element2 = XmlUtil.createTextElement(document, RESOURCE_ID, "" + resource.getId());
        Element element3 = XmlUtil.createTextElement(document, RESOURCE_TYPE, "0");
        element.appendChild(element2);
        element.appendChild(element3);
        if (resource.isEmpty()) {
            Element element4 = XmlUtil.createTextElement(document, RESOURCE_EMPTY, "1");
            element.appendChild(element4);
        } else {
            Element element5 = XmlUtil.createTextElement(document, RESOURCE_EMPTY, "0");
            Element element6 = XmlUtil.createTextElement(document, RESOURCE_NAME, resource.getName());
            Element element7 = XmlUtil.createTextElement(document, RESOURCE_CODE, resource.getCode());
            Element element8 = XmlUtil.createTextElement(document, RESOURCE_MATERIAL_LABEL, ((MaterialResource)resource).getMeasurementUnit());
            Element element9 = XmlUtil.createTextElement(document, RESOURCE_STANDARD_RATE, "" + resource.getStandardRate());
            Element element10 = XmlUtil.createTextElement(document, RESOURCE_STANDARD_RATE_FORMAT, "8");
            Element element11 = XmlUtil.createTextElement(document, RESOURCE_NOTES, resource.getNotes());
            element.appendChild(element5);
            element.appendChild(element6);
            element.appendChild(element7);
            element.appendChild(element8);
            element.appendChild(element9);
            element.appendChild(element10);
            element.appendChild(element11);
        }
        return element;
    }
}

