/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.dB.msproject.xml;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Dependency;
import com.sbs.jpm.core.DurationManager;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.dB.TaskCollection;
import com.sbs.xml.XmlUtil;
import java.text.MessageFormat;
import javax.swing.JOptionPane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DependencyLoader {
    public static final String TASK_DEPENDENCY = "PredecessorLink";
    private static final String TASK_PREDECESSOR_ID = "PredecessorUID";
    private static final String TASK_DEPENDENCY_TYPE = "Type";
    private static final String TASK_DEPENDENCY_START_TO_START = "3";
    private static final String TASK_DEPENDENCY_START_TO_FINISH = "2";
    private static final String TASK_DEPENDENCY_FINISH_TO_START = "1";
    private static final String TASK_DEPENDENCY_FINISH_TO_FINISH = "0";
    private static final String TASK_DEPENDENCY_LAG = "LinkLag";
    private static final String TASK_DEPENDENCY_UNIT = "LagFormat";
    private TaskCollection taskCollection;

    public DependencyLoader(TaskCollection taskCollection) {
        this.taskCollection = taskCollection;
    }

    private static Node getChildNode(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(string) != 0) continue;
            return node2;
        }
        return null;
    }

    public Dependency loadTaskDependency(Node node, Dependency dependency) {
        Object object;
        Node node2;
        Node node3 = DependencyLoader.getChildNode(node, TASK_PREDECESSOR_ID);
        if (node3 != null) {
            Task task = this.taskCollection.getTaskForId((long)Long.valueOf(XmlUtil.getTextFromNode(node3)));
            dependency.setPredecessor(task);
        }
        if ((node2 = DependencyLoader.getChildNode(node, TASK_DEPENDENCY_TYPE)) != null) {
            String string = XmlUtil.getTextFromNode(node2);
            if (TASK_DEPENDENCY_START_TO_START.compareTo(string) == 0) {
                dependency.setType(1);
            } else if (TASK_DEPENDENCY_START_TO_FINISH.compareTo(string) == 0) {
                dependency.setType(2);
            } else if (TASK_DEPENDENCY_FINISH_TO_START.compareTo(string) == 0) {
                dependency.setType(0);
            } else if (TASK_DEPENDENCY_FINISH_TO_FINISH.compareTo(string) == 0) {
                dependency.setType(3);
            } else {
                throw new RuntimeException("Invalid dependency type: " + string);
            }
        }
        long l = 0L;
        Node node4 = DependencyLoader.getChildNode(node, TASK_DEPENDENCY_LAG);
        if (node4 != null) {
            object = XmlUtil.getTextFromNode(node4);
            l = Long.parseLong((String)object) * 6000L;
            dependency.setTaskDelay(l);
        }
        if ((object = DependencyLoader.getChildNode(node, TASK_DEPENDENCY_UNIT)) != null) {
            String string = XmlUtil.getTextFromNode((Node)object);
            if (string.equals(TASK_DEPENDENCY_START_TO_START)) {
                dependency.setUnit(DurationManager.MINUTE);
            } else if (string.equals("5")) {
                dependency.setUnit(DurationManager.HOUR);
            } else if (string.equals("7")) {
                dependency.setUnit(DurationManager.DAY);
            } else if (string.equals("9")) {
                dependency.setUnit(DurationManager.WEEK);
            } else {
                dependency.setUnit(DurationManager.DAY);
            }
        }
        return dependency;
    }

    public static void storeTaskDependencyList(Document document, Element element, Task task, Task task2) {
        for (Dependency dependency : task.getPredecessorDependencies()) {
            Object[] objectArray;
            if (dependency.getPredecessor().isDescendent(task2)) {
                objectArray = DependencyLoader.storeTaskDependency(document, dependency);
                element.appendChild((Node)objectArray);
                continue;
            }
            objectArray = new Object[]{task.getName(), dependency.getPredecessor().getName()};
            JOptionPane.showMessageDialog(null, MessageFormat.format(Common.I18N_MESSAGES.getString("dependency.externalDependency.message"), objectArray), Common.I18N_MESSAGES.getString("dependency.externalDependency.title"), 2);
        }
    }

    private static Element storeTaskDependency(Document document, Dependency dependency) {
        Element element = document.createElement(TASK_DEPENDENCY);
        Element element2 = XmlUtil.createTextElement(document, TASK_PREDECESSOR_ID, "" + dependency.getPredecessor().getId());
        Element element3 = dependency.getType() == 1 ? XmlUtil.createTextElement(document, TASK_DEPENDENCY_TYPE, TASK_DEPENDENCY_START_TO_START) : (dependency.getType() == 2 ? XmlUtil.createTextElement(document, TASK_DEPENDENCY_TYPE, TASK_DEPENDENCY_START_TO_FINISH) : (dependency.getType() == 3 ? XmlUtil.createTextElement(document, TASK_DEPENDENCY_TYPE, TASK_DEPENDENCY_FINISH_TO_FINISH) : XmlUtil.createTextElement(document, TASK_DEPENDENCY_TYPE, TASK_DEPENDENCY_FINISH_TO_START)));
        Element element4 = XmlUtil.createTextElement(document, TASK_DEPENDENCY_LAG, "" + dependency.getTaskDelay() / 6000L);
        Element element5 = dependency.getUnit().equals(DurationManager.MINUTE) ? XmlUtil.createTextElement(document, TASK_DEPENDENCY_UNIT, TASK_DEPENDENCY_START_TO_START) : (dependency.getUnit().equals(DurationManager.HOUR) ? XmlUtil.createTextElement(document, TASK_DEPENDENCY_UNIT, "5") : (dependency.getUnit().equals(DurationManager.WEEK) ? XmlUtil.createTextElement(document, TASK_DEPENDENCY_UNIT, "9") : XmlUtil.createTextElement(document, TASK_DEPENDENCY_UNIT, "7")));
        element.appendChild(element2);
        element.appendChild(element3);
        element.appendChild(element4);
        element.appendChild(element5);
        return element;
    }
}

