/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.dB.msproject.xml;

import com.sbs.jpm.Common;
import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.calendar.DayWorkingPattern;
import com.sbs.jpm.calendar.PeriodInDay;
import com.sbs.jpm.calendar.ResourceCalendarManager;
import com.sbs.jpm.calendar.StandardCalendarManager;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.HumanResource;
import com.sbs.jpm.core.InvalidOperationException;
import com.sbs.jpm.dB.CalendarCollection;
import com.sbs.jpm.dB.msproject.xml.MSCalendar;
import com.sbs.xml.XmlUtil;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CalendarLoader {
    public static Map resourceCalendarToIdMap = new HashMap();
    public static Map idToMSCalendarMap = new HashMap();
    public static final String CALENDAR = "Calendar";
    public static final String CALENDAR_NAME = "Name";
    public static final String CALENDAR_IS_BASE_CALENDAR = "IsBaseCalendar";
    public static final String CALENDAR_ID = "UID";
    public static final String BASE_CALENDAR_ID = "BaseCalendarUID";
    public static final String CALENDAR_LIST = "Calendars";
    public static final String WEEK_PATTERN_LIST = "WeekDays";
    public static final String PATTERN = "WeekDay";
    public static final String PATTERN_TYPE = "DayType";
    public static final String PATTERN_WORKING = "DayWorking";
    public static final String TIME_PERIOD = "TimePeriod";
    public static final String FROM_DATE = "FromDate";
    public static final String TO_DATE = "ToDate";
    public static final String WORKING_TIMES = "WorkingTimes";
    public static final String WORKING_TIME = "WorkingTime";
    public static final String FROM_TIME = "FromTime";
    public static final String TO_TIME = "ToTime";
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static final DecimalFormat periodFormat = new DecimalFormat("00");

    private static Node getChildNode(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(string) != 0) continue;
            return node2;
        }
        return null;
    }

    public static List loadCalendarList(Node node) {
        Object object;
        Node node2;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node3 = nodeList.item(i);
            if (node3.getNodeType() != 1 || node3.getNodeName().compareTo(CALENDAR) != 0 || (node2 = CalendarLoader.getChildNode(node3, CALENDAR_IS_BASE_CALENDAR)) == null || !XmlUtil.getTextFromNode(node2).equals("1")) continue;
            object = CalendarLoader.loadCalendar(node3);
            linkedList.add(object);
        }
        CalendarCollection calendarCollection = new CalendarCollection(linkedList);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(CALENDAR) != 0 || (object = CalendarLoader.getChildNode(node2, CALENDAR_IS_BASE_CALENDAR)) == null || !XmlUtil.getTextFromNode((Node)object).equals("0")) continue;
            MSCalendar mSCalendar = CalendarLoader.loadResourceCalendar(node2, calendarCollection);
            Node node4 = CalendarLoader.getChildNode(node2, CALENDAR_ID);
            if (node4 == null) continue;
            idToMSCalendarMap.put(Long.parseLong(XmlUtil.getTextFromNode(node4)), mSCalendar);
        }
        return linkedList;
    }

    private static CalendarManager loadCalendar(Node node) {
        StandardCalendarManager standardCalendarManager = new StandardCalendarManager(Long.MIN_VALUE);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            if (node2.getNodeName().compareTo(CALENDAR_NAME) == 0) {
                standardCalendarManager.setName(XmlUtil.getTextFromNode(node2));
            }
            if (node2.getNodeName().compareTo(CALENDAR_ID) == 0) {
                standardCalendarManager.setId(Long.parseLong(XmlUtil.getTextFromNode(node2)));
            }
            if (node2.getNodeName().compareTo(WEEK_PATTERN_LIST) != 0) continue;
            CalendarLoader.loadWeekPatternList(standardCalendarManager, node2);
        }
        return standardCalendarManager;
    }

    private static MSCalendar loadResourceCalendar(Node node, CalendarCollection calendarCollection) {
        Node node2;
        MSCalendar mSCalendar = new MSCalendar();
        Node node3 = CalendarLoader.getChildNode(node, BASE_CALENDAR_ID);
        if (node3 != null) {
            long l = Long.parseLong(XmlUtil.getTextFromNode(node3));
            mSCalendar.setCalendar(calendarCollection.getCalendarForId(l));
        }
        if ((node2 = CalendarLoader.getChildNode(node, WEEK_PATTERN_LIST)) != null) {
            mSCalendar.setSpecialPatternList(CalendarLoader.loadSpecialPatternList(node2));
        }
        return mSCalendar;
    }

    private static void loadWeekPatternList(CalendarManager calendarManager, Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(PATTERN) != 0) continue;
            CalendarLoader.loadWeekPattern(calendarManager, node2);
        }
    }

    private static void loadWeekPattern(CalendarManager calendarManager, Node node) {
        Object object;
        int n;
        Object object2;
        Node node2;
        DayWorkingPattern dayWorkingPattern = new DayWorkingPattern();
        dayWorkingPattern.setOwner(calendarManager);
        Node node3 = CalendarLoader.getChildNode(node, PATTERN_WORKING);
        if (node3 != null) {
            boolean bl;
            boolean bl2 = bl = XmlUtil.getTextFromNode(node3).equals("1");
            if (!bl) {
                dayWorkingPattern.setWorking(bl);
            }
        }
        if ((node2 = CalendarLoader.getChildNode(node, WORKING_TIMES)) != null) {
            object2 = node2.getChildNodes();
            for (n = 0; n < object2.getLength(); ++n) {
                object = object2.item(n);
                if (object.getNodeType() != 1 || object.getNodeName().compareTo(WORKING_TIME) != 0 || object.getChildNodes().getLength() == 0) continue;
                dayWorkingPattern.addAlternance(CalendarLoader.loadPeriodInDay((Node)object));
            }
        }
        if ((object2 = CalendarLoader.getChildNode(node, TIME_PERIOD)) != null) {
            try {
                Date date = dateFormat.parse(XmlUtil.getTextFromNode(CalendarLoader.getChildNode((Node)object2, FROM_DATE)));
                object = dateFormat.parse(XmlUtil.getTextFromNode(CalendarLoader.getChildNode((Node)object2, TO_DATE)));
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                while (calendar.getTime().before((Date)object)) {
                    calendarManager.setDayPattern(calendar, dayWorkingPattern);
                    calendar.add(6, 1);
                }
            }
            catch (Exception exception) {
                Common.logException("Error:", exception);
            }
        } else {
            n = 2;
            object = CalendarLoader.getChildNode(node, PATTERN_TYPE);
            if (object != null) {
                int n2 = Integer.parseInt(XmlUtil.getTextFromNode((Node)object));
                switch (n2) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        n = 2;
                        break;
                    }
                    case 3: {
                        n = 3;
                        break;
                    }
                    case 4: {
                        n = 4;
                        break;
                    }
                    case 5: {
                        n = 5;
                        break;
                    }
                    case 6: {
                        n = 6;
                        break;
                    }
                    case 7: {
                        n = 7;
                        break;
                    }
                    case 1: {
                        n = 1;
                        break;
                    }
                }
            }
            calendarManager.setDayPattern(n, dayWorkingPattern);
        }
    }

    private static void loadSpecialPattern(List list, Node node) {
        Object object;
        Object object2;
        Node node2;
        DayWorkingPattern dayWorkingPattern = new DayWorkingPattern();
        Node node3 = CalendarLoader.getChildNode(node, PATTERN_WORKING);
        if (node3 != null) {
            boolean bl;
            boolean bl2 = bl = XmlUtil.getTextFromNode(node3).equals("1");
            if (!bl) {
                dayWorkingPattern.setWorking(bl);
            }
        }
        if ((node2 = CalendarLoader.getChildNode(node, WORKING_TIMES)) != null) {
            object2 = node2.getChildNodes();
            for (int i = 0; i < object2.getLength(); ++i) {
                object = object2.item(i);
                if (object.getNodeType() != 1 || object.getNodeName().compareTo(WORKING_TIME) != 0) continue;
                dayWorkingPattern.addAlternance(CalendarLoader.loadPeriodInDay((Node)object));
            }
        }
        if ((object2 = CalendarLoader.getChildNode(node, TIME_PERIOD)) != null) {
            try {
                Date date = dateFormat.parse(XmlUtil.getTextFromNode(CalendarLoader.getChildNode((Node)object2, FROM_DATE)));
                object = dateFormat.parse(XmlUtil.getTextFromNode(CalendarLoader.getChildNode((Node)object2, TO_DATE)));
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                while (calendar.getTime().before((Date)object)) {
                    CalendarManager.SpecialDay specialDay = new CalendarManager.SpecialDay();
                    specialDay.setDate((Calendar)calendar.clone());
                    specialDay.setDayPattern(dayWorkingPattern);
                    list.add(specialDay);
                    calendar.add(6, 1);
                }
            }
            catch (Exception exception) {
                Common.logException("Error:", exception);
            }
        }
    }

    private static List loadSpecialPatternList(Node node) {
        LinkedList linkedList = new LinkedList();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(PATTERN) != 0) continue;
            CalendarLoader.loadSpecialPattern(linkedList, node2);
        }
        return linkedList;
    }

    private static PeriodInDay loadPeriodInDay(Node node) {
        long l = 0L;
        long l2 = 0L;
        Node node2 = CalendarLoader.getChildNode(node, FROM_TIME);
        Node node3 = CalendarLoader.getChildNode(node, TO_TIME);
        String string = XmlUtil.getTextFromNode(node2);
        String string2 = XmlUtil.getTextFromNode(node3);
        try {
            l += (long)(periodFormat.parse(string.substring(0, 2)).intValue() * 3600 * 1000);
            l += (long)(periodFormat.parse(string.substring(3, 5)).intValue() * 60 * 1000);
            l += (long)(periodFormat.parse(string.substring(6)).intValue() * 1000);
            int n = periodFormat.parse(string2.substring(0, 2)).intValue();
            if (n == 0) {
                n = 24;
            }
            l2 += (long)(n * 3600 * 1000);
            l2 += (long)(periodFormat.parse(string2.substring(3, 5)).intValue() * 60 * 1000);
            l2 += (long)(periodFormat.parse(string2.substring(6)).intValue() * 1000);
        }
        catch (ParseException parseException) {
            Common.logException("Error:", parseException);
        }
        PeriodInDay periodInDay = null;
        try {
            periodInDay = new PeriodInDay(true, l, l2);
        }
        catch (InvalidOperationException invalidOperationException) {
            Common.logException("Error:", invalidOperationException);
            JOptionPane.showMessageDialog(Common.getApplication(), invalidOperationException.getLocalizedMessage(), Common.I18N_MESSAGES.getString("file.failedToOpen"), 0);
        }
        return periodInDay;
    }

    public static Element storeCalendarList(Document document, Company company) {
        Object object;
        List<CalendarManager> list = company.getCalendarList();
        Element element = document.createElement(CALENDAR_LIST);
        long l = 0L;
        for (CalendarManager uniqueId : list) {
            l = uniqueId.getId() + 1L;
            object = CalendarLoader.storeCalendar(document, uniqueId);
            element.appendChild((Node)object);
        }
        for (HumanResource humanResource : company.getHumanResources()) {
            if (humanResource.getCalendar() == null) continue;
            object = humanResource.getResourceCalendar();
            resourceCalendarToIdMap.put(object, ++l);
            Element element2 = CalendarLoader.storeResourceCalendar(document, (ResourceCalendarManager)object, l);
            element.appendChild(element2);
        }
        return element;
    }

    private static Element storeCalendar(Document document, CalendarManager calendarManager) {
        Element element = document.createElement(CALENDAR);
        Element element2 = XmlUtil.createTextElement(document, CALENDAR_ID, "" + (calendarManager.getId() + 1L));
        Element element3 = XmlUtil.createTextElement(document, CALENDAR_NAME, calendarManager.getName());
        Element element4 = XmlUtil.createTextElement(document, CALENDAR_IS_BASE_CALENDAR, "1");
        Element element5 = document.createElement(WEEK_PATTERN_LIST);
        CalendarLoader.storeWeekPatternList(document, element5, calendarManager.getWeekPatternList());
        CalendarLoader.storeSpecialPatternList(document, element5, calendarManager.getSpecialPatternList());
        element.appendChild(element2);
        element.appendChild(element3);
        element.appendChild(element4);
        element.appendChild(element5);
        return element;
    }

    private static Element storeResourceCalendar(Document document, ResourceCalendarManager resourceCalendarManager, long l) {
        Element element = document.createElement(CALENDAR);
        Element element2 = XmlUtil.createTextElement(document, CALENDAR_ID, "" + l);
        Element element3 = XmlUtil.createTextElement(document, BASE_CALENDAR_ID, "" + (resourceCalendarManager.getId() + 1L));
        Element element4 = XmlUtil.createTextElement(document, CALENDAR_NAME, resourceCalendarManager.getResource().getName());
        Element element5 = XmlUtil.createTextElement(document, CALENDAR_IS_BASE_CALENDAR, "0");
        element.appendChild(element2);
        element.appendChild(element4);
        element.appendChild(element5);
        element.appendChild(element3);
        if (!resourceCalendarManager.getResourcePatternList().isEmpty()) {
            Element element6 = document.createElement(WEEK_PATTERN_LIST);
            CalendarLoader.storeSpecialPatternList(document, element6, resourceCalendarManager.getResourcePatternList());
            element.appendChild(element6);
        }
        return element;
    }

    private static Element storeWeekPatternList(Document document, Element element, DayWorkingPattern[] dayWorkingPatternArray) {
        for (int i = 0; i < dayWorkingPatternArray.length; ++i) {
            DayWorkingPattern dayWorkingPattern = dayWorkingPatternArray[i];
            Element element2 = CalendarLoader.storeDayPattern(document, i + 1, dayWorkingPattern);
            element.appendChild(element2);
        }
        return element;
    }

    private static Element storeSpecialPatternList(Document document, Element element, List list) {
        for (CalendarManager.SpecialDay specialDay : list) {
            Element element2 = CalendarLoader.storeDayPattern(document, specialDay.getDate(), specialDay.getDayPattern());
            element.appendChild(element2);
        }
        return element;
    }

    private static Element storeDayPattern(Document document, int n, DayWorkingPattern dayWorkingPattern) {
        PeriodInDay periodInDay;
        int n2;
        Element element = document.createElement(PATTERN);
        Element element2 = XmlUtil.createTextElement(document, PATTERN_TYPE, String.valueOf(n));
        element.appendChild(element2);
        Element element3 = dayWorkingPattern.isWorking() ? XmlUtil.createTextElement(document, PATTERN_WORKING, "1") : XmlUtil.createTextElement(document, PATTERN_WORKING, "0");
        element.appendChild(element3);
        Element element4 = null;
        PeriodInDay[] periodInDayArray = dayWorkingPattern.getPeriodsInDay();
        for (n2 = 0; n2 < periodInDayArray.length; ++n2) {
            periodInDay = periodInDayArray[n2];
            if (!periodInDay.isWorking()) continue;
            element4 = document.createElement(WORKING_TIMES);
            break;
        }
        if (element4 != null) {
            for (n2 = 0; n2 < periodInDayArray.length; ++n2) {
                periodInDay = periodInDayArray[n2];
                if (!periodInDay.isWorking()) continue;
                element4.appendChild(CalendarLoader.storePeriodInDay(document, periodInDay));
            }
            element.appendChild(element4);
        }
        return element;
    }

    private static Element storeDayPattern(Document document, Calendar calendar, DayWorkingPattern dayWorkingPattern) {
        PeriodInDay periodInDay;
        int n;
        Element element = document.createElement(PATTERN);
        Element element2 = XmlUtil.createTextElement(document, PATTERN_TYPE, "0");
        element.appendChild(element2);
        Element element3 = dayWorkingPattern.isWorking() ? XmlUtil.createTextElement(document, PATTERN_WORKING, "1") : XmlUtil.createTextElement(document, PATTERN_WORKING, "0");
        element.appendChild(element3);
        Element element4 = document.createElement(TIME_PERIOD);
        long l = CalendarManager.getDayStartTime(calendar);
        Element element5 = XmlUtil.createTextElement(document, FROM_DATE, dateFormat.format(new Date(l)));
        Element element6 = XmlUtil.createTextElement(document, TO_DATE, dateFormat.format(new Date(l + 86400000L - 1L)));
        element4.appendChild(element5);
        element4.appendChild(element6);
        element.appendChild(element4);
        Element element7 = null;
        PeriodInDay[] periodInDayArray = dayWorkingPattern.getPeriodsInDay();
        for (n = 0; n < periodInDayArray.length; ++n) {
            periodInDay = periodInDayArray[n];
            if (!periodInDay.isWorking()) continue;
            element7 = document.createElement(WORKING_TIMES);
            break;
        }
        if (element7 != null) {
            for (n = 0; n < periodInDayArray.length; ++n) {
                periodInDay = periodInDayArray[n];
                if (!periodInDay.isWorking()) continue;
                element7.appendChild(CalendarLoader.storePeriodInDay(document, periodInDay));
            }
            element.appendChild(element7);
        }
        return element;
    }

    private static Element storePeriodInDay(Document document, PeriodInDay periodInDay) {
        Element element = document.createElement(WORKING_TIME);
        long l = periodInDay.getStartPeriod();
        long l2 = l / 3600000L;
        long l3 = l % 3600000L / 60000L;
        long l4 = l % 3600000L % 60000L / 1000L;
        Element element2 = XmlUtil.createTextElement(document, FROM_TIME, periodFormat.format(l2) + ":" + periodFormat.format(l3) + ":" + periodFormat.format(l4));
        long l5 = periodInDay.getEndPeriod();
        l2 = l5 / 3600000L;
        l3 = l5 % 3600000L / 60000L;
        l4 = l5 % 3600000L % 60000L / 1000L;
        Element element3 = XmlUtil.createTextElement(document, TO_TIME, periodFormat.format(l2) + ":" + periodFormat.format(l3) + ":" + periodFormat.format(l4));
        element.appendChild(element2);
        element.appendChild(element3);
        return element;
    }
}

