/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.dB.msproject.xml;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.baseline.Baseline;
import com.sbs.xml.XmlUtil;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BaselineLoader {
    public static final String BASELINE = "Baseline";
    private static final String BASELINE_NO = "Number";
    private static final String BASELINE_START = "Start";
    private static final String BASELINE_END = "Finish";
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    private static Node getChildNode(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(string) != 0) continue;
            return node2;
        }
        return null;
    }

    public static void loadBaseline(Task task, Node node) {
        Node node2 = BaselineLoader.getChildNode(node, BASELINE_NO);
        if (node2 != null) {
            Baseline baseline = new Baseline();
            int n = Integer.parseInt(XmlUtil.getTextFromNode(node2));
            if (n >= 10) {
                return;
            }
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Date date;
                String string;
                Node node3 = nodeList.item(i);
                if (node3.getNodeType() != 1) continue;
                if (node3.getNodeName().compareTo(BASELINE_START) == 0) {
                    string = XmlUtil.getTextFromNode(node3);
                    date = null;
                    try {
                        date = dateFormat.parse(string);
                    }
                    catch (ParseException parseException) {
                        Common.logException("Error:", parseException);
                    }
                    baseline.setStartDate(date);
                    baseline.setCompletion(0.0);
                    baseline.setCompletionDate(date);
                    continue;
                }
                if (node3.getNodeName().compareTo(BASELINE_END) != 0) continue;
                string = XmlUtil.getTextFromNode(node3);
                date = null;
                try {
                    date = dateFormat.parse(string);
                }
                catch (ParseException parseException) {
                    Common.logException("Error:", parseException);
                }
                baseline.setEndDate(date);
            }
            task.setBaselineAt(n, baseline);
        }
    }

    public static void storeBaselineList(Document document, Element element, Task task) {
        for (int i = 0; i < 10; ++i) {
            Baseline baseline = task.getBaselineAt(i);
            if (baseline == null) continue;
            element.appendChild(BaselineLoader.storeBaseline(document, baseline, i));
        }
    }

    private static Element storeBaseline(Document document, Baseline baseline, int n) {
        Element element = document.createElement(BASELINE);
        Element element2 = XmlUtil.createTextElement(document, BASELINE_NO, "" + n);
        Element element3 = XmlUtil.createTextElement(document, BASELINE_START, dateFormat.format(baseline.getStartDate()));
        Element element4 = XmlUtil.createTextElement(document, BASELINE_END, dateFormat.format(baseline.getEndDate()));
        element.appendChild(element2);
        element.appendChild(element3);
        element.appendChild(element4);
        return element;
    }
}

