/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.dB.msproject.xml;

import com.sbs.jpm.Common;
import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.calendar.Period;
import com.sbs.jpm.core.Assignment;
import com.sbs.jpm.core.MaterialResource;
import com.sbs.jpm.core.Resource;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.dB.ResourceCollection;
import com.sbs.jpm.dB.TaskCollection;
import com.sbs.xml.XmlUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AssignmentLoader {
    private static final String ASSIGNMENT_ID = "UID";
    private static final String ASSIGNMENT_TASK_ID = "TaskUID";
    private static final String ASSIGNMENT_RESOURCE_ID = "ResourceUID";
    private static final String ASSIGNMENT_UNITS = "Units";
    public static final String ASSIGNMENT_LIST = "Assignments";
    private static final String ASSIGNMENT = "Assignment";
    private static final String TIMEPHASED_DATA = "TimephasedData";
    private static final String TIMEPHASED_DATA_TYPE = "Type";
    private static final String TIMEPHASED_DATA_ID = "UID";
    private static final String TIMEPHASED_DATA_START = "Start";
    private static final String TIMEPHASED_DATA_FINISH = "Finish";
    private static final String TIMEPHASED_DATA_UNIT = "Unit";
    private static final String TIMEPHASED_DATA_VALUE = "Value";
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private TaskCollection taskCollection;
    private ResourceCollection resourceCollection;
    private static int id;

    public AssignmentLoader(TaskCollection taskCollection, ResourceCollection resourceCollection) {
        this.taskCollection = taskCollection;
        this.resourceCollection = resourceCollection;
    }

    private static Node getChildNode(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(string) != 0) continue;
            return node2;
        }
        return null;
    }

    public void loadAssignmentList(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(ASSIGNMENT) != 0) continue;
            this.loadAssignment(node2);
        }
    }

    private void loadAssignment(Node node) {
        Node node2 = AssignmentLoader.getChildNode(node, ASSIGNMENT_RESOURCE_ID);
        Node node3 = AssignmentLoader.getChildNode(node, ASSIGNMENT_TASK_ID);
        Node node4 = AssignmentLoader.getChildNode(node, ASSIGNMENT_UNITS);
        long l = Long.valueOf(XmlUtil.getTextFromNode(node2));
        if (l < 0L) {
            return;
        }
        Task task = this.taskCollection.getTaskForId((long)Long.valueOf(XmlUtil.getTextFromNode(node3)));
        Resource resource = this.resourceCollection.getResourceForId(l);
        double d = Double.valueOf(XmlUtil.getTextFromNode(node4));
        if (task.isSplitted()) {
            for (Task task2 : task.getChildList()) {
                Assignment assignment = new Assignment(Common.getIdGenerator().getNewId());
                assignment.setTask(task2);
                assignment.setResource(resource);
                assignment.setUnits(d);
                assignment.getTask().addAssignment(assignment);
                assignment.getResource().addAssignment(assignment);
            }
        } else {
            Assignment assignment = new Assignment(Common.getIdGenerator().getNewId());
            assignment.setTask(task);
            assignment.setResource(resource);
            assignment.setUnits(d);
            assignment.getTask().addAssignment(assignment);
            assignment.getResource().addAssignment(assignment);
        }
    }

    public Element storeAssignmentList(Document document, Task task) {
        Element element = document.createElement(ASSIGNMENT_LIST);
        id = 0;
        this.storeAssignmentList(document, element, task);
        return element;
    }

    private void storeAssignmentList(Document document, Element element, Task task) {
        for (Assignment uniqueId : task.getAssignments()) {
            Element element2 = this.storeAssignment(document, uniqueId);
            element.appendChild(element2);
        }
        for (Task task2 : task.getChildList()) {
            this.storeAssignmentList(document, element, task2);
        }
    }

    private void storeTimePhasedData(Document document, Element element, Assignment assignment) {
        Task task = assignment.getTask();
        CalendarManager calendarManager = task.getUsedCalendar();
        for (Period period : calendarManager.getPeriods(task.getStartDate(), task.getEndDate())) {
            Element element2 = document.createElement(TIMEPHASED_DATA);
            Element element3 = XmlUtil.createTextElement(document, "UID", "" + id);
            Element element4 = XmlUtil.createTextElement(document, TIMEPHASED_DATA_TYPE, "1");
            Element element5 = XmlUtil.createTextElement(document, TIMEPHASED_DATA_START, dateFormat.format(new Date(period.getStartPeriod())));
            Element element6 = XmlUtil.createTextElement(document, TIMEPHASED_DATA_FINISH, dateFormat.format(new Date(period.getEndPeriod())));
            long l = assignment.getResource() instanceof MaterialResource ? period.getDuration() * 3600000L / task.getWorkingDuration() : period.getDuration();
            long l2 = l / 3600000L;
            long l3 = l % 3600000L / 60000L;
            long l4 = l % 3600000L % 60000L / 1000L;
            Element element7 = XmlUtil.createTextElement(document, TIMEPHASED_DATA_UNIT, "8");
            Element element8 = XmlUtil.createTextElement(document, TIMEPHASED_DATA_VALUE, "PT" + l2 + "H" + l3 + "M" + l4 + "S");
            element2.appendChild(element3);
            element2.appendChild(element4);
            element2.appendChild(element5);
            element2.appendChild(element6);
            element2.appendChild(element7);
            if (period.getType()) {
                element2.appendChild(element8);
            }
            element.appendChild(element2);
        }
    }

    private Element storeAssignment(Document document, Assignment assignment) {
        Element element = document.createElement(ASSIGNMENT);
        Element element2 = XmlUtil.createTextElement(document, "UID", "" + id);
        Element element3 = XmlUtil.createTextElement(document, ASSIGNMENT_TASK_ID, "" + assignment.getTask().getId());
        Element element4 = XmlUtil.createTextElement(document, ASSIGNMENT_RESOURCE_ID, "" + assignment.getResource().getId());
        Element element5 = XmlUtil.createTextElement(document, ASSIGNMENT_UNITS, "" + assignment.getUnits());
        element.appendChild(element2);
        element.appendChild(element3);
        element.appendChild(element4);
        element.appendChild(element5);
        this.storeTimePhasedData(document, element, assignment);
        ++id;
        return element;
    }
}

