/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.core.io;

import com.sbs.jpm.Common;
import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.calendar.DayWorkingPattern;
import com.sbs.jpm.calendar.PeriodInDay;
import com.sbs.jpm.core.Assignment;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Dependency;
import com.sbs.jpm.core.DurationManager;
import com.sbs.jpm.core.HumanResource;
import com.sbs.jpm.core.InvalidOperationException;
import com.sbs.jpm.core.MaterialResource;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.TaskPlanner;
import com.sbs.jpm.core.baseline.Baseline;
import com.sbs.jpm.core.constraint.ALAP;
import com.sbs.jpm.core.constraint.ASAP;
import com.sbs.jpm.core.constraint.FNET;
import com.sbs.jpm.core.constraint.FNLT;
import com.sbs.jpm.core.constraint.MFO;
import com.sbs.jpm.core.constraint.MSO;
import com.sbs.jpm.core.constraint.SNET;
import com.sbs.jpm.core.constraint.SNLT;
import com.sbs.jpm.core.io.ProjectIOException;
import com.sbs.jpm.core.io.ProjectIOMSP;
import com.sbs.jpm.dB.msproject.xml.ProjectLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Rate;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.mspdi.MSPDIReader;
import net.sf.mpxj.mspdi.MSPDIWriter;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ProjectIOMSXML
extends ProjectIOMSP {
    ProjectIOMSXML() {
    }

    private Company loadProject(Node node) throws Exception {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            if (node2.getNodeName().compareTo("Project") == 0) {
                Company company = new Company();
                Task task = ProjectLoader.loadProject(node2, company);
                company.setRootTask(task);
                company.setLoaded(true);
                this.updateCompletions(company.getRootTask());
                ProjectIOMSXML.updateSplittedTasks(company.getRootTask());
                company.computeTasksId();
                company.computeResourceId();
                TaskPlanner.forceTree(company.getRootTask(), false);
                for (HumanResource humanResource : company.getHumanResources()) {
                    if (humanResource.isEmpty()) continue;
                    for (Assignment assignment : humanResource.getAssignments()) {
                        Task task2 = assignment.getTask();
                        assignment.start(task2.getStartDate(), task2.getEndDate(), task2.getCompletionDate());
                    }
                    humanResource.computeWorkIntervals();
                }
                company.computeCriticalPath();
                return company;
            }
            throw new ProjectIOException(Common.I18N_MESSAGES.getString("file.invalidFormat"));
        }
        return new Company();
    }

    public Company load(InputStream inputStream) throws ProjectIOException {
        boolean bl = false;
        if (bl) {
            ProjectFile projectFile = null;
            try {
                projectFile = new MSPDIReader().read(inputStream);
                Company company = this.loadProject(projectFile);
                return company;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                Common.logException("Error loading input stream:", throwable);
                throw new ProjectIOException(throwable.getLocalizedMessage());
            }
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            StreamSource streamSource = new StreamSource(this.getClass().getClassLoader().getResourceAsStream("com/sbs/jpm/core/io/mspdi.xsd"));
            Schema schema = schemaFactory.newSchema(streamSource);
            Validator validator = schema.newValidator();
            Company company = this.loadProject(document);
            return company;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Common.logException("Error loading input stream:", throwable);
            throw new ProjectIOException(throwable.getLocalizedMessage());
        }
    }

    private static void updateSplittedTasks(Task task) {
        if (!task.isEmpty() && !task.isLeaf()) {
            if (task.isSplitted()) {
                task.setConstraint(task.getConstraint());
            } else {
                for (int i = 0; i < task.getChildNumber(); ++i) {
                    Task task2 = task.getChildAt(i);
                    ProjectIOMSXML.updateSplittedTasks(task2);
                }
            }
        }
    }

    protected void storeDayPattern(ProjectCalendarHours projectCalendarHours, DayWorkingPattern dayWorkingPattern) throws InvalidOperationException {
        for (int i = 0; i < dayWorkingPattern.getPeriodsInDay().length; ++i) {
            PeriodInDay periodInDay = dayWorkingPattern.getPeriodInDayAt(i);
            if (!periodInDay.isWorking()) continue;
            Calendar calendar = Calendar.getInstance();
            long l = CalendarManager.getDayStartTime(calendar);
            calendar.setTimeInMillis(l + periodInDay.getStartPeriod());
            Date date = calendar.getTime();
            calendar.setTimeInMillis(l + periodInDay.getEndPeriod());
            Date date2 = calendar.getTime();
            DateRange dateRange = new DateRange(date, date2);
            projectCalendarHours.addRange(dateRange);
        }
    }

    private void saveTaskDependencies(Task task, Task task2, ProjectFile projectFile) {
        net.sf.mpxj.Task task3 = projectFile.getTaskByUniqueID(Integer.valueOf(task.getId().intValue()));
        for (Dependency mouseHoover : task.getPredecessorDependencies()) {
            Object[] objectArray;
            if (mouseHoover.getPredecessor().isDescendent(task2)) {
                objectArray = task3.addPredecessor(projectFile.getTaskByUniqueID(Integer.valueOf(mouseHoover.getPredecessor().getId().intValue())));
                if (mouseHoover.getType() == 0) {
                    objectArray.setType(RelationType.FINISH_START);
                } else if (mouseHoover.getType() == 3) {
                    objectArray.setType(RelationType.FINISH_FINISH);
                } else if (mouseHoover.getType() == 2) {
                    objectArray.setType(RelationType.START_FINISH);
                } else if (mouseHoover.getType() == 1) {
                    objectArray.setType(RelationType.START_START);
                }
                double d = mouseHoover.getTaskDelay();
                if (mouseHoover.getUnit().equals(DurationManager.MINUTE)) {
                    objectArray.setDuration(Duration.getInstance((double)(d / (double)task2.getDurationManager().getDuration(DurationManager.MINUTE)), (TimeUnit)TimeUnit.MINUTES));
                    continue;
                }
                if (mouseHoover.getUnit().equals(DurationManager.HOUR)) {
                    objectArray.setDuration(Duration.getInstance((double)(d / (double)task2.getDurationManager().getDuration(DurationManager.HOUR)), (TimeUnit)TimeUnit.HOURS));
                    continue;
                }
                if (mouseHoover.getUnit().equals(DurationManager.DAY)) {
                    objectArray.setDuration(Duration.getInstance((double)(d / (double)task2.getDurationManager().getDuration(DurationManager.DAY)), (TimeUnit)TimeUnit.DAYS));
                    continue;
                }
                if (!mouseHoover.getUnit().equals(DurationManager.WEEK)) continue;
                objectArray.setDuration(Duration.getInstance((double)(d / (double)task2.getDurationManager().getDuration(DurationManager.WEEK)), (TimeUnit)TimeUnit.WEEKS));
                continue;
            }
            objectArray = new Object[]{task.getName(), mouseHoover.getPredecessor().getName()};
            JOptionPane.showMessageDialog(null, MessageFormat.format(Common.I18N_MESSAGES.getString("dependency.externalDependency.message"), objectArray), Common.I18N_MESSAGES.getString("dependency.externalDependency.title"), 2);
        }
        if (!task.isSplitted()) {
            for (int i = 0; i < task.getChildNumber(); ++i) {
                Task task4 = task.getChildAt(i);
                this.saveTaskDependencies(task4, task2, projectFile);
            }
        }
    }

    private void saveTask(Task task, net.sf.mpxj.Task task2, Task task3, ProjectFile projectFile, int n, String string) {
        net.sf.mpxj.Task task4 = task2 == null ? projectFile.addTask() : task2.addTask();
        if (task.isEmpty()) {
            task4.setNull(true);
        } else {
            ResourceAssignment resourceAssignment;
            task4.setNull(false);
            task4.setOutlineLevel(Integer.valueOf(n));
            task4.setOutlineNumber(string);
            task4.setWBS(string);
            task4.setName(task.getName());
            task4.setUniqueID(Integer.valueOf(task.getId().intValue()));
            task4.setFixedCost((Number)task.getFixedCost());
            if (task.getAccrual().equals(Task.START)) {
                task4.setFixedCostAccrual(AccrueType.START);
            } else if (task.getAccrual().equals(Task.END)) {
                task4.setFixedCostAccrual(AccrueType.END);
            } else if (task.getAccrual().equals(Task.PRORATED)) {
                task4.setFixedCostAccrual(AccrueType.PRORATED);
            }
            if (task.getCalendar() != null) {
                task4.setCalendar(projectFile.getBaseCalendarByUniqueID(Integer.valueOf(task.getCalendar().getId().intValue())));
            }
            task4.setNotes(task.getNotes());
            task4.setMilestone(task.isMilestone());
            TimeUnit timeUnit = TimeUnit.DAYS;
            double d = task.isLeaf() || task.isSplitted() ? (double)task.getDuration() : (double)task.getWorkingDuration();
            DurationManager durationManager = task.getProjectTask().getDurationManager();
            if (task.getDurationUnit().equals(DurationManager.MINUTE)) {
                timeUnit = TimeUnit.MINUTES;
                d /= (double)durationManager.getDuration(DurationManager.MINUTE);
            } else if (task.getDurationUnit().equals(DurationManager.HOUR)) {
                timeUnit = TimeUnit.HOURS;
                d /= (double)durationManager.getDuration(DurationManager.HOUR);
            } else if (task.getDurationUnit().equals(DurationManager.DAY)) {
                timeUnit = TimeUnit.DAYS;
                d /= (double)durationManager.getDuration(DurationManager.DAY);
            } else if (task.getDurationUnit().equals(DurationManager.WEEK)) {
                timeUnit = TimeUnit.WEEKS;
                d /= (double)durationManager.getDuration(DurationManager.WEEK);
            }
            task4.setDuration(Duration.getInstance((double)d, (TimeUnit)timeUnit));
            TimeUnit timeUnit2 = TimeUnit.DAYS;
            double d2 = task.isLeaf() || task.isSplitted() ? (double)task.getWork() : (double)task.getWorkExceptChildren();
            if (task.getWorkUnit().equals(DurationManager.MINUTE)) {
                timeUnit2 = TimeUnit.MINUTES;
                d2 /= (double)durationManager.getDuration(DurationManager.MINUTE);
            } else if (task.getWorkUnit().equals(DurationManager.HOUR)) {
                timeUnit2 = TimeUnit.HOURS;
                d2 /= (double)durationManager.getDuration(DurationManager.HOUR);
            } else if (task.getWorkUnit().equals(DurationManager.DAY)) {
                timeUnit2 = TimeUnit.DAYS;
                d2 /= (double)durationManager.getDuration(DurationManager.DAY);
            } else if (task.getWorkUnit().equals(DurationManager.WEEK)) {
                timeUnit2 = TimeUnit.WEEKS;
                d2 /= (double)durationManager.getDuration(DurationManager.WEEK);
            }
            task4.setWork(Duration.getInstance((double)d2, (TimeUnit)timeUnit2));
            if (task.getConstraint() instanceof ASAP) {
                task4.setConstraintType(ConstraintType.AS_SOON_AS_POSSIBLE);
            } else if (task.getConstraint() instanceof ALAP) {
                task4.setConstraintType(ConstraintType.AS_LATE_AS_POSSIBLE);
            } else if (task.getConstraint() instanceof SNET) {
                task4.setConstraintType(ConstraintType.START_NO_EARLIER_THAN);
                task4.setConstraintDate(task.getConstraint().getDate());
            } else if (task.getConstraint() instanceof SNLT) {
                task4.setConstraintType(ConstraintType.START_NO_LATER_THAN);
                task4.setConstraintDate(task.getConstraint().getDate());
            } else if (task.getConstraint() instanceof FNET) {
                task4.setConstraintType(ConstraintType.FINISH_NO_EARLIER_THAN);
                task4.setConstraintDate(task.getConstraint().getDate());
            } else if (task.getConstraint() instanceof FNLT) {
                task4.setConstraintType(ConstraintType.FINISH_NO_LATER_THAN);
                task4.setConstraintDate(task.getConstraint().getDate());
            } else if (task.getConstraint() instanceof MSO) {
                task4.setConstraintType(ConstraintType.MUST_START_ON);
                task4.setConstraintDate(task.getConstraint().getDate());
            } else if (task.getConstraint() instanceof MFO) {
                task4.setConstraintType(ConstraintType.MUST_FINISH_ON);
                task4.setConstraintDate(task.getConstraint().getDate());
            }
            if (task.getDeadlineDate() != null) {
                task4.setDeadline(task4.getDeadline());
            }
            task4.setStart(task.getStartDate());
            task4.setFinish(task.getEndDate());
            task4.setIgnoreResourceCalendar(task.isForcedWorking());
            task4.setPercentageComplete((Number)task.getCompletion());
            task4.setPercentageWorkComplete((Number)task.getWorkCompletion());
            task4.setStop(task.getCompletionDate());
            task4.setExpanded(task.isExpanded());
            task4.setEffortDriven(task.isWorkDriven());
            if (task.isWorkDriven()) {
                if (task.isFixedUnits()) {
                    task4.setType(TaskType.FIXED_UNITS);
                } else {
                    task4.setType(TaskType.FIXED_WORK);
                }
            } else if (task.isFixedUnits()) {
                task4.setType(TaskType.FIXED_UNITS);
            } else {
                task4.setType(TaskType.FIXED_DURATION);
            }
            if (task4.getType().compareTo((Enum)TaskType.FIXED_UNITS) == 0) {
                task.setWorkDriven(task4.getEffortDriven());
                task.setFixedUnits(true);
            } else if (task4.getType().compareTo((Enum)TaskType.FIXED_DURATION) == 0) {
                task.setWorkDriven(task4.getEffortDriven());
                task.setFixedUnits(false);
            } else if (task4.getType().compareTo((Enum)TaskType.FIXED_WORK) == 0) {
                task.setWorkDriven(true);
                task.setFixedUnits(false);
            }
            if (task.isSplitted()) {
                Iterator<Assignment> iterator = task.getChildAt(task.getChildNumber() - 1);
                LinkedList<DateRange> serializable2 = new LinkedList<DateRange>();
                for (Task task5 : task.getChildList()) {
                    DateRange dateRange = new DateRange(task5.getStartDate(), task5.getEndDate());
                    serializable2.add(dateRange);
                    if (task5.equals(iterator)) continue;
                    serializable2.add(DateRange.EMPTY_RANGE);
                }
                task4.setSplits(serializable2);
                task4.setExpanded(false);
            }
            if (task.isSplitted()) {
                for (Assignment assignment : task.getChildAt(0).getAssignments()) {
                    resourceAssignment = task4.addResourceAssignment(projectFile.getResourceByUniqueID(Integer.valueOf((int)assignment.getResource().getId())));
                    resourceAssignment.setUnits((Number)(assignment.getUnits() * 100.0));
                }
            } else {
                for (Assignment assignment : task.getAssignments()) {
                    resourceAssignment = task4.addResourceAssignment(projectFile.getResourceByUniqueID(Integer.valueOf((int)assignment.getResource().getId())));
                    resourceAssignment.setUnits((Number)(assignment.getUnits() * 100.0));
                }
            }
            for (int i = 0; i < 10; ++i) {
                Baseline baseline = task.getBaselineAt(i);
                if (baseline == null) continue;
                task4.setBaselineStart(i + 1, task.getBaselineAt(i).getStartDate());
                task4.setBaselineFinish(i + 1, task.getBaselineAt(i).getEndDate());
            }
        }
        if (!task.isSplitted()) {
            for (int i = 0; i < task.getChildNumber(); ++i) {
                Task task6 = task.getChildAt(i);
                if (string.equals("0")) {
                    this.saveTask(task6, task4, task3, projectFile, n + 1, "" + (i + 1));
                    continue;
                }
                this.saveTask(task6, task4, task3, projectFile, n + 1, string + "." + (i + 1));
            }
        }
    }

    public void saveProject(Task task, ProjectFile projectFile, boolean bl) {
        PeriodInDay[] periodInDayArray;
        Date date;
        Object object;
        ProjectCalendar projectCalendar;
        Company company = task.getCompany();
        ProjectHeader projectHeader = projectFile.getProjectHeader();
        projectHeader.setProjectTitle(task.getName());
        projectHeader.setManager(task.getManager());
        projectHeader.setStartDate(task.getConstraint().getDate());
        projectHeader.setFinishDate(task.getEndDate());
        projectHeader.setCriticalSlackLimit(Integer.valueOf((int)(task.getCriticalSlackLimit() / 86400000L)));
        projectHeader.setCurrencySymbol(task.getCurrencyUnit());
        projectHeader.setMinutesPerDay((Number)(task.getDurationManager().getDuration(DurationManager.DAY) / 60000L));
        projectHeader.setMinutesPerWeek((Number)(task.getDurationManager().getDuration(DurationManager.WEEK) / 60000L));
        for (CalendarManager uniqueId : company.getCalendarList()) {
            projectCalendar = projectFile.addBaseCalendar();
            projectCalendar.setName(uniqueId.getName());
            projectCalendar.setUniqueID(Integer.valueOf(uniqueId.getId().intValue() + 1));
            try {
                Object d = projectCalendar.addCalendarHours(Day.MONDAY);
                DayWorkingPattern dayWorkingPattern = uniqueId.getDayPattern(2);
                this.storeDayPattern((ProjectCalendarHours)d, dayWorkingPattern);
                projectCalendar.setWorkingDay(Day.MONDAY, dayWorkingPattern.isWorking());
                d = projectCalendar.addCalendarHours(Day.TUESDAY);
                DayWorkingPattern dayWorkingPattern2 = uniqueId.getDayPattern(3);
                this.storeDayPattern((ProjectCalendarHours)d, dayWorkingPattern2);
                projectCalendar.setWorkingDay(Day.TUESDAY, dayWorkingPattern2.isWorking());
                d = projectCalendar.addCalendarHours(Day.WEDNESDAY);
                DayWorkingPattern dayWorkingPattern3 = uniqueId.getDayPattern(4);
                this.storeDayPattern((ProjectCalendarHours)d, dayWorkingPattern3);
                projectCalendar.setWorkingDay(Day.WEDNESDAY, dayWorkingPattern3.isWorking());
                d = projectCalendar.addCalendarHours(Day.THURSDAY);
                DayWorkingPattern dayWorkingPattern4 = uniqueId.getDayPattern(5);
                this.storeDayPattern((ProjectCalendarHours)d, dayWorkingPattern4);
                projectCalendar.setWorkingDay(Day.THURSDAY, dayWorkingPattern4.isWorking());
                d = projectCalendar.addCalendarHours(Day.FRIDAY);
                DayWorkingPattern dayWorkingPattern5 = uniqueId.getDayPattern(6);
                this.storeDayPattern((ProjectCalendarHours)d, dayWorkingPattern5);
                projectCalendar.setWorkingDay(Day.FRIDAY, dayWorkingPattern5.isWorking());
                d = projectCalendar.addCalendarHours(Day.SATURDAY);
                DayWorkingPattern dayWorkingPattern6 = uniqueId.getDayPattern(7);
                this.storeDayPattern((ProjectCalendarHours)d, dayWorkingPattern6);
                projectCalendar.setWorkingDay(Day.SATURDAY, dayWorkingPattern6.isWorking());
                d = projectCalendar.addCalendarHours(Day.SUNDAY);
                DayWorkingPattern dayWorkingPattern7 = uniqueId.getDayPattern(1);
                this.storeDayPattern((ProjectCalendarHours)d, dayWorkingPattern7);
                projectCalendar.setWorkingDay(Day.SUNDAY, dayWorkingPattern7.isWorking());
            }
            catch (InvalidOperationException invalidOperationException) {
                Common.logException("Error:", invalidOperationException);
            }
            for (CalendarManager.SpecialDay specialDay : uniqueId.getSpecialPatternList()) {
                DayWorkingPattern dayWorkingPattern = specialDay.getDayPattern();
                ProjectCalendarException projectCalendarException = projectCalendar.addCalendarException();
                object = dayWorkingPattern.getPeriodsInDay();
                for (int i = 0; i < ((PeriodInDay[])object).length; ++i) {
                    PeriodInDay periodInDay = object[i];
                    long l = CalendarManager.getDayStartTime(c);
                    date = new Date(l + periodInDay.getStartPeriod());
                    periodInDayArray = new Date(l + periodInDay.getEndPeriod());
                    DateRange dateRange = new DateRange(date, (Date)periodInDayArray);
                    projectCalendarException.addRange(dateRange);
                }
                projectCalendarException.setWorking(dayWorkingPattern.isWorking());
                projectCalendarException.setFromDate(specialDay.getDate().getTime());
                projectCalendarException.setToDate(specialDay.getDate().getTime());
            }
        }
        projectHeader.setCalendarName(task.getCalendar() != null ? task.getCalendar().getName() : company.getCalendarManager().getName());
        for (HumanResource humanResource : company.getHumanResources()) {
            projectCalendar = projectFile.addResource();
            if (humanResource.isEmpty()) {
                projectCalendar.setIsNull(true);
                continue;
            }
            projectCalendar.setIsNull(false);
            projectCalendar.setType(ResourceType.WORK);
            projectCalendar.setUniqueID(Integer.valueOf((int)humanResource.getId()));
            if (humanResource.getName() != null) {
                projectCalendar.setName(humanResource.getName());
            }
            if (humanResource.getCode() != null) {
                projectCalendar.setCode(humanResource.getCode());
            }
            if (humanResource.getEmail() != null) {
                projectCalendar.setEmailAddress(humanResource.getEmail());
            }
            projectCalendar.setMaxUnits((Number)(humanResource.getMaxUnits() * 100.0));
            double d = humanResource.getStandardRate();
            projectCalendar.setStandardRate(new Rate(d, TimeUnit.HOURS));
            double d2 = humanResource.getOvertimeRate();
            projectCalendar.setOvertimeRate(new Rate(d2, TimeUnit.HOURS));
            object = humanResource.getNotes();
            if (object != null && ((String)object).length() != 0) {
                projectCalendar.setNotes(humanResource.getNotes());
            }
            if (humanResource.getResourceCalendar().getResourcePatternList().isEmpty()) continue;
            ProjectCalendar projectCalendar2 = projectFile.addResourceCalendar();
            projectCalendar2.setBaseCalendar(projectFile.getBaseCalendarByUniqueID(Integer.valueOf(humanResource.getResourceCalendar().getId().intValue())));
            for (CalendarManager.SpecialDay specialDay : humanResource.getResourceCalendar().getResourcePatternList()) {
                DayWorkingPattern dayWorkingPattern = specialDay.getDayPattern();
                date = projectCalendar2.addCalendarException();
                periodInDayArray = dayWorkingPattern.getPeriodsInDay();
                for (int i = 0; i < periodInDayArray.length; ++i) {
                    PeriodInDay periodInDay = periodInDayArray[i];
                    long l = CalendarManager.getDayStartTime(c);
                    Date date2 = new Date(l + periodInDay.getStartPeriod());
                    Date date3 = new Date(l + periodInDay.getEndPeriod());
                    DateRange dateRange = new DateRange(date2, date3);
                    date.addRange(dateRange);
                }
                date.setWorking(dayWorkingPattern.isWorking());
                date.setFromDate(specialDay.getDate().getTime());
                date.setToDate(specialDay.getDate().getTime());
            }
        }
        for (MaterialResource materialResource : company.getMaterialResources()) {
            projectCalendar = projectFile.addResource();
            if (materialResource.isEmpty()) {
                projectCalendar.setIsNull(true);
                continue;
            }
            projectCalendar.setIsNull(false);
            projectCalendar.setType(ResourceType.MATERIAL);
            projectCalendar.setUniqueID(Integer.valueOf((int)materialResource.getId()));
            if (materialResource.getName() != null) {
                projectCalendar.setName(materialResource.getName());
            }
            if (materialResource.getCode() != null) {
                projectCalendar.setCode(materialResource.getCode());
            }
            double d = materialResource.getStandardRate();
            projectCalendar.setStandardRate(new Rate(d, TimeUnit.HOURS));
            String string = materialResource.getNotes();
            if (string == null || string.length() == 0) continue;
            projectCalendar.setNotes(materialResource.getNotes());
        }
        this.saveTask(task, null, task, projectFile, 0, "0");
        this.saveTaskDependencies(task, task, projectFile);
    }

    public void save(Company company, OutputStream outputStream, boolean bl) throws ProjectIOException {
        boolean bl2 = false;
        if (bl2) {
            MSPDIWriter mSPDIWriter = new MSPDIWriter();
            try {
                ProjectFile projectFile = new ProjectFile();
                this.saveProject(company.getRootTask(), projectFile, bl);
                mSPDIWriter.write(projectFile, outputStream);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                Common.logException("Error:", iOException);
                JOptionPane.showMessageDialog(null, iOException.getLocalizedMessage(), Common.I18N_MESSAGES.getString("file.failedToSave"), 0);
            }
        } else {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
                Document document = dOMImplementation.createDocument("http://schemas.microsoft.com/project", "Project", null);
                ProjectLoader.storeProject(document, company.getRootTask());
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("standalone", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                DOMSource dOMSource = new DOMSource(document);
                StreamResult streamResult = new StreamResult(outputStream);
                transformer.transform(dOMSource, streamResult);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                parserConfigurationException.printStackTrace();
                Common.logException("Error:", parserConfigurationException);
                JOptionPane.showMessageDialog(null, parserConfigurationException.getLocalizedMessage(), Common.I18N_MESSAGES.getString("file.failedToSave"), 0);
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                transformerConfigurationException.printStackTrace();
                Common.logException("Error:", transformerConfigurationException);
                JOptionPane.showMessageDialog(null, transformerConfigurationException.getMessage(), Common.I18N_MESSAGES.getString("file.failedToSave"), 0);
            }
            catch (TransformerException transformerException) {
                transformerException.printStackTrace();
                Common.logException("Error:", transformerException);
                JOptionPane.showMessageDialog(null, transformerException.getMessage(), Common.I18N_MESSAGES.getString("file.failedToSave"), 0);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                Common.logException("Error:", throwable);
                JOptionPane.showMessageDialog(null, throwable.getMessage(), Common.I18N_MESSAGES.getString("file.failedToSave"), 0);
            }
        }
    }

    public void save(Task task, OutputStream outputStream, boolean bl) throws ProjectIOException {
        boolean bl2 = false;
        if (bl2) {
            MSPDIWriter mSPDIWriter = new MSPDIWriter();
            try {
                ProjectFile projectFile = new ProjectFile();
                this.saveProject(task, projectFile, bl);
                mSPDIWriter.write(projectFile, outputStream);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                Common.logException("Error:", iOException);
                JOptionPane.showMessageDialog(null, iOException.getLocalizedMessage(), Common.I18N_MESSAGES.getString("file.failedToSave"), 0);
            }
        } else {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
                Document document = dOMImplementation.createDocument("http://schemas.microsoft.com/project", "Project", null);
                ProjectLoader.storeProject(document, task);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                DOMSource dOMSource = new DOMSource(document);
                StreamResult streamResult = new StreamResult(outputStream);
                transformer.transform(dOMSource, streamResult);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                Common.logException("Error:", parserConfigurationException);
                parserConfigurationException.printStackTrace();
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                Common.logException("Error:", transformerConfigurationException);
                transformerConfigurationException.printStackTrace();
            }
            catch (TransformerException transformerException) {
                Common.logException("Error:", transformerException);
                transformerException.printStackTrace();
            }
        }
    }
}

