/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.core.io;

import com.sbs.jpm.Common;
import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.calendar.DayWorkingPattern;
import com.sbs.jpm.calendar.PeriodInDay;
import com.sbs.jpm.calendar.RemainingDuration;
import com.sbs.jpm.calendar.ResourceCalendarManager;
import com.sbs.jpm.calendar.StandardCalendarManager;
import com.sbs.jpm.core.Assignment;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Dependency;
import com.sbs.jpm.core.DurationManager;
import com.sbs.jpm.core.HumanResource;
import com.sbs.jpm.core.InvalidOperationException;
import com.sbs.jpm.core.MaterialResource;
import com.sbs.jpm.core.Resource;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.TaskPlanner;
import com.sbs.jpm.core.baseline.Baseline;
import com.sbs.jpm.core.baseline.ProjectBaseline;
import com.sbs.jpm.core.constraint.ASAP;
import com.sbs.jpm.core.constraint.FNET;
import com.sbs.jpm.core.constraint.FNLT;
import com.sbs.jpm.core.constraint.MFO;
import com.sbs.jpm.core.constraint.MSO;
import com.sbs.jpm.core.constraint.SNET;
import com.sbs.jpm.core.constraint.SNLT;
import com.sbs.jpm.core.io.ProjectIO;
import com.sbs.jpm.core.io.ProjectIOException;
import com.sbs.jpm.dB.CalendarCollection;
import com.sbs.jpm.dB.ResourceCollection;
import com.sbs.jpm.dB.TaskCollection;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectDateFormat;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Rate;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.mpx.MPXReader;
import net.sf.mpxj.mpx.MPXWriter;

class ProjectIOMSMPX
implements ProjectIO {
    private static Calendar c = Calendar.getInstance();
    private CalendarCollection calendarCollection;
    private TaskCollection taskCollection;
    private Map<net.sf.mpxj.Task, Task> msTaskToTaskMap = new HashMap<net.sf.mpxj.Task, Task>();

    ProjectIOMSMPX() {
    }

    private Task loadProject(ProjectFile projectFile, Company company) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Cloneable cloneable;
        Object object52;
        Object object6;
        Cloneable cloneable2;
        Object object72;
        Date date;
        Date date2;
        String string;
        Task task = new Task(Common.getIdGenerator().getNewId(), Common.I18N_RP.getString("allProjects"));
        Task task2 = new Task(Common.getIdGenerator().getNewId(), Common.I18N_RP.getString("project"));
        task2.setCompany(company);
        task2.setId(0L);
        company.setRootTask(task2);
        ProjectHeader projectHeader = projectFile.getProjectHeader();
        String string2 = projectHeader.getProjectTitle();
        if (string2 != null && !string2.equals("")) {
            task2.setName(string2);
        }
        if ((string = projectHeader.getManager()) != null) {
            task2.setManager(projectHeader.getManager());
        }
        if ((date2 = projectHeader.getStartDate()) != null) {
            task2.setConstraint(new SNET(date2));
            task2.setStartDate(date2);
        }
        if ((date = projectHeader.getFinishDate()) != null) {
            task2.setEndDate(date);
        }
        task2.setCriticalSlackLimit((long)projectHeader.getCriticalSlackLimit().intValue() * 86400000L);
        task2.setCurrencyUnit(projectHeader.getCurrencySymbol());
        task2.getDurationManager().setDuration(DurationManager.DAY, (long)projectHeader.getMinutesPerDay().intValue() * 60000L);
        task2.getDurationManager().setDuration(DurationManager.WEEK, (long)projectHeader.getMinutesPerWeek().intValue() * 60000L);
        LinkedList<CalendarManager> linkedList = new LinkedList<CalendarManager>();
        for (Object object72 : projectFile.getBaseCalendars()) {
            cloneable2 = new StandardCalendarManager(Long.MIN_VALUE);
            if (object72.getName().equals("Used for Microsoft Project 98 Baseline Calendar")) continue;
            ((CalendarManager)cloneable2).setName(object72.getName());
            ((CalendarManager)cloneable2).setId(object72.getUniqueID().intValue());
            object6 = new DayWorkingPattern();
            ((DayWorkingPattern)object6).setOwner((CalendarManager)cloneable2);
            boolean bl = object72.isWorkingDay(Day.MONDAY);
            if (bl) {
                this.loadDayPattern(object72.getCalendarHours(Day.MONDAY), (DayWorkingPattern)object6);
            } else {
                ((DayWorkingPattern)object6).setWorking(bl);
            }
            ((CalendarManager)cloneable2).setDayPattern(2, (DayWorkingPattern)object6);
            object6 = new DayWorkingPattern();
            ((DayWorkingPattern)object6).setOwner((CalendarManager)cloneable2);
            bl = object72.isWorkingDay(Day.TUESDAY);
            if (bl) {
                this.loadDayPattern(object72.getCalendarHours(Day.TUESDAY), (DayWorkingPattern)object6);
            } else {
                ((DayWorkingPattern)object6).setWorking(bl);
            }
            ((CalendarManager)cloneable2).setDayPattern(3, (DayWorkingPattern)object6);
            object6 = new DayWorkingPattern();
            ((DayWorkingPattern)object6).setOwner((CalendarManager)cloneable2);
            bl = object72.isWorkingDay(Day.WEDNESDAY);
            if (bl) {
                this.loadDayPattern(object72.getCalendarHours(Day.WEDNESDAY), (DayWorkingPattern)object6);
            } else {
                ((DayWorkingPattern)object6).setWorking(bl);
            }
            ((CalendarManager)cloneable2).setDayPattern(4, (DayWorkingPattern)object6);
            object6 = new DayWorkingPattern();
            ((DayWorkingPattern)object6).setOwner((CalendarManager)cloneable2);
            bl = object72.isWorkingDay(Day.THURSDAY);
            if (bl) {
                this.loadDayPattern(object72.getCalendarHours(Day.THURSDAY), (DayWorkingPattern)object6);
            } else {
                ((DayWorkingPattern)object6).setWorking(bl);
            }
            ((CalendarManager)cloneable2).setDayPattern(5, (DayWorkingPattern)object6);
            object6 = new DayWorkingPattern();
            ((DayWorkingPattern)object6).setOwner((CalendarManager)cloneable2);
            bl = object72.isWorkingDay(Day.FRIDAY);
            if (bl) {
                this.loadDayPattern(object72.getCalendarHours(Day.FRIDAY), (DayWorkingPattern)object6);
            } else {
                ((DayWorkingPattern)object6).setWorking(bl);
            }
            ((CalendarManager)cloneable2).setDayPattern(6, (DayWorkingPattern)object6);
            object6 = new DayWorkingPattern();
            ((DayWorkingPattern)object6).setOwner((CalendarManager)cloneable2);
            bl = object72.isWorkingDay(Day.SATURDAY);
            if (bl) {
                this.loadDayPattern(object72.getCalendarHours(Day.SATURDAY), (DayWorkingPattern)object6);
            } else {
                ((DayWorkingPattern)object6).setWorking(bl);
            }
            ((CalendarManager)cloneable2).setDayPattern(7, (DayWorkingPattern)object6);
            object6 = new DayWorkingPattern();
            ((DayWorkingPattern)object6).setOwner((CalendarManager)cloneable2);
            bl = object72.isWorkingDay(Day.SUNDAY);
            if (bl) {
                this.loadDayPattern(object72.getCalendarHours(Day.SUNDAY), (DayWorkingPattern)object6);
            } else {
                ((DayWorkingPattern)object6).setWorking(bl);
            }
            ((CalendarManager)cloneable2).setDayPattern(1, (DayWorkingPattern)object6);
            for (ProjectCalendarException projectCalendarException : object72.getCalendarExceptions()) {
                Object object8;
                int n;
                object52 = new DayWorkingPattern();
                ((DayWorkingPattern)object52).setOwner((CalendarManager)cloneable2);
                for (n = 0; n < projectCalendarException.getRangeCount(); n += 1) {
                    object8 = projectCalendarException.getRange(n);
                    if (object8.getStart() == null) continue;
                    c.setTime(object8.getStart());
                    long l = CalendarManager.getDayStartTime(c);
                    ((DayWorkingPattern)object52).addAlternance(new PeriodInDay(true, object8.getStart().getTime() - l, object8.getEnd().getTime() - l));
                }
                n = projectCalendarException.getWorking() ? 1 : 0;
                if (!n) {
                    ((DayWorkingPattern)object52).setWorking(n != 0);
                }
                object8 = projectCalendarException.getFromDate();
                cloneable = projectCalendarException.getToDate();
                c.setTime((Date)object8);
                while (c.getTime().before((Date)cloneable)) {
                    ((CalendarManager)cloneable2).setDayPattern(c, (DayWorkingPattern)object52);
                    c.add(6, 1);
                }
            }
            linkedList.add((CalendarManager)cloneable2);
        }
        this.calendarCollection = new CalendarCollection(linkedList);
        company.setCalendarList(linkedList);
        for (Object object72 : projectFile.getResourceCalendars()) {
        }
        Object object9 = null;
        object72 = projectHeader.getCalendarName();
        company.setCalendarManager(this.calendarCollection.getCalendarForId(projectFile.getBaseCalendar((String)object72).getUniqueID().longValue()));
        cloneable2 = new LinkedList();
        object6 = new LinkedList();
        for (Object object52 : projectFile.getAllResources()) {
            if (object52.getUniqueID().equals(0)) continue;
            HumanResource humanResource = new HumanResource(Long.MIN_VALUE);
            humanResource.setOwner(company);
            humanResource.setId(object52.getUniqueID().intValue());
            if (object52.getName() != null) {
                humanResource.setName(object52.getName());
            }
            if (object52.getCode() != null) {
                humanResource.setCode(object52.getCode());
            }
            if (object52.getEmailAddress() != null) {
                humanResource.setEmail(object52.getEmailAddress());
            }
            humanResource.setMaxUnits(object52.getMaxUnits().doubleValue() / 100.0);
            double d = 0.0;
            if (object52.getStandardRate() != null) {
                d = object52.getStandardRate().getAmount();
                object4 = object52.getStandardRate().getUnits();
                if (object4.equals((Object)TimeUnit.MINUTES)) {
                    humanResource.setStandardRate(d * 60.0);
                } else if (object4.equals((Object)TimeUnit.HOURS)) {
                    humanResource.setStandardRate(d);
                } else if (object4.equals((Object)TimeUnit.DAYS)) {
                    humanResource.setStandardRate(d / 24.0);
                } else if (object4.equals((Object)TimeUnit.WEEKS)) {
                    humanResource.setStandardRate(d / 168.0);
                } else if (object4.equals((Object)TimeUnit.MONTHS)) {
                    humanResource.setStandardRate(d / 720.0);
                } else if (object4.equals((Object)TimeUnit.YEARS)) {
                    humanResource.setStandardRate(d / 8760.0);
                } else {
                    humanResource.setStandardRate(d);
                }
            }
            if (object52.getOvertimeRate() != null) {
                double d2 = object52.getOvertimeRate().getAmount();
                object3 = object52.getOvertimeRate().getUnits();
                if (object3.equals((Object)TimeUnit.MINUTES)) {
                    humanResource.setOvertimeRate(d2 * 60.0);
                } else if (object3.equals((Object)TimeUnit.HOURS)) {
                    humanResource.setOvertimeRate(d2);
                } else if (object3.equals((Object)TimeUnit.DAYS)) {
                    humanResource.setOvertimeRate(d2 / 24.0);
                } else if (object3.equals((Object)TimeUnit.WEEKS)) {
                    humanResource.setOvertimeRate(d2 / 168.0);
                } else if (object3.equals((Object)TimeUnit.MONTHS)) {
                    humanResource.setOvertimeRate(d2 / 720.0);
                } else if (object3.equals((Object)TimeUnit.YEARS)) {
                    humanResource.setOvertimeRate(d2 / 8760.0);
                } else {
                    humanResource.setOvertimeRate(d2);
                }
            }
            if ((object4 = humanResource.getNotes()) != null && ((String)object4).length() != 0) {
                humanResource.setNotes(object52.getNotes());
            }
            object2 = new ResourceCalendarManager(humanResource);
            object9 = this.calendarCollection.getCalendarForId(object52.getResourceCalendar().getBaseCalendar().getUniqueID().longValue());
            object3 = new LinkedList();
            for (Object object10 : object52.getResourceCalendar().getCalendarExceptions()) {
                Object object11;
                int n;
                DayWorkingPattern dayWorkingPattern = new DayWorkingPattern();
                dayWorkingPattern.setOwner((CalendarManager)object9);
                for (n = 0; n < object10.getRangeCount(); n += 1) {
                    object11 = object10.getRange(n);
                    if (object11.getStart() == null) continue;
                    c.setTime(object11.getStart());
                    long l = CalendarManager.getDayStartTime(c);
                    dayWorkingPattern.addAlternance(new PeriodInDay(true, object11.getStart().getTime() - l, object11.getEnd().getTime() - l));
                }
                n = object10.getWorking() ? 1 : 0;
                if (!n) {
                    dayWorkingPattern.setWorking(n != 0);
                }
                object11 = object10.getFromDate();
                Date date3 = object10.getToDate();
                c.setTime((Date)object11);
                while (c.getTime().before(date3)) {
                    CalendarManager.SpecialDay specialDay = new CalendarManager.SpecialDay();
                    specialDay.setDate((Calendar)c.clone());
                    specialDay.setDayPattern(dayWorkingPattern);
                    object3.add(specialDay);
                    c.add(6, 1);
                }
            }
            ((ResourceCalendarManager)object2).setResourcePatternList((List<CalendarManager.SpecialDay>)object3);
            humanResource.setCalendar((CalendarManager)object9);
            humanResource.setResourceCalendar((ResourceCalendarManager)object2);
            cloneable2.add(humanResource);
        }
        LinkedList linkedList2 = new LinkedList(cloneable2);
        linkedList2.addAll(object6);
        object52 = new ResourceCollection(linkedList2);
        company.setHumanResources((List<HumanResource>)((Object)cloneable2));
        company.setMaterialResources((List<MaterialResource>)object6);
        this.taskCollection = new TaskCollection();
        this.taskCollection.putTaskForId(task2.getId(), task2);
        for (net.sf.mpxj.Task task3 : projectFile.getAllTasks()) {
            if (this.msTaskToTaskMap.containsKey(task3)) continue;
            this.loadTask(task3, task2, company);
        }
        for (net.sf.mpxj.Task task4 : projectFile.getAllTasks()) {
            cloneable = this.taskCollection.getTaskForId(new Long(task4.getUniqueID().longValue()));
            object4 = task4.getPredecessors();
            if (object4 == null || object4.isEmpty()) continue;
            object2 = object4.iterator();
            while (object2.hasNext()) {
                Object object10;
                object3 = (Relation)object2.next();
                object = new Dependency(Common.getIdGenerator().getNewId());
                object10 = this.taskCollection.getTaskForId(new Long(object3.getTaskUniqueID().longValue()));
                ((Dependency)object).setPredecessor((Task)object10);
                double d = object3.getDuration().getDuration();
                d = object3.getDuration().getUnits().equals((Object)TimeUnit.HOURS) ? (d *= (double)task2.getDurationManager().getDuration(DurationManager.HOUR)) : (object3.getDuration().getUnits().equals((Object)TimeUnit.MINUTES) ? (d *= (double)task2.getDurationManager().getDuration(DurationManager.MINUTE)) : (object3.getDuration().getUnits().equals((Object)TimeUnit.DAYS) ? (d *= (double)task2.getDurationManager().getDuration(DurationManager.DAY)) : (object3.getDuration().getUnits().equals((Object)TimeUnit.WEEKS) ? (d *= (double)task2.getDurationManager().getDuration(DurationManager.WEEK)) : (object3.getDuration().getUnits().equals((Object)TimeUnit.PERCENT) ? d / 100.0 * (double)((Task)object10).getDuration() : (d *= (double)task2.getDurationManager().getDuration(DurationManager.DAY))))));
                ((Dependency)object).setTaskDelay((long)d);
                ((Dependency)object).setSuccessor((Task)cloneable);
                if (object3.getType().equals((Object)RelationType.START_START)) {
                    ((Dependency)object).setType(1);
                } else if (object3.getType().equals((Object)RelationType.START_FINISH)) {
                    ((Dependency)object).setType(2);
                } else if (object3.getType().equals((Object)RelationType.FINISH_START)) {
                    ((Dependency)object).setType(0);
                } else if (object3.getType().equals((Object)RelationType.FINISH_FINISH)) {
                    ((Dependency)object).setType(3);
                } else {
                    throw new RuntimeException("Invalid dependency type");
                }
                ((Dependency)object).getPredecessor();
                Task.addDependency((Dependency)object, true);
            }
        }
        for (ResourceAssignment resourceAssignment : projectFile.getAllResourceAssignments()) {
            cloneable = resourceAssignment.getTask();
            object4 = resourceAssignment.getResource();
            object2 = new Assignment(Common.getIdGenerator().getNewId());
            object3 = this.taskCollection.getTaskForId(new Long(cloneable.getUniqueID().longValue()));
            ((Assignment)object2).setTask((Task)object3);
            object = ((ResourceCollection)object52).getResourceForId(new Long(object4.getUniqueID().longValue()));
            ((Assignment)object2).setResource((Resource)object);
            resourceAssignment.setUnits((Number)(resourceAssignment.getUnits().doubleValue() / 100.0));
            ((Assignment)object2).getTask().addAssignment((Assignment)object2);
            ((Assignment)object2).getResource().addAssignment((Assignment)object2);
        }
        for (net.sf.mpxj.Task task5 : projectFile.getAllTasks()) {
            cloneable = this.taskCollection.getTaskForId(new Long(task5.getUniqueID().longValue()));
            if (cloneable == null || task5.getResourceAssignments().size() <= 0) continue;
            cloneable.setWorkDriven(task5.getEffortDriven());
        }
        for (net.sf.mpxj.Task task6 : projectFile.getAllTasks()) {
            cloneable = this.taskCollection.getTaskForId(new Long(task6.getUniqueID().longValue()));
            if (cloneable == null) continue;
            if (task6.getPercentageComplete() != null) {
                cloneable.setCompletion(task6.getPercentageComplete().intValue());
                continue;
            }
            cloneable.setCompletion(0.0);
        }
        company.setMultiProject(1);
        return task2;
    }

    private boolean isEmpty(net.sf.mpxj.Task task) {
        return task.getNull();
    }

    public void loadTask(net.sf.mpxj.Task task, Task task2, Company company) throws Exception {
        Object object;
        Object object2;
        Object object3;
        boolean bl = this.isEmpty(task);
        Task task3 = new Task(Common.getIdGenerator().getNewId());
        this.msTaskToTaskMap.put(task, task3);
        task3.setEmpty(bl);
        if (!bl) {
            task3.setCompany(company);
        }
        if (task.getParentTask() != null) {
            object3 = this.msTaskToTaskMap.get(task.getParentTask());
            if (this.isEmpty(task.getParentTask())) {
                object3 = task2;
            }
            ((Task)object3).addChild(task3, false);
        } else {
            task2.addChild(task3, false);
        }
        if (!bl) {
            int n;
            double d;
            task3.setName(task.getName());
            task3.setId(task.getUniqueID().intValue());
            if (task.getDuration() != null) {
                object3 = task.getDuration().getUnits();
                if (object3 != null) {
                    if (object3.equals((Object)TimeUnit.MINUTES)) {
                        task3.setDurationUnit(DurationManager.MINUTE);
                    } else if (object3.equals((Object)TimeUnit.HOURS)) {
                        task3.setDurationUnit(DurationManager.HOUR);
                    } else if (object3.equals((Object)TimeUnit.DAYS)) {
                        task3.setDurationUnit(DurationManager.DAY);
                    } else if (object3.equals((Object)TimeUnit.WEEKS)) {
                        task3.setDurationUnit(DurationManager.WEEK);
                    } else {
                        task3.setDurationUnit(DurationManager.DAY);
                    }
                }
            } else {
                task3.setDurationUnit(DurationManager.DAY);
            }
            if (task.getFixedCost() != null) {
                task3.setFixedCost(task.getFixedCost().doubleValue());
                if (task.getFixedCostAccrual() != null) {
                    if (task.getFixedCostAccrual().equals((Object)AccrueType.START)) {
                        task3.setAccrual(Task.START);
                    } else if (task.getFixedCostAccrual().equals((Object)AccrueType.END)) {
                        task3.setAccrual(Task.END);
                    } else if (task.getFixedCostAccrual().equals((Object)AccrueType.PRORATED)) {
                        task3.setAccrual(Task.PRORATED);
                    } else {
                        task3.setAccrual(Task.PRORATED);
                    }
                }
            }
            if (task.getCalendar() != null) {
                task3.setCalendar(this.calendarCollection.getCalendarForId(task.getCalendar().getUniqueID().longValue()));
            }
            if ((object3 = task.getNotes()) != null) {
                task3.setNotes((String)object3);
            }
            if (task.getMilestone()) {
                task3.changeDuration(0L);
            }
            if (task.getDuration() != null) {
                d = task.getDuration().getDuration();
                if (task.getDuration().getUnits().equals((Object)TimeUnit.HOURS)) {
                    task3.setDuration((long)(d * (double)task2.getDurationManager().getDuration(DurationManager.HOUR)));
                } else if (task.getDuration().getUnits().equals((Object)TimeUnit.MINUTES)) {
                    task3.setDuration((long)(d * (double)task2.getDurationManager().getDuration(DurationManager.MINUTE)));
                } else if (task.getDuration().getUnits().equals((Object)TimeUnit.DAYS)) {
                    task3.setDuration((long)(d * (double)task2.getDurationManager().getDuration(DurationManager.DAY)));
                } else if (task.getDuration().getUnits().equals((Object)TimeUnit.WEEKS)) {
                    task3.setDuration((long)(d * (double)task2.getDurationManager().getDuration(DurationManager.WEEK)));
                } else {
                    task3.setDuration((long)(d * (double)task2.getDurationManager().getDuration(DurationManager.DAY)));
                }
            } else {
                task3.setDuration(task2.getDurationManager().getDuration(DurationManager.DAY));
            }
            if (task.getWork() != null) {
                d = task.getWork().getDuration();
                if (task.getWork().getUnits().equals((Object)TimeUnit.HOURS)) {
                    task3.setWork((long)(d * (double)task2.getDurationManager().getDuration(DurationManager.HOUR)));
                } else if (task.getWork().getUnits().equals((Object)TimeUnit.MINUTES)) {
                    task3.setWork((long)(d * (double)task2.getDurationManager().getDuration(DurationManager.MINUTE)));
                } else if (task.getWork().getUnits().equals((Object)TimeUnit.DAYS)) {
                    task3.setWork((long)(d * (double)task2.getDurationManager().getDuration(DurationManager.DAY)));
                } else if (task.getWork().getUnits().equals((Object)TimeUnit.WEEKS)) {
                    task3.setWork((long)(d * (double)task2.getDurationManager().getDuration(DurationManager.WEEK)));
                } else {
                    task3.setWork((long)(d * (double)task2.getDurationManager().getDuration(DurationManager.DAY)));
                }
            } else {
                task3.setWork(task2.getDurationManager().getDuration(DurationManager.DAY));
            }
            if (task.getConstraintType().equals((Object)ConstraintType.AS_SOON_AS_POSSIBLE)) {
                task3.setConstraint(new ASAP());
            } else if (task.getConstraintType().equals((Object)ConstraintType.START_NO_EARLIER_THAN)) {
                task3.setConstraint(new SNET(task.getConstraintDate()));
            } else if (task.getConstraintType().equals((Object)ConstraintType.MUST_START_ON)) {
                task3.setConstraint(new MSO(task.getConstraintDate()));
            } else if (task.getConstraintType().equals((Object)ConstraintType.MUST_FINISH_ON)) {
                task3.setConstraint(new MFO(task.getConstraintDate()));
            } else if (task.getConstraintType().equals((Object)ConstraintType.START_NO_LATER_THAN)) {
                task3.setConstraint(new SNLT(task.getConstraintDate()));
            } else if (task.getConstraintType().equals((Object)ConstraintType.FINISH_NO_EARLIER_THAN)) {
                task3.setConstraint(new FNET(task.getConstraintDate()));
            } else if (task.getConstraintType().equals((Object)ConstraintType.FINISH_NO_LATER_THAN)) {
                task3.setConstraint(new FNLT(task.getConstraintDate()));
            }
            task3.setDeadlineDate(task.getDeadline());
            task3.setStartDate(task.getStart());
            task3.setEndDate(task.getFinish());
            if (task3.getEndDate() == null) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(task.getStart());
                object2 = task3.getCalendar() != null ? task3.getCalendar() : CalendarManager.createStandardCalendarInstance();
                RemainingDuration remainingDuration = new RemainingDuration(task3.getDuration());
                ((CalendarManager)object2).convertToWorkingTime(calendar, remainingDuration, !task3.isMilestone());
                task3.setEndDate(new Date(remainingDuration.getEndMilis()));
            }
            task3.setForcedWorking(task.getIgnoreResourceCalendar());
            if (task.getPercentageComplete() != null) {
                task3.setCompletion(task.getPercentageComplete().intValue());
            } else {
                task3.setCompletion(0.0);
            }
            object = task.getStop();
            if (object == null) {
                object = task.getStart();
            }
            task3.setCompletionDate((Date)object);
            object2 = new Baseline();
            if (task.getBaselineStart() != null && task.getBaselineFinish() != null) {
                ((Baseline)object2).setStartDate(task.getBaselineStart());
                ((Baseline)object2).setEndDate(task.getBaselineFinish());
                task3.setBaselineAt(0, (Baseline)object2);
            }
            for (n = 1; n < 10; ++n) {
                if (task.getBaselineStart(n) == null || task.getBaselineFinish(n) == null) continue;
                object2 = new Baseline();
                ((Baseline)object2).setStartDate(task.getBaselineStart(n));
                ((Baseline)object2).setEndDate(task.getBaselineFinish(n));
                task3.setBaselineAt(n, (Baseline)object2);
            }
            this.taskCollection.putTaskForId(task3.getId(), task3);
            for (n = 0; n < task3.getBaselines().length; ++n) {
                Baseline baseline = task3.getBaselineAt(n);
                if (baseline == null) continue;
                task2.setProjectBaselineAt(n, new ProjectBaseline(null, null));
            }
        }
        object3 = task.getChildTasks();
        object = object3.iterator();
        while (object.hasNext()) {
            object2 = (net.sf.mpxj.Task)object.next();
            if (this.msTaskToTaskMap.containsKey(object2)) continue;
            this.loadTask((net.sf.mpxj.Task)object2, task2, company);
        }
    }

    private void loadDayPattern(ProjectCalendarHours projectCalendarHours, DayWorkingPattern dayWorkingPattern) throws InvalidOperationException {
        for (DateRange dateRange : projectCalendarHours) {
            if (dateRange.getStart() == null) continue;
            if (dateRange.getStart().equals(dateRange.getEnd())) {
                dayWorkingPattern.addAlternance(new PeriodInDay(true, 0L, 86400000L));
                continue;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(dateRange.getStart());
            calendar.clear(14);
            long l = CalendarManager.getDayStartTime(calendar);
            calendar.setTime(dateRange.getStart());
            calendar.clear(14);
            long l2 = calendar.getTimeInMillis();
            calendar.setTime(dateRange.getEnd());
            calendar.clear(14);
            long l3 = calendar.getTimeInMillis();
            dayWorkingPattern.addAlternance(new PeriodInDay(true, l2 - l, l3 - l));
        }
    }

    private Company loadProject(ProjectFile projectFile) throws Exception {
        Company company = new Company();
        Task task = this.loadProject(projectFile, company);
        company.setRootTask(task);
        company.setLoaded(true);
        for (HumanResource humanResource : company.getHumanResources()) {
            if (humanResource.isEmpty()) continue;
            for (Assignment assignment : humanResource.getAssignments()) {
                Task task2 = assignment.getTask();
                assignment.start(task2.getStartDate(), task2.getEndDate(), task2.getCompletionDate());
            }
            humanResource.computeWorkIntervals();
        }
        ProjectIOMSMPX.updateCompletions(company.getRootTask());
        company.computeTasksId();
        company.computeResourceId();
        TaskPlanner.forceTree(company.getRootTask(), false);
        company.computeCriticalPath();
        return company;
    }

    public Company load(InputStream inputStream) throws ProjectIOException {
        ProjectFile projectFile = null;
        try {
            projectFile = new MPXReader().read(inputStream);
            Company company = this.loadProject(projectFile);
            return company;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Common.logException("Error loading input stream:", throwable);
            throw new ProjectIOException(throwable.getLocalizedMessage());
        }
    }

    private static void updateCompletions(Task task) {
        if (!task.isEmpty() && task.isLeaf()) {
            task.setCompletion(task.getCompletion());
        } else {
            for (int i = 0; i < task.getChildNumber(); ++i) {
                Task task2 = task.getChildAt(i);
                ProjectIOMSMPX.updateCompletions(task2);
            }
        }
    }

    private void saveDayPattern(ProjectCalendarHours projectCalendarHours, DayWorkingPattern dayWorkingPattern) throws InvalidOperationException {
        for (int i = 0; i < dayWorkingPattern.getPeriodsInDay().length; ++i) {
            PeriodInDay periodInDay = dayWorkingPattern.getPeriodInDayAt(i);
            if (!periodInDay.isWorking()) continue;
            Calendar calendar = Calendar.getInstance();
            long l = CalendarManager.getDayStartTime(calendar);
            Date date = new Date(l + periodInDay.getStartPeriod());
            Date date2 = new Date(l + periodInDay.getEndPeriod());
            DateRange dateRange = new DateRange(date, date2);
            projectCalendarHours.addRange(dateRange);
        }
    }

    private void storeTask(ProjectFile projectFile, Task task, String string, int n) {
        net.sf.mpxj.Task task2 = projectFile.addTask();
        task2.setWBS(string);
        task2.setOutlineNumber(string);
        task2.setOutlineLevel(Integer.valueOf(n));
        task2.setNull(task.isEmpty());
        if (!task.isEmpty()) {
            Serializable serializable;
            int n2;
            task2.setName(task.getName());
            task2.setUniqueID(Integer.valueOf(task.getId().intValue()));
            task2.setFixedCost((Number)task.getFixedCost());
            if (task.getAccrual().equals(AccrueType.START)) {
                task2.setFixedCostAccrual(AccrueType.START);
            } else if (task.getAccrual().equals(AccrueType.END)) {
                task2.setFixedCostAccrual(AccrueType.END);
            } else if (task.getAccrual().equals(AccrueType.PRORATED)) {
                task2.setFixedCostAccrual(AccrueType.PRORATED);
            } else {
                task2.setFixedCostAccrual(AccrueType.PRORATED);
            }
            task2.setCalendar(projectFile.getBaseCalendarByUniqueID(Integer.valueOf(task.getUsedCalendar().getId().intValue())));
            task2.setIgnoreResourceCalendar(task.isForcedWorking());
            String string2 = task.getNotes();
            if (string2 != null) {
                task2.setNotes(string2);
            }
            task2.setMilestone(task.isMilestone());
            Duration duration = null;
            Duration duration2 = null;
            Duration duration3 = null;
            Duration duration4 = null;
            if (task.getDurationUnit().equals(DurationManager.DAY)) {
                duration = Duration.getInstance((double)((double)task.getDuration() / (double)task.getProjectTask().getDurationManager().getDuration(DurationManager.DAY)), (TimeUnit)TimeUnit.DAYS);
                duration3 = Duration.getInstance((double)((double)task.getActualDuration() / (double)task.getProjectTask().getDurationManager().getDuration(DurationManager.DAY)), (TimeUnit)TimeUnit.DAYS);
                duration4 = Duration.getInstance((double)((double)task.getRemainingDuration() / (double)task.getProjectTask().getDurationManager().getDuration(DurationManager.DAY)), (TimeUnit)TimeUnit.DAYS);
                duration2 = Duration.getInstance((double)(task.getWork() / task.getProjectTask().getDurationManager().getDuration(DurationManager.DAY)), (TimeUnit)TimeUnit.DAYS);
            } else if (task.getDurationUnit().equals(DurationManager.HOUR)) {
                duration = Duration.getInstance((double)((double)task.getDuration() / (double)task.getProjectTask().getDurationManager().getDuration(DurationManager.HOUR)), (TimeUnit)TimeUnit.HOURS);
                duration3 = Duration.getInstance((double)((double)task.getActualDuration() / (double)task.getProjectTask().getDurationManager().getDuration(DurationManager.HOUR)), (TimeUnit)TimeUnit.HOURS);
                duration4 = Duration.getInstance((double)((double)task.getRemainingDuration() / (double)task.getProjectTask().getDurationManager().getDuration(DurationManager.HOUR)), (TimeUnit)TimeUnit.HOURS);
                duration2 = Duration.getInstance((double)(task.getWork() / task.getProjectTask().getDurationManager().getDuration(DurationManager.HOUR)), (TimeUnit)TimeUnit.HOURS);
            } else if (task.getDurationUnit().equals(DurationManager.MINUTE)) {
                duration = Duration.getInstance((double)((double)task.getDuration() / (double)task.getProjectTask().getDurationManager().getDuration(DurationManager.MINUTE)), (TimeUnit)TimeUnit.MINUTES);
                duration3 = Duration.getInstance((double)((double)task.getActualDuration() / (double)task.getProjectTask().getDurationManager().getDuration(DurationManager.MINUTE)), (TimeUnit)TimeUnit.MINUTES);
                duration4 = Duration.getInstance((double)((double)task.getRemainingDuration() / (double)task.getProjectTask().getDurationManager().getDuration(DurationManager.MINUTE)), (TimeUnit)TimeUnit.MINUTES);
                duration2 = Duration.getInstance((double)(task.getWork() / task.getProjectTask().getDurationManager().getDuration(DurationManager.MINUTE)), (TimeUnit)TimeUnit.MINUTES);
            } else if (task.getDurationUnit().equals(DurationManager.WEEK)) {
                duration = Duration.getInstance((double)((double)task.getDuration() / (double)task.getProjectTask().getDurationManager().getDuration(DurationManager.WEEK)), (TimeUnit)TimeUnit.WEEKS);
                duration3 = Duration.getInstance((double)((double)task.getActualDuration() / (double)task.getProjectTask().getDurationManager().getDuration(DurationManager.WEEK)), (TimeUnit)TimeUnit.WEEKS);
                duration4 = Duration.getInstance((double)((double)task.getRemainingDuration() / (double)task.getProjectTask().getDurationManager().getDuration(DurationManager.WEEK)), (TimeUnit)TimeUnit.WEEKS);
                duration2 = Duration.getInstance((double)(task.getWork() / task.getProjectTask().getDurationManager().getDuration(DurationManager.WEEK)), (TimeUnit)TimeUnit.WEEKS);
            }
            task2.setDuration(duration);
            task2.setActualDuration(duration3);
            task2.setRemainingDuration(duration4);
            task2.setWork(duration2);
            if (task.getConstraint() instanceof ASAP) {
                task2.setConstraintType(ConstraintType.AS_SOON_AS_POSSIBLE);
            } else if (task.getConstraint() instanceof SNET) {
                task2.setConstraintType(ConstraintType.START_NO_EARLIER_THAN);
                task2.setConstraintDate(task.getConstraint().getDate());
            } else if (task.getConstraint() instanceof MSO) {
                task2.setConstraintType(ConstraintType.MUST_START_ON);
                task2.setConstraintDate(task.getConstraint().getDate());
            } else if (task.getConstraint() instanceof MFO) {
                task2.setConstraintType(ConstraintType.MUST_FINISH_ON);
                task2.setConstraintDate(task.getConstraint().getDate());
            } else if (task.getConstraint() instanceof SNLT) {
                task2.setConstraintType(ConstraintType.START_NO_LATER_THAN);
                task2.setConstraintDate(task.getConstraint().getDate());
            } else if (task.getConstraint() instanceof FNET) {
                task2.setConstraintType(ConstraintType.FINISH_NO_EARLIER_THAN);
                task2.setConstraintDate(task.getConstraint().getDate());
            } else if (task.getConstraint() instanceof FNLT) {
                task2.setConstraintType(ConstraintType.FINISH_NO_LATER_THAN);
                task2.setConstraintDate(task.getConstraint().getDate());
            }
            task2.setDeadline(task.getDeadlineDate());
            task2.setStart(task.getStartDate());
            task2.setFinish(task.getEndDate());
            task2.setPercentageComplete((Number)task.getCompletion());
            task2.setPhysicalPercentComplete(Integer.valueOf((int)task.getCompletion()));
            task2.setPercentageWorkComplete((Number)task.getWorkCompletion());
            task2.setStop(task.getCompletionDate());
            task2.setEffortDriven(task.isWorkDriven());
            if (task.getBaselineAt(0) != null) {
                Baseline baseline = task.getBaselineAt(0);
                task2.setBaselineStart(baseline.getStartDate());
                task2.setBaselineFinish(baseline.getEndDate());
            }
            for (n2 = 1; n2 < 10; ++n2) {
                if (task.getBaselineAt(n2) == null) continue;
                serializable = task.getBaselineAt(n2);
                task2.setBaselineStart(n2, ((Baseline)serializable).getStartDate());
                task2.setBaselineFinish(n2, ((Baseline)serializable).getEndDate());
            }
            ++n;
            for (n2 = 0; n2 < task.getChildList().size(); ++n2) {
                serializable = task.getChildAt(n2);
                if (string.equals("0")) {
                    this.storeTask(projectFile, (Task)serializable, "" + (n2 + 1), n);
                    continue;
                }
                this.storeTask(projectFile, (Task)serializable, string + "." + (n2 + 1), n);
            }
        }
    }

    private void storeDependencies(ProjectFile projectFile, Task task) {
        for (Dependency mouseHoover : task.getPredecessorDependencies()) {
            net.sf.mpxj.Task task2 = projectFile.getTaskByUniqueID(Integer.valueOf(mouseHoover.getPredecessor().getId().intValue()));
            net.sf.mpxj.Task task3 = projectFile.getTaskByUniqueID(Integer.valueOf(mouseHoover.getSuccessor().getId().intValue()));
            Relation relation = task3.addPredecessor(task2);
            if (mouseHoover.getType() == 1) {
                relation.setType(RelationType.START_START);
            } else if (mouseHoover.getType() == 2) {
                relation.setType(RelationType.START_FINISH);
            } else if (mouseHoover.getType() == 0) {
                relation.setType(RelationType.FINISH_START);
            } else if (mouseHoover.getType() == 3) {
                relation.setType(RelationType.FINISH_FINISH);
            }
            Duration duration = null;
            if (mouseHoover.getUnit().equals(DurationManager.HOUR)) {
                duration = Duration.getInstance((double)(mouseHoover.getTaskDelay() / task.getProjectTask().getDurationManager().getDuration(DurationManager.HOUR)), (TimeUnit)TimeUnit.HOURS);
            } else if (mouseHoover.getUnit().equals(DurationManager.MINUTE)) {
                duration = Duration.getInstance((double)(mouseHoover.getTaskDelay() / task.getProjectTask().getDurationManager().getDuration(DurationManager.MINUTE)), (TimeUnit)TimeUnit.MINUTES);
            } else if (mouseHoover.getUnit().equals(DurationManager.DAY)) {
                duration = Duration.getInstance((double)(mouseHoover.getTaskDelay() / task.getProjectTask().getDurationManager().getDuration(DurationManager.DAY)), (TimeUnit)TimeUnit.DAYS);
            } else if (mouseHoover.getUnit().equals(DurationManager.WEEK)) {
                duration = Duration.getInstance((double)(mouseHoover.getTaskDelay() / task.getProjectTask().getDurationManager().getDuration(DurationManager.WEEK)), (TimeUnit)TimeUnit.WEEKS);
            }
            relation.setDuration(duration);
        }
        for (int i = 0; i < task.getChildList().size(); ++i) {
            Task task4 = task.getChildAt(i);
            this.storeDependencies(projectFile, task4);
        }
    }

    private void storeAssignments(ProjectFile projectFile, Task task) {
        for (Assignment uniqueId : task.getAssignments()) {
            net.sf.mpxj.Task task2 = projectFile.getTaskByUniqueID(Integer.valueOf(task.getId().intValue()));
            net.sf.mpxj.Resource resource = projectFile.getResourceByUniqueID(Integer.valueOf((int)uniqueId.getResource().getId()));
            ResourceAssignment resourceAssignment = task2.addResourceAssignment(resource);
            resourceAssignment.setUnits((Number)uniqueId.getUnits());
        }
        for (int i = 0; i < task.getChildList().size(); ++i) {
            Task task3 = task.getChildAt(i);
            this.storeDependencies(projectFile, task3);
        }
    }

    private void saveProject(ProjectFile projectFile, Task task) throws Exception {
        Object object;
        Object object2;
        Object object3;
        ProjectCalendar projectCalendar;
        ProjectHeader projectHeader = projectFile.getProjectHeader();
        projectHeader.setDateFormat(ProjectDateFormat.DD_MMMMM_YYYY_HH_MM);
        projectHeader.setFinishDate(task.getEndDate());
        projectHeader.setManager(task.getManager());
        projectHeader.setProjectTitle(task.getName());
        projectHeader.setStartDate(task.getStartDate());
        projectHeader.setCriticalSlackLimit(Integer.valueOf((int)(task.getCriticalSlackLimit() / 86400000L)));
        projectHeader.setCurrencySymbol(task.getCurrencyUnit());
        projectHeader.setMinutesPerDay((Number)(task.getDurationManager().getDuration(DurationManager.DAY) / 60000L));
        projectHeader.setPercentageComplete((Number)task.getCompletion());
        for (CalendarManager uniqueId : task.getCompany().getCalendarList()) {
            projectCalendar = projectFile.addBaseCalendar();
            projectCalendar.setName(uniqueId.getName());
            projectCalendar.setUniqueID(Integer.valueOf(uniqueId.getId().intValue()));
            object3 = uniqueId.getDayPattern(2);
            boolean bl = ((DayWorkingPattern)object3).isWorking();
            projectCalendar.setWorkingDay(Day.MONDAY, bl);
            if (bl) {
                object2 = projectCalendar.addCalendarHours(Day.MONDAY);
                this.saveDayPattern((ProjectCalendarHours)object2, (DayWorkingPattern)object3);
            }
            object3 = uniqueId.getDayPattern(3);
            bl = ((DayWorkingPattern)object3).isWorking();
            projectCalendar.setWorkingDay(Day.TUESDAY, bl);
            if (bl) {
                object2 = projectCalendar.addCalendarHours(Day.TUESDAY);
                this.saveDayPattern((ProjectCalendarHours)object2, (DayWorkingPattern)object3);
            }
            object3 = uniqueId.getDayPattern(4);
            bl = ((DayWorkingPattern)object3).isWorking();
            projectCalendar.setWorkingDay(Day.WEDNESDAY, bl);
            if (bl) {
                object2 = projectCalendar.addCalendarHours(Day.WEDNESDAY);
                this.saveDayPattern((ProjectCalendarHours)object2, (DayWorkingPattern)object3);
            }
            object3 = uniqueId.getDayPattern(5);
            bl = ((DayWorkingPattern)object3).isWorking();
            projectCalendar.setWorkingDay(Day.THURSDAY, bl);
            if (bl) {
                object2 = projectCalendar.addCalendarHours(Day.THURSDAY);
                this.saveDayPattern((ProjectCalendarHours)object2, (DayWorkingPattern)object3);
            }
            object3 = uniqueId.getDayPattern(6);
            bl = ((DayWorkingPattern)object3).isWorking();
            projectCalendar.setWorkingDay(Day.FRIDAY, bl);
            if (bl) {
                object2 = projectCalendar.addCalendarHours(Day.FRIDAY);
                this.saveDayPattern((ProjectCalendarHours)object2, (DayWorkingPattern)object3);
            }
            object3 = uniqueId.getDayPattern(7);
            bl = ((DayWorkingPattern)object3).isWorking();
            projectCalendar.setWorkingDay(Day.SATURDAY, bl);
            if (bl) {
                object2 = projectCalendar.addCalendarHours(Day.SATURDAY);
                this.saveDayPattern((ProjectCalendarHours)object2, (DayWorkingPattern)object3);
            }
            object3 = uniqueId.getDayPattern(1);
            bl = ((DayWorkingPattern)object3).isWorking();
            projectCalendar.setWorkingDay(Day.SUNDAY, bl);
            if (bl) {
                object2 = projectCalendar.addCalendarHours(Day.SUNDAY);
                this.saveDayPattern((ProjectCalendarHours)object2, (DayWorkingPattern)object3);
            }
            object3 = uniqueId.getSpecialPatternList().iterator();
            while (object3.hasNext()) {
                ProjectCalendarException projectCalendarException = projectCalendar.addCalendarException();
                object2 = (CalendarManager.SpecialDay)object3.next();
                object = ((CalendarManager.SpecialDay)object2).getDayPattern();
                for (int i = 0; i < ((DayWorkingPattern)object).getPeriodsInDay().length; ++i) {
                    PeriodInDay periodInDay = ((DayWorkingPattern)object).getPeriodInDayAt(i);
                    c.setTimeInMillis(System.currentTimeMillis());
                    long l = CalendarManager.getDayStartTime(c);
                    DateRange dateRange = new DateRange(new Date(l + periodInDay.getStartPeriod()), new Date(l + periodInDay.getEndPeriod()));
                    projectCalendarException.addRange(dateRange);
                }
                projectCalendarException.setWorking(((DayWorkingPattern)object).isWorking());
                projectCalendarException.setFromDate(((CalendarManager.SpecialDay)object2).getDate().getTime());
                projectCalendarException.setToDate(((CalendarManager.SpecialDay)object2).getDate().getTime());
            }
        }
        projectHeader.setCalendarName(task.getUsedCalendar().getName());
        for (HumanResource humanResource : task.getCompany().getHumanResources()) {
            int n;
            DayWorkingPattern dayWorkingPattern;
            CalendarManager.SpecialDay specialDay;
            projectCalendar = projectFile.addResource();
            projectCalendar.setType(ResourceType.WORK);
            projectCalendar.setUniqueID(Integer.valueOf((int)humanResource.getId()));
            projectCalendar.setName(humanResource.getName());
            projectCalendar.setEmailAddress(humanResource.getEmail());
            projectCalendar.setMaxUnits((Number)(humanResource.getMaxUnits() * 100.0));
            object3 = new Rate(humanResource.getStandardRate(), TimeUnit.HOURS);
            projectCalendar.setStandardRate((Rate)object3);
            object3 = new Rate(humanResource.getOvertimeRate(), TimeUnit.HOURS);
            projectCalendar.setOvertimeRate((Rate)object3);
            String string = humanResource.getNotes();
            if (string != null && string.length() != 0) {
                projectCalendar.setNotes(string);
            }
            object2 = humanResource.getResourceCalendar();
            object = projectFile.addResourceCalendar();
            object.setName(humanResource.getName());
            ProjectCalendar projectCalendar2 = ((CalendarManager)object2).getSpecialPatternList().iterator();
            while (projectCalendar2.hasNext()) {
                ProjectCalendarException projectCalendarException = object.addCalendarException();
                specialDay = projectCalendar2.next();
                dayWorkingPattern = specialDay.getDayPattern();
                for (n = 0; n < dayWorkingPattern.getPeriodsInDay().length; ++n) {
                    PeriodInDay periodInDay = dayWorkingPattern.getPeriodInDayAt(n);
                    c.setTimeInMillis(System.currentTimeMillis());
                    long l = CalendarManager.getDayStartTime(c);
                    DateRange dateRange = new DateRange(new Date(l + periodInDay.getStartPeriod()), new Date(l + periodInDay.getEndPeriod()));
                    projectCalendarException.addRange(dateRange);
                }
                projectCalendarException.setWorking(dayWorkingPattern.isWorking());
                projectCalendarException.setFromDate(specialDay.getDate().getTime());
                projectCalendarException.setToDate(specialDay.getDate().getTime());
            }
            projectCalendar2 = projectFile.getBaseCalendarByUniqueID(Integer.valueOf(humanResource.getUsedCalendar().getId().intValue()));
            for (int i = 0; i < projectCalendar2.getHours().length; ++i) {
                specialDay = projectCalendar2.getHours()[i];
                if (specialDay == null) continue;
                dayWorkingPattern = object.addCalendarHours();
                for (n = 0; n < specialDay.getRangeCount(); ++n) {
                    dayWorkingPattern.addRange(specialDay.getRange(n));
                }
            }
            object.setBaseCalendar(projectCalendar2);
            projectCalendar.setResourceCalendar((ProjectCalendar)object);
        }
        for (MaterialResource materialResource : task.getCompany().getMaterialResources()) {
            projectCalendar = projectFile.addResource();
            projectCalendar.setType(ResourceType.MATERIAL);
            projectCalendar.setUniqueID(Integer.valueOf((int)materialResource.getId()));
            projectCalendar.setName(materialResource.getName());
            object3 = new Rate(materialResource.getStandardRate(), TimeUnit.HOURS);
            projectCalendar.setStandardRate((Rate)object3);
            String string = materialResource.getNotes();
            if (string == null || string.length() == 0) continue;
            projectCalendar.setNotes(string);
        }
        this.storeTask(projectFile, task, "0", 0);
        this.storeDependencies(projectFile, task);
        this.storeAssignments(projectFile, task);
    }

    public void save(Company company, OutputStream outputStream, boolean bl) throws ProjectIOException {
        ProjectFile projectFile = new ProjectFile();
        try {
            this.saveProject(projectFile, company.getRootTask());
            new MPXWriter().write(projectFile, outputStream);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Common.logException("Error saving project:", throwable);
            throw new ProjectIOException(throwable.getLocalizedMessage());
        }
    }

    public void save(Task task, OutputStream outputStream, boolean bl) throws ProjectIOException {
        ProjectFile projectFile = new ProjectFile();
        try {
            this.saveProject(projectFile, task);
            new MPXWriter().write(projectFile, outputStream);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Common.logException("Error saving project:", throwable);
            throw new ProjectIOException(throwable.getLocalizedMessage());
        }
    }
}

