/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.core.field;

import com.sbs.jpm.Common;
import com.sbs.jpm.CompanyDocument;
import com.sbs.jpm.core.field.FieldEvent;
import com.sbs.jpm.core.field.FieldListener;
import java.util.EventListener;
import javax.swing.event.EventListenerList;

public class FieldManager {
    public static final int FIELD_NO = 10;
    public static final String CUSTOM_NAME = Common.I18N_RP.getString("field.data") + " ";
    private String[] taskFieldNames = new String[10];
    private String[] resourceFieldNames = new String[10];
    private String[] clientFieldNames = new String[10];
    private EventListenerList listeners = new EventListenerList();
    private static FieldManager instance = new FieldManager();

    private FieldManager() {
        this.setDefaults();
    }

    public void setDefaults() {
        for (int i = 0; i < 10; ++i) {
            this.taskFieldNames[i] = CUSTOM_NAME + (i + 1);
            this.resourceFieldNames[i] = CUSTOM_NAME + (i + 1);
            this.clientFieldNames[i] = CUSTOM_NAME + (i + 1);
        }
    }

    public static FieldManager getInstance() {
        return instance;
    }

    public void setCustomNames() {
        int n;
        for (n = 0; n < 10; ++n) {
            this.fireTaskNameChanged(this.taskFieldNames[n], n);
        }
        for (n = 0; n < 10; ++n) {
            this.fireResourceNameChanged(this.resourceFieldNames[n], n);
        }
        for (n = 0; n < 10; ++n) {
            this.fireClientNameChanged(this.clientFieldNames[n], n);
        }
    }

    public void resetCustomNames() {
        int n;
        for (n = 0; n < 10; ++n) {
            this.fireTaskNameChanged(CUSTOM_NAME + (n + 1), n);
        }
        for (n = 0; n < 10; ++n) {
            this.fireResourceNameChanged(CUSTOM_NAME + (n + 1), n);
        }
        for (n = 0; n < 10; ++n) {
            this.fireClientNameChanged(CUSTOM_NAME + (n + 1), n);
        }
    }

    public void setTaskFieldNameAt(int n, String string) {
        this.taskFieldNames[n] = string;
        this.fireTaskNameChanged(string, n);
    }

    public String getTaskFieldNameAt(int n) {
        return this.taskFieldNames[n];
    }

    public void setResourceFieldNameAt(int n, String string) {
        this.resourceFieldNames[n] = string;
        this.fireResourceNameChanged(string, n);
    }

    public String getResourceFieldNameAt(int n) {
        return this.resourceFieldNames[n];
    }

    public void setClientFieldNameAt(int n, String string) {
        this.clientFieldNames[n] = string;
        this.fireClientNameChanged(string, n);
    }

    public String getClientFieldNameAt(int n) {
        return this.clientFieldNames[n];
    }

    public String[] getResourceFieldNames() {
        return this.resourceFieldNames;
    }

    public String[] getClientFieldNames() {
        return this.clientFieldNames;
    }

    public String[] getTaskFieldNames() {
        return this.taskFieldNames;
    }

    private void fireTaskNameChanged(String string, int n) {
        FieldEvent fieldEvent = new FieldEvent(this);
        fieldEvent.setName(string);
        fieldEvent.setTaskIndex(n);
        EventListener[] eventListenerArray = this.listeners.getListeners(FieldListener.class);
        int n2 = eventListenerArray.length;
        for (int i = 0; i < n2; ++i) {
            ((FieldListener)eventListenerArray[i]).taskNameChanged(fieldEvent);
        }
        CompanyDocument companyDocument = (CompanyDocument)Common.getProjectDocumentManager().getSelectedDocument();
        if (companyDocument != null && companyDocument.getData() != null && companyDocument.getData().isLoaded()) {
            companyDocument.getData().setChanged(true);
        }
    }

    private void fireResourceNameChanged(String string, int n) {
        FieldEvent fieldEvent = new FieldEvent(this);
        fieldEvent.setName(string);
        fieldEvent.setResourceIndex(n);
        EventListener[] eventListenerArray = this.listeners.getListeners(FieldListener.class);
        int n2 = eventListenerArray.length;
        for (int i = 0; i < n2; ++i) {
            ((FieldListener)eventListenerArray[i]).resourceNameChanged(fieldEvent);
        }
        CompanyDocument companyDocument = (CompanyDocument)Common.getProjectDocumentManager().getSelectedDocument();
        if (companyDocument != null && companyDocument.getData() != null && companyDocument.getData().isLoaded()) {
            companyDocument.getData().setChanged(true);
        }
    }

    private void fireClientNameChanged(String string, int n) {
        FieldEvent fieldEvent = new FieldEvent(this);
        fieldEvent.setName(string);
        fieldEvent.setClientIndex(n);
        EventListener[] eventListenerArray = this.listeners.getListeners(FieldListener.class);
        int n2 = eventListenerArray.length;
        for (int i = 0; i < n2; ++i) {
            ((FieldListener)eventListenerArray[i]).clientNameChanged(fieldEvent);
        }
        CompanyDocument companyDocument = (CompanyDocument)Common.getProjectDocumentManager().getSelectedDocument();
        if (companyDocument != null && companyDocument.getData() != null && companyDocument.getData().isLoaded()) {
            companyDocument.getData().setChanged(true);
        }
    }

    public void addFieldListener(FieldListener fieldListener) {
        this.listeners.add(FieldListener.class, fieldListener);
    }

    public void removeFieldListener(FieldListener fieldListener) {
        this.listeners.remove(FieldListener.class, fieldListener);
    }
}

