/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.core.constraint;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.constraint.ALAP;
import com.sbs.jpm.core.constraint.ASAP;
import com.sbs.jpm.core.constraint.Constraint;
import com.sbs.jpm.core.constraint.FNET;
import com.sbs.jpm.core.constraint.FNLT;
import com.sbs.jpm.core.constraint.MFO;
import com.sbs.jpm.core.constraint.MSO;
import com.sbs.jpm.core.constraint.SNET;
import com.sbs.jpm.core.constraint.SNLT;
import java.util.Date;

public final class ConstraintManager {
    public static final String SNET = Common.I18N_RP.getString("constraint.type.SNET");
    public static final String SNLT = Common.I18N_RP.getString("constraint.type.SNLT");
    public static final String FNET = Common.I18N_RP.getString("constraint.type.FNET");
    public static final String FNLT = Common.I18N_RP.getString("constraint.type.FNLT");
    public static final String MSO = Common.I18N_RP.getString("constraint.type.MSO");
    public static final String MFO = Common.I18N_RP.getString("constraint.type.MFO");
    public static final String ASAP = Common.I18N_RP.getString("constraint.type.ASAP");
    public static final String ALAP = Common.I18N_RP.getString("constraint.type.ALAP");
    private static final String[] constraintList = new String[]{ASAP, SNET, SNLT, FNET, FNLT, MSO, MFO};

    public static String[] getConstraintList() {
        return constraintList;
    }

    public static Constraint createConstraint(String string, Date date) {
        if (string.equals(SNET)) {
            return new SNET(date);
        }
        if (string.equals(SNLT)) {
            return new SNLT(date);
        }
        if (string.equals(ASAP)) {
            return new ASAP();
        }
        if (string.equals(ALAP)) {
            return new ALAP();
        }
        if (string.equals(FNET)) {
            return new FNET(date);
        }
        if (string.equals(FNLT)) {
            return new FNLT(date);
        }
        if (string.equals(MSO)) {
            return new MSO(date);
        }
        if (string.equals(MFO)) {
            return new MFO(date);
        }
        return null;
    }

    public static String getConstraintType(Constraint constraint) {
        if (constraint instanceof SNET) {
            return SNET;
        }
        if (constraint instanceof SNLT) {
            return SNLT;
        }
        if (constraint instanceof ASAP) {
            return ASAP;
        }
        if (constraint instanceof ALAP) {
            return ALAP;
        }
        if (constraint instanceof FNET) {
            return FNET;
        }
        if (constraint instanceof FNLT) {
            return FNLT;
        }
        if (constraint instanceof MSO) {
            return MSO;
        }
        if (constraint instanceof MFO) {
            return MFO;
        }
        return null;
    }
}

