/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.core.conflict;

import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.conflict.Conflict;
import com.sbs.jpm.core.conflict.ConflictManagerEvent;
import com.sbs.jpm.core.conflict.ConflictManagerListener;
import java.io.Serializable;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConflictManager
implements Serializable {
    private List<Conflict> conflicts = new LinkedList<Conflict>();
    private EventListenerList listeners = new EventListenerList();

    public void addConflict(Conflict conflict) {
        conflict.getTask().setConflict(true);
        this.conflicts.add(conflict);
        this.fireConflictAdded(conflict, this.conflicts.size() - 1);
    }

    public void removeConflict(Conflict conflict) {
        this.conflicts.remove(conflict);
    }

    public Conflict getConflictAt(int n) {
        return this.conflicts.get(n);
    }

    public int getConflictIndex(Conflict conflict) {
        return this.conflicts.indexOf(conflict);
    }

    public Conflict getConflict(Task task) {
        Conflict[] conflictArray = this.conflicts.toArray(new Conflict[0]);
        for (int i = 0; i < conflictArray.length; ++i) {
            Conflict conflict = conflictArray[i];
            if (!conflict.getTask().equals(task)) continue;
            return conflict;
        }
        return null;
    }

    public int getConflictNumber() {
        return this.conflicts.size();
    }

    public void removeConflict(Task task) {
        Conflict[] conflictArray = this.conflicts.toArray(new Conflict[0]);
        for (int i = 0; i < conflictArray.length; ++i) {
            Conflict conflict = conflictArray[i];
            if (!conflict.getTask().equals(task)) continue;
            int n = this.conflicts.indexOf(conflict);
            this.conflicts.remove(conflict);
            this.fireConflictRemoved(conflict, n);
        }
        task.setConflict(false);
    }

    private void fireConflictAdded(Conflict conflict, int n) {
        ConflictManagerEvent conflictManagerEvent = new ConflictManagerEvent(this, conflict, n);
        EventListener[] eventListenerArray = this.listeners.getListeners(ConflictManagerListener.class);
        int n2 = eventListenerArray.length;
        for (int i = 0; i < n2; ++i) {
            ((ConflictManagerListener)eventListenerArray[i]).conflictAdded(conflictManagerEvent);
        }
    }

    private void fireConflictRemoved(Conflict conflict, int n) {
        ConflictManagerEvent conflictManagerEvent = new ConflictManagerEvent(this, conflict, n);
        EventListener[] eventListenerArray = this.listeners.getListeners(ConflictManagerListener.class);
        int n2 = eventListenerArray.length;
        for (int i = 0; i < n2; ++i) {
            ((ConflictManagerListener)eventListenerArray[i]).conflictRemoved(conflictManagerEvent);
        }
    }

    public void addConflictManagerListener(ConflictManagerListener conflictManagerListener) {
        this.listeners.add(ConflictManagerListener.class, conflictManagerListener);
    }

    public void removeConflictManagerListener(ConflictManagerListener conflictManagerListener) {
        this.listeners.remove(ConflictManagerListener.class, conflictManagerListener);
    }

    public List<Conflict> getConflicts() {
        return this.conflicts;
    }

    public void setConflicts(List<Conflict> list) {
        this.conflicts = list;
    }
}

