/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.core.conflict;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.conflict.ConflictEvent;
import com.sbs.jpm.core.conflict.ConflictListener;
import java.io.Serializable;
import java.util.EventListener;
import javax.swing.event.EventListenerList;

public class Conflict
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Task task;
    private String message;
    private EventListenerList listeners;

    public Conflict() {
        this(new Task(Common.getIdGenerator().getNewId()), "");
    }

    public Conflict(Task task, String string) {
        this.task = task;
        this.message = string;
        this.listeners = new EventListenerList();
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
        this.fireConflictChanged();
    }

    public Task getTask() {
        return this.task;
    }

    public void setTask(Task task) {
        this.task = task;
    }

    private void fireConflictChanged() {
        ConflictEvent conflictEvent = new ConflictEvent(this);
        EventListener[] eventListenerArray = this.listeners.getListeners(ConflictListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((ConflictListener)eventListenerArray[i]).conflictChanged(conflictEvent);
        }
    }

    public void addConflictListener(ConflictListener conflictListener) {
        this.listeners.add(ConflictListener.class, conflictListener);
    }

    public void removeConflictListener(ConflictListener conflictListener) {
        this.listeners.remove(ConflictListener.class, conflictListener);
    }
}

