/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.core.baseline;

import com.sbs.jpm.core.baseline.BaselineManagerEvent;
import com.sbs.jpm.core.baseline.BaselineManagerListener;
import java.util.EventListener;
import javax.swing.event.EventListenerList;

public class BaselineManager {
    public static final int BASELINE_NO = 10;
    public static final int VISIBLE_BASELINE_NO = 1;
    private boolean showBaseline = false;
    private int visibleBaseline;
    private EventListenerList listeners = new EventListenerList();
    private static BaselineManager instance = new BaselineManager();

    private BaselineManager() {
    }

    public static BaselineManager getInstance() {
        return instance;
    }

    public boolean isShowBaseline() {
        return this.showBaseline;
    }

    public void setShowBaseline(boolean bl) {
        this.showBaseline = bl;
        if (bl) {
            this.fireBaselineShown();
        } else {
            this.fireBaselineHidden();
        }
    }

    public int getVisibleBaseline() {
        return this.visibleBaseline;
    }

    public void setVisibleBaseline(int n) {
        this.visibleBaseline = n;
    }

    private void fireBaselineShown() {
        BaselineManagerEvent baselineManagerEvent = new BaselineManagerEvent(this);
        EventListener[] eventListenerArray = this.listeners.getListeners(BaselineManagerListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((BaselineManagerListener)eventListenerArray[i]).baselineShown(baselineManagerEvent);
        }
    }

    private void fireBaselineHidden() {
        BaselineManagerEvent baselineManagerEvent = new BaselineManagerEvent(this);
        EventListener[] eventListenerArray = this.listeners.getListeners(BaselineManagerListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((BaselineManagerListener)eventListenerArray[i]).baselineHidden(baselineManagerEvent);
        }
    }

    public void addBaselineManagerListener(BaselineManagerListener baselineManagerListener) {
        this.listeners.add(BaselineManagerListener.class, baselineManagerListener);
    }

    public void removeBaselineManagerListener(BaselineManagerListener baselineManagerListener) {
        this.listeners.remove(BaselineManagerListener.class, baselineManagerListener);
    }
}

