/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.core;

import com.sbs.jpm.Common;
import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.calendar.DayWorkingPattern;
import com.sbs.jpm.calendar.Period;
import com.sbs.jpm.calendar.RemainingDuration;
import com.sbs.jpm.calendar.event.CalendarManagerEvent;
import com.sbs.jpm.calendar.event.CalendarManagerListener;
import com.sbs.jpm.core.ActualWorkingData;
import com.sbs.jpm.core.AllocationUnit;
import com.sbs.jpm.core.Assignment;
import com.sbs.jpm.core.AssignmentUnit;
import com.sbs.jpm.core.CircularRelationshipException;
import com.sbs.jpm.core.Client;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.CurrencyManager;
import com.sbs.jpm.core.Dependency;
import com.sbs.jpm.core.DurationManager;
import com.sbs.jpm.core.HumanResource;
import com.sbs.jpm.core.Link;
import com.sbs.jpm.core.MaterialResource;
import com.sbs.jpm.core.MouseHoover;
import com.sbs.jpm.core.Resource;
import com.sbs.jpm.core.Risk;
import com.sbs.jpm.core.TaskDeadlineHoover;
import com.sbs.jpm.core.TaskPlanner;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.baseline.Baseline;
import com.sbs.jpm.core.baseline.ProjectBaseline;
import com.sbs.jpm.core.constraint.ASAP;
import com.sbs.jpm.core.constraint.Constraint;
import com.sbs.jpm.core.constraint.MSO;
import com.sbs.jpm.core.constraint.SNET;
import com.sbs.jpm.core.constraint.SNLT;
import com.sbs.jpm.core.event.CompanyAdapter;
import com.sbs.jpm.core.event.CompanyEvent;
import com.sbs.jpm.core.event.CompanyListener;
import com.sbs.jpm.core.event.TaskEvent;
import com.sbs.jpm.core.event.TaskListener;
import com.sbs.jpm.undo.TaskPartSplitEdit;
import com.sbs.jpm.undo.TaskSplitEdit;
import java.awt.Color;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Task
extends MouseHoover
implements Cloneable,
Serializable,
UniqueId {
    public static final long INVALID_DURATION = Long.MIN_VALUE;
    public static final long INVALID_WORK = Long.MAX_VALUE;
    public long uniqueID;
    public boolean cycleVisited = false;
    public boolean cycleCurrentPath = false;
    private boolean dirty = false;
    private boolean conflict = false;
    private boolean expanded = true;
    boolean calculated = false;
    public int visitCounter;
    public static final long ROUND_COMPLETION_DATE_TO_MILLISECONDS_VALUE = 1000L;
    public static final String START = Common.I18N_RP.getString("task.accrual.start");
    public static final String END = Common.I18N_RP.getString("task.accrual.end");
    public static final String PRORATED = Common.I18N_RP.getString("task.accrual.prorated");
    public static final String PLANNING = Common.I18N_RP.getString("task.status.planning");
    public static final String IN_PROGRESS = Common.I18N_RP.getString("task.status.inProgress");
    public static final String ON_HOLD = Common.I18N_RP.getString("task.status.onHold");
    public static final String CLOSED = Common.I18N_RP.getString("task.status.closed");
    private static final Calendar c = Calendar.getInstance();
    private static Map<Task, Task> cloneMap = new HashMap<Task, Task>();
    private String code = "";
    private String status = PLANNING;
    private String manager = "";
    private String description = "";
    private long criticalSlackLimit = 1L;
    private String criticalSlackUnit;
    private DurationManager durationManager;
    private CurrencyManager currencyManager;
    private DayWorkingPattern customPattern;
    private List<Link> links;
    private String assumptions = "";
    private String constraints = "";
    private List<Risk> risks;
    boolean project;
    private ProjectBaseline[] projectBaselines = new ProjectBaseline[10];
    private Baseline[] baselines = new Baseline[10];
    private String[] fields = new String[10];
    boolean force;
    boolean splitted;
    String name;
    String durationUnit;
    String workUnit;
    String currencyUnit;
    Long taskId;
    String notes = "";
    long duration;
    long phaseWorkingDuration = -1L;
    long saveLeafDuration = 28800000L;
    long saveLeafWork = 0L;
    double saveLeafCompletion = 0.0;
    double completion;
    double workCompletion;
    boolean critical;
    Date criticalDate;
    Date startDate = c.getTime();
    Date endDate;
    Date deadlineDate;
    Date completionDate = c.getTime();
    private boolean forcedWorking = false;
    private double fixedCost;
    private String accrual;
    boolean workDriven = false;
    boolean fixedUnits = true;
    Task parent;
    Company company;
    Client client;
    CalendarManager calendar;
    List<Task> childList;
    Constraint constraint;
    List<Dependency> successorDependencies;
    List<Dependency> predecessorDependencies;
    List<Assignment> assignments;
    private CompanyListener companyHandler;
    private EventListenerList listeners;
    private boolean empty = true;
    private final CalendarHandler calendarHandler = new CalendarHandler();
    private Color barColor;
    static final Date MAX_DATE = new Date(Long.MAX_VALUE);
    long workOnTask = 0L;
    long saveWorkOnTask = 0L;
    long saveDuration = 0L;
    public TaskDeadlineHoover deadlineHoover = new TaskDeadlineHoover(this);

    @Override
    public void setUniqueId(long l) {
        this.uniqueID = l;
    }

    @Override
    public long getUniqueId() {
        return this.uniqueID;
    }

    public Task(long l) {
        this();
        this.setUniqueId(l);
    }

    private Task() {
        this.uniqueID = Long.MIN_VALUE;
        this.links = new LinkedList<Link>();
        this.risks = new LinkedList<Risk>();
        this.customPattern = CalendarManager.createCustomDayWorkingPattern();
        this.durationManager = new DurationManager();
        this.currencyManager = new CurrencyManager();
        this.criticalSlackUnit = DurationManager.DAY;
        this.listeners = new EventListenerList();
        this.successorDependencies = new LinkedList<Dependency>();
        this.predecessorDependencies = new LinkedList<Dependency>();
        this.childList = new LinkedList<Task>();
        this.assignments = new LinkedList<Assignment>();
        this.durationUnit = DurationManager.DAY;
        this.workUnit = DurationManager.HOUR;
        this.currencyUnit = CurrencyManager.getDefaultCurrency();
    }

    public Task(long l, String string) {
        this(string);
        this.setUniqueId(l);
    }

    public Task(String string) {
        this();
        this.empty = false;
        this.project = true;
        this.duration = 28800000L;
        this.name = string;
        c.setTimeInMillis(CalendarManager.getDayStartTime(c));
        CalendarManager.STANDARD_CALENDAR.getFirstTime(c, true, Long.MAX_VALUE);
        this.constraint = new SNET(c.getTime());
        this.startDate = c.getTime();
        this.endDate = c.getTime();
        this.completionDate = c.getTime();
        this.accrual = PRORATED;
    }

    public void setFieldAt(int n, String string) {
        if (this.empty && !this.initEmptyTask()) {
            return;
        }
        this.fields[n] = string;
        this.fireNameChanged();
    }

    public String getFieldAt(int n) {
        return this.fields[n];
    }

    public void saveBaselineAt(int n) {
        if (this.isProject()) {
            this.setProjectBaselineAt(n, new ProjectBaseline(new Date(), ""));
            Baseline baseline = new Baseline(this.getStartDate(), this.getEndDate());
            baseline.setCompletion(this.completion);
            baseline.setCompletionDate(this.getCompletionDate());
            this.setBaselineAt(n, baseline);
        }
        for (int i = 0; i < this.getChildNumber(); ++i) {
            Task task = this.getChildAt(i);
            if (!task.isEmpty() && task.isLeaf()) {
                Baseline baseline = new Baseline(task.getStartDate(), task.getEndDate());
                baseline.setCompletion(task.completion);
                baseline.setCompletionDate(task.getCompletionDate());
                task.setBaselineAt(n, baseline);
                continue;
            }
            task.saveBaselineAt(n);
        }
    }

    public void clearBaselineAt(int n) {
        if (this.isProject()) {
            this.setProjectBaselineAt(n, null);
            this.setBaselineAt(n, null);
        }
        for (int i = 0; i < this.getChildNumber(); ++i) {
            Task task = this.getChildAt(i);
            if (!task.isEmpty() && task.isLeaf()) {
                task.setBaselineAt(n, null);
                continue;
            }
            task.clearBaselineAt(n);
        }
    }

    public void setBaselineAt(int n, Baseline baseline) {
        this.baselines[n] = baseline;
        this.fireBaselineChanged();
    }

    public Baseline getBaselineAt(int n) {
        return this.baselines[n];
    }

    public void setProjectBaselineAt(int n, ProjectBaseline projectBaseline) {
        this.projectBaselines[n] = projectBaseline;
    }

    public int getProjectBaselineIndex(ProjectBaseline projectBaseline) {
        for (int i = 0; i < 10; ++i) {
            if (this.projectBaselines[i] == null || !this.projectBaselines[i].equals(projectBaseline)) continue;
            return i;
        }
        return -1;
    }

    public ProjectBaseline getProjectBaselineAt(int n) {
        return this.projectBaselines[n];
    }

    public String getCode() {
        return this.code;
    }

    public String getManager() {
        return this.manager;
    }

    public void setCode(String string) {
        this.code = string;
        this.fireProjectChanged();
    }

    public void setManager(String string) {
        this.manager = string;
        this.fireProjectChanged();
    }

    public String getAssumptions() {
        return this.assumptions;
    }

    public void setAssumptions(String string) {
        this.assumptions = string;
        this.fireProjectAssumptionsChanged();
    }

    public String getConstraints() {
        return this.constraints;
    }

    public void setConstraints(String string) {
        this.constraints = string;
        this.fireProjectConstraintsChanged();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
        this.fireProjectDescriptionChanged();
    }

    public DayWorkingPattern getCustomPattern() {
        return this.customPattern;
    }

    public void setCustomPattern(DayWorkingPattern dayWorkingPattern) {
        this.customPattern = dayWorkingPattern;
    }

    public List<Risk> getRisks() {
        return this.risks;
    }

    public int getRisksNumber() {
        return this.risks.size();
    }

    public int getRiskIndex(Risk risk) {
        return this.risks.indexOf(risk);
    }

    public Risk getRiskAt(int n) {
        return this.risks.get(n);
    }

    public void addRiskAt(int n, Risk risk) {
        if (risk != null) {
            risk.setOwner(this.getCompany());
            this.risks.add(n, risk);
            this.fireRiskAdded(risk, n);
        }
    }

    public void addRisk(Risk risk) {
        if (risk != null) {
            this.addRiskAt(this.getRisksNumber(), risk);
        }
    }

    public void removeRiskAt(int n) {
        Risk risk = this.risks.remove(n);
        this.fireRiskRemoved(risk, n);
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public int getLinksNumber() {
        return this.links.size();
    }

    public int getLinkIndex(Link link) {
        return this.links.indexOf(link);
    }

    public Link getLinkAt(int n) {
        return this.links.get(n);
    }

    public void addLinkAt(int n, Link link) {
        if (link != null) {
            link.setOwner(this.getCompany());
            this.links.add(n, link);
            this.fireLinkAdded(link, n);
        }
    }

    public void addLink(Link link) {
        if (link != null) {
            this.addLinkAt(this.getLinksNumber(), link);
        }
    }

    public void removeLinkAt(int n) {
        Link link = this.links.remove(n);
        this.fireLinkRemoved(link, n);
    }

    public boolean isForcedWorking() {
        return this.forcedWorking;
    }

    public void setForcedWorking(boolean bl) {
        if (this.forcedWorking != bl) {
            if (this.empty && !this.initEmptyTask()) {
                return;
            }
            this.forcedWorking = bl;
            if (this.isSplitted()) {
                for (Task task : this.childList) {
                    task.forcedWorking = bl;
                    task.setDirty(true, false);
                }
            }
            this.setDirty(true, false);
            this.fireForcedWorkingChanged();
        }
    }

    public CalendarManager getCalendar() {
        return this.calendar;
    }

    public CalendarManager getUsedCalendar() {
        CalendarManager calendarManager = this.calendar;
        if (calendarManager == null) {
            calendarManager = this.getProjectTask().getCalendar();
        }
        if (calendarManager == null) {
            calendarManager = this.getCompany().getCalendarManager();
        }
        return calendarManager;
    }

    void setProjectDirty() {
        if (this.isLeaf() && this.calendar == null) {
            this.setDirty(true, false);
        }
        for (Task task : this.childList) {
            task.setProjectDirty();
        }
    }

    public void setCalendar(CalendarManager calendarManager) {
        if (this.empty && !this.initEmptyTask()) {
            return;
        }
        if (this.isSplitted()) {
            for (Task task : this.getChildList()) {
                task.setCalendar(calendarManager);
            }
        }
        CalendarManager calendarManager2 = this.calendar;
        this.calendar = calendarManager;
        if (calendarManager2 != null) {
            calendarManager2.removeCalendarManagerListener(this.calendarHandler);
        }
        if (calendarManager != null) {
            calendarManager.addCalendarManagerListener(this.calendarHandler);
        }
        this.setDirty(true, false);
        if (this.isProject()) {
            this.setProjectDirty();
        }
        this.fireDataChanged();
        if (this.company != null) {
            this.company.computeCriticalPath();
        }
    }

    public List<Dependency> getSuccessorDependencies() {
        return this.successorDependencies;
    }

    public boolean containsDependency(Dependency dependency) {
        return this.successorDependencies.contains(dependency);
    }

    public List<Dependency> getPredecessorDependencies() {
        return this.predecessorDependencies;
    }

    public int getAssignmentNumber() {
        return this.assignments.size();
    }

    public List<Assignment> getAssignments() {
        return this.assignments;
    }

    public Assignment getAssignmentAt(int n) {
        return this.assignments.get(n);
    }

    public int getAssignmentIndex(Assignment assignment) {
        return this.assignments.indexOf(assignment);
    }

    public int getAssignmentIndex(Resource resource) {
        int n = 0;
        for (Assignment assignment : this.assignments) {
            if (assignment.getResource().equals(resource)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public boolean containsResource(Resource resource) {
        for (Assignment assignment : this.getAssignments()) {
            Resource resource2 = assignment.getResource();
            if (resource == null || !resource.equals(resource2)) continue;
            return true;
        }
        return false;
    }

    public void addAssignment(Assignment assignment, int n) {
        Resource resource = assignment.getResource();
        for (Assignment assignment2 : this.getAssignments()) {
            Resource resource2 = assignment2.getResource();
            if (resource == null || !resource.equals(resource2)) continue;
            return;
        }
        this.assignments.add(n, assignment);
        this.fireAssignmentAdded(assignment, this.assignments.indexOf(assignment));
    }

    public void addAssignment(Assignment assignment) {
        this.addAssignment(assignment, this.assignments.size());
    }

    public void removeAssignment(int n) {
        Assignment assignment = this.assignments.remove(n);
        if (!this.hasHumanResources() && !this.workDriven) {
            this.workOnTask = 0L;
        }
        this.fireAssignmentRemoved(assignment, n);
    }

    public void removeAssignment(Assignment assignment) {
        int n = this.assignments.indexOf(assignment);
        this.removeAssignment(n);
    }

    private void justInitEmptyTask() {
        if (this.startDate == null) {
            this.startDate = this.parent != null ? this.parent.getStartDate() : this.getProjectTask().getStartDate();
        }
        this.workUnit = DurationManager.HOUR;
        this.durationUnit = this.getProjectTask().getDurationManager().getDefaultUnit();
        this.currencyUnit = CurrencyManager.getDefaultCurrency();
        if (this.duration == 0L) {
            this.duration = this.getProjectTask().getDurationManager().getDuration(this.getProjectTask().getDurationManager().getDefaultUnit());
        }
        if (this.name == null) {
            this.name = " ";
        }
        if (this.notes == null) {
            this.notes = " ";
        }
        if (this.constraint == null) {
            this.constraint = new ASAP();
        }
        if (this.accrual == null) {
            this.accrual = PRORATED;
        }
        this.forcedWorking = this.getProjectTask().isForcedWorking();
        this.empty = false;
        if (this.endDate == null) {
            TaskPlanner.computeEndDate(this);
        }
        if (this.completionDate == null) {
            this.computeCompletionDate();
        }
        this.getCompany().computeTasksId();
    }

    public DurationManager getDurationManager() {
        return this.durationManager;
    }

    private boolean initEmptyTask() {
        if (this.getCompany().getRootTask().getTaskList(false).size() < 20) {
            this.justInitEmptyTask();
            return true;
        }
        JOptionPane.showMessageDialog(Common.getApplication(), Common.I18N_MESSAGES.getString("task.trial.message"), Common.I18N_MESSAGES.getString("task.trial.title"), 0);
        return false;
    }

    public List<Task> removeEmptyTasks() {
        Task task;
        int n;
        Task[] taskArray = this.childList.toArray(new Task[0]);
        int n2 = taskArray.length;
        LinkedList<Task> linkedList = new LinkedList<Task>();
        int n3 = -1;
        for (n = 0; n < n2; ++n) {
            task = taskArray[n];
            if (task.empty) continue;
            n3 = n;
        }
        if (n2 - 1 > n3) {
            for (n = n2 - 1; n > n3; --n) {
                task = this.getChildAt(n);
                linkedList.add(0, task);
                this.deleteChild(task);
            }
        }
        return linkedList;
    }

    public long getWorkingDuration() {
        if (this.empty) {
            return 0L;
        }
        if (this.isSplitted()) {
            long l = 0L;
            for (Task task : this.getChildList()) {
                l += task.getWorkingDuration();
            }
            return l;
        }
        if (this.isLeaf()) {
            return this.duration;
        }
        if (this.phaseWorkingDuration == -1L) {
            Date date = this.getStartDate();
            Date date2 = this.getEndDate();
            CalendarManager calendarManager = this.getUsedCalendar();
            this.phaseWorkingDuration = calendarManager.getDuration(date, date2, true);
        }
        return this.phaseWorkingDuration;
    }

    public long getActualWorkingDuration() {
        return (long)(this.completion / 100.0 * (double)this.getWorkingDuration());
    }

    public long getRemainingWorkingDuration() {
        return (long)((double)this.getWorkingDuration() - this.completion / 100.0 * (double)this.getWorkingDuration());
    }

    public long getWorkingDuration(Date date, Date date2) {
        if (this.empty) {
            return 0L;
        }
        Date date3 = this.getStartDate();
        Date date4 = this.getEndDate();
        date3 = date3.after(date) ? date3 : date;
        date4 = date4.before(date2) ? date4 : date2;
        CalendarManager calendarManager = this.getUsedCalendar();
        long l = calendarManager.getDuration(date3, date4, true);
        return l;
    }

    public long getDuration() {
        if (this.isSplitted()) {
            long l = 0L;
            for (Task task : this.getChildList()) {
                l += task.getDuration();
            }
            return l;
        }
        return this.duration;
    }

    public long getActualDuration() {
        return (long)(this.completion / 100.0 * (double)this.duration);
    }

    public long getRemainingDuration() {
        return this.duration - this.getActualDuration();
    }

    private void deleteSplitLastChild(boolean bl) {
        Serializable serializable;
        Task task = this.getChildAt(0);
        for (Assignment assignment : task.getAssignments()) {
            serializable = assignment.getResource();
            Assignment assignment2 = new Assignment(Common.getIdGenerator().getNewId(), this, (Resource)serializable, assignment.getUnits());
            this.addAssignment(assignment2);
            ((Resource)serializable).addAssignment(assignment2);
        }
        long l = this.getChildAt(0).getDuration();
        serializable = this.getChildAt(0).getConstraint();
        this.deleteChild(this.getChildAt(0));
        this.splitted = false;
        this.setConstraint((Constraint)serializable);
        this.changeDuration(l);
    }

    private void setSplitTaskDuration(long l) {
        int n;
        long l2 = l;
        int n2 = 0;
        Task task = this.getChildAt(this.getChildNumber() - 1);
        for (n = 0; n < this.getChildNumber(); ++n) {
            Task task2 = this.getChildAt(n);
            if (l2 > task2.getDuration()) {
                if (n < this.getChildNumber() - 1) {
                    l2 -= task2.getDuration();
                    continue;
                }
                n2 = n;
                task = task2;
                continue;
            }
            n2 = n;
            task = task2;
            break;
        }
        for (n = this.getChildNumber() - 1; n > n2; --n) {
            this.deleteChild(this.getChildAt(n));
        }
        if (this.getChildNumber() == 0) {
            this.changeDuration(l2);
        } else {
            task.changeDuration(l2);
        }
    }

    public void setDuration(long l) {
        this.duration = l;
    }

    public void changeDuration(long l) {
        if (this.empty && !this.initEmptyTask()) {
            return;
        }
        if (this.isSplitted()) {
            this.setSplitTaskDuration(l);
            return;
        }
        this.duration = l;
        if (this.workDriven && this.hasHumanResources()) {
            this.saveWorkOnTask = this.workOnTask;
            this.saveDuration = l;
            this.workOnTask = Long.MAX_VALUE;
        }
        this.setDirty(true);
        this.fireDataChanged();
        if (this.company != null) {
            this.company.computeCriticalPath();
        }
    }

    private void setSplitWork(long l, boolean bl) {
        int n;
        long l2 = l;
        int n2 = 0;
        Task task = this.getChildAt(0);
        for (n = 0; n < this.getChildNumber(); ++n) {
            Task task2 = this.getChildAt(n);
            if (task2.hasHumanResources()) {
                task = task2;
                n2 = n;
            }
            if (l2 <= task2.getWorkExceptChildren()) break;
            if (n >= this.getChildNumber() - 1) continue;
            l2 -= task2.getWorkExceptChildren();
        }
        if (n2 == 0 && !task.hasHumanResources()) {
            task.changeWork(l, bl);
            return;
        }
        for (n = this.getChildNumber() - 1; n > n2; --n) {
            this.deleteChild(this.getChildAt(n));
        }
        if (this.getChildNumber() == 0) {
            this.changeWork(l2, bl);
        } else {
            task.changeWork(l2, bl);
        }
    }

    public void setWork(long l) {
        this.workOnTask = l;
    }

    public void changeWork(long l, boolean bl) {
        if (this.isSplitted()) {
            this.setSplitWork(l, bl);
        } else {
            if (this.hasHumanResources()) {
                this.saveWorkOnTask = this.workOnTask;
                this.saveDuration = this.duration;
                this.duration = Long.MIN_VALUE;
            }
            this.workOnTask = l;
            this.setDirty(true);
            this.fireDataChanged();
        }
    }

    public String getOutlineNumber() {
        if (this.parent == null) {
            return "0";
        }
        if (this.parent.getParent() == null) {
            return this.parent.getChildIndex(this) + 1 + "";
        }
        return this.parent.getOutlineNumber() + "." + (this.parent.getChildIndex(this) + 1);
    }

    public double getCompletion() {
        return this.completion;
    }

    public Date getCompletionDate() {
        if (this.empty) {
            return null;
        }
        return this.completionDate;
    }

    public double getCompletionForCompletionDate(Date date) {
        if (date.before(this.getStartDate())) {
            return 0.0;
        }
        if (date.after(this.getEndDate())) {
            return 100.0;
        }
        CalendarManager calendarManager = this.getUsedCalendar();
        long l = calendarManager.getDuration(this.getStartDate(), date, true);
        double d = (double)l * 100.0 / (double)this.getDuration();
        return d;
    }

    public void catchUp(Date date) {
        double d = this.getCompletionForCompletionDate(date);
        if (this.isLeaf()) {
            TaskPlanner.setCompletion(this, d);
        }
        for (Task task : this.childList) {
            if (task.isEmpty()) continue;
            task.catchUp(date);
        }
    }

    public void setCompletion(double d) {
        if (this.empty && !this.initEmptyTask()) {
            return;
        }
        if (this.isSplitted()) {
            double d2 = d * (double)this.getDuration() / 100.0;
            long l = (long)d2;
            for (Task task : this.getChildList()) {
                if (l > task.getDuration()) {
                    task.setCompletion(100.0);
                    l -= task.getDuration();
                    continue;
                }
                if (l > 0L) {
                    double d3 = 100L * l / task.getDuration();
                    task.setCompletion(d3);
                    l -= task.getDuration();
                    continue;
                }
                task.setCompletion(0.0);
            }
        }
        TaskPlanner.setCompletion(this, d);
    }

    public void setWorkCompletion(double d, boolean bl) {
        if (this.empty && !this.initEmptyTask()) {
            return;
        }
        if (this.isSplitted()) {
            long l;
            long l2 = l = (long)(d * (double)this.getWork()) / 100L;
            for (Task task : this.getChildList()) {
                if (l2 > task.getWork()) {
                    task.setWorkCompletion(100.0, bl);
                    l2 -= task.getWork();
                    continue;
                }
                if (l2 > 0L) {
                    double d2 = 100L * l2 / task.getWork();
                    task.setWorkCompletion(d2, bl);
                    l2 = 0L;
                    continue;
                }
                task.setWorkCompletion(0.0, bl);
            }
        } else {
            this.workCompletion = d;
            TaskPlanner.setWorkCompletion(this, d, bl);
        }
    }

    public Long getId() {
        return this.taskId;
    }

    public void setId(long l) {
        this.taskId = new Long(l);
    }

    public long computeId(long l) {
        this.taskId = new Long(l);
        long l2 = l;
        for (Task task : this.childList) {
            ++l2;
            l2 = task.computeId(l2);
        }
        return l2;
    }

    public String getDurationUnit() {
        return this.durationUnit;
    }

    public void setDurationUnit(String string) {
        this.durationUnit = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (this.empty && !this.initEmptyTask()) {
            return;
        }
        this.name = string;
        this.fireNameChanged();
    }

    public void setChangingName(String string) {
        this.name = string;
        this.fireChangingNameChanged();
    }

    public boolean isCritical() {
        return this.critical;
    }

    public boolean isAncestor(Task task) {
        for (Task task2 = task.getParent(); task2 != null; task2 = task2.getParent()) {
            if (task2 != this) continue;
            return true;
        }
        return false;
    }

    public boolean isDescendent(Task task) {
        return task.isAncestor(this);
    }

    public boolean isDescendent(List<Task> list) {
        for (Task task : list) {
            if (!this.isDescendent(task)) continue;
            return true;
        }
        return false;
    }

    public String getNotes() {
        return this.notes;
    }

    public Color getBarColor() {
        return this.barColor;
    }

    public void setBarColor(Color color) {
        this.barColor = color;
        this.fireNameChanged();
    }

    public void setNotes(String string) {
        if (this.empty && !this.initEmptyTask()) {
            return;
        }
        this.notes = string;
        this.fireNotesChanged();
    }

    public Date getStartDate() {
        if (this.empty) {
            return null;
        }
        return this.startDate;
    }

    public Date getActualStartDate() {
        if (this.empty) {
            return null;
        }
        return this.completion != 0.0 ? this.startDate : null;
    }

    public Date getEndDate() {
        if (this.empty) {
            return null;
        }
        return this.endDate;
    }

    public Date getActualEndDate() {
        if (this.empty) {
            return null;
        }
        return this.completion == 100.0 ? this.endDate : null;
    }

    public boolean isWorkDriven() {
        return this.workDriven;
    }

    public boolean isDurationDriven() {
        return !this.isWorkDriven();
    }

    public boolean hasHumanResources() {
        for (Assignment assignment : this.getAssignments()) {
            Resource resource = assignment.getResource();
            if (!(resource instanceof HumanResource)) continue;
            return true;
        }
        return false;
    }

    public void setWorkDriven(boolean bl) {
        this.workDriven = bl;
        if (this.isSplitted()) {
            for (Task task : this.childList) {
                task.workDriven = bl;
            }
        }
        this.fireTaskTypeChanged();
    }

    public boolean isFixedUnits() {
        return this.fixedUnits;
    }

    public void setFixedUnits(boolean bl) {
        if (this.fixedUnits != bl) {
            if (this.empty && !this.initEmptyTask()) {
                return;
            }
            this.fixedUnits = bl;
            if (this.isSplitted()) {
                for (Task task : this.childList) {
                    task.fixedUnits = bl;
                }
            }
            this.fireFixedUnitsChanged();
        }
    }

    public ActualWorkingData getData() {
        ActualWorkingData actualWorkingData = new ActualWorkingData();
        actualWorkingData.startDate = this.startDate;
        actualWorkingData.endDate = this.endDate;
        actualWorkingData.completionDate = this.completionDate;
        actualWorkingData.work = this.workOnTask;
        actualWorkingData.duration = this.getDuration();
        actualWorkingData.workDriven = this.workDriven;
        return actualWorkingData;
    }

    public void setData(ActualWorkingData actualWorkingData) {
        this.startDate = actualWorkingData.startDate;
        this.endDate = actualWorkingData.endDate;
        this.completionDate = actualWorkingData.completionDate;
        this.workOnTask = actualWorkingData.work;
        this.duration = actualWorkingData.duration;
        this.workDriven = actualWorkingData.workDriven;
    }

    public void computeCompletionDate() {
        if (!this.isLeaf()) {
            double d = (double)this.duration * this.getCompletion() / 100.0;
            this.completionDate = new Date(this.getStartDate().getTime() + (long)d);
        } else {
            CalendarManager calendarManager = this.getUsedCalendar();
            double d = (double)this.duration * this.getCompletion() / 100.0;
            RemainingDuration remainingDuration = new RemainingDuration((long)d);
            c.setTime(this.getStartDate());
            calendarManager.convertToWorkingTime(c, remainingDuration, 1000L, !this.isMilestone());
            this.completionDate = new Date(remainingDuration.getEndMilis());
        }
    }

    void computeWorkCompletionDate() {
        if (this.isLeaf()) {
            Long l = this.getWork();
            if (l == 0L) {
                this.completionDate = this.startDate;
            } else {
                double d = this.workCompletion * (double)l.longValue() / 100.0;
                LinkedList<Long> linkedList = new LinkedList<Long>();
                for (Assignment object32 : this.getAssignments()) {
                    object32.start(object32.getTask().getStartDate(), object32.getTask().getEndDate(), object32.getTask().getCompletionDate());
                }
                for (Assignment assignment : this.getAssignments()) {
                    List list = assignment.getResourceUnits();
                    Object object = list.iterator();
                    while (object.hasNext()) {
                        AllocationUnit allocationUnit = (AllocationUnit)object.next();
                        linkedList.add(allocationUnit.startDate);
                        linkedList.add(allocationUnit.endDate);
                    }
                }
                CalendarManager calendarManager = this.getUsedCalendar();
                List list = calendarManager.getPeriods(this.startDate, this.endDate);
                for (Object object : list) {
                    if (!((Period)object).getType()) continue;
                    linkedList.add(((Period)object).getStartPeriod());
                    linkedList.add(((Period)object).getEndPeriod());
                }
                Collections.sort(linkedList);
                long l2 = this.startDate.getTime();
                for (int i = 0; i < linkedList.size() - 1; ++i) {
                    long l3 = (Long)linkedList.get(i);
                    long l4 = (Long)linkedList.get(i + 1);
                    long l5 = 0L;
                    for (Assignment assignment : this.getAssignments()) {
                        double d2 = 0.0;
                        double d3 = 0.0;
                        for (AssignmentUnit assignmentUnit : assignment.getAllocationUnits()) {
                            long l6;
                            if (l3 >= assignmentUnit.endDate) continue;
                            if (l4 <= assignmentUnit.startDate) break;
                            long l7 = l4 < assignmentUnit.endDate ? l4 : assignmentUnit.endDate;
                            long l8 = l6 = l3 > assignmentUnit.startDate ? l3 : assignmentUnit.startDate;
                            if (assignmentUnit.getType() == 1) {
                                d2 += (double)(l7 - l6) * assignment.getUnits();
                                continue;
                            }
                            if (assignmentUnit.getType() == 0) {
                                d3 += (double)(l7 - l6) * assignment.getUnits();
                                continue;
                            }
                            if (assignmentUnit.getType() != 2) continue;
                            d2 += (double)(l7 - l6) * assignment.getUnits();
                            d3 += (double)(l7 - l6) * assignment.getUnits();
                        }
                        if (this.isForcedWorking()) {
                            if (d2 == 0.0) continue;
                            l5 = (long)((double)l5 + d2);
                            continue;
                        }
                        if (d2 == 0.0 || d3 == 0.0) continue;
                        l5 = (long)((double)l5 + d3);
                    }
                    if ((double)l5 < d) {
                        d -= (double)l5;
                        l2 += l4 - l3;
                        continue;
                    }
                    l2 += (long)((double)(l4 - l3) * d / (double)l5);
                    break;
                }
                this.completionDate = new Date(l2);
            }
        }
    }

    public Constraint getConstraint() {
        return this.constraint;
    }

    public void setProjectStartDate(Date date) {
        this.constraint = new SNET(date);
    }

    public void setConstraint(Constraint constraint) {
        if (this.empty && !this.initEmptyTask()) {
            return;
        }
        Task task = this;
        Task task2 = null;
        Constraint constraint2 = constraint;
        if (this.isSplitted()) {
            task2 = this;
            task = constraint.isStartRelatedConstraint() ? task2.getChildAt(0) : task2.getChildAt(task2.getChildNumber() - 1);
        } else if (this.getParent() != null && this.getParent().isSplitted()) {
            Task task3 = this.getParent().getChildAt(0);
            Task task4 = this.getParent().getChildAt(this.getParent().getChildNumber() - 1);
            if (this == task4) {
                if (constraint.isStartRelatedConstraint()) {
                    if (task3.getConstraint().isStartRelatedConstraint()) {
                        constraint2 = task3.getConstraint();
                        task2 = this.getParent();
                    } else {
                        constraint2 = new ASAP();
                        task2 = this.getParent();
                    }
                } else if (!this.getParent().getConstraint().isStartRelatedConstraint()) {
                    constraint2 = constraint;
                    task2 = this.getParent();
                }
            } else if (this == task3) {
                if (!constraint.isStartRelatedConstraint() || constraint instanceof ASAP) {
                    if (!task4.getConstraint().isStartRelatedConstraint()) {
                        constraint2 = task4.getConstraint();
                        task2 = this.getParent();
                    } else {
                        constraint2 = new ASAP();
                        task2 = this.getParent();
                    }
                } else if (this.getParent().getConstraint().isStartRelatedConstraint()) {
                    constraint2 = constraint;
                    task2 = this.getParent();
                }
            }
        }
        if (task2 != null) {
            TaskPlanner.setConstraint(task2, constraint2);
        }
        TaskPlanner.setConstraint(task, constraint);
        if (this.company != null) {
            this.company.computeCriticalPath();
        }
    }

    public List<Task> getChildList() {
        return this.childList;
    }

    public List<Task> getTaskList(boolean bl) {
        LinkedList<Task> linkedList = new LinkedList<Task>();
        if (this.getParent() != null) {
            linkedList.add(this);
        }
        for (int i = 0; i < this.getChildNumber(); ++i) {
            Task task = this.getChildAt(i);
            if (task.isEmpty()) continue;
            if (bl) {
                linkedList.addAll(this.getChildAt(i).getTaskList(true));
                continue;
            }
            if (task.isSplitted()) {
                linkedList.add(task);
                continue;
            }
            linkedList.addAll(this.getChildAt(i).getTaskList(bl));
        }
        return linkedList;
    }

    public List<Task> getProjectTaskList() {
        LinkedList<Task> linkedList = new LinkedList<Task>();
        if (this.isProject()) {
            linkedList.add(this);
        }
        for (int i = 0; i < this.getChildNumber(); ++i) {
            Task task = this.getChildAt(i);
            if (!task.isEPSNode()) continue;
            linkedList.addAll(task.getProjectTaskList());
        }
        return linkedList;
    }

    public Task getChildAt(int n) {
        return this.childList.get(n);
    }

    public Task getProjectChildAt(int n) {
        int n2 = -1;
        Task task = null;
        for (int i = 0; i < this.childList.size(); ++i) {
            task = this.childList.get(i);
            if (task.isEPSNode()) {
                ++n2;
            }
            if (n2 == n) break;
        }
        return task;
    }

    public int getChildIndex(Task task) {
        return this.childList.indexOf(task);
    }

    public int getProjectChildIndex(Task task) {
        int n = -1;
        for (int i = 0; i < this.childList.size(); ++i) {
            Task task2 = this.childList.get(i);
            if (task2.isEPSNode()) {
                ++n;
            }
            if (task2.equals(task)) break;
        }
        return n;
    }

    public boolean isLeaf() {
        if (!this.empty) {
            return this.childList.isEmpty();
        }
        return true;
    }

    public boolean isProjectLeaf() {
        if (!this.empty) {
            return this.getProjectChildNumber() == 0;
        }
        return true;
    }

    public boolean isEPSNode() {
        if (!this.empty) {
            if (this.isProject()) {
                return true;
            }
            return this.containsProject();
        }
        return false;
    }

    private boolean containsProject() {
        boolean bl = false;
        for (Task task : this.childList) {
            if (!task.isEPSNode()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void setEmpty(boolean bl) {
        this.empty = bl;
    }

    public void revertToEmpty() {
        this.empty = true;
        this.getCompany().computeTasksId();
    }

    public void setChildList(List<Task> list) {
        this.childList = list;
        for (Task task : list) {
            task.parent = this;
        }
        this.fireDataChanged();
        if (this.company != null) {
            this.company.computeCriticalPath();
        }
    }

    public int getChildNumber() {
        if (!this.empty) {
            return this.childList.size();
        }
        return 0;
    }

    public int getProjectChildNumber() {
        if (!this.empty) {
            int n = 0;
            for (int i = 0; i < this.childList.size(); ++i) {
                Task task = this.childList.get(i);
                if (!task.isEPSNode()) continue;
                ++n;
            }
            return n;
        }
        return 0;
    }

    int getEmptyChildNumber() {
        Task[] taskArray = this.childList.toArray(new Task[0]);
        int n = taskArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Task task = taskArray[i];
            if (!task.empty) continue;
            ++n2;
        }
        return n2;
    }

    public Task getParent() {
        return this.parent;
    }

    public List<Task> getPath(Task task) {
        if (this == task) {
            LinkedList<Task> linkedList = new LinkedList<Task>();
            linkedList.add(this);
            return linkedList;
        }
        List<Task> list = this.parent.getPath(task);
        list.add(this);
        return list;
    }

    public Company getCompany() {
        return this.company;
    }

    public Task getProjectTask() {
        if (this.project) {
            return this;
        }
        Task task = this;
        while (task.getParent() != null) {
            if (!(task = task.getParent()).isProject()) continue;
            return task;
        }
        return null;
    }

    public void outdent() {
        TaskPlanner.outdent(this);
        if (this.company != null) {
            this.company.computeCriticalPath();
        }
    }

    public void indent(Task task) throws CircularRelationshipException {
        TaskPlanner.indent(this, task);
        if (this.company != null) {
            this.company.computeCriticalPath();
        }
    }

    public void moveUp() {
        if (!this.isEmpty()) {
            int n = this.parent.getChildIndex(this);
            this.parent.fireChildWillRemove(this);
            this.parent.childList.remove(this);
            this.parent.childList.add(n - 1, this);
            this.parent.computeId(this.parent.getId());
            this.parent.fireChildAdded(this);
        }
    }

    public void moveDown() {
        if (!this.isEmpty()) {
            int n = this.parent.getChildIndex(this);
            this.parent.fireChildWillRemove(this);
            this.parent.childList.remove(this);
            this.parent.childList.add(n + 1, this);
            this.parent.computeId(this.parent.getId());
            this.parent.fireChildAdded(this);
        }
    }

    public void addChild(Task task, boolean bl) {
        this.addChild(this.getChildNumber(), task);
    }

    public void addChild(int n, Task task) {
        TaskPlanner.addTask(this, n, task);
        if (this.company != null) {
            this.company.computeTasksId();
            if (!task.isEmpty()) {
                this.company.computeCriticalPath();
            }
        }
    }

    public void deleteChild(Task task) {
        int n = this.getChildIndex(task);
        Task task2 = null;
        Task task3 = null;
        if (this.isSplitted()) {
            if (n > 0) {
                task2 = this.getChildAt(n - 1);
            }
            if (this.getChildNumber() > n + 1) {
                task3 = this.getChildAt(n + 1);
            }
            if (task3 != null && task2 != null) {
                Dependency dependency = new Dependency(Common.getIdGenerator().getNewId());
                dependency.setPredecessor(task2);
                dependency.setSuccessor(task3);
                try {
                    Task.addDependency(dependency, true);
                }
                catch (CircularRelationshipException circularRelationshipException) {
                    Common.logException("Error:", circularRelationshipException);
                }
            }
        }
        if (!this.isSplitted()) {
            TaskPlanner.deleteTask(this, task);
        } else if (this.getChildNumber() == 2) {
            TaskPlanner.deleteTask(this, task);
            this.deleteSplitLastChild(false);
        } else {
            TaskPlanner.deleteTask(this, task);
        }
        this.getCompany().computeTasksId();
        if (this.company != null) {
            this.company.computeCriticalPath();
        }
    }

    public static boolean addDependency(Dependency dependency, boolean bl) throws CircularRelationshipException {
        try {
            boolean bl2 = TaskPlanner.addDependency(dependency, bl);
            if (dependency.getPredecessor().getCompany() != null) {
                dependency.getPredecessor().getCompany().computeCriticalPath();
            }
            return bl2;
        }
        catch (CircularRelationshipException circularRelationshipException) {
            TaskPlanner.removeDependency(dependency);
            throw circularRelationshipException;
        }
    }

    public static void removeDependency(Dependency dependency) {
        TaskPlanner.removeDependency(dependency);
        if (dependency.getPredecessor().getCompany() != null) {
            dependency.getPredecessor().getCompany().computeCriticalPath();
        }
    }

    public void setCompany(Company company) {
        this.company = company;
        company.addCompanyListener(this.getCompanyHandler());
        for (int i = 0; i < this.childList.size(); ++i) {
            Task task = this.childList.get(i);
            task.setCompany(company);
        }
    }

    Task getFirstNonEmptyChild() {
        for (Task task : this.childList.toArray(new Task[0])) {
            if (task.empty) continue;
            return task;
        }
        return null;
    }

    private void fireAssignmentAdded(Assignment assignment, int n) {
        TaskEvent taskEvent = new TaskEvent((Object)this, assignment, n);
        EventListener[] eventListenerArray = this.listeners.getListeners(TaskListener.class);
        int n2 = eventListenerArray.length;
        for (int i = 0; i < n2; ++i) {
            ((TaskListener)eventListenerArray[i]).assignmentAdded(taskEvent);
        }
        this.empty = false;
        if (this.company != null) {
            this.company.setChanged(true);
        }
    }

    private void fireAssignmentRemoved(Assignment assignment, int n) {
        TaskEvent taskEvent = new TaskEvent((Object)this, assignment, n);
        EventListener[] eventListenerArray = this.listeners.getListeners(TaskListener.class);
        int n2 = eventListenerArray.length;
        for (int i = 0; i < n2; ++i) {
            ((TaskListener)eventListenerArray[i]).assignmentRemoved(taskEvent);
        }
        this.empty = false;
        if (this.company != null) {
            this.company.setChanged(true);
        }
    }

    void fireChildAdded(Task task) {
        TaskEvent taskEvent = new TaskEvent((Object)this, task, this.getChildIndex(task));
        EventListener[] eventListenerArray = this.listeners.getListeners(TaskListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((TaskListener)eventListenerArray[i]).childAdded(taskEvent);
        }
        this.empty = false;
        if (this.company != null) {
            this.company.setChanged(true);
        }
    }

    void fireChildRemoved(Task task) {
        if (this.isLeaf()) {
            this.duration = this.saveLeafDuration;
            this.workOnTask = this.saveLeafWork;
            this.completion = this.saveLeafCompletion;
        }
        TaskEvent taskEvent = new TaskEvent((Object)this, task, this.getChildIndex(task));
        EventListener[] eventListenerArray = this.listeners.getListeners(TaskListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((TaskListener)eventListenerArray[i]).childRemoved(taskEvent);
        }
        this.empty = false;
        if (this.company != null) {
            this.company.setChanged(true);
        }
    }

    void fireChildWillRemove(Task task) {
        TaskEvent taskEvent = new TaskEvent((Object)this, task, this.getChildIndex(task));
        EventListener[] eventListenerArray = this.listeners.getListeners(TaskListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((TaskListener)eventListenerArray[i]).childWillRemove(taskEvent);
        }
    }

    void fireSuccesorAdded(Dependency dependency) {
        TaskEvent taskEvent = new TaskEvent(this, dependency);
        EventListener[] eventListenerArray = this.listeners.getListeners(TaskListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((TaskListener)eventListenerArray[i]).successorAdded(taskEvent);
        }
        this.empty = false;
        if (this.company != null) {
            this.company.setChanged(true);
        }
    }

    void fireSuccesorRemoved(Dependency dependency) {
        TaskEvent taskEvent = new TaskEvent(this, dependency);
        EventListener[] eventListenerArray = this.listeners.getListeners(TaskListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((TaskListener)eventListenerArray[i]).successorRemoved(taskEvent);
        }
        this.empty = false;
        if (this.company != null) {
            this.company.setChanged(true);
        }
    }

    void firePredecessorAdded(Dependency dependency) {
        TaskEvent taskEvent = new TaskEvent(this, dependency);
        EventListener[] eventListenerArray = this.listeners.getListeners(TaskListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((TaskListener)eventListenerArray[i]).predecessorAdded(taskEvent);
        }
        this.empty = false;
        if (this.company != null) {
            this.company.setChanged(true);
        }
    }

    void firePredecessorRemoved(Dependency dependency) {
        TaskEvent taskEvent = new TaskEvent(this, dependency);
        EventListener[] eventListenerArray = this.listeners.getListeners(TaskListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((TaskListener)eventListenerArray[i]).predecessorRemoved(taskEvent);
        }
        this.empty = false;
        if (this.company != null) {
            this.company.setChanged(true);
        }
    }

    private void fireRiskAdded(Risk risk, int n) {
        TaskEvent taskEvent = new TaskEvent((Object)this, risk, n);
        EventListener[] eventListenerArray = this.listeners.getListeners(TaskListener.class);
        int n2 = eventListenerArray.length;
        for (int i = 0; i < n2; ++i) {
            ((TaskListener)eventListenerArray[i]).riskAdded(taskEvent);
        }
        this.getCompany().setChanged(true);
    }

    private void fireRiskRemoved(Risk risk, int n) {
        TaskEvent taskEvent = new TaskEvent((Object)this, risk, n);
        EventListener[] eventListenerArray = this.listeners.getListeners(TaskListener.class);
        int n2 = eventListenerArray.length;
        for (int i = 0; i < n2; ++i) {
            ((TaskListener)eventListenerArray[i]).riskRemoved(taskEvent);
        }
        this.getCompany().setChanged(true);
    }

    private void fireLinkAdded(Link link, int n) {
        TaskEvent taskEvent = new TaskEvent((Object)this, link, n);
        EventListener[] eventListenerArray = this.listeners.getListeners(TaskListener.class);
        int n2 = eventListenerArray.length;
        for (int i = 0; i < n2; ++i) {
            ((TaskListener)eventListenerArray[i]).linkAdded(taskEvent);
        }
        this.getCompany().setChanged(true);
    }

    private void fireTaskTypeChanged() {
        TaskEvent taskEvent = new TaskEvent(this);
        EventListener[] eventListenerArray = this.listeners.getListeners(TaskListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((TaskListener)eventListenerArray[i]).taskTypeChanged(taskEvent);
        }
        this.getCompany().setChanged(true);
    }

    private void fireLinkRemoved(Link link, int n) {
        TaskEvent taskEvent = new TaskEvent((Object)this, link, n);
        EventListener[] eventListenerArray = this.listeners.getListeners(TaskListener.class);
        int n2 = eventListenerArray.length;
        for (int i = 0; i < n2; ++i) {
            ((TaskListener)eventListenerArray[i]).linkRemoved(taskEvent);
        }
        this.getCompany().setChanged(true);
    }

    void fireDataChanged() {
        TaskEvent taskEvent = new TaskEvent(this);
        this.empty = false;
        if (this.company != null) {
            this.company.setChanged(true);
        }
        EventListener[] eventListenerArray = this.listeners.getListeners(TaskListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((TaskListener)eventListenerArray[i]).dataChanged(taskEvent);
        }
    }

    private void fireNameChanged() {
        TaskEvent taskEvent = new TaskEvent(this);
        EventListener[] eventListenerArray = this.listeners.getListeners(TaskListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((TaskListener)eventListenerArray[i]).nameChanged(taskEvent);
        }
        this.empty = false;
        if (this.company != null) {
            this.company.setChanged(true);
        }
    }

    private void fireConflictChanged() {
        TaskEvent taskEvent = new TaskEvent(this);
        EventListener[] eventListenerArray = this.listeners.getListeners(TaskListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((TaskListener)eventListenerArray[i]).conflictChanged(taskEvent);
        }
    }

    private void fireSplittedChanged() {
        TaskEvent taskEvent = new TaskEvent(this);
        EventListener[] eventListenerArray = this.listeners.getListeners(TaskListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((TaskListener)eventListenerArray[i]).splittedChanged(taskEvent);
        }
        this.empty = false;
        if (this.company != null) {
            this.company.setChanged(true);
        }
    }

    private void fireChangingNameChanged() {
        TaskEvent taskEvent = new TaskEvent(this);
        EventListener[] eventListenerArray = this.listeners.getListeners(TaskListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((TaskListener)eventListenerArray[i]).changingNameChanged(taskEvent);
        }
        if (this.company != null) {
            this.company.setChanged(true);
        }
    }

    private void fireBaselineChanged() {
        TaskEvent taskEvent = new TaskEvent(this);
        EventListener[] eventListenerArray = this.listeners.getListeners(TaskListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((TaskListener)eventListenerArray[i]).baselineChanged(taskEvent);
        }
        this.empty = false;
        if (this.company != null) {
            this.company.setChanged(true);
        }
    }

    private void fireProjectChanged() {
        TaskEvent taskEvent = new TaskEvent(this);
        EventListener[] eventListenerArray = this.listeners.getListeners(TaskListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((TaskListener)eventListenerArray[i]).projectChanged(taskEvent);
        }
        this.empty = false;
        if (this.company != null) {
            this.company.setChanged(true);
        }
    }

    private void fireProjectAssumptionsChanged() {
        TaskEvent taskEvent = new TaskEvent(this);
        EventListener[] eventListenerArray = this.listeners.getListeners(TaskListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((TaskListener)eventListenerArray[i]).projectAssumptionsChanged(taskEvent);
        }
        this.empty = false;
        if (this.company != null) {
            this.company.setChanged(true);
        }
    }

    private void fireProjectConstraintsChanged() {
        TaskEvent taskEvent = new TaskEvent(this);
        EventListener[] eventListenerArray = this.listeners.getListeners(TaskListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((TaskListener)eventListenerArray[i]).projectConstraintsChanged(taskEvent);
        }
        this.empty = false;
        if (this.company != null) {
            this.company.setChanged(true);
        }
    }

    private void fireProjectDescriptionChanged() {
        TaskEvent taskEvent = new TaskEvent(this);
        EventListener[] eventListenerArray = this.listeners.getListeners(TaskListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((TaskListener)eventListenerArray[i]).projectDescriptionChanged(taskEvent);
        }
        this.empty = false;
        if (this.company != null) {
            this.company.setChanged(true);
        }
    }

    private void fireNotesChanged() {
        TaskEvent taskEvent = new TaskEvent(this);
        EventListener[] eventListenerArray = this.listeners.getListeners(TaskListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((TaskListener)eventListenerArray[i]).notesChanged(taskEvent);
        }
        this.empty = false;
        if (this.company != null) {
            this.company.setChanged(true);
        }
    }

    private void fireFixedCostChanged() {
        TaskEvent taskEvent = new TaskEvent(this);
        EventListener[] eventListenerArray = this.listeners.getListeners(TaskListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((TaskListener)eventListenerArray[i]).fixedCostChanged(taskEvent);
        }
        this.empty = false;
        if (this.company != null) {
            this.company.setChanged(true);
        }
    }

    private void fireAccrualChanged() {
        TaskEvent taskEvent = new TaskEvent(this);
        EventListener[] eventListenerArray = this.listeners.getListeners(TaskListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((TaskListener)eventListenerArray[i]).accrualChanged(taskEvent);
        }
        this.empty = false;
        if (this.company != null) {
            this.company.setChanged(true);
        }
    }

    private void fireForcedWorkingChanged() {
        TaskEvent taskEvent = new TaskEvent(this);
        EventListener[] eventListenerArray = this.listeners.getListeners(TaskListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((TaskListener)eventListenerArray[i]).forcedWorkingChanged(taskEvent);
        }
        this.empty = false;
        if (this.company != null) {
            this.company.setChanged(true);
        }
    }

    private void fireFixedUnitsChanged() {
        TaskEvent taskEvent = new TaskEvent(this);
        EventListener[] eventListenerArray = this.listeners.getListeners(TaskListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((TaskListener)eventListenerArray[i]).fixedUnitsChanged(taskEvent);
        }
        this.empty = false;
        if (this.company != null) {
            this.company.setChanged(true);
        }
    }

    public void addTaskListener(TaskListener taskListener) {
        this.listeners.add(TaskListener.class, taskListener);
    }

    public void removeTaskListener(TaskListener taskListener) {
        this.listeners.remove(TaskListener.class, taskListener);
    }

    public String toString() {
        return this.name;
    }

    public String getFullName() {
        String string = this.name;
        for (Task task = this.parent; task != null; task = task.getParent()) {
            string = string + "/" + task.getName();
        }
        return string;
    }

    private CompanyListener getCompanyHandler() {
        if (this.companyHandler == null) {
            this.companyHandler = new CompanyHandler();
        }
        return this.companyHandler;
    }

    public double getCost(Date date, Date date2) {
        double d = 0.0;
        for (Task task : this.childList) {
            d += task.getCost(date, date2);
        }
        double d2 = 0.0;
        for (Assignment assignment : this.assignments) {
            Resource resource = assignment.getResource();
            if (resource instanceof HumanResource) {
                assignment.computeWork(date, date2, this.completionDate);
                d2 += resource.getCost(assignment, date, date2);
                continue;
            }
            double d3 = resource.getCost(assignment, date, date2);
            if (d3 == -1.0) continue;
            d2 += d3;
        }
        if (!this.isEmpty()) {
            if (this.accrual.equals(START)) {
                if (!this.startDate.before(date) && !this.startDate.after(date2)) {
                    return d + d2 + this.fixedCost;
                }
                return d + d2;
            }
            if (this.accrual.equals(END)) {
                if (!this.getEndDate().before(date) && !this.getEndDate().after(date2)) {
                    return d + d2 + this.fixedCost;
                }
                return d + d2;
            }
            if (this.isMilestone()) {
                if (!this.startDate.before(date) && this.startDate.before(date2)) {
                    return d + d2 + this.fixedCost;
                }
                return d + d2;
            }
            return d + d2 + (double)this.getWorkingDuration(date, date2) * this.fixedCost / (double)this.getWorkingDuration();
        }
        return 0.0;
    }

    public double getCost() {
        double d = 0.0;
        for (Task task : this.childList) {
            d += task.getCost();
        }
        double d2 = 0.0;
        for (Assignment assignment : this.assignments) {
            Resource resource = assignment.getResource();
            d2 += resource.getCost(assignment);
        }
        return d + d2 + this.fixedCost;
    }

    public double getActualCost() {
        if (this.completion == 0.0) {
            return 0.0;
        }
        if (this.isLeaf()) {
            return this.getCost(this.startDate, this.completionDate);
        }
        double d = 0.0;
        for (Task task : this.childList) {
            d += task.getActualCost();
        }
        double d2 = 0.0;
        for (Assignment assignment : this.assignments) {
            Resource resource = assignment.getResource();
            if (resource instanceof HumanResource) {
                assignment.computeWork(this.startDate, this.completionDate, this.completionDate);
            }
            d2 += resource.getCost(assignment, this.startDate, this.completionDate);
        }
        if (!this.isEmpty()) {
            if (this.accrual.equals(START)) {
                return d + d2 + this.fixedCost;
            }
            if (this.accrual.equals(END)) {
                if (this.completion == 100.0) {
                    return d + d2 + this.fixedCost;
                }
                return d + d2;
            }
            return d + d2 + this.fixedCost * this.completion / 100.0;
        }
        return 0.0;
    }

    public double getRemainingCost() {
        if (this.completion == 100.0) {
            return 0.0;
        }
        if (this.isLeaf()) {
            return this.getCost(this.completionDate, this.endDate);
        }
        double d = 0.0;
        for (Task task : this.childList) {
            d += task.getRemainingCost();
        }
        double d2 = 0.0;
        for (Assignment assignment : this.assignments) {
            Resource resource = assignment.getResource();
            if (resource instanceof HumanResource) {
                assignment.computeWork(this.completionDate, this.endDate, this.completionDate);
            }
            d2 += resource.getCost(assignment, this.completionDate, this.endDate);
        }
        if (!this.isEmpty()) {
            if (this.accrual.equals(START)) {
                if (this.completion == 0.0) {
                    return d + d2 + this.fixedCost;
                }
                return d + d2;
            }
            if (this.accrual.equals(END)) {
                return d + d2 + this.fixedCost;
            }
            return d + d2 + this.fixedCost * (100.0 - this.completion) / 100.0;
        }
        return 0.0;
    }

    public long getWork(Date date, Date date2) {
        long l = 0L;
        for (Task task : this.childList) {
            l += task.getWork(date, date2);
        }
        long l2 = 0L;
        for (Assignment assignment : this.assignments) {
            Resource resource = assignment.getResource();
            if (!(resource instanceof HumanResource)) continue;
            assignment.computeWork(date, date2, this.completionDate);
            HumanResource humanResource = (HumanResource)resource;
            l2 += humanResource.getWork(assignment, date, date2);
        }
        return l + l2;
    }

    public long getWork() {
        long l = 0L;
        for (Task task : this.childList) {
            l += task.getWork();
        }
        return l + this.getWorkExceptChildren();
    }

    public long getActualWork() {
        if (this.isLeaf()) {
            return this.getWork(this.startDate, this.completionDate);
        }
        long l = 0L;
        for (Task task : this.childList) {
            l += task.getActualWork();
        }
        long l2 = 0L;
        for (Assignment assignment : this.assignments) {
            Resource resource = assignment.getResource();
            if (!(resource instanceof HumanResource)) continue;
            assignment.computeWork(this.startDate, this.completionDate, this.completionDate);
            HumanResource humanResource = (HumanResource)resource;
            l2 += humanResource.getWork(assignment, this.startDate, this.completionDate);
        }
        return l + l2;
    }

    public long getRemainingWork() {
        if (this.isLeaf()) {
            return this.getWork(this.completionDate, this.endDate);
        }
        long l = 0L;
        for (Task task : this.childList) {
            l += task.getRemainingWork();
        }
        long l2 = 0L;
        for (Assignment assignment : this.assignments) {
            Resource resource = assignment.getResource();
            if (!(resource instanceof HumanResource)) continue;
            assignment.computeWork(this.completionDate, this.endDate, this.completionDate);
            HumanResource humanResource = (HumanResource)resource;
            l2 += humanResource.getWork(assignment, this.completionDate, this.endDate);
        }
        return l + l2;
    }

    public long getWorkExceptChildren() {
        return this.workOnTask;
    }

    public double getFixedCost() {
        return this.fixedCost;
    }

    public void setFixedCost(double d) {
        if (this.empty && !this.initEmptyTask()) {
            return;
        }
        this.fixedCost = d;
        this.fireFixedCostChanged();
        Task task = this.getParent();
        if (task != null) {
            task.setFixedCost(task.getFixedCost());
        }
    }

    public String getAccrual() {
        return this.accrual;
    }

    public void setAccrual(String string) {
        if (this.empty && !this.initEmptyTask()) {
            return;
        }
        this.accrual = string;
        this.fireAccrualChanged();
        Task task = this.getParent();
        if (task != null) {
            task.setAccrual(task.getAccrual());
        }
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }

    public boolean isMilestone() {
        return this.duration == 0L;
    }

    public boolean isSplitted() {
        return this.splitted;
    }

    public void setSplitted(boolean bl) {
        this.splitted = bl;
        this.fireSplittedChanged();
    }

    public boolean isParentSplitted() {
        if (this.parent != null) {
            return this.parent.isSplitted();
        }
        return false;
    }

    public TaskPartSplitEdit splitPart(Date date, TaskPartSplitEdit taskPartSplitEdit) {
        if (date.before(this.getStartDate())) {
            date = this.getStartDate();
        } else if (date.after(this.getEndDate())) {
            date = this.getEndDate();
        }
        ActualWorkingData actualWorkingData = this.getData();
        double d = this.getCompletion();
        Constraint constraint = this.getConstraint();
        long l = this.getDuration();
        CalendarManager calendarManager = this.getUsedCalendar();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        long l2 = calendarManager.getDuration(this.getStartDate(), calendar.getTime(), true);
        long l3 = l - l2;
        Task task = new Task(taskPartSplitEdit == null ? Common.getIdGenerator().getNewId() : taskPartSplitEdit.t1Id);
        task.startDate = date;
        task.endDate = this.endDate;
        this.endDate = date;
        Date date2 = this.getCompletionDate();
        calendar.setTime(date2);
        long l4 = calendarManager.getDuration(this.getStartDate(), calendar.getTime(), true);
        this.getParent().addChild(this.getParent().getChildIndex(this) + 1, task);
        task.setCalendar(this.getCalendar());
        task.setName(this.getName());
        this.setDuration(l2);
        task.setDuration(l3);
        Constraint constraint2 = this.getConstraint();
        if (constraint2 instanceof SNET || constraint2 instanceof SNLT || constraint2 instanceof ASAP || constraint2 instanceof MSO) {
            task.setConstraint(new ASAP());
        } else {
            this.setConstraint(new SNET(this.getStartDate()));
            task.setConstraint(constraint2);
        }
        Cloneable cloneable = new LinkedList<Dependency>();
        for (Dependency object : this.getSuccessorDependencies()) {
            if (object.getType() == 0 && object.getType() == 3) continue;
            cloneable.add(object);
        }
        Iterator<Dependency> iterator = cloneable.iterator();
        while (iterator.hasNext()) {
            Dependency dependency = iterator.next();
            Task.removeDependency(dependency);
            dependency.setPredecessor(task);
            try {
                Task.addDependency(dependency, true);
            }
            catch (CircularRelationshipException circularRelationshipException) {
                Common.logException("Error:", circularRelationshipException);
                circularRelationshipException.printStackTrace();
            }
        }
        cloneable = new Dependency(taskPartSplitEdit == null ? Common.getIdGenerator().getNewId() : taskPartSplitEdit.dependencyId);
        ((Dependency)cloneable).setPredecessor(this);
        ((Dependency)cloneable).setSuccessor(task);
        try {
            Task.addDependency((Dependency)cloneable, true);
        }
        catch (CircularRelationshipException circularRelationshipException) {
            Common.logException("Error:", circularRelationshipException);
            circularRelationshipException.printStackTrace();
        }
        int n = 0;
        for (Assignment assignment : this.getAssignments()) {
            double d2 = assignment.getUnits();
            double d3 = assignment.getUnits();
            if (assignment.getResource() instanceof MaterialResource) {
                d2 = d2 * (double)l2 / (double)l;
                d3 = assignment.getUnits() - d2;
            }
            Resource resource = assignment.getResource();
            long l5 = taskPartSplitEdit == null ? Common.getIdGenerator().getNewId() : taskPartSplitEdit.t1AssIDs.elementAt(n).longValue();
            Assignment assignment2 = new Assignment(l5, task, resource, d3);
            task.addAssignment(assignment2);
            resource.addAssignment(assignment2);
            assignment.units = d2;
            ++n;
        }
        if (date.after(date2)) {
            task.setCompletion(0.0);
            if (l2 != 0L) {
                this.setCompletion((int)(l4 * 100L / l2));
            } else {
                this.setCompletion(0.0);
            }
        } else {
            this.setCompletion(100.0);
            l4 -= l2;
            if (l3 == 0L) {
                task.setCompletion(0.0);
            } else {
                task.setCompletion((int)(l4 * 100L / l3));
            }
        }
        task.setForcedWorking(this.forcedWorking);
        task.setWorkDriven(this.workDriven);
        if (task.isWorkDriven() && task.hasHumanResources()) {
            task.workOnTask = Long.MAX_VALUE;
            this.workOnTask = Long.MAX_VALUE;
        }
        if (taskPartSplitEdit == null) {
            return new TaskPartSplitEdit(this, date, actualWorkingData, d, constraint, task, (Dependency)cloneable, "02-10-2009 : 12:32:00");
        }
        taskPartSplitEdit.t1 = task;
        taskPartSplitEdit.dependency = cloneable;
        return null;
    }

    public TaskSplitEdit split(Date date, TaskSplitEdit taskSplitEdit) {
        if (date.before(this.getStartDate())) {
            date = this.getStartDate();
        } else if (date.after(this.getEndDate())) {
            date = this.getEndDate();
        }
        long l = this.getDuration();
        CalendarManager calendarManager = this.getUsedCalendar();
        c.setTime(date);
        Task task = new Task(taskSplitEdit == null ? Common.getIdGenerator().getNewId() : taskSplitEdit.t1Id);
        Task task2 = new Task(taskSplitEdit == null ? Common.getIdGenerator().getNewId() : taskSplitEdit.t2Id);
        long l2 = calendarManager.getDuration(this.getStartDate(), c.getTime(), true);
        long l3 = l - l2;
        Date date2 = this.getCompletionDate();
        c.setTime(date2);
        long l4 = calendarManager.getDuration(this.getStartDate(), c.getTime(), true);
        this.splitted = true;
        this.addChild(task, false);
        this.addChild(task2, false);
        task.startDate = this.startDate;
        task.endDate = date;
        task2.startDate = date;
        task2.endDate = this.endDate;
        task.calendar = this.getCalendar();
        task2.calendar = this.getCalendar();
        task.name = this.getName();
        task2.name = this.getName();
        task.accrual = this.getAccrual();
        task2.accrual = this.getAccrual();
        task.setDuration(l2);
        task.setForcedWorking(this.forcedWorking);
        task.setWorkDriven(this.workDriven);
        task2.setDuration(l3);
        task2.setForcedWorking(this.forcedWorking);
        task2.setWorkDriven(this.workDriven);
        Constraint constraint = this.getConstraint();
        if (constraint instanceof SNET || constraint instanceof SNLT || constraint instanceof ASAP || constraint instanceof MSO) {
            task.constraint = constraint;
            task2.constraint = new ASAP();
        } else {
            task.constraint = new SNET(this.getStartDate());
            task2.constraint = constraint;
        }
        long l5 = taskSplitEdit == null ? Common.getIdGenerator().getNewId() : taskSplitEdit.dependencyId;
        Dependency dependency = new Dependency(l5);
        dependency.setPredecessor(task);
        dependency.setSuccessor(task2);
        try {
            Task.addDependency(dependency, false);
        }
        catch (CircularRelationshipException circularRelationshipException) {
            circularRelationshipException.printStackTrace();
            Common.logException("Error:", circularRelationshipException);
        }
        LinkedList<Assignment> linkedList = new LinkedList<Assignment>();
        int n = 0;
        for (Assignment assignment : this.getAssignments()) {
            Resource resource = assignment.getResource();
            long l6 = taskSplitEdit == null ? Common.getIdGenerator().getNewId() : taskSplitEdit.t1AssIDs.elementAt(n).longValue();
            double d = assignment.getUnits();
            double d2 = assignment.getUnits();
            if (assignment.getResource() instanceof MaterialResource) {
                d = d * (double)l2 / (double)l;
                d2 = assignment.getUnits() - d;
            }
            Assignment assignment2 = new Assignment(l6, task, resource, d);
            task.addAssignment(assignment2);
            resource.addAssignment(assignment2);
            long l7 = taskSplitEdit == null ? Common.getIdGenerator().getNewId() : taskSplitEdit.t2AssIDs.elementAt(n).longValue();
            Assignment assignment3 = new Assignment(l7, task2, resource, d2);
            task2.addAssignment(assignment3);
            resource.addAssignment(assignment3);
            ++n;
        }
        while (this.getAssignments().size() > 0) {
            Assignment assignment = this.getAssignmentAt(0);
            linkedList.add(assignment);
            assignment.getResource().removeAssignment(assignment);
            this.removeAssignment(0);
        }
        if (date.after(date2)) {
            task2.setCompletion(0.0);
            task.setCompletion((double)l4 * 100.0 / (double)l2);
        } else {
            task.setCompletion(100.0);
            task2.setCompletion((double)(l4 -= l2) * 100.0 / (double)l3);
        }
        if (task.isWorkDriven() && task.hasHumanResources()) {
            task.workOnTask = Long.MAX_VALUE;
            task2.workOnTask = Long.MAX_VALUE;
        }
        this.setSplitted(true);
        if (taskSplitEdit == null) {
            return new TaskSplitEdit(this, date, task, task2, dependency, linkedList, "01-10-2009 18:15:00");
        }
        taskSplitEdit.t1 = task;
        taskSplitEdit.t2 = task2;
        taskSplitEdit.dependency = dependency;
        return null;
    }

    public long getCriticalSlackLimit() {
        return this.criticalSlackLimit;
    }

    public void setCriticalSlackLimit(long l) {
        this.criticalSlackLimit = l;
        this.getCompany().computeCriticalPath();
        this.getCompany().setChanged(true);
    }

    public String getCriticalSlackUnit() {
        return this.criticalSlackUnit;
    }

    public void setCriticalSlackUnit(String string) {
        this.criticalSlackUnit = string;
    }

    public boolean isProject() {
        return this.project;
    }

    public void setProject(boolean bl) {
        this.project = bl;
    }

    public void setParent(Task task) {
        this.parent = task;
    }

    public static List<Task> cloneTasks(List<Task> list, boolean bl) {
        LinkedList<Task> linkedList = new LinkedList<Task>();
        for (Task task : list) {
            Task task2 = cloneMap.containsKey(task) ? cloneMap.get(task) : task.clone(list, bl);
            linkedList.add(task2);
        }
        cloneMap.clear();
        return linkedList;
    }

    private Task clone(List<Task> list, boolean bl) {
        UniqueId uniqueId;
        Task task = new Task();
        if (bl) {
            task.setUniqueId(Common.getIdGenerator().getNewId());
        } else {
            task.uniqueID = this.uniqueID;
        }
        cloneMap.put(this, task);
        task.name = this.name;
        task.accrual = this.accrual;
        task.assumptions = this.assumptions;
        task.barColor = this.getBarColor();
        task.code = this.code;
        task.constraint = this.constraint;
        task.dirty = true;
        task.completion = 0.0;
        task.workCompletion = 0.0;
        task.childList = new LinkedList<Task>();
        task.successorDependencies = new LinkedList<Dependency>();
        task.predecessorDependencies = new LinkedList<Dependency>();
        task.assignments = new LinkedList<Assignment>();
        task.listeners = new EventListenerList();
        task.parent = null;
        task.company = null;
        task.conflict = false;
        task.completionDate = this.startDate;
        task.constraints = this.constraints;
        task.criticalSlackLimit = this.criticalSlackLimit;
        task.criticalSlackUnit = this.criticalSlackUnit;
        task.currencyUnit = this.currencyUnit;
        task.description = this.description;
        task.duration = this.duration;
        task.durationUnit = this.durationUnit;
        task.empty = this.empty;
        task.endDate = this.endDate;
        task.expanded = this.expanded;
        task.fixedCost = this.fixedCost;
        task.forcedWorking = this.forcedWorking;
        task.manager = this.manager;
        task.name = this.name;
        task.notes = this.notes;
        task.project = this.project;
        task.splitted = this.splitted;
        task.startDate = this.startDate;
        task.status = this.status;
        task.workOnTask = this.workOnTask;
        task.workCompletion = 0.0;
        task.workDriven = this.workDriven;
        task.workUnit = this.workUnit;
        for (Dependency uniqueId3 : this.successorDependencies) {
            uniqueId = uniqueId3.getSuccessor();
            boolean bl2 = false;
            for (Task task2 : list) {
                if (!((Task)uniqueId).isDescendent(task2) && !list.contains(uniqueId)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) continue;
            Task task3 = cloneMap.containsKey(uniqueId) ? cloneMap.get(uniqueId) : super.clone(list, bl);
            Dependency dependency = (Dependency)uniqueId3.clone(bl);
            dependency.setPredecessor(task);
            dependency.setSuccessor(task3);
            if (TaskPlanner.areLinked(task, task3) != null) continue;
            task.successorDependencies.add(dependency);
            task3.predecessorDependencies.add(dependency);
        }
        for (Assignment assignment : this.assignments) {
            uniqueId = (Resource)assignment.getResource().clone(false);
            long l = bl ? Common.getIdGenerator().getNewId() : assignment.getUniqueId();
            Assignment assignment2 = new Assignment(l, task, (Resource)uniqueId, assignment.getUnits());
            task.assignments.add(assignment2);
        }
        for (Task task4 : this.childList) {
            uniqueId = cloneMap.containsKey(task4) ? cloneMap.get(task4) : task4.clone(list, bl);
            task.addChild((Task)uniqueId, false);
        }
        return task;
    }

    public void updateClonedAssignments(Company company) {
        Assignment[] assignmentArray = this.assignments.toArray(new Assignment[0]);
        for (int i = 0; i < assignmentArray.length; ++i) {
            Assignment uniqueId = assignmentArray[i];
            Resource resource = company.getResourceForId(uniqueId.getResource().getId());
            if (resource != null) {
                if (!resource.getName().equals(uniqueId.getResource().getName())) continue;
                uniqueId.resource = company.getResourceForId(uniqueId.getResource().getId());
                continue;
            }
            this.assignments.remove(uniqueId);
        }
        for (Task task : this.childList) {
            task.updateClonedAssignments(company);
        }
    }

    public void addClonnedAssignments(boolean bl) {
        for (Assignment uniqueId : this.getAssignments()) {
            uniqueId.getResource().addAssignment(uniqueId);
        }
        for (Task task : this.childList) {
            task.addClonnedAssignments(bl);
        }
    }

    public double getWorkCompletion() {
        return this.workCompletion;
    }

    public CurrencyManager getCurrencyManager() {
        return this.currencyManager;
    }

    public String getCurrencyUnit() {
        return this.currencyUnit;
    }

    public void setCurrencyUnit(String string) {
        this.currencyUnit = string;
    }

    public Date getDeadlineDate() {
        return this.deadlineDate;
    }

    public void setDeadlineDate(Date date) {
        if (this.empty && !this.initEmptyTask()) {
            return;
        }
        this.deadlineDate = date;
        this.fireDataChanged();
    }

    public void setStartDate(Date date) {
        this.startDate = date;
    }

    public void setEndDate(Date date) {
        this.endDate = date;
    }

    public void setCompletionDate(Date date) {
        this.completionDate = date;
    }

    public String getWorkUnit() {
        return this.workUnit;
    }

    public void setWorkUnit(String string) {
        this.workUnit = string;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String string) {
        this.status = string;
        this.fireProjectChanged();
    }

    public int getNonEmptyBaselinesNo() {
        int n = 0;
        for (int i = 0; i < 10; ++i) {
            ProjectBaseline projectBaseline = this.getProjectBaselineAt(i);
            if (projectBaseline == null) continue;
            ++n;
        }
        return n;
    }

    public Baseline[] getBaselines() {
        return this.baselines;
    }

    public ProjectBaseline[] getProjectBaselines() {
        return this.projectBaselines;
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
        this.fireProjectChanged();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean bl) {
        this.setDirty(bl, true);
    }

    public void setDirty(boolean bl, boolean bl2) {
        this.dirty = bl;
        if (bl2) {
            for (Task task : this.childList) {
                task.setDirty(bl, bl2);
            }
        }
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean bl) {
        this.expanded = bl;
    }

    public boolean isConflict() {
        return this.conflict;
    }

    public void setConflict(boolean bl) {
        this.conflict = bl;
        this.fireConflictChanged();
    }

    private class CalendarHandler
    implements CalendarManagerListener,
    Serializable {
        private CalendarHandler() {
        }

        public void dayWorkingPatternChanged(CalendarManagerEvent calendarManagerEvent) {
        }

        public void calendarChanged(CalendarManagerEvent calendarManagerEvent) {
            Task.this.setDirty(true, false);
            if (Task.this.isProject()) {
                Task.this.setProjectDirty();
            }
        }

        public void nameChanged(CalendarManagerEvent calendarManagerEvent) {
        }
    }

    private class CompanyHandler
    extends CompanyAdapter
    implements Serializable {
        private CompanyHandler() {
        }

        public void resourceRemoved(CompanyEvent companyEvent) {
            Resource resource = companyEvent.getResource();
            int n = Task.this.getAssignmentIndex(resource);
            if (n != -1) {
                resource.removeAssignment(Task.this.getAssignmentAt(n));
                Task.this.removeAssignment(n);
            }
        }
    }
}

