/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.core;

import com.sbs.jpm.core.Assignment;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.event.ResourceEvent;
import com.sbs.jpm.core.event.ResourceListener;
import java.io.Serializable;
import java.util.Date;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Resource
implements Cloneable,
Serializable,
UniqueId {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected String code;
    protected String notes;
    protected long resourceId;
    protected double standardRate;
    private String[] fields = new String[10];
    protected Company owner;
    public List<Assignment> assignments;
    protected EventListenerList listeners;
    protected boolean empty;
    protected long uniqueId;

    public Resource() {
        this(Long.MIN_VALUE);
    }

    public Resource(long l) {
        this.setUniqueId(l);
        this.empty = true;
        this.listeners = new EventListenerList();
        this.assignments = new LinkedList<Assignment>();
    }

    protected abstract void initEmptyResource();

    public void revertToEmpty() {
        this.empty = true;
        this.getOwner().computeResourceId();
    }

    public long getId() {
        return this.resourceId;
    }

    public void setId(long l) {
        this.resourceId = new Long(l);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (this.empty) {
            this.initEmptyResource();
        }
        this.name = string;
        this.fireDataChanged();
    }

    public void setFieldAt(int n, String string) {
        if (this.empty) {
            this.initEmptyResource();
        }
        this.fields[n] = string;
        this.fireDataChanged();
    }

    public String getFieldAt(int n) {
        return this.fields[n];
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void setEmpty(boolean bl) {
        this.empty = bl;
    }

    public double getStandardRate() {
        return this.standardRate;
    }

    public void setStandardRate(double d) {
        if (this.empty) {
            this.initEmptyResource();
        }
        this.standardRate = d;
        this.fireDataChanged();
    }

    public Company getOwner() {
        return this.owner;
    }

    public void setOwner(Company company) {
        this.owner = company;
    }

    public Date getFirstWorkingDate() {
        if (this.assignments.isEmpty()) {
            return null;
        }
        Date date = this.assignments.get(0).getTask().getStartDate();
        Iterator<Assignment> iterator = this.assignments.iterator();
        while (iterator.hasNext()) {
            Date date2 = iterator.next().getTask().getStartDate();
            if (!date2.before(date)) continue;
            date = date2;
        }
        return date;
    }

    protected double getStandardCost(Assignment assignment, Date date, Date date2) {
        if (!this.isEmpty()) {
            double d = assignment.getUnits(date, date2);
            if (d != -1.0) {
                return d * this.standardRate;
            }
            return -1.0;
        }
        return 0.0;
    }

    public double getActualCost(Assignment assignment, Date date, Date date2) {
        if (!this.isEmpty()) {
            double d = assignment.getActualUnits(date, date2);
            if (d != -1.0) {
                return d * this.standardRate;
            }
            return -1.0;
        }
        return 0.0;
    }

    public double getRemainingCost(Assignment assignment, Date date, Date date2) {
        if (!this.isEmpty() && !this.isEmpty()) {
            double d = assignment.getRemainingUnits(date, date2);
            if (d != -1.0) {
                return d * this.standardRate;
            }
            return -1.0;
        }
        return 0.0;
    }

    public double getStandardCost(Date date, Date date2) {
        if (!this.isEmpty()) {
            double d = 0.0;
            boolean bl = false;
            for (Assignment assignment : this.getAssignments()) {
                double d2 = this.getStandardCost(assignment, date, date2);
                if (d2 == -1.0) continue;
                bl = true;
                d += d2;
            }
            if (bl) {
                return d;
            }
            return -1.0;
        }
        return 0.0;
    }

    public double getActualCost(Date date, Date date2) {
        if (!this.isEmpty()) {
            double d = 0.0;
            boolean bl = false;
            for (Assignment assignment : this.getAssignments()) {
                double d2 = this.getActualCost(assignment, date, date2);
                if (d2 == -1.0) continue;
                bl = true;
                d += d2;
            }
            if (bl) {
                return d;
            }
            return -1.0;
        }
        return 0.0;
    }

    public double getRemainingCost(Date date, Date date2) {
        if (!this.isEmpty()) {
            double d = 0.0;
            boolean bl = false;
            for (Assignment assignment : this.getAssignments()) {
                double d2 = this.getRemainingCost(assignment, date, date2);
                if (d2 == -1.0) continue;
                bl = true;
                d += d2;
            }
            if (bl) {
                return d;
            }
            return -1.0;
        }
        return 0.0;
    }

    protected double getStandardCost(Assignment assignment) {
        if (!this.isEmpty()) {
            return this.getStandardRate() * assignment.getUnits();
        }
        return 0.0;
    }

    public double getActualCost(Assignment assignment) {
        if (!this.isEmpty()) {
            return this.standardRate * assignment.getActualUnits();
        }
        return 0.0;
    }

    public double getActualCost() {
        if (!this.isEmpty()) {
            double d = 0.0;
            for (Assignment assignment : this.getAssignments()) {
                d += this.getActualCost(assignment);
            }
            return d;
        }
        return 0.0;
    }

    public double getRemainingCost() {
        if (!this.isEmpty()) {
            double d = 0.0;
            for (Assignment assignment : this.getAssignments()) {
                d += this.getRemainingCost(assignment);
            }
            return d;
        }
        return 0.0;
    }

    public double getRemainingCost(Assignment assignment) {
        if (!this.isEmpty()) {
            return this.standardRate * assignment.getRemainingUnits();
        }
        return 0.0;
    }

    protected double getStandardCost() {
        if (!this.isEmpty()) {
            double d = 0.0;
            for (Assignment assignment : this.getAssignments()) {
                d += this.getStandardCost(assignment);
            }
            return d;
        }
        return 0.0;
    }

    public double getCost(Date date, Date date2) {
        return this.getStandardCost(date, date2);
    }

    public double getCost(Assignment assignment, Date date, Date date2) {
        return this.getStandardCost(assignment, date, date2);
    }

    public double getCost(Assignment assignment) {
        return this.getStandardCost(assignment);
    }

    public double getCost() {
        return this.getStandardCost();
    }

    public int getAssignmentNumber() {
        return this.assignments.size();
    }

    public List<Assignment> getAssignments() {
        return this.assignments;
    }

    public Assignment getAssignmentAt(int n) {
        return this.assignments.get(n);
    }

    public int getAssignmentIndex(Assignment assignment) {
        return this.assignments.indexOf(assignment);
    }

    public int getAssignmentIndex(Task task) {
        int n = 0;
        for (Assignment assignment : this.assignments) {
            if (assignment.getTask().equals(task)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void addAssignment(Assignment assignment) {
        this.addAssignment(assignment, this.assignments.size());
    }

    public void addAssignment(Assignment assignment, int n) {
        Task task = assignment.getTask();
        for (Assignment assignment2 : this.getAssignments()) {
            Task task2 = assignment2.getTask();
            if (task == null || !task.equals(task2)) continue;
            return;
        }
        this.assignments.add(n, assignment);
        this.fireAssignmentAdded(assignment, this.assignments.indexOf(assignment));
    }

    public void removeAssignment(Assignment assignment) {
        int n = this.assignments.indexOf(assignment);
        this.assignments.remove(assignment);
        this.fireAssignmentRemoved(assignment, n);
    }

    private void fireResourceChanged() {
        this.empty = false;
        if (this.owner != null) {
            this.owner.setChanged(true);
        }
    }

    public void fireDataChanged() {
        ResourceEvent resourceEvent = new ResourceEvent(this);
        EventListener[] eventListenerArray = this.listeners.getListeners(ResourceListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((ResourceListener)eventListenerArray[i]).dataChanged(resourceEvent);
        }
        this.fireResourceChanged();
    }

    private void fireAssignmentAdded(Assignment assignment, int n) {
        ResourceEvent resourceEvent = new ResourceEvent(this, assignment, n);
        EventListener[] eventListenerArray = this.listeners.getListeners(ResourceListener.class);
        int n2 = eventListenerArray.length;
        for (int i = 0; i < n2; ++i) {
            ((ResourceListener)eventListenerArray[i]).assignmentAdded(resourceEvent);
        }
        this.fireResourceChanged();
    }

    private void fireAssignmentRemoved(Assignment assignment, int n) {
        ResourceEvent resourceEvent = new ResourceEvent(this, assignment, n);
        EventListener[] eventListenerArray = this.listeners.getListeners(ResourceListener.class);
        int n2 = eventListenerArray.length;
        for (int i = 0; i < n2; ++i) {
            ((ResourceListener)eventListenerArray[i]).assignmentRemoved(resourceEvent);
        }
        this.fireResourceChanged();
    }

    private void fireNotesChanged() {
        ResourceEvent resourceEvent = new ResourceEvent(this);
        EventListener[] eventListenerArray = this.listeners.getListeners(ResourceListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((ResourceListener)eventListenerArray[i]).notesChanged(resourceEvent);
        }
        this.fireResourceChanged();
    }

    public void addResourceListener(ResourceListener resourceListener) {
        this.listeners.add(ResourceListener.class, resourceListener);
    }

    public void removeResourceListener(ResourceListener resourceListener) {
        this.listeners.remove(ResourceListener.class, resourceListener);
    }

    public String toString() {
        return this.name;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String string) {
        if (this.empty) {
            this.initEmptyResource();
        }
        this.notes = string;
        this.fireNotesChanged();
    }

    public abstract Object clone(boolean var1);

    public String getCode() {
        return this.code;
    }

    public void setCode(String string) {
        if (this.empty) {
            this.initEmptyResource();
        }
        this.code = string;
        this.fireDataChanged();
    }

    @Override
    public void setUniqueId(long l) {
        this.uniqueId = l;
    }

    @Override
    public long getUniqueId() {
        return this.uniqueId;
    }
}

